/*
 * Decompiled with CFR 0.152.
 */
package gameIHM;

import gameIHM.KeyboardListener;
import gameIHM.MiniMap;
import gameIHM.ZoneCommande;
import gameIHM.ZoneJeu;
import gameIHM.ZonePersonnage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import zork2Class.Game;
import zork2Class.Item;
import zork2Class.Player;

public class GameFrame
extends JFrame {
    public ZoneJeu zoneJeu;
    public MiniMap miniMap;
    public ZoneCommande zoneCommande;
    public ZonePersonnage zonePersonnage;
    public JTextArea viewArea;
    public JTextField console;
    public JComboBox inventaire;
    public JComboBox usableItem;
    private Game game;
    private KeyboardListener keyboardListener;

    public GameFrame(Game partie) {
        this.game = partie;
        this.setTitle("Zork 2 ..:: Projet de programmation 2002/2003 IUT de Vannes::..");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/imgDefault/iconeZ2.gif"));
        this.zoneJeu = new ZoneJeu(this);
        this.miniMap = new MiniMap(this);
        this.zoneCommande = new ZoneCommande(this);
        this.zonePersonnage = new ZonePersonnage(this);
        this.viewArea = new JTextArea("");
        this.console = new JTextField();
        this.inventaire = new JComboBox();
        this.usableItem = new JComboBox();
        JLabel invLabel = new JLabel("Inventaire", 0);
        JLabel usableLabel = new JLabel("Objets accessibles", 0);
        JScrollPane panel = new JScrollPane(this.viewArea);
        panel.setVerticalScrollBar(panel.createVerticalScrollBar());
        Panel panel1 = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        this.viewArea.setEditable(false);
        this.viewArea.setBackground(new Color(204, 204, 204));
        this.viewArea.setAutoscrolls(true);
        this.inventaire.addActionListener(new ListenerInventaire());
        this.usableItem.addActionListener(new ListenerUsableItems());
        this.console.addActionListener(new ListenerConsole());
        this.zoneJeu.setBounds(0, 0, 500, 500);
        this.miniMap.setBounds(500, 0, 200, 200);
        invLabel.setBounds(500, 200, 200, 20);
        this.inventaire.setBounds(500, 220, 203, 20);
        this.zonePersonnage.setBounds(500, 240, 200, 200);
        usableLabel.setBounds(500, 440, 200, 20);
        this.usableItem.setBounds(500, 460, 203, 20);
        this.zoneCommande.setBounds(500, 480, 200, 200);
        panel.setBounds(0, 500, 500, 160);
        this.console.setBounds(0, 660, 500, 20);
        this.setSize(700, 701);
        this.getContentPane().add(this.usableItem);
        this.getContentPane().add(this.inventaire);
        this.getContentPane().add(this.zoneJeu);
        this.getContentPane().add(this.miniMap);
        this.getContentPane().add(this.zonePersonnage);
        this.getContentPane().add(this.zoneCommande);
        this.getContentPane().add(panel);
        this.getContentPane().add(invLabel);
        this.getContentPane().add(usableLabel);
        this.getContentPane().add(this.console);
        this.keyboardListener = new KeyboardListener(this.game);
        this.zoneCommande.addKeyListener(this.keyboardListener);
        this.zoneJeu.addKeyListener(this.keyboardListener);
        this.zonePersonnage.addKeyListener(this.keyboardListener);
        this.miniMap.addKeyListener(this.keyboardListener);
        this.getContentPane().add(new JLabel());
        this.updateInventaire(this.game.getPlayer());
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setVisible(true);
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void updateInventaire(Player joueur) {
        this.inventaire.removeAllItems();
        Enumeration e = joueur.getInventory().elements();
        while (e.hasMoreElements()) {
            Item tmp = (Item)e.nextElement();
            this.inventaire.addItem(tmp);
        }
    }

    private class ListenerInventaire
    implements ActionListener {
        ListenerInventaire() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ListenerUsableItems
    implements ActionListener {
        ListenerUsableItems() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ListenerConsole
    implements ActionListener {
        ListenerConsole() {
        }

        public void actionPerformed(ActionEvent e) {
            String commande = GameFrame.this.console.getText();
            GameFrame.this.console.setText("");
            GameFrame.this.game.executeCommand(commande);
        }
    }
}

