/*
 * Decompiled with CFR 0.152.
 */
package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import zork2Class.DirectoryListReader;
import zork2Class.Game;
import zork2Class.Player;

public class LoadGameFrame
extends JDialog {
    private JList partie;
    private Game laPartie;
    private Vector ret = new Vector(0, 1);

    public LoadGameFrame(JFrame owner, Game laPartie) {
        super((Frame)owner, true);
        this.init(laPartie);
    }

    public LoadGameFrame(JDialog owner, Game laPartie) {
        super((Dialog)owner, true);
        this.init(laPartie);
    }

    private void init(Game laPartie) {
        this.laPartie = laPartie;
        this.setTitle("Zork 2 : Charger une partie");
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.setDefaultCloseOperation(1);
        this.getContentPane().setBackground(new Color(255, 255, 206));
        JLabel image = new JLabel(new ImageIcon("images/ihms/load/z2.jpg"));
        this.getContentPane().add((Component)image, "North");
        JPanel panelCentre = new JPanel(new BorderLayout(10, 10));
        JPanel panelNorth = new JPanel(new GridLayout(1, 2, 10, 10));
        JPanel panelSouth = new JPanel(new GridLayout(1, 2, 10, 10));
        panelSouth.setBackground(new Color(255, 255, 206));
        panelNorth.setBackground(new Color(255, 255, 206));
        panelCentre.setBackground(new Color(255, 255, 206));
        this.partie = new JList(this.ret);
        JScrollPane scrollPane = new JScrollPane(this.partie);
        this.partie.setBackground(new Color(255, 255, 206));
        this.partie.setOpaque(true);
        panelNorth.add(new JLabel("parties existantes :", 2));
        panelNorth.add(new JLabel());
        panelCentre.add((Component)scrollPane, "Center");
        JButton annuler = new JButton(new ImageIcon("images/ihms/bac.gif"));
        annuler.setRolloverIcon(new ImageIcon("images/ihms/bac2.gif"));
        annuler.setPressedIcon(new ImageIcon("images/ihms/bac3.gif"));
        annuler.setContentAreaFilled(false);
        annuler.addActionListener(new ListenerBoutonsAnnuler());
        JButton valider = new JButton(new ImageIcon("images/ihms/load/load.gif"));
        valider.setRolloverIcon(new ImageIcon("images/ihms/load/load2.gif"));
        valider.setPressedIcon(new ImageIcon("images/ihms/load/load3.gif"));
        valider.setContentAreaFilled(false);
        valider.addActionListener(new ListenerBoutonsValider());
        panelSouth.add(annuler);
        panelSouth.add(valider);
        panelCentre.add((Component)panelNorth, "North");
        panelCentre.add((Component)panelSouth, "South");
        DirectoryListReader tmp = new DirectoryListReader("./sauvegardes");
        String[] donjons = tmp.listDirectory();
        this.refresh();
        this.getContentPane().add((Component)panelCentre, "Center");
        this.setResizable(false);
        this.setSize(326, 440);
    }

    public void refresh() {
        this.ret = new Vector(0, 1);
        File repertoire = new File("./sauvegardes");
        String[] fichiers = repertoire.list();
        int i = 0;
        while (i < fichiers.length) {
            if (fichiers[i].endsWith(".sz2")) {
                fichiers[i] = fichiers[i].replaceAll(".sz2", "");
                this.ret.addElement(fichiers[i]);
            }
            ++i;
        }
        this.partie.setListData(this.ret);
        this.partie.setSelectedIndex(0);
    }

    private class ListenerBoutonsAnnuler
    implements ActionListener {
        ListenerBoutonsAnnuler() {
        }

        public void actionPerformed(ActionEvent e) {
            LoadGameFrame.this.hide();
        }
    }

    private class ListenerBoutonsValider
    implements ActionListener {
        ListenerBoutonsValider() {
        }

        public void actionPerformed(ActionEvent e) {
            String tmp = (String)LoadGameFrame.this.partie.getSelectedValue();
            LoadGameFrame.this.hide();
            LoadGameFrame.this.hide();
            LoadGameFrame.this.laPartie.setPlayer(new Player());
            LoadGameFrame.this.laPartie.changeIsLocked();
            LoadGameFrame.this.laPartie.launchGame();
            LoadGameFrame.this.laPartie.executeCommand("load " + tmp);
        }
    }
}

