/*
 * Decompiled with CFR 0.152.
 */
package gameIHM;

import gameIHM.GameFrame;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;
import zork2Class.Item;
import zork2Class.Player;
import zork2Class.Room;

public class MiniMap
extends Canvas {
    private GameFrame fenetre;
    private final int LARGEUR_SALLE = 60;
    private Image bufferImage;
    private Image roseVent;
    private Image fond;

    public MiniMap(GameFrame fenetre) {
        this.fenetre = fenetre;
        this.init();
    }

    public MiniMap() {
        this.init();
    }

    private void init() {
        this.roseVent = Toolkit.getDefaultToolkit().getImage("images/imgDefault/RoseVents.gif");
        this.fond = Toolkit.getDefaultToolkit().getImage("images/imgDefault/FondMiniMap.jpg");
        this.setBackground(Color.lightGray);
        this.setVisible(true);
    }

    public void paint(Graphics g) {
        if (this.bufferImage == null) {
            this.bufferImage = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics buffer = this.bufferImage.getGraphics();
        boolean haveMap = false;
        int milieuX = this.getWidth() / 2;
        int milieuY = this.getHeight() / 2;
        buffer.drawImage(this.fond, 1, 1, this);
        buffer.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        buffer.drawImage(this.roseVent, 10, 10, this);
        Player joueur = this.fenetre.getGame().getPlayer();
        Room salle = joueur.getCurrentRoom();
        this.drawRoom(buffer, milieuX, milieuY, salle);
        Vector items = joueur.getInventory();
        Enumeration e = items.elements();
        while (e.hasMoreElements()) {
            Item tmp = (Item)e.nextElement();
            if (!tmp.isMap()) continue;
            haveMap = true;
        }
        if (salle.getDoorNorth() != null && (salle.getDoorNorth().getDestination().isVisited() || haveMap)) {
            this.drawRoom(buffer, milieuX, milieuY - 60 - 4, salle.getDoorNorth().getDestination());
        }
        if (salle.getDoorSouth() != null && (salle.getDoorSouth().getDestination().isVisited() || haveMap)) {
            this.drawRoom(buffer, milieuX, milieuY + 60 + 4, salle.getDoorSouth().getDestination());
        }
        if (salle.getDoorEast() != null && (salle.getDoorEast().getDestination().isVisited() || haveMap)) {
            this.drawRoom(buffer, milieuX + 60 + 4, milieuY, salle.getDoorEast().getDestination());
        }
        if (salle.getDoorWest() != null && (salle.getDoorWest().getDestination().isVisited() || haveMap)) {
            this.drawRoom(buffer, milieuX - 60 - 4, milieuY, salle.getDoorWest().getDestination());
        }
        g.drawImage(this.bufferImage, 0, 0, this);
    }

    private void drawRoom(Graphics g, int milieuX, int milieuY, Room salle) {
        g.setColor(Color.white);
        g.fillRect(milieuX - this.LARGEUR_SALLE / 2, milieuY - this.LARGEUR_SALLE / 2, 60, 60);
        g.setColor(Color.black);
        g.drawRect(milieuX - this.LARGEUR_SALLE / 2, milieuY - this.LARGEUR_SALLE / 2, 60, 60);
        int j = 0;
        while (j < 8) {
            int i = 0;
            while (i < 8) {
                if (salle.getItemPosition(i, j) != null) {
                    Item objet = salle.getItemPosition(i, j);
                    if (salle.getItemPosition(i, j).couldBeCross()) {
                        g.setColor(Color.lightGray);
                        g.fillRect(milieuX - this.LARGEUR_SALLE / 2 + i * 7 + 3, milieuY - this.LARGEUR_SALLE / 2 + j * 7 + 3, 6, 6);
                    } else {
                        g.setColor(Color.black);
                        g.fillRect(milieuX - this.LARGEUR_SALLE / 2 + i * 7 + 3, milieuY - this.LARGEUR_SALLE / 2 + j * 7 + 3, 6, 6);
                    }
                }
                if (salle.getChest() != null && salle.getChest().getPosX() == i && salle.getChest().getPosY() == j) {
                    if (salle.getChest().isOpen()) {
                        g.setColor(Color.cyan);
                        g.fillRect(milieuX - this.LARGEUR_SALLE / 2 + i * 7 + 3, milieuY - this.LARGEUR_SALLE / 2 + j * 7 + 3, 6, 6);
                    } else {
                        g.setColor(Color.blue);
                        g.fillRect(milieuX - this.LARGEUR_SALLE / 2 + i * 7 + 3, milieuY - this.LARGEUR_SALLE / 2 + j * 7 + 3, 6, 6);
                    }
                }
                if (this.fenetre.getGame().getPlayer().getPosX() == i && this.fenetre.getGame().getPlayer().getPosY() == j && this.getWidth() / 2 == milieuX && this.getHeight() / 2 == milieuY) {
                    this.drawPlayer(g, milieuX - this.LARGEUR_SALLE / 2 + i * 7 + 3, milieuY - this.LARGEUR_SALLE / 2 + j * 7 + 3);
                }
                ++i;
            }
            ++j;
        }
        if (salle.getDoorNorth() != null) {
            if (salle.getDoorNorth().doorIsOpen()) {
                this.drawNorthDoor(g, milieuX, milieuY, new Color(128, 64, 0));
            } else {
                this.drawNorthDoor(g, milieuX, milieuY, Color.red);
            }
        }
        if (salle.getDoorSouth() != null) {
            if (salle.getDoorSouth().doorIsOpen()) {
                this.drawSouthDoor(g, milieuX, milieuY, new Color(128, 64, 0));
            } else {
                this.drawSouthDoor(g, milieuX, milieuY, Color.red);
            }
        }
        if (salle.getDoorEast() != null) {
            if (salle.getDoorEast().doorIsOpen()) {
                this.drawEastDoor(g, milieuX, milieuY, new Color(128, 64, 0));
            } else {
                this.drawEastDoor(g, milieuX, milieuY, Color.red);
            }
        }
        if (salle.getDoorWest() != null) {
            if (salle.getDoorWest().doorIsOpen()) {
                this.drawWestDoor(g, milieuX, milieuY, new Color(128, 64, 0));
            } else {
                this.drawWestDoor(g, milieuX, milieuY, Color.red);
            }
        }
    }

    private void drawWestDoor(Graphics g, int milieuX, int milieuY, Color couleur) {
        g.setColor(couleur);
        g.fillRect(milieuX - this.LARGEUR_SALLE / 2 - 2, milieuY - 14, 4, 16);
    }

    private void drawEastDoor(Graphics g, int milieuX, int milieuY, Color couleur) {
        g.setColor(couleur);
        g.fillRect(milieuX + this.LARGEUR_SALLE / 2 - 2, milieuY - 14, 4, 16);
    }

    private void drawNorthDoor(Graphics g, int milieuX, int milieuY, Color couleur) {
        g.setColor(couleur);
        g.fillRect(milieuX - 7, milieuY - this.LARGEUR_SALLE / 2 - 2, 16, 4);
    }

    private void drawSouthDoor(Graphics g, int milieuX, int milieuY, Color couleur) {
        g.setColor(couleur);
        g.fillRect(milieuX - 7, milieuY + this.LARGEUR_SALLE / 2 - 2, 16, 4);
    }

    private void drawPlayer(Graphics g, int posX, int posY) {
        g.setColor(Color.BLACK);
        g.drawLine(posX + 3, posY, posX + 3, posY + 4);
        g.drawLine(posX + 1, posY + 2, posX + 5, posY + 2);
        g.drawLine(posX + 1, posY + 6, posX + 2, posY + 5);
        g.drawLine(posX + 5, posY + 6, posX + 4, posY + 5);
    }
}

