/*
 * Decompiled with CFR 0.152.
 */
package gameIHM;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import zork2Class.Game;
import zork2Class.HighScoreFile;
import zork2Class.Item;

public class WinnerFrame
extends JDialog {
    private Game partie;

    public WinnerFrame(Game partie, boolean win) {
        JLabel labelCentre;
        this.partie = partie;
        this.setSize(450, 400);
        this.setResizable(false);
        this.getContentPane().setBackground(new Color(255, 255, 206));
        this.setDefaultCloseOperation(3);
        if (win) {
            this.setTitle("Bravo vous avez gagn\u00e9 !!!");
            labelCentre = new JLabel(new ImageIcon("images/ihms/winner/win.jpg"));
            this.getContentPane().add((Component)labelCentre, "Center");
        } else {
            this.setTitle("vous avez perdu !!!");
            labelCentre = new JLabel(new ImageIcon("images/ihms/winner/lost.jpg"));
            this.getContentPane().add((Component)labelCentre, "Center");
        }
        JButton menu = new JButton(new ImageIcon("images/ihms/winner/mp.gif"));
        menu.setRolloverIcon(new ImageIcon("images/ihms/winner/mp2.gif"));
        menu.setPressedIcon(new ImageIcon("images/ihms/winner/mp3.gif"));
        menu.setContentAreaFilled(false);
        JButton quitter = new JButton(new ImageIcon("images/ihms/winner/quit.gif"));
        quitter.setRolloverIcon(new ImageIcon("images/ihms/winner/quit2.gif"));
        quitter.setPressedIcon(new ImageIcon("images/ihms/winner/quit3.gif"));
        quitter.setContentAreaFilled(false);
        JButton highScore = new JButton(new ImageIcon("images/ihms/winner/ms.gif"));
        highScore.setRolloverIcon(new ImageIcon("images/ihms/winner/ms2.gif"));
        highScore.setPressedIcon(new ImageIcon("images/ihms/winner/ms3.gif"));
        highScore.setContentAreaFilled(false);
        menu.addActionListener(new MenuListener());
        quitter.addActionListener(new QuitterListener());
        highScore.addActionListener(new HighScoreListener());
        JPanel panelSouth = new JPanel(new GridLayout(1, 3));
        panelSouth.setBackground(new Color(255, 255, 206));
        panelSouth.add(menu);
        panelSouth.add(highScore);
        panelSouth.add(quitter);
        this.getContentPane().add((Component)panelSouth, "South");
        this.show();
        long score = partie.getPlayer().getScore().getValue();
        Enumeration e = partie.getPlayer().getInventory().elements();
        while (e.hasMoreElements()) {
            Item tmp = (Item)e.nextElement();
            score += (long)tmp.getValue();
        }
        HighScoreFile bestScore = new HighScoreFile(partie.getDungeonName());
        if (bestScore.writeScore(partie.getPlayer().getName(), score)) {
            JOptionPane.showMessageDialog(this, "Vous avez realis\u00e9e un des meilleurs scores avec un score de " + score, "meilleurs scores", 1);
        }
    }

    private class MenuListener
    implements ActionListener {
        MenuListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            WinnerFrame.this.hide();
            WinnerFrame.this.partie = new Game();
            WinnerFrame.this.partie.changeIsLocked();
            WinnerFrame.this.partie.launchMainMenu();
        }
    }

    private class HighScoreListener
    implements ActionListener {
        HighScoreListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            WinnerFrame.this.partie.executeCommand("best score");
        }
    }

    private class QuitterListener
    implements ActionListener {
        QuitterListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            WinnerFrame.this.partie.executeCommand("exit");
        }
    }
}

