/*
 * Decompiled with CFR 0.152.
 */
package gameIHM;

import gameIHM.GameFrame;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import zork2Class.Chest;
import zork2Class.Item;
import zork2Class.Player;
import zork2Class.Room;

public class ZoneJeu
extends Canvas {
    private GameFrame fenetre;
    private Image joueur;
    private Image roseVent;
    private Image zork2;
    private Image epe;
    private Image bufferImage;
    private static final int DECALAGE_X = 3;
    private static final int DECALAGE_Y = 70;
    private static final int TAILLE_CASEX = 44;
    private static final int TAILLE_CASEY = 35;
    private static final int TAILLEX_MUR_N = 354;
    private static final int TAILLEY_MUR_N = 66;
    private static final int TAILLEX_MUR_E = 141;
    private static final int TAILLEY_MUR_E = 345;
    private static final int TAILLEX_SOL = 494;
    private static final int TAILLEY_SOL = 280;
    private static final int DECALAGE_HAUT = 138;
    private int oldX;
    private int oldY;

    public ZoneJeu(GameFrame fenetre) {
        this.fenetre = fenetre;
        this.init();
    }

    public ZoneJeu() {
        this.init();
    }

    private void init() {
        this.setBackground(new Color(255, 255, 206));
        this.roseVent = Toolkit.getDefaultToolkit().getImage("images/imgDefault/RoseVents2.gif");
        this.zork2 = Toolkit.getDefaultToolkit().getImage("images/ihms/zork2play.jpg");
        this.epe = Toolkit.getDefaultToolkit().getImage("images/imgDefault/epe.gif");
        this.joueur = Toolkit.getDefaultToolkit().getImage("images/imgDefault/merlin.gif");
        this.oldX = 3;
        this.oldY = 3;
        this.setVisible(true);
    }

    public void paint(Graphics g) {
        if (this.bufferImage == null) {
            this.bufferImage = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics buffer = this.bufferImage.getGraphics();
        Player joueur = this.fenetre.getGame().getPlayer();
        Room salle = joueur.getCurrentRoom();
        int x = joueur.getPosX();
        int y = joueur.getPosY();
        boolean isArmee = joueur.getCurrentWeapon() != null;
        buffer.drawImage(this.roseVent, 10, 10, this);
        buffer.drawImage(this.zork2, 120, 433, this);
        buffer.drawImage(salle.getImgFloor(), 3, 136, this);
        buffer.setColor(this.getBackground());
        buffer.fillRect(143, 70, 354, 66);
        buffer.drawImage(salle.getImgBackWall(), 143, 70, this);
        if (salle.getDoorNorth() != null) {
            buffer.drawImage(salle.getDoorNorth().getImgDoor(), 277, 70, this);
        }
        buffer.drawImage(salle.getImgLeftWall(), 3, 70, this);
        if (salle.getDoorWest() != null) {
            buffer.drawImage(salle.getDoorWest().getImgDoor(), 71, 145, this);
        }
        Item[][] tabTmp = salle.getItemPosition();
        int i = 0;
        while (i < tabTmp.length) {
            int j = 0;
            while (j < tabTmp[i].length) {
                Chest coffre = salle.getChest();
                if (coffre != null && coffre.getPosX() == i && coffre.getPosY() == j) {
                    if (salle.getChest().isOpen()) {
                        buffer.drawImage(coffre.getImgChestOpen(), i * 44 + 138 - j * 18 + 3 - 8, j * 35 + 25 + 70, 44, 67, this);
                    } else {
                        buffer.drawImage(coffre.getImgChestClose(), i * 44 + 138 - j * 18 + 3 - 8, j * 35 + 25 + 70, 44, 67, this);
                    }
                } else if (tabTmp[i][j] != null) {
                    buffer.drawImage(tabTmp[i][j].getImage(), i * 44 + 138 - j * 18 + 3 - 8, j * 35 + 25 + 70, 44, 67, this);
                }
                if (i == x && j == y) {
                    buffer.drawImage(this.joueur, x * 44 + 138 - y * 18 + 3 - 8, y * 35 + 25 + 70, this);
                    if (isArmee) {
                        buffer.drawImage(this.epe, x * 44 + 138 - y * 18 + 3 - 8, y * 35 + 25 + 70, this);
                    }
                }
                ++j;
            }
            ++i;
        }
        buffer.drawImage(salle.getImgRightWall(), 357, 70, this);
        if (salle.getDoorEast() != null) {
            buffer.drawImage(salle.getDoorEast().getImgDoor(), 425, 145, this);
        }
        buffer.drawImage(salle.getImgFrontWall(), 3, 350, this);
        if (salle.getDoorSouth() != null) {
            buffer.drawImage(salle.getDoorSouth().getImgDoor(), 139, 350, this);
        }
        g.drawImage(this.bufferImage, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void movePlayerNorth() {
        Player joueur = this.fenetre.getGame().getPlayer();
        int x = joueur.getPosX();
        int y = joueur.getPosY();
        if (y - 1 > 0 && y - 1 < 8) {
            this.repaint(this.oldX * 44 + 138 - this.oldY * 18 + 3, this.oldY * 35 + 25 + 70, 43, 67);
            this.repaint(this.oldX * 44 + 138 - (this.oldY - 1) * 18 + 3, (this.oldY - 1) * 35 + 25 + 70, 43, 67);
        }
    }

    public void movePlayerSouth() {
        Player joueur = this.fenetre.getGame().getPlayer();
        int x = joueur.getPosX();
        int y = joueur.getPosY();
        if (y + 1 > 0 && y + 1 < 8) {
            this.repaint(this.oldX * 44 + 138 - this.oldY * 18 + 3, this.oldY * 35 + 25 + 70, 43, 67);
            this.repaint(this.oldX * 44 + 138 - (this.oldY + 1) * 18 + 3, (this.oldY + 1) * 35 + 25 + 70, 43, 67);
        }
    }

    public void movePlayerEast() {
        Player joueur = this.fenetre.getGame().getPlayer();
        int x = joueur.getPosX();
        int y = joueur.getPosY();
        if (x + 1 > 0 && x + 1 < 8) {
            this.repaint(this.oldX * 44 + 138 - this.oldY * 18 + 3, this.oldY * 35 + 25 + 70, 43, 67);
            this.repaint((this.oldX + 1) * 44 + 138 - this.oldY * 18 + 3, this.oldY * 35 + 25 + 70, 43, 67);
        }
    }

    public void movePlayerWest() {
        Player joueur = this.fenetre.getGame().getPlayer();
        int x = joueur.getPosX();
        int y = joueur.getPosY();
        if (x - 1 > 0 && x - 1 < 8) {
            this.repaint(this.oldX * 44 + 138 - this.oldY * 18 + 3, this.oldY * 35 + 25 + 70, 43, 67);
            this.repaint((this.oldX - 1) * 44 + 138 - this.oldY * 18 + 3, this.oldY * 35 + 25 + 70, 43, 67);
        }
    }
}

