/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;
import zork2Class.Room;

public class Door {
    public static final String IMG_NEXT_DOOR_DEFAULT_PATH = "images/imgDefault/Door_E.gif";
    public static final String IMG_FRONT_DOOR_DEFAULT_PATH = "images/imgDefault/Door.gif";
    private String key = "no_key";
    private String destinationName;
    private Room destination;
    private Image imgDoor;
    private boolean isOpen;

    public Door() {
        this.isOpen = true;
        this.invariant();
    }

    public Door(String laPiece) {
        this.destinationName = laPiece;
        this.isOpen = true;
        this.invariant();
    }

    public Door(Room laPiece) {
        this.destination = laPiece;
        this.isOpen = true;
        this.invariant();
    }

    public boolean CanBeOpen() {
        boolean ret = true;
        if (this.getKey().equalsIgnoreCase("no_key") && !this.isOpen) {
            ret = false;
        }
        this.invariant();
        return ret;
    }

    public String getDestinationName() {
        this.invariant();
        return this.destinationName;
    }

    public boolean doorIsOpen() {
        this.invariant();
        return this.isOpen;
    }

    public String getKey() {
        this.invariant();
        return this.key;
    }

    public Room getDestination() {
        this.invariant();
        return this.destination;
    }

    public Image getImgDoor() {
        this.invariant();
        return this.imgDoor;
    }

    public void setDestinationName(String destination) {
        this.destinationName = destination;
        this.invariant();
    }

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
        this.invariant();
    }

    public void setKey(String key) {
        this.key = key;
        this.invariant();
    }

    public void setDestination(Room destination) {
        this.destination = destination;
        this.invariant();
    }

    public void setImgDoor(Image imgDoor) {
        this.imgDoor = imgDoor;
        this.invariant();
    }

    public void setImgDoor(String imgDoor) {
        this.imgDoor = Toolkit.getDefaultToolkit().getImage(imgDoor);
        this.invariant();
    }

    public void checkAndSetImgDoor(String string) {
        if (this.imgDoor == null) {
            if (string.equalsIgnoreCase("east") || string.equalsIgnoreCase("west")) {
                this.setImgDoor(IMG_NEXT_DOOR_DEFAULT_PATH);
            } else if (string.equalsIgnoreCase("north") || string.equalsIgnoreCase("south")) {
                this.setImgDoor(IMG_FRONT_DOOR_DEFAULT_PATH);
            }
        }
        this.invariant();
    }

    private void invariant() {
    }
}

