/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import zork2Class.Chest;
import zork2Class.Door;
import zork2Class.Item;
import zork2Class.ItemFileReader;
import zork2Class.Ordeal;
import zork2Class.OrdealFileReader;
import zork2Class.Room;

public class DungeonFileReader {
    private Hashtable listRooms = new Hashtable();
    private Hashtable tableItems;
    private Hashtable tableOrdeals;
    private String nameDungeon;
    private String firstRoom;
    private String finalRoom;

    public DungeonFileReader(String str) {
        this.nameDungeon = str;
    }

    public boolean readDungeonFile() {
        boolean ret = false;
        Room room = null;
        try {
            try {
                String s;
                this.loadDungeonParts();
                FileReader inReader = new FileReader("maps/" + this.nameDungeon + "/dungeon.zdu");
                BufferedReader in = new BufferedReader(inReader);
                while (!(s = in.readLine().trim()).equals("<DUNGEON>")) {
                }
                s = in.readLine().trim();
                while (!s.equals("</DUNGEON>") && s != null) {
                    StringTokenizer sl;
                    StringTokenizer st = new StringTokenizer(s, "=");
                    if (st.hasMoreTokens()) {
                        s = st.nextToken().trim();
                    }
                    if (s.startsWith("<!--")) {
                        while (!s.endsWith("-->")) {
                            s = in.readLine().trim();
                        }
                    } else if (s.equalsIgnoreCase("firstRoom")) {
                        sl = new StringTokenizer(st.nextToken().trim(), "\"");
                        if (sl.hasMoreTokens()) {
                            this.firstRoom = sl.nextToken().trim();
                        }
                    } else if (s.equalsIgnoreCase("finalRoom")) {
                        sl = new StringTokenizer(st.nextToken().trim(), "\"");
                        if (sl.hasMoreTokens()) {
                            this.finalRoom = sl.nextToken().trim();
                        }
                    } else {
                        if (s.equalsIgnoreCase("<ROOM>")) {
                            room = new Room();
                            s = in.readLine().trim();
                            while (!s.equalsIgnoreCase("</ROOM>")) {
                                if (s.equals("")) {
                                    while ((s = in.readLine().trim()).equals("")) {
                                    }
                                    continue;
                                }
                                if (s.startsWith("<!--")) {
                                    while (!s.endsWith("-->")) {
                                        s = in.readLine().trim();
                                    }
                                } else {
                                    if (s != null) {
                                        st = new StringTokenizer(s, "=");
                                        s = st.nextToken().trim();
                                    }
                                    if (s.equalsIgnoreCase("Name")) {
                                        s = st.nextToken().trim();
                                        sl = new StringTokenizer(s, "\"");
                                        if (sl.hasMoreTokens()) {
                                            room.setRoomName(sl.nextToken().trim());
                                        }
                                    } else if (s.equalsIgnoreCase("Description")) {
                                        s = st.nextToken().trim();
                                        sl = new StringTokenizer(s, "\"");
                                        if (sl.hasMoreTokens()) {
                                            room.setRoomDescription(sl.nextToken().trim());
                                            room.setRoomDescription(room.getDescription().replace('\u00a4', '\n'));
                                        }
                                    } else if (s.equalsIgnoreCase("imgBackWall")) {
                                        s = st.nextToken().trim();
                                        sl = new StringTokenizer(s, "\"");
                                        if (sl.hasMoreTokens() && !(s = sl.nextToken().trim()).equalsIgnoreCase("default")) {
                                            room.setImgBackWall(s);
                                        }
                                    } else if (s.equalsIgnoreCase("imgRightWall")) {
                                        s = st.nextToken().trim();
                                        sl = new StringTokenizer(s, "\"");
                                        if (sl.hasMoreTokens() && !(s = sl.nextToken().trim()).equalsIgnoreCase("default")) {
                                            room.setImgRightWall(s);
                                        }
                                    } else if (s.equalsIgnoreCase("imgFrontWall")) {
                                        s = st.nextToken().trim();
                                        sl = new StringTokenizer(s, "\"");
                                        if (sl.hasMoreTokens() && !(s = sl.nextToken().trim()).equalsIgnoreCase("default")) {
                                            room.setImgFrontWall(s);
                                        }
                                    } else if (s.equalsIgnoreCase("imgLeftWall")) {
                                        s = st.nextToken().trim();
                                        sl = new StringTokenizer(s, "\"");
                                        if (sl.hasMoreTokens() && !(s = sl.nextToken().trim()).equalsIgnoreCase("default")) {
                                            room.setImgLeftWall(s);
                                        }
                                    } else if (s.equalsIgnoreCase("imgFloor")) {
                                        s = st.nextToken().trim();
                                        sl = new StringTokenizer(s, "\"");
                                        if (sl.hasMoreTokens() && !(s = sl.nextToken().trim()).equalsIgnoreCase("default")) {
                                            room.setImgFloor(s);
                                        }
                                    } else if (s.equalsIgnoreCase("Ordeal")) {
                                        sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                        if (sl.hasMoreTokens()) {
                                            s = sl.nextToken().trim();
                                            Ordeal tempOrd = (Ordeal)this.tableOrdeals.get(s.toLowerCase());
                                            room.setOrdeal(tempOrd);
                                        }
                                    } else if (s.equalsIgnoreCase("<ITEM>")) {
                                        st = new StringTokenizer(in.readLine(), "=");
                                        if (st.hasMoreElements()) {
                                            s = st.nextToken().trim();
                                        }
                                        int posX = 4;
                                        int posY = 4;
                                        String nameItem = new String();
                                        while (!s.equalsIgnoreCase("</ITEM>")) {
                                            if (s.equalsIgnoreCase("name")) {
                                                s = st.nextToken();
                                                sl = new StringTokenizer(s.trim(), "\"");
                                                if (sl.hasMoreTokens()) {
                                                    nameItem = sl.nextToken().trim();
                                                }
                                            } else if (s.equalsIgnoreCase("posX")) {
                                                sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                                if (sl.hasMoreTokens()) {
                                                    posX = Integer.parseInt(sl.nextToken().trim());
                                                }
                                            } else if (s.equalsIgnoreCase("posY") && (sl = new StringTokenizer(st.nextToken().trim(), "\"")).hasMoreTokens()) {
                                                posY = Integer.parseInt(sl.nextToken().trim());
                                            }
                                            if (!(st = new StringTokenizer(in.readLine(), "=")).hasMoreTokens()) continue;
                                            s = st.nextToken().trim();
                                        }
                                        if (!nameItem.equals("") && this.tableItems.containsKey(nameItem)) {
                                            Item item = (Item)this.tableItems.get(nameItem);
                                            room.setItemPosition(item, posX, posY);
                                        }
                                    } else if (s.equalsIgnoreCase("<CHEST>")) {
                                        s = in.readLine().trim();
                                        Chest chest = new Chest();
                                        while (!s.equalsIgnoreCase("</CHEST>")) {
                                            if (s.startsWith("<!--")) {
                                                while (!s.endsWith("-->")) {
                                                    s = in.readLine().trim();
                                                }
                                            } else {
                                                st = new StringTokenizer(s, "=");
                                                if (st.hasMoreTokens()) {
                                                    s = st.nextToken();
                                                    s = s.trim();
                                                }
                                                if (s.equalsIgnoreCase("Key")) {
                                                    sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                                    if (sl.hasMoreTokens()) {
                                                        chest.setKey(sl.nextToken());
                                                    }
                                                } else if (s.equalsIgnoreCase("Item")) {
                                                    sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                                    if (sl.hasMoreTokens() && this.tableItems.containsKey(s = sl.nextToken())) {
                                                        chest.setItem((Item)this.tableItems.get(s));
                                                    }
                                                } else if (s.equalsIgnoreCase("imgClose")) {
                                                    sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                                    if (sl.hasMoreTokens() && !(s = sl.nextToken()).equalsIgnoreCase("default")) {
                                                        chest.setImgChestClose(Toolkit.getDefaultToolkit().getImage(s));
                                                    }
                                                } else if (s.equalsIgnoreCase("imgOpen")) {
                                                    sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                                    if (sl.hasMoreTokens() && !(s = sl.nextToken()).equalsIgnoreCase("default")) {
                                                        chest.setImgChestOpen(Toolkit.getDefaultToolkit().getImage(s));
                                                    }
                                                } else if (s.equalsIgnoreCase("isOpen")) {
                                                    sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                                    if (sl.hasMoreTokens() && (s = sl.nextToken()).equalsIgnoreCase("false")) {
                                                        chest.setIsOpen(false);
                                                    }
                                                } else if (s.equalsIgnoreCase("posX")) {
                                                    sl = new StringTokenizer(st.nextToken().trim(), "\"");
                                                    if (sl.hasMoreTokens()) {
                                                        chest.setPosX(Integer.parseInt(sl.nextToken().trim()));
                                                    }
                                                } else if (s.equalsIgnoreCase("posY") && (sl = new StringTokenizer(st.nextToken().trim(), "\"")).hasMoreTokens()) {
                                                    chest.setPosY(Integer.parseInt(sl.nextToken().trim()));
                                                }
                                            }
                                            s = in.readLine().trim();
                                        }
                                        room.setChest(chest);
                                    } else if (s.equalsIgnoreCase("<DOOR>")) {
                                        s = in.readLine().trim();
                                        while (!s.equalsIgnoreCase("</DOOR>")) {
                                            Door door = new Door();
                                            if (s.equalsIgnoreCase("<NORTH>")) {
                                                s = in.readLine().trim();
                                                while (!s.equalsIgnoreCase("</NORTH>")) {
                                                    this.readDoor(door, s);
                                                    s = in.readLine().trim();
                                                }
                                                room.setDoorNorth(door);
                                            } else if (s.equalsIgnoreCase("<SOUTH>")) {
                                                s = in.readLine().trim();
                                                while (!s.equalsIgnoreCase("</SOUTH>")) {
                                                    this.readDoor(door, s);
                                                    s = in.readLine().trim();
                                                }
                                                room.setDoorSouth(door);
                                            } else if (s.equalsIgnoreCase("<EAST>")) {
                                                s = in.readLine().trim();
                                                while (!s.equalsIgnoreCase("</EAST>")) {
                                                    this.readDoor(door, s);
                                                    s = in.readLine().trim();
                                                }
                                                room.setDoorEast(door);
                                            } else if (s.equalsIgnoreCase("<WEST>")) {
                                                s = in.readLine().trim();
                                                while (!s.equalsIgnoreCase("</WEST>")) {
                                                    this.readDoor(door, s);
                                                    s = in.readLine().trim();
                                                }
                                                room.setDoorWest(door);
                                            }
                                            s = in.readLine().trim();
                                        }
                                    }
                                }
                                s = in.readLine();
                                if (s == null) continue;
                                s = s.trim();
                            }
                        }
                        if (room != null && room.getName() != null) {
                            this.listRooms.put(room.getName(), room);
                        }
                    }
                    s = in.readLine();
                    if (s == null) continue;
                    s = s.trim();
                }
                in.close();
                ret = true;
                if (this.firstRoom == null) {
                    JOptionPane.showMessageDialog(null, "Le fichier " + this.nameDungeon + "/dongeon.zdu ne comporte pas d'attributs beginRoom.\n Cet attribut est obligatoire.", "Incoh\u00e9rences dans le fichier de param\u00e9trages", 0);
                    ret = false;
                } else {
                    boolean isIn = false;
                    Enumeration e = this.listRooms.keys();
                    while (e.hasMoreElements()) {
                        if (!this.firstRoom.equalsIgnoreCase((String)e.nextElement())) continue;
                        isIn = true;
                    }
                    if (!isIn) {
                        JOptionPane.showMessageDialog(null, "L'attribut firstRoom contenu dans le fichier " + this.nameDungeon + "/dongeon.zdu, n'est pas une salle existante.\n Veuillez contacter le cr\u00e9ateur du niveau.", "Incoh\u00e9rences dans le fichier de param\u00e9trages", 0);
                        ret = false;
                    }
                }
                if (ret) {
                    if (this.finalRoom == null) {
                        JOptionPane.showMessageDialog(null, "Le fichier " + this.nameDungeon + "/dongeon.zdu ne comporte pas d'attributs finalRoom.\n Cet attribut est obligatoire.", "Incoh\u00e9rences dans le fichier de param\u00e9trages", 0);
                        ret = false;
                    } else {
                        boolean isIn = false;
                        Enumeration e = this.listRooms.keys();
                        while (e.hasMoreElements()) {
                            if (!this.finalRoom.equalsIgnoreCase((String)e.nextElement())) continue;
                            isIn = true;
                        }
                        if (!isIn) {
                            JOptionPane.showMessageDialog(null, "L'attribut finalRoom contenu dans le fichier " + this.nameDungeon + "/dongeon.zdu, n'est pas une salle existante.\n Veuillez contacter le cr\u00e9ateur du niveau.", "Incoh\u00e9rences dans le fichier de param\u00e9trages", 0);
                            ret = false;
                        }
                    }
                }
                if (ret) {
                    Enumeration e = this.listRooms.elements();
                    while (e.hasMoreElements()) {
                        room = (Room)e.nextElement();
                        if (room.getDoorEast() != null) {
                            room.setDoorEast(this.loadDoor(room.getDoorEast()));
                        }
                        if (room.getDoorWest() != null) {
                            room.setDoorWest(this.loadDoor(room.getDoorWest()));
                        }
                        if (room.getDoorSouth() != null) {
                            room.setDoorSouth(this.loadDoor(room.getDoorSouth()));
                        }
                        if (room.getDoorNorth() == null) continue;
                        room.setDoorNorth(this.loadDoor(room.getDoorNorth()));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Erreur de chargement", 0);
                ret = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return ret;
    }

    private Door loadDoor(Door door) {
        boolean roomExist = false;
        String nameDest = door.getDestinationName();
        Enumeration e = this.listRooms.keys();
        while (e.hasMoreElements() && !roomExist) {
            String tmp = (String)e.nextElement();
            if (!nameDest.equalsIgnoreCase(tmp)) continue;
            roomExist = true;
            Room room = (Room)this.listRooms.get(tmp);
            door.setDestination(room);
        }
        if (!roomExist) {
            door.setDestinationName(null);
        }
        return door;
    }

    private void readDoor(Door door, String line) {
        StringTokenizer sl;
        String s = line;
        StringTokenizer st = new StringTokenizer(s, "=");
        if (st.hasMoreTokens()) {
            s = st.nextToken().trim();
        }
        if (s.equalsIgnoreCase("destination")) {
            StringTokenizer sl2 = new StringTokenizer(st.nextToken().trim(), "\"");
            if (sl2.hasMoreTokens()) {
                s = sl2.nextToken();
                door.setDestinationName(s);
            }
        } else if (s.equalsIgnoreCase("isOpen")) {
            StringTokenizer sl3 = new StringTokenizer(st.nextToken().trim(), "\"");
            if (sl3.hasMoreTokens() && (s = sl3.nextToken()).equalsIgnoreCase("false")) {
                door.setIsOpen(false);
            }
        } else if (s.equalsIgnoreCase("key")) {
            StringTokenizer sl4 = new StringTokenizer(st.nextToken().trim(), "\"");
            if (sl4.hasMoreTokens()) {
                door.setKey(sl4.nextToken());
            }
        } else if (s.equalsIgnoreCase("img") && (sl = new StringTokenizer(st.nextToken().trim(), "\"")).hasMoreTokens() && !(s = sl.nextToken()).equalsIgnoreCase("default")) {
            door.setImgDoor(s);
        }
    }

    private void loadDungeonParts() {
        ItemFileReader itemRead = new ItemFileReader(this.nameDungeon);
        if (itemRead.readItemFile()) {
            this.tableItems = itemRead.getLesItems();
            OrdealFileReader ordRead = new OrdealFileReader(this.nameDungeon, this.tableItems);
            if (ordRead.readOrdealFile()) {
                this.tableOrdeals = ordRead.getLesOrdeals();
            }
        }
    }

    public String getFinalRoomName() {
        return this.finalRoom;
    }

    public Room getFinalRoom() {
        Room ret = this.listRooms.containsKey(this.finalRoom) ? (Room)this.listRooms.get(this.finalRoom) : null;
        return ret;
    }

    public String getFirstRoomName() {
        return this.firstRoom;
    }

    public Room getFirstRoom() {
        Room ret = this.listRooms.containsKey(this.firstRoom) ? (Room)this.listRooms.get(this.firstRoom) : null;
        return ret;
    }

    public Hashtable getListRooms() {
        return this.listRooms;
    }

    public Hashtable getTableItems() {
        return this.tableItems;
    }

    public String getNameDungeon() {
        return this.nameDungeon;
    }

    public Hashtable getTableOrdeals() {
        return this.tableOrdeals;
    }
}

