/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import zork2Class.Game;
import zork2Class.Item;
import zork2Class.Room;

public class DungeonFileSaving {
    private Game game;
    private String name;
    private PrintWriter out;

    public DungeonFileSaving(Game game, String nameSaving) {
        this.name = nameSaving;
        this.game = game;
    }

    public boolean writeDungeonFile() {
        boolean ret = false;
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter("sauvegardes/" + this.name + ".sz2")));
            this.out.println("<!-- Backup Zork 2");
            this.out.println("Build by Zork2, used only on the game : Zork 2");
            this.out.println("Authors : BOYERE Fabien, DE VERDELHAN Michel");
            this.out.println("-->");
            this.out.println("<Z2SAVING>");
            this.out.println("\t\tDungeon = \"" + this.game.getDungeonName() + "\"");
            this.out.println("\t<PLAYER>");
            this.out.println("\t\tName = \"" + this.game.getPlayer().getName() + "\"");
            this.out.println("\t\tStrength = \"" + this.game.getPlayer().getStrengthLevel() + "\"");
            this.out.println("\t\tDexterity = \"" + this.game.getPlayer().getDexterityLevel() + "\"");
            this.out.println("\t\tIntelligence = \"" + this.game.getPlayer().getIntelligenceLevel() + "\"");
            this.out.println("\t\tStartEnergy = \"" + this.game.getPlayer().getEnergyLevel() + "\"");
            this.out.println("\t\tLifeNumber = \"" + this.game.getPlayer().getLifeNumber() + "\"");
            this.out.println("\t\tEnergyAt = \"" + this.game.getPlayer().getCurrentEnergy() + "\"");
            this.out.println("\t\tposY = \"" + this.game.getPlayer().getPosY() + "\"");
            this.out.println("\t\tposX = \"" + this.game.getPlayer().getPosX() + "\"");
            this.out.println("\t\tScore = \"" + this.game.getPlayer().getScore().getValue() + "\"");
            if (this.game.getPlayer().getLastRoom() != null) {
                this.out.println("\t\tLastRoom = \"" + this.game.getPlayer().getLastRoom().getName() + "\"");
            }
            if (this.game.getPlayer().getCurrentRoom() != null) {
                this.out.println("\t\tCurrentRoom = \"" + this.game.getPlayer().getCurrentRoom().getName() + "\"");
            }
            if (this.game.getPlayer().getCurrentWeapon() != null) {
                this.out.println("\t\tCurrentWeapon = \"" + this.game.getPlayer().getCurrentWeapon().getName() + "\"");
            }
            Enumeration e = this.game.getPlayer().getInventory().elements();
            while (e.hasMoreElements()) {
                Item item = (Item)e.nextElement();
                this.out.println("\t\tItem = \"" + item.getName() + "\"");
            }
            this.out.println("\t</PLAYER>");
            Enumeration i = this.game.getListRoom().elements();
            while (i.hasMoreElements()) {
                Room laRoom = (Room)i.nextElement();
                if (!laRoom.isVisited()) continue;
                this.out.println("\t<ROOM>");
                this.out.println("\t\tName = \"" + laRoom.getName() + "\"");
                if (laRoom.getDoorSouth() != null) {
                    this.out.println("\t\tDoorSouthOpen = \"" + laRoom.getDoorSouth().doorIsOpen() + "\"");
                }
                if (laRoom.getDoorNorth() != null) {
                    this.out.println("\t\tDoorNorthOpen = \"" + laRoom.getDoorNorth().doorIsOpen() + "\"");
                }
                if (laRoom.getDoorWest() != null) {
                    this.out.println("\t\tDoorWestOpen = \"" + laRoom.getDoorWest().doorIsOpen() + "\"");
                }
                if (laRoom.getDoorEast() != null) {
                    this.out.println("\t\tDoorEastOpen = \"" + laRoom.getDoorEast().doorIsOpen() + "\"");
                }
                if (laRoom.getChest() != null) {
                    if (laRoom.getChest().getItem() != null) {
                        this.out.println("\t\titemInChest = \"" + laRoom.getChest().getItem().getName() + "\"");
                    }
                    if (!laRoom.getChest().isOpen()) {
                        this.out.println("\t\tchestIsOpen = \"false\"");
                    } else {
                        this.out.println("\t\tchestIsOpen = \"true\"");
                    }
                }
                int k = 0;
                while (k < 8) {
                    int j = 0;
                    while (j < 8) {
                        if (laRoom.getItemPosition(j, k) != null && !laRoom.getItemPosition(j, k).equals("")) {
                            this.out.println("\t\titem = \"" + laRoom.getItemPosition(j, k).getName() + "," + k + "," + j + "\"");
                        }
                        ++j;
                    }
                    ++k;
                }
                if (laRoom.getOrdeal() != null) {
                    this.out.println("\t\tOrdealActivate = \"" + laRoom.isOrdealActivate() + "\"");
                }
                this.out.println("\t</ROOM>");
            }
            this.out.println("</Z2SAVING>");
            this.out.close();
            ret = true;
        }
        catch (IOException e) {
            System.out.println("Le fichier ne peut \u00eatre cr\u00e9er");
            ret = false;
        }
        return ret;
    }
}

