/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import zork2Class.Game;
import zork2Class.Item;
import zork2Class.Ordeal;
import zork2Class.Player;
import zork2Class.PlayerIsDeadException;
import zork2Class.Reward;

public class FightOrdeal
extends Ordeal {
    private OrdealFrame fenetre;
    private String monsterName;
    private int monsterEnergy;
    private int currentMonsterEnergy;
    private int monsterFightsCapacity;
    private JButton bouton;
    private JButton abandonner;
    private int numberOfTurn;

    public FightOrdeal(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.invariant();
    }

    public FightOrdeal() {
        this.setName(this.name);
        this.setDescription(this.description);
        this.invariant();
    }

    public int getMonsterEnergy() {
        this.invariant();
        return this.monsterEnergy;
    }

    public int getMonsterFightCapacity() {
        this.invariant();
        return this.monsterFightsCapacity;
    }

    public String getMonsterName() {
        this.invariant();
        return this.monsterName;
    }

    public void setMonsterEnergy(int monsterEnergy) {
        this.monsterEnergy = monsterEnergy;
        this.invariant();
    }

    public void setMonsterFightsCapacity(int monsterFightsCapacity) {
        this.monsterFightsCapacity = monsterFightsCapacity;
        this.invariant();
    }

    public void setMonsterName(String monsterName) {
        this.monsterName = monsterName;
        this.invariant();
    }

    public int getCurrentMonsterEnergy() {
        this.invariant();
        return this.currentMonsterEnergy;
    }

    public void setCurrentMonsterEnergy(int i) {
        this.currentMonsterEnergy = i;
        this.invariant();
    }

    public void ordealSuccess(boolean b) {
        Game partie = this.fenetre.getPartie();
        if (b) {
            partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
            this.appReward();
            this.bouton.setEnabled(false);
            this.abandonner.setEnabled(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
        } else {
            partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
            partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
            partie.executeCommand("#Vous avez perdu une vie car vous vous etes fait battre par le monstre\n");
            this.bouton.setEnabled(false);
            this.abandonner.setEnabled(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
            if (partie.getPlayer().getLifeNumber() <= 0) {
                closer.stop();
                this.fenetre.dispose();
                partie.PlayerIsDead();
            }
        }
        this.invariant();
    }

    public void appReward() {
        Game partie = this.fenetre.getPartie();
        Player joueur = partie.getPlayer();
        Reward recompense = this.getRecompense();
        if (recompense != null) {
            joueur.setStrengthLevel(joueur.getBaseStrengthLevel() + recompense.getStrengthBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getStrengthBonus() + " en force.\n");
            joueur.setDexterityLevel(joueur.getBaseDexterityLevel() + recompense.getDexterityBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getDexterityBonus() + " en dexterit\u00e9e.\n");
            joueur.setIntelligenceLevel(joueur.getBaseIntelligenceLevel() + recompense.getIntelligenceBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getIntelligenceBonus() + " en intelligence.\n");
            joueur.setCurrentEnergy(joueur.getCurrentEnergy() + recompense.getEnergyBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getEnergyBonus() + " en energie.\n");
            joueur.getScore().addPoint(this.getRecompense().getScore() / this.numberOfTurn);
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getScore() / this.numberOfTurn + " points.\n");
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getLifeBonus() + " vie(s).\n");
            Enumeration e = recompense.getItem().elements();
            while (e.hasMoreElements()) {
                Item objet = (Item)e.nextElement();
                joueur.getInventory().add(objet);
                if (joueur.canWearItem(objet)) continue;
                joueur.dropItem(objet);
            }
            partie.getFenetre().updateInventaire(partie.getPlayer());
            partie.getFenetre().miniMap.repaint();
            partie.getFenetre().zonePersonnage.repaint();
        }
        this.invariant();
    }

    public void doOrdeal(Game partie) {
        this.bouton = new JButton("Lancer l'\u00e9preuve");
        this.abandonner = new JButton("Abandonner");
        this.fenetre = new OrdealFrame(partie, partie.getFenetre(), "fight");
        JPanel panel = this.fenetre.getPanelCote();
        panel.add(new JLabel());
        panel.add(new JLabel("cliquez pour", 0));
        panel.add(new JLabel("commencer l'\u00e9preuve", 0));
        panel.add(this.bouton);
        panel.add(new JLabel());
        panel.add(new JLabel());
        panel.add(this.abandonner);
        this.fenetre.setPanelCote(panel);
        this.bouton.addActionListener(new FightOrdealListener(this.fenetre, 1));
        this.abandonner.addActionListener(new FightOrdealListener(this.fenetre, 2));
        this.fenetre.getViewArea().setText("EPREUVE DE COMBAT :\n");
        this.fenetre.getViewArea().append("_____________________________________________\n");
        partie.executeCommand("#_____________________________________________\n");
        this.fenetre.getViewArea().append("Vous devez affronter " + this.getMonsterName() + "\n");
        partie.executeCommand("#Vous devez affronter " + this.getMonsterName() + "\n");
        this.fenetre.getViewArea().append("qui a " + this.getMonsterEnergy() + " points de vie\n");
        partie.executeCommand("#qui a " + this.getMonsterEnergy() + " points de vie\n");
        this.fenetre.getViewArea().append("et une capacit\u00e9e de combat de " + this.getMonsterFightCapacity() + " points\n");
        partie.executeCommand("#et une capacit\u00e9e de combat de " + this.getMonsterFightCapacity() + " points\n");
        this.fenetre.getViewArea().append("_____________________________________________\n");
        partie.executeCommand("#_____________________________________________\n");
        this.fenetre.getViewArea().append(String.valueOf(this.getDescription()) + "\n");
        partie.executeCommand("#" + this.getDescription() + "\n");
        this.currentMonsterEnergy = this.getMonsterEnergy();
        this.numberOfTurn = 0;
        this.fenetre.setSize(338, 582);
        this.fenetre.setVisible(true);
        this.invariant();
    }

    private void invariant() {
    }

    private class FightOrdealListener
    implements ActionListener {
        private OrdealFrame fenetre;
        private int index;

        public FightOrdealListener(OrdealFrame fenetre, int index) {
            this.fenetre = fenetre;
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            Game partie = this.fenetre.getPartie();
            switch (this.index) {
                case 1: {
                    JButton bouton = (JButton)e.getSource();
                    if (bouton.getText().equalsIgnoreCase("Lancer l'\u00e9preuve")) {
                        bouton.setText("Etape suivante");
                    }
                    FightOrdeal fightOrdeal = FightOrdeal.this;
                    fightOrdeal.numberOfTurn = fightOrdeal.numberOfTurn + 1;
                    Player joueur = partie.getPlayer();
                    Item arme = joueur.getCurrentWeapon();
                    boolean critique = false;
                    int attaque = joueur.getStrengthLevel() / 10;
                    Random rand = new Random();
                    attaque = rand.nextInt(attaque + 1);
                    if (arme != null) {
                        attaque += arme.getPowerWeapon();
                    }
                    if (rand.nextInt(101) < joueur.getStrengthLevel() && rand.nextInt(101) < joueur.getIntelligenceLevel() && rand.nextInt(101) < joueur.getDexterityLevel()) {
                        critique = true;
                        attaque *= 3;
                    }
                    int attaqueMonstre = rand.nextInt(FightOrdeal.this.getMonsterFightCapacity() + 1);
                    this.fenetre.getViewArea().append("_____________________________________________\n");
                    partie.executeCommand("#_____________________________________________\n");
                    this.fenetre.getViewArea().append("Le monstre vous frappe de " + attaqueMonstre + "\n");
                    partie.executeCommand("#Le monstre vous frappe de " + attaqueMonstre + "\n");
                    if (critique) {
                        this.fenetre.getViewArea().append("COUP CRITIQUE\n");
                        partie.executeCommand("#COUP CRITIQUE\n");
                    }
                    this.fenetre.getViewArea().append("Vous frappez le monstre de " + attaque + "\n");
                    partie.executeCommand("#Vous frappez le monstre de " + attaque + "\n");
                    int tmp = FightOrdeal.this.getCurrentMonsterEnergy() - attaque;
                    if (tmp < 0) {
                        tmp = 0;
                    }
                    this.fenetre.getViewArea().append("Le monstre n'a plus que " + tmp + " points de vie\n");
                    partie.executeCommand("#Le monstre n'a plus que " + tmp + " points de vie\n");
                    this.fenetre.getViewArea().append("_____________________________________________\n");
                    partie.executeCommand("#_____________________________________________\n");
                    boolean test = true;
                    if (joueur.getCurrentEnergy() - attaqueMonstre <= 0) {
                        joueur.setCurrentEnergy(joueur.getCurrentEnergy() - attaqueMonstre);
                        FightOrdeal.this.setCurrentMonsterEnergy(FightOrdeal.this.getCurrentMonsterEnergy() - attaque);
                        this.fenetre.getZone().repaint();
                        FightOrdeal.this.ordealSuccess(false);
                        test = false;
                    }
                    if (FightOrdeal.this.getCurrentMonsterEnergy() - attaque <= 0) {
                        joueur.setCurrentEnergy(joueur.getCurrentEnergy() - attaqueMonstre);
                        FightOrdeal.this.setCurrentMonsterEnergy(FightOrdeal.this.getCurrentMonsterEnergy() - attaque);
                        this.fenetre.getZone().repaint();
                        FightOrdeal.this.ordealSuccess(true);
                        test = false;
                    }
                    if (!test) break;
                    joueur.setCurrentEnergy(joueur.getCurrentEnergy() - attaqueMonstre);
                    FightOrdeal.this.setCurrentMonsterEnergy(FightOrdeal.this.getCurrentMonsterEnergy() - attaque);
                    this.fenetre.getZone().repaint();
                    break;
                }
                case 2: {
                    partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
                    partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
                    partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'\u00e9preuve\n");
                    partie.setLockCommand(false);
                    partie.getFenetre().setEnabled(true);
                    this.fenetre.dispose();
                    partie.getFenetre().zonePersonnage.repaint();
                    partie.getFenetre().zoneJeu.repaint();
                    try {
                        partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber() - 1);
                        break;
                    }
                    catch (PlayerIsDeadException e1) {
                        partie.PlayerIsDead();
                    }
                }
            }
        }
    }
}

