/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;
import zork2Class.Chest;
import zork2Class.Door;
import zork2Class.Item;
import zork2Class.PlayerIsDeadException;
import zork2Class.PlayerNotHaveKeyException;
import zork2Class.Room;
import zork2Class.Score;

public class Player {
    private String name;
    private int strengthLevel;
    private int dexterityLevel;
    private int intelligenceLevel;
    private int energyLevel;
    private int currentEnergy;
    private int lifeNumber;
    private int posX;
    private int posY;
    private Score score;
    private Room currentRoom;
    private Room lastRoom;
    private Item currentWeapon;
    private Vector inventory;
    private Image imgPlayer;

    public Player() {
        this.setScore(new Score());
        this.setPosX(4);
        this.setPosY(4);
        this.setInventory(new Vector());
        this.setImgPlayer(Toolkit.getDefaultToolkit().getImage("imgDefault/perso.gif"));
    }

    public Player(String string, int n, int n2, int n3, int n4) {
        this.setName(string);
        this.setDexterityLevel(n4);
        this.setIntelligenceLevel(n3);
        this.setStrengthLevel(n);
        try {
            this.setLifeNumber(3);
        }
        catch (PlayerIsDeadException playerIsDeadException) {
            System.out.println("Player Constuctor error : default life number<0 ");
        }
        try {
            this.setEnergyLevel(n2);
        }
        catch (PlayerIsDeadException playerIsDeadException) {
            System.out.println("Player Constuctor error : default energy level<0 ");
        }
        this.setScore(new Score());
        this.setPosX(4);
        this.setPosY(4);
        this.setInventory(new Vector());
        this.setImgPlayer(Toolkit.getDefaultToolkit().getImage("imgDefault/perso.gif"));
    }

    public char getCardinalPosition() {
        int n = 32;
        if (this.getPosX() == 0 && (this.getPosY() == 2 || this.getPosY() == 3) && this.currentRoom.getDoorWest() != null) {
            n = 119;
        }
        if (this.getPosX() == 7 && (this.getPosY() == 2 || this.getPosY() == 3) && this.currentRoom.getDoorEast() != null) {
            n = 101;
        }
        if (this.getPosY() == 0 && (this.getPosX() == 3 || this.getPosX() == 4) && this.currentRoom.getDoorNorth() != null) {
            n = 110;
        }
        if (this.getPosY() == 7 && (this.getPosX() == 3 || this.getPosX() == 4) && this.currentRoom.getDoorSouth() != null) {
            n = 115;
        }
        return (char)n;
    }

    public boolean isNearChest() {
        boolean bl = false;
        Chest chest = this.getCurrentRoom().getChest();
        if (chest != null) {
            int n = Math.abs(this.getPosX() - chest.getPosX());
            int n2 = Math.abs(this.getPosY() - chest.getPosY());
            if (n <= 1 && n2 <= 1) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isNearItem() {
        boolean bl = false;
        if (this.getCurrentRoom().getItemPosition(this.getPosX(), this.getPosY()) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean canWearItem(Item item) {
        boolean bl = false;
        if (item.getWeigth() > 0 && this.getMaxWeight() >= this.getPoid() + item.getWeigth()) {
            bl = true;
        }
        return bl;
    }

    public void dropItem(Item item) {
        if (item != null && this.inventory.contains(item)) {
            if (this.getCurrentRoom().getItemPosition(this.getPosX(), this.getPosY()) == null) {
                this.inventory.remove(item);
                if (this.getCurrentWeapon() == item) {
                    this.setCurrentWeapon(null);
                }
                this.getCurrentRoom().setItemPosition(item, this.getPosX(), this.getPosY());
            } else {
                boolean bl = false;
                int n = 1;
                while (!bl && n < 8) {
                    int n2 = this.getPosY() - n;
                    while (n2 < this.getPosY() + n + 1) {
                        int n3 = this.getPosX() - n;
                        while (n3 < this.getPosX() + n + 1) {
                            if (n3 >= 0 && n3 < 8 && n2 >= 0 && n2 < 8 && !bl && this.getCurrentRoom().getItemPosition(n3, n2) == null) {
                                if (this.getCurrentRoom().getChest() != null) {
                                    if (this.getCurrentRoom().getChest().getPosX() != n3 || this.getCurrentRoom().getChest().getPosY() != n2) {
                                        this.inventory.remove(item);
                                        if (this.getCurrentWeapon() == item) {
                                            this.setCurrentWeapon(null);
                                        }
                                        this.getCurrentRoom().setItemPosition(item, n3, n2);
                                        bl = true;
                                    }
                                } else {
                                    this.inventory.remove(item);
                                    if (this.getCurrentWeapon() == item) {
                                        this.setCurrentWeapon(null);
                                    }
                                    this.getCurrentRoom().setItemPosition(item, n3, n2);
                                    bl = true;
                                }
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
    }

    public void takeItem(Item item) {
        if (this.canWearItem(item)) {
            Room room = this.getCurrentRoom();
            this.getInventory().add(item);
            if (room.getItemPosition(this.getPosX(), this.getPosY()) != null && room.getItemPosition(this.getPosX(), this.getPosY()) == item) {
                room.setItemPosition(null, this.getPosX(), this.getPosY());
            }
            if (room.getChest() != null && room.getChest().getItem() != null && room.getChest().getItem() == item) {
                room.getChest().setItem(null);
            }
        }
    }

    public void changeWeapon(Item item) {
        if (item.isWeapon()) {
            this.setCurrentWeapon(item);
            this.setCurrentEnergy(this.currentEnergy + item.getEnergyAdd());
        }
    }

    public boolean openADoor(Door door) {
        boolean bl = false;
        if (!door.doorIsOpen()) {
            String string = door.getKey();
            Enumeration enumeration = this.getInventory().elements();
            while (enumeration.hasMoreElements()) {
                Item item = (Item)enumeration.nextElement();
                if (!item.getName().equals(string) || door.doorIsOpen()) continue;
                door.setIsOpen(true);
                bl = true;
                this.getInventory().remove(item);
                if (item != this.getCurrentWeapon()) continue;
                this.setCurrentWeapon(null);
            }
        }
        return bl;
    }

    public void openChest() throws PlayerNotHaveKeyException {
        boolean bl = false;
        if (this.isNearChest()) {
            String string = this.getCurrentRoom().getChest().getKey();
            Enumeration enumeration = this.getInventory().elements();
            while (enumeration.hasMoreElements()) {
                Item item = (Item)enumeration.nextElement();
                if (!item.getName().equals(string) || this.getCurrentRoom().getChest().isOpen()) continue;
                this.getCurrentRoom().getChest().setIsOpen(true);
                this.getInventory().remove(item);
                if (item == this.getCurrentWeapon()) {
                    this.setCurrentWeapon(null);
                }
                bl = true;
            }
            if (!bl && !this.getCurrentRoom().getChest().isOpen()) {
                throw new PlayerNotHaveKeyException();
            }
        }
    }

    public boolean checkLoseLife() throws PlayerIsDeadException {
        boolean bl = false;
        int n = 0;
        if (this.currentWeapon != null) {
            n = this.currentWeapon.getEnergyAdd();
        }
        if (this.currentEnergy + n <= 0) {
            bl = true;
            this.setLifeNumber(this.getLifeNumber() - 1);
        }
        return bl;
    }

    public boolean dropWeaponKill() {
        boolean bl = false;
        int n = 0;
        if (this.currentWeapon != null) {
            n = this.currentWeapon.getEnergyAdd();
        }
        if (this.getCurrentEnergy() - n <= 0) {
            bl = true;
        }
        return bl;
    }

    public Room getCurrentRoom() {
        return this.currentRoom;
    }

    public Item getCurrentWeapon() {
        return this.currentWeapon;
    }

    public int getDexterityLevel() {
        int n = this.dexterityLevel;
        if (this.getCurrentWeapon() != null) {
            n += this.getCurrentWeapon().getDexterityAdd();
        }
        if (n > 100) {
            n = 100;
        }
        return n;
    }

    public int getBaseDexterityLevel() {
        int n = this.dexterityLevel;
        return n;
    }

    public int getEnergyLevel() {
        int n = this.energyLevel;
        if (this.getCurrentWeapon() != null) {
            n += this.getCurrentWeapon().getEnergyAdd();
        }
        if (n > 100) {
            n = 100;
        }
        return n;
    }

    public int getBaseEnergyLevel() {
        int n = this.energyLevel;
        return n;
    }

    public Image getImgPlayer() {
        return this.imgPlayer;
    }

    public int getIntelligenceLevel() {
        int n = this.intelligenceLevel;
        if (this.getCurrentWeapon() != null) {
            n += this.getCurrentWeapon().getIntelligenceAdd();
        }
        if (n > 100) {
            n = 100;
        }
        return n;
    }

    public int getBaseIntelligenceLevel() {
        int n = this.intelligenceLevel;
        return n;
    }

    public Vector getInventory() {
        return this.inventory;
    }

    public Room getLastRoom() {
        return this.lastRoom;
    }

    public int getLifeNumber() {
        return this.lifeNumber;
    }

    public String getName() {
        return this.name;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public Score getScore() {
        return this.score;
    }

    public int getStrengthLevel() {
        int n = this.strengthLevel;
        if (this.getCurrentWeapon() != null) {
            n += this.getCurrentWeapon().getStrengthAdd();
        }
        if (n > 100) {
            n = 100;
        }
        return n;
    }

    public int getBaseStrengthLevel() {
        int n = this.strengthLevel;
        return n;
    }

    public int getMaxWeight() {
        return this.getStrengthLevel() * 2;
    }

    public int getPoid() {
        int n = 0;
        Enumeration enumeration = this.inventory.elements();
        while (enumeration.hasMoreElements()) {
            Item item = (Item)enumeration.nextElement();
            n += item.getWeigth();
        }
        return n;
    }

    public int getCurrentEnergy() {
        return this.currentEnergy;
    }

    public void setCurrentRoom(Room room) {
        this.currentRoom = room;
    }

    public void setCurrentWeapon(Item item) {
        this.currentWeapon = item;
    }

    public void setDexterityLevel(int n) {
        if (n >= 0 && n <= 100) {
            this.dexterityLevel = n;
        }
    }

    public void setEnergyLevel(int n) throws PlayerIsDeadException {
        if (n >= 0 && n <= 100) {
            this.energyLevel = n;
            this.setCurrentEnergy(this.energyLevel);
        }
    }

    public void setImgPlayer(Image image) {
        this.imgPlayer = image;
    }

    public void setImgPlayer(String string) {
        this.imgPlayer = Toolkit.getDefaultToolkit().getImage(string);
    }

    public void setIntelligenceLevel(int n) {
        if (n >= 0 && n <= 100) {
            this.intelligenceLevel = n;
        }
    }

    public void setInventory(Vector vector) {
        this.inventory = vector;
    }

    public void setLastRoom(Room room) {
        this.lastRoom = room;
    }

    public void setLifeNumber(int n) throws PlayerIsDeadException {
        if (n < this.lifeNumber) {
            this.setCurrentEnergy(this.getEnergyLevel());
        }
        this.lifeNumber = n;
        if (this.lifeNumber <= 0) {
            throw new PlayerIsDeadException();
        }
        if (this.lifeNumber > 6) {
            this.lifeNumber = 6;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public void setStrengthLevel(int n) {
        if (n >= 0 && n <= 100) {
            this.strengthLevel = n;
        }
    }

    public void setCurrentEnergy(int n) {
        boolean bl = false;
        if (n < this.currentEnergy) {
            bl = true;
        }
        this.currentEnergy = n <= this.getEnergyLevel() ? n : this.getEnergyLevel();
        if (bl) {
            try {
                bl = this.checkLoseLife();
            }
            catch (PlayerIsDeadException playerIsDeadException) {
                // empty catch block
            }
        }
    }
}

