/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;
import zork2Class.Chest;
import zork2Class.Door;
import zork2Class.Item;
import zork2Class.Ordeal;
import zork2Class.Player;

public class Room {
    public static final String IMG_WALL_FRONT_DEFAULT = "images/imgDefault/frontWall.gif";
    public static final String IMG_WALL_NEXT_DEFAULT = "images/imgDefault/rightWall.gif";
    public static final String IMG_FLOOR_DEFAULT = "images/imgDefault/floor.gif";
    private String name;
    private String description;
    private Item[][] itemPosition;
    private Door doorWest;
    private Door doorEast;
    private Door doorNorth;
    private Door doorSouth;
    private Ordeal ordeal;
    private Chest chest;
    private Image imgRightWall;
    private Image imgLeftWall;
    private Image imgFrontWall;
    private Image imgBackWall;
    private Image imgFloor;
    private boolean isVisited;
    private boolean isOrdealActivate;

    public Room() {
        this.imgRightWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_NEXT_DEFAULT);
        this.imgBackWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_FRONT_DEFAULT);
        this.imgFrontWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_FRONT_DEFAULT);
        this.imgLeftWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_NEXT_DEFAULT);
        this.imgFloor = Toolkit.getDefaultToolkit().getImage(IMG_FLOOR_DEFAULT);
        this.itemPosition = new Item[8][];
        this.isVisited = false;
        this.isOrdealActivate = true;
        this.itemPosition = new Item[8][];
        int n = 0;
        while (n < 8) {
            this.itemPosition[n] = new Item[8];
            ++n;
        }
    }

    public Room(String string, String string2) {
        this.name = string;
        this.description = string2;
        this.imgRightWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_NEXT_DEFAULT);
        this.imgBackWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_FRONT_DEFAULT);
        this.imgFrontWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_FRONT_DEFAULT);
        this.imgLeftWall = Toolkit.getDefaultToolkit().getImage(IMG_WALL_NEXT_DEFAULT);
        this.imgFloor = Toolkit.getDefaultToolkit().getImage(IMG_FLOOR_DEFAULT);
        this.isVisited = false;
        this.isOrdealActivate = true;
        this.itemPosition = new Item[8][];
        int n = 0;
        while (n < 8) {
            this.itemPosition[n] = new Item[8];
            ++n;
        }
    }

    public boolean westDoorExist() {
        boolean bl = this.doorWest != null;
        return bl;
    }

    public boolean eastDoorExist() {
        boolean bl = this.doorEast != null;
        return bl;
    }

    public boolean southDoorExist() {
        boolean bl = this.doorSouth != null;
        return bl;
    }

    public boolean northDoorExist() {
        boolean bl = this.doorNorth != null;
        return bl;
    }

    public boolean haveDoor() {
        boolean bl = false;
        if (this.northDoorExist()) {
            bl = true;
        }
        if (this.southDoorExist()) {
            bl = true;
        }
        if (this.eastDoorExist()) {
            bl = true;
        }
        if (this.westDoorExist()) {
            bl = true;
        }
        return bl;
    }

    public boolean canGoToPosition(int n, int n2) {
        boolean bl = true;
        if (n < 8 && n >= 0 && n2 < 8 && n2 >= 0) {
            if (this.chest != null && this.chest.getPosX() == n && this.chest.getPosY() == n2) {
                bl = false;
            }
            if (this.itemPosition[n][n2] != null && !this.itemPosition[n][n2].couldBeCross()) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isItemOnPosition(int n, int n2) {
        boolean bl = true;
        if (this.itemPosition[n2][n] == null) {
            bl = false;
        }
        return bl;
    }

    public void centerPlayer(Player player) {
        if (this.canGoToPosition(3, 3)) {
            player.setPosX(3);
            player.setPosY(3);
        } else {
            boolean bl = false;
            int n = 0;
            while (!bl && n < 2) {
                int n2 = 2 - n;
                while (n2 <= 4 + n) {
                    int n3 = 2 - n;
                    while (n3 <= 4 + n) {
                        if (this.canGoToPosition(n3, n2) && !bl) {
                            player.setPosX(n3);
                            player.setPosY(n2);
                            bl = true;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public int countDoor() {
        int n = 0;
        if (this.getDoorEast() != null) {
            ++n;
        }
        if (this.getDoorNorth() != null) {
            ++n;
        }
        if (this.getDoorSouth() != null) {
            ++n;
        }
        if (this.getDoorWest() != null) {
            ++n;
        }
        return n;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public Chest getChest() {
        return this.chest;
    }

    public Door getDoorEast() {
        return this.doorEast;
    }

    public Door getDoorNorth() {
        return this.doorNorth;
    }

    public Door getDoorSouth() {
        return this.doorSouth;
    }

    public Door getDoorWest() {
        return this.doorWest;
    }

    public Image getImgBackWall() {
        return this.imgBackWall;
    }

    public Image getImgFloor() {
        return this.imgFloor;
    }

    public Image getImgFrontWall() {
        return this.imgFrontWall;
    }

    public Image getImgLeftWall() {
        return this.imgLeftWall;
    }

    public Image getImgRightWall() {
        return this.imgRightWall;
    }

    public Item[][] getItemPosition() {
        return this.itemPosition;
    }

    public Item getItemPosition(int n, int n2) {
        return this.itemPosition[n][n2];
    }

    public Ordeal getOrdeal() {
        return this.ordeal;
    }

    public boolean isOrdealActivate() {
        return this.isOrdealActivate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setChest(Chest chest) {
        this.chest = chest;
    }

    public void setDoorEast(Door door) {
        this.doorEast = door;
    }

    public void setDoorNorth(Door door) {
        this.doorNorth = door;
    }

    public void setDoorSouth(Door door) {
        this.doorSouth = door;
    }

    public void setDoorWest(Door door) {
        this.doorWest = door;
    }

    public void setImgBackWall(String string) {
        this.imgBackWall = Toolkit.getDefaultToolkit().getImage(string);
    }

    public void setImgFloor(String string) {
        this.imgFloor = Toolkit.getDefaultToolkit().getImage(string);
    }

    public void setImgFrontWall(String string) {
        this.imgFrontWall = Toolkit.getDefaultToolkit().getImage(string);
    }

    public void setImgLeftWall(String string) {
        this.imgLeftWall = Toolkit.getDefaultToolkit().getImage(string);
    }

    public void setImgRightWall(String string) {
        this.imgRightWall = Toolkit.getDefaultToolkit().getImage(string);
    }

    public void setItemPosition(Item item, int n, int n2) {
        if (n2 < this.itemPosition.length && n < this.itemPosition[0].length) {
            this.itemPosition[n][n2] = item;
        }
    }

    public void setOrdeal(Ordeal ordeal) {
        this.ordeal = ordeal;
    }

    public void setRoomDescription(String string) {
        this.description = string;
    }

    public void setRoomName(String string) {
        this.name = string;
    }

    public void setImgBackWall(Image image) {
        this.imgBackWall = image;
    }

    public void setImgFloor(Image image) {
        this.imgFloor = image;
    }

    public void setImgFrontWall(Image image) {
        this.imgFrontWall = image;
    }

    public void setImgLeftWall(Image image) {
        this.imgLeftWall = image;
    }

    public void setImgRightWall(Image image) {
        this.imgRightWall = image;
    }

    public void setIsOrdealActivate(boolean bl) {
        this.isOrdealActivate = bl;
    }

    public void setIsVisited(boolean bl) {
        this.isVisited = bl;
    }

    public void setItemPosition(Item[][] itemArray) {
        this.itemPosition = itemArray;
    }
}

