/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import zork2Class.Game;
import zork2Class.Item;
import zork2Class.Ordeal;
import zork2Class.Player;
import zork2Class.PlayerIsDeadException;
import zork2Class.Reward;

public class SkillOrdeal
extends Ordeal {
    private OrdealFrame fenetre;
    private int strengthLevel;
    private int dexterityLevel;
    private int intelligenceLevel;
    private JButton bouton;
    private JButton abandonner;

    public SkillOrdeal(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.setDexterityLevel(0);
        this.setDexterityLevel(0);
        this.setDexterityLevel(0);
    }

    public SkillOrdeal() {
        this.setName(this.name);
        this.setDescription(this.description);
    }

    public int getDexterityLevel() {
        return this.dexterityLevel;
    }

    public int getIntelligenceLevel() {
        return this.intelligenceLevel;
    }

    public int getStrengthLevel() {
        return this.strengthLevel;
    }

    public void setDexterityLevel(int dexterityLevel) {
        this.dexterityLevel = dexterityLevel;
    }

    public void setIntelligenceLevel(int intelligenceLevel) {
        this.intelligenceLevel = intelligenceLevel;
    }

    public void setStrengthLevel(int strengthLevel) {
        this.strengthLevel = strengthLevel;
    }

    public void ordealSuccess(boolean b) {
        Game partie = this.fenetre.getPartie();
        if (b) {
            partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
            this.appReward();
            this.bouton.setEnabled(false);
            this.abandonner.setEnabled(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
        } else {
            partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
            partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
            partie.executeCommand("#Vous avez perdu une vie car vous avez perdu l'\u00e9preuve\n");
            this.bouton.setEnabled(false);
            this.abandonner.setEnabled(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
            try {
                partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber() - 1);
            }
            catch (PlayerIsDeadException e) {
                closer.stop();
                this.fenetre.dispose();
                partie.PlayerIsDead();
            }
        }
    }

    public void doOrdeal(Game partie) {
        this.bouton = new JButton("Lancer l'\u00e9preuve");
        this.abandonner = new JButton("Abandonner");
        this.fenetre = new OrdealFrame(partie, partie.getFenetre(), "skill");
        JPanel panel = this.fenetre.getPanelCote();
        panel.add(new JLabel());
        panel.add(new JLabel("cliquez pour", 0));
        panel.add(new JLabel("commencer l'\u00e9preuve", 0));
        panel.add(this.bouton);
        panel.add(new JLabel());
        panel.add(new JLabel());
        panel.add(this.abandonner);
        this.fenetre.setPanelCote(panel);
        this.bouton.addActionListener(new SkillOrdealListener(1));
        this.abandonner.addActionListener(new SkillOrdealListener(2));
        this.fenetre.getViewArea().setText("EPREUVE DE COMPETENCES :\n");
        partie.executeCommand("#EPREUVE DE COMPETENCES :\n");
        this.fenetre.getViewArea().append(this.getDescription());
        String strenghtAdd = "\n\t-  " + this.getStrengthLevel() + " en force et";
        String dexteAdd = "\n\t-  " + this.getDexterityLevel() + " en dexterit\u00e9e et";
        String intelAdd = "\n\t-  " + this.getIntelligenceLevel() + " en intelligence";
        String descAdd = "\n______________________________________________\nVous devez obtenir un minimum de :" + strenghtAdd + dexteAdd + intelAdd + "\nLors d'un lanc\u00e9 al\u00e9atoire en fonction de vos comp\u00e9tences\n______________________________________________\n";
        this.fenetre.getViewArea().append(descAdd);
        partie.executeCommand("#\n______________________________________________\nVous devez obtenir un minimum de :" + strenghtAdd + dexteAdd + intelAdd + "\nLors d'un lanc\u00e9 al\u00e9atoire en fonction de vos comp\u00e9tences\n______________________________________________\n");
        this.fenetre.setSize(338, 590);
        this.fenetre.setVisible(true);
    }

    public void appReward() {
        Game partie = this.fenetre.getPartie();
        Player joueur = partie.getPlayer();
        Reward recompense = this.getRecompense();
        if (recompense != null) {
            joueur.setStrengthLevel(joueur.getStrengthLevel() + recompense.getStrengthBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getStrengthBonus() + " en force.\n");
            joueur.setDexterityLevel(joueur.getDexterityLevel() + recompense.getDexterityBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getDexterityBonus() + " en dexterit\u00e9e.\n");
            joueur.setIntelligenceLevel(joueur.getIntelligenceLevel() + recompense.getIntelligenceBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getIntelligenceBonus() + " en intelligence.\n");
            joueur.setCurrentEnergy(joueur.getCurrentEnergy() + recompense.getEnergyBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getEnergyBonus() + " en energie.\n");
            joueur.getScore().addPoint(this.getRecompense().getScore());
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getScore() + " points.\n");
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getLifeBonus() + " vie(s).\n");
            Enumeration e = recompense.getItem().elements();
            while (e.hasMoreElements()) {
                Item objet = (Item)e.nextElement();
                joueur.getInventory().add(objet);
                if (joueur.canWearItem(objet)) continue;
                joueur.dropItem(objet);
            }
            partie.getFenetre().updateInventaire(partie.getPlayer());
            try {
                joueur.setLifeNumber(joueur.getLifeNumber() + recompense.getLifeBonus());
            }
            catch (PlayerIsDeadException e1) {
                partie.PlayerIsDead();
            }
            partie.getFenetre().miniMap.repaint();
            partie.getFenetre().zonePersonnage.repaint();
        }
    }

    public class SkillOrdealListener
    implements ActionListener {
        private int index;

        public SkillOrdealListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent arg0) {
            Game partie = SkillOrdeal.this.fenetre.getPartie();
            switch (this.index) {
                case 1: {
                    boolean success = true;
                    Random rand = new Random();
                    int valStrength = rand.nextInt(partie.getPlayer().getStrengthLevel());
                    String strengthSummary = "";
                    int valDexte = rand.nextInt(partie.getPlayer().getDexterityLevel());
                    String dexteSummary = "";
                    int valIntel = rand.nextInt(partie.getPlayer().getIntelligenceLevel());
                    String intelSummary = "";
                    if (valStrength < SkillOrdeal.this.getStrengthLevel()) {
                        success = false;
                        strengthSummary = "\n\t-Vous n'avez obtenu que " + valStrength + " sur " + SkillOrdeal.this.getStrengthLevel() + " requis.";
                    } else {
                        strengthSummary = "\n\t-Vous avez obtenu " + valStrength + " sur " + SkillOrdeal.this.getStrengthLevel() + " requis.";
                    }
                    if (valDexte < SkillOrdeal.this.getDexterityLevel()) {
                        success = false;
                        dexteSummary = "\n\t-Vous n'avez obtenu que " + valDexte + " sur " + SkillOrdeal.this.getDexterityLevel() + " requis.";
                    } else {
                        dexteSummary = "\n\t-Vous avez obtenu " + valDexte + " sur " + SkillOrdeal.this.getDexterityLevel() + " requis.";
                    }
                    if (valIntel < SkillOrdeal.this.getIntelligenceLevel()) {
                        success = false;
                        intelSummary = "\n\t-Vous n'avez obtenu que " + valIntel + " sur " + SkillOrdeal.this.getIntelligenceLevel() + " requis.";
                    } else {
                        intelSummary = "\n\t-Vous avez obtenu " + valIntel + " sur " + SkillOrdeal.this.getIntelligenceLevel() + " requis.";
                    }
                    String result = success ? "\nR\u00e9sultat de l'\u00e9preuve :" + strengthSummary + dexteSummary + intelSummary + "\nL'\u00e9preuve est un succes" : "\nR\u00e9sultat de l'\u00e9preuve :" + strengthSummary + dexteSummary + intelSummary + "\nL'\u00e9preuve est perdu";
                    SkillOrdeal.this.fenetre.getViewArea().append(result);
                    partie.executeCommand("#" + result);
                    SkillOrdeal.this.ordealSuccess(success);
                    break;
                }
                case 2: {
                    partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
                    partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
                    partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'\u00e9preuve\n");
                    partie.setLockCommand(false);
                    partie.getFenetre().setEnabled(true);
                    SkillOrdeal.this.fenetre.dispose();
                    partie.getFenetre().zonePersonnage.repaint();
                    partie.getFenetre().zoneJeu.repaint();
                    try {
                        partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber() - 1);
                        break;
                    }
                    catch (PlayerIsDeadException e) {
                        partie.PlayerIsDead();
                    }
                }
            }
        }
    }
}

