/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import zork2Class.Game;
import zork2Class.Item;
import zork2Class.Player;
import zork2Class.PlayerIsDeadException;
import zork2Class.QuestionOrdeal;
import zork2Class.Reward;

public class WithQCM
extends QuestionOrdeal {
    private Vector answerChoice;
    private OrdealFrame fenetre;
    private JButton[] boutons;
    private JButton abandonner;

    public WithQCM(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.setAnswer("");
        this.setQuestion("");
        this.answerChoice = new Vector(0, 1);
    }

    public WithQCM() {
        this.setName(this.name);
        this.setDescription(this.description);
    }

    public Vector getAnswerChoice() {
        return this.answerChoice;
    }

    public void setAnswerChoice(Vector answerChoice) {
        this.answerChoice = answerChoice;
    }

    public void ordealSuccess(boolean b) {
        Game partie = this.fenetre.getPartie();
        this.fenetre.getPanelCote().setEnabled(false);
        if (b) {
            partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
            this.fenetre.getViewArea().append("\nBonne reponse");
            partie.executeCommand("#\nBonne reponse");
            this.appReward();
            int i = 0;
            while (i < this.boutons.length) {
                this.boutons[i].setEnabled(false);
                ++i;
            }
            this.abandonner.setEnabled(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
        } else {
            this.fenetre.getViewArea().append("\nMauvaise reponse");
            partie.executeCommand("#\nMauvaise reponse");
            partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
            partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
            partie.executeCommand("#Vous avez perdu une vie car vous avez perdu l'\u00e9preuve\n");
            int i = 0;
            while (i < this.boutons.length) {
                this.boutons[i].setEnabled(false);
                ++i;
            }
            this.abandonner.setEnabled(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
            try {
                partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber() - 1);
            }
            catch (PlayerIsDeadException e) {
                closer.stop();
                this.fenetre.dispose();
                partie.PlayerIsDead();
            }
        }
    }

    public void doOrdeal(Game partie) {
        int val;
        this.fenetre = new OrdealFrame(partie, partie.getFenetre(), "withqcm");
        JPanel panel = this.fenetre.getPanelCote();
        panel.add(new JLabel("____Votre reponse :____", 0));
        Random rand = new Random();
        Vector reponsesPossibles = (Vector)this.answerChoice.clone();
        Vector reponses = new Vector(0, 1);
        int i = 0;
        while (i < 4 && !reponsesPossibles.isEmpty()) {
            val = rand.nextInt(reponsesPossibles.size());
            reponses.add(reponsesPossibles.elementAt(val));
            reponsesPossibles.removeElementAt(val);
            ++i;
        }
        val = rand.nextInt(reponses.size() + 1);
        reponses.add(val, this.getAnswer());
        this.boutons = new JButton[reponses.size()];
        i = 0;
        while (i < this.boutons.length) {
            this.boutons[i] = new JButton((String)reponses.elementAt(i));
            panel.add(this.boutons[i]);
            this.boutons[i].addActionListener(new ButtonListener());
            ++i;
        }
        if (this.boutons.length < 5) {
            i = this.boutons.length;
            while (i < 5) {
                panel.add(new JLabel());
                ++i;
            }
        }
        this.abandonner = new JButton("abandonner");
        this.abandonner.addActionListener(new AbandonnerListener());
        panel.add(this.abandonner);
        this.fenetre.setPanelCote(panel);
        this.fenetre.getViewArea().setText("EPREUVE DE QUESTION A CHOIX MULTIPLE:\n");
        partie.executeCommand("#EPREUVE DE QUESTION A CHOIX MULTIPLE:\n");
        this.fenetre.getViewArea().append("______________________________________________\n" + this.getDescription() + "\n" + this.getQuestion() + " ?\n______________________________________________\n");
        partie.executeCommand("#______________________________________________\n" + this.getDescription() + "\n" + this.getQuestion() + " ?\n______________________________________________\n");
        this.fenetre.setSize(338, 590);
        this.fenetre.setVisible(true);
    }

    public void appReward() {
        Game partie = this.fenetre.getPartie();
        Player joueur = partie.getPlayer();
        Reward recompense = this.getRecompense();
        if (recompense != null) {
            joueur.setStrengthLevel(joueur.getStrengthLevel() + recompense.getStrengthBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getStrengthBonus() + " en force.\n");
            joueur.setDexterityLevel(joueur.getDexterityLevel() + recompense.getDexterityBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getDexterityBonus() + " en dexterit\u00e9e.\n");
            joueur.setIntelligenceLevel(joueur.getIntelligenceLevel() + recompense.getIntelligenceBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getIntelligenceBonus() + " en intelligence.\n");
            joueur.setCurrentEnergy(joueur.getCurrentEnergy() + recompense.getEnergyBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getEnergyBonus() + " en energie.\n");
            joueur.getScore().addPoint(this.getRecompense().getScore());
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getScore() + " points.\n");
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getLifeBonus() + " vie(s).\n");
            Enumeration e = recompense.getItem().elements();
            while (e.hasMoreElements()) {
                Item objet = (Item)e.nextElement();
                joueur.getInventory().add(objet);
                if (joueur.canWearItem(objet)) continue;
                joueur.dropItem(objet);
            }
            partie.getFenetre().updateInventaire(partie.getPlayer());
            try {
                joueur.setLifeNumber(joueur.getLifeNumber() + recompense.getLifeBonus());
            }
            catch (PlayerIsDeadException e1) {
                partie.PlayerIsDead();
            }
            partie.getFenetre().miniMap.repaint();
            partie.getFenetre().zonePersonnage.repaint();
        }
    }

    private class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JButton bouton = (JButton)e.getSource();
            WithQCM.this.fenetre.getPartie().executeCommand("#" + bouton.getText() + "\n");
            WithQCM.this.ordealSuccess(bouton.getText().equalsIgnoreCase(WithQCM.this.getAnswer()));
        }
    }

    private class AbandonnerListener
    implements ActionListener {
        AbandonnerListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            Game partie = WithQCM.this.fenetre.getPartie();
            partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
            partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
            partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'\u00e9preuve\n");
            partie.setLockCommand(false);
            partie.getFenetre().setEnabled(true);
            WithQCM.this.fenetre.dispose();
            partie.getFenetre().zoneJeu.repaint();
            partie.getFenetre().zonePersonnage.repaint();
            try {
                partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber() - 1);
            }
            catch (PlayerIsDeadException e) {
                partie.PlayerIsDead();
            }
        }
    }
}

