/*
 * Decompiled with CFR 0.152.
 */
package zork2Class;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import zork2Class.Game;
import zork2Class.Item;
import zork2Class.Player;
import zork2Class.PlayerIsDeadException;
import zork2Class.QuestionOrdeal;
import zork2Class.Reward;

public class WithoutQCM
extends QuestionOrdeal {
    private int answerNumber;
    private JTextField text;
    private OrdealFrame fenetre;
    private JButton valider;
    private JButton abandonner;

    public WithoutQCM(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.setAnswer("");
        this.setQuestion("");
    }

    public WithoutQCM() {
        this.setName(this.name);
        this.setDescription(this.description);
    }

    public int getAnswerNumber() {
        return this.answerNumber;
    }

    public void setAnswerNumber(int answerNumber) {
        this.answerNumber = answerNumber;
    }

    public void ordealSuccess(boolean b) {
        Game partie = this.fenetre.getPartie();
        this.fenetre.getPanelCote().setEnabled(false);
        if (b) {
            partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
            this.appReward();
            this.valider.setEnabled(false);
            this.abandonner.setEnabled(false);
            this.text.setEditable(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
        } else {
            partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
            partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
            partie.executeCommand("#Vous avez perdu une vie car vous avez perdu l'\u00e9preuve\n");
            this.valider.setEnabled(false);
            this.abandonner.setEnabled(false);
            this.text.setEditable(false);
            CloseTimer closer = new CloseTimer(this.fenetre);
            try {
                partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber() - 1);
            }
            catch (PlayerIsDeadException e) {
                closer.stop();
                this.fenetre.dispose();
                partie.PlayerIsDead();
            }
        }
    }

    public void doOrdeal(Game partie) {
        this.text = new JTextField();
        this.valider = new JButton("Valider");
        this.abandonner = new JButton("Abandonner");
        this.fenetre = new OrdealFrame(partie, partie.getFenetre(), "withoutqcm");
        JPanel panel = this.fenetre.getPanelCote();
        panel.add(new JLabel());
        panel.add(new JLabel("     Votre reponse :     ", 0));
        panel.add(this.text);
        panel.add(new JLabel());
        panel.add(this.valider);
        panel.add(new JLabel());
        panel.add(this.abandonner);
        this.fenetre.setPanelCote(panel);
        this.text.addActionListener(new ValiderListener());
        this.valider.addActionListener(new ValiderListener());
        this.abandonner.addActionListener(new AbandonnerListener());
        this.answerNumber = 0;
        this.fenetre.getViewArea().setText("EPREUVE DE QUESTION :\n");
        partie.executeCommand("#EPREUVE DE QUESTION :\n");
        this.fenetre.getViewArea().append("______________________________________________\n" + this.getDescription() + "\n" + this.getQuestion() + " ?\n______________________________________________\n");
        partie.executeCommand("#______________________________________________\n" + this.getDescription() + "\n" + this.getQuestion() + " ?\n______________________________________________\n");
        this.fenetre.setSize(330, 590);
        this.fenetre.setVisible(true);
    }

    public void appReward() {
        Game partie = this.fenetre.getPartie();
        Player joueur = partie.getPlayer();
        Reward recompense = this.getRecompense();
        if (recompense != null) {
            joueur.setStrengthLevel(joueur.getStrengthLevel() + recompense.getStrengthBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getStrengthBonus() + " en force.\n");
            joueur.setDexterityLevel(joueur.getDexterityLevel() + recompense.getDexterityBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getDexterityBonus() + " en dexterit\u00e9e.\n");
            joueur.setIntelligenceLevel(joueur.getIntelligenceLevel() + recompense.getIntelligenceBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getIntelligenceBonus() + " en intelligence.\n");
            joueur.setCurrentEnergy(joueur.getCurrentEnergy() + recompense.getEnergyBonus());
            partie.executeCommand("#Vous avez gagn\u00e9 " + recompense.getEnergyBonus() + " en energie.\n");
            joueur.getScore().addPoint(this.getRecompense().getScore() / (this.answerNumber + 1));
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getScore() / (this.answerNumber + 1) + " points.\n");
            partie.executeCommand("#Vous avez gagn\u00e9 " + this.getRecompense().getLifeBonus() + " vie(s).\n");
            Enumeration e = recompense.getItem().elements();
            while (e.hasMoreElements()) {
                Item objet = (Item)e.nextElement();
                joueur.getInventory().add(objet);
                if (joueur.canWearItem(objet)) continue;
                joueur.dropItem(objet);
            }
            partie.getFenetre().updateInventaire(partie.getPlayer());
            try {
                joueur.setLifeNumber(joueur.getLifeNumber() + recompense.getLifeBonus());
            }
            catch (PlayerIsDeadException e1) {
                partie.PlayerIsDead();
            }
            partie.getFenetre().miniMap.repaint();
            partie.getFenetre().zonePersonnage.repaint();
        }
    }

    private class ValiderListener
    implements ActionListener {
        ValiderListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (WithoutQCM.this.text.getText().equalsIgnoreCase(WithoutQCM.this.getAnswer().trim())) {
                WithoutQCM.this.fenetre.getViewArea().append(String.valueOf(WithoutQCM.this.text.getText()) + "\nVotre reponse est bonne.\n");
                WithoutQCM.this.fenetre.getPartie().executeCommand("#" + WithoutQCM.this.text.getText() + "\nVotre reponse est bonne.\n");
                WithoutQCM.this.ordealSuccess(true);
            } else {
                WithoutQCM.this.fenetre.getViewArea().append(String.valueOf(WithoutQCM.this.text.getText()) + "\nVotre reponse est mauvaise.\nIl vous reste " + (2 - WithoutQCM.this.answerNumber) + " chances.\n");
                WithoutQCM.this.fenetre.getPartie().executeCommand("#" + WithoutQCM.this.text.getText() + "\nVotre reponse est mauvaise.\nIl vous reste " + (2 - WithoutQCM.this.answerNumber) + " chances.\n");
                WithoutQCM.this.text.setText("");
                if (WithoutQCM.this.answerNumber >= 2) {
                    WithoutQCM.this.ordealSuccess(false);
                } else {
                    WithoutQCM withoutQCM = WithoutQCM.this;
                    withoutQCM.answerNumber = withoutQCM.answerNumber + 1;
                }
            }
        }
    }

    private class AbandonnerListener
    implements ActionListener {
        AbandonnerListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            Game partie = WithoutQCM.this.fenetre.getPartie();
            partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
            partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
            partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'\u00e9preuve\n");
            partie.setLockCommand(false);
            partie.getFenetre().setEnabled(true);
            WithoutQCM.this.fenetre.dispose();
            partie.getFenetre().zoneJeu.repaint();
            partie.getFenetre().zonePersonnage.repaint();
            try {
                partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber() - 1);
            }
            catch (PlayerIsDeadException e) {
                partie.PlayerIsDead();
            }
        }
    }
}

