package gameIHM;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JDialog;

/**
 * <b>This class generate a canvas</b><br> 
 * This create a canvas which contains the image of the "About". This class
 * is call by AboutSoftFrame, when, you like to know the author of the software
 * @author Michel DE VERDELHAN, Fabien BOYERE
 * @since j2sdk 1.4.0
 */
public class AboutGraphic extends Canvas {

	// attributs
	private JDialog fenetre;
	private Image imageFond;
	private Image imageBuffer;
	
	/**
	 * Constructor for AboutGraphic. This constructor run for create a graphical area
	 * which contains the image of the the "About frame"
	 */
	public AboutGraphic(JDialog fenetre) {
		super();
		this.fenetre = fenetre;
		this.init();
	}


	/**
	 * Constructor for AboutGraphic. This constructor run for create a graphical area
	 * which contains the image of the the "About frame".
	 * @param arg0
	 */
	public AboutGraphic(GraphicsConfiguration arg0) {
		super(arg0);
		this.init();
	}

	/**
	 * Method init. This method is used to initialize the graphical area with 
	 * his component.
	 */
	private void init() {
		this.setSize(400,225);
		this.imageFond=Toolkit.getDefaultToolkit().getImage("images/ihms/about/z2.jpg");
		this.setVisible(true);
		this.addMouseListener(new CloseListener(this.fenetre));
	}
	
	/**
	 * Paint methode. This method is used to draw the different graphics in the 
	 * graphical area.
	 */
	public void paint(Graphics g){
		if (this.imageBuffer==null){
			this.imageBuffer=this.createImage(this.getWidth(),this.getHeight());
		}
		Graphics buffer=this.imageBuffer.getGraphics();
		buffer.drawImage(this.imageFond,0,0,this);

		buffer.setFont(new Font("Arial",Font.BOLD,12));
		buffer.drawString("Development Team :",20,195);
		buffer.drawString("Date : ",150,215);
		buffer.drawString("Version : ",20,215);
		buffer.setFont(new Font("Arial",Font.PLAIN,12));
		buffer.drawString(" Michel DE VERDELHAN - Fabien BOYERE",150,195);
		buffer.drawString("1.0",80,215);
		buffer.drawString("june 2003",200,215);
		
		g.drawImage(this.imageBuffer, 0, 0, this);
	}
	
////////////////////////////////////////\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\	
//////////////////////          CLASS CloseListener         \\\\\\\\\\\\\\\\\\\\	
//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\//////////////////////////////////////////
	/**
	 * <b>This class manage the mouse Clic Event on graphical area</b><br> 
	 * When a user clic on this graphical area, it is this class which
	 * attribute the action "quit".
	 * @author Michel DE VERDELHAN, Fabien BOYERE
	 */
	class CloseListener extends MouseAdapter{
			
		//attribut
		private JDialog fenetre;
		
		//constructor
		/**
		 * This constructor is used to quit the "about" window. You call it when
		 * clic on the graphical area because you would like to quit the about frame.
		 * @param fenetre - there is the name of the Frame which is concern by ButtonListener
		 */
		public CloseListener(JDialog fenetre){
			this.fenetre = fenetre;
		}
		
		//mthode obligatoire d'attribution des actions
		//lors d'un relachement du clic de la souris sur la zone graphique
		//l'action ci-dessous va s'executer
		public void mouseReleased(MouseEvent x){
			this.fenetre.dispose();
		}
	}

}
