package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import zork2Class.DirectoryListReader;
import zork2Class.HighScoreFile;

/**	
 * the class BestScoreFrame
 * creation :6 juin 2003 at 10:16:13 at omaha beach
 * @author Michel de VERDELHAN Fabien BOYERE
 * @version 1.0
 */
public class BestScoreFrame extends JDialog {

	//attributs
	private JComboBox donjon;
	private JList viewArea;

	/** the constructor for BestScoreFrame
	 * @throws java.awt.HeadlessException
	 */
	public BestScoreFrame() {
		super();
		//paramtre de la frame
		this.setTitle("Zork 2 : Cration du personnage");
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().setBackground(new Color(255,255,206));
		this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);

		// on cree le panel qui contient le bouton retour
		JPanel panelSouth = new JPanel(new FlowLayout(FlowLayout.CENTER));
		panelSouth.setBackground(new Color(255,255,206));
		JButton retour;
		retour = new JButton(new ImageIcon("images/ihms/bac.gif"));
		retour.setRolloverIcon(new ImageIcon("images/ihms/bac2.gif"));
		retour.setPressedIcon(new ImageIcon("images/ihms/bac3.gif"));
		retour.setContentAreaFilled(false);
		panelSouth.add(retour);
		
		//on cre le panel choix du donjon
		JPanel choice = new JPanel(new FlowLayout(FlowLayout.LEFT));
		choice.setBackground(new Color(255,255,206));
		this.donjon=new JComboBox();
		JLabel labelChoix=new JLabel("Choix du donjon :",JLabel.RIGHT);
		
		//panelSouth.add(new JLabel());
		choice.add(labelChoix);
		choice.add(donjon);
		
		DirectoryListReader tmp=new DirectoryListReader("./maps");
		String[] donjons=tmp.listDirectory();

		for (int i=0;i<donjons.length;i++){
			this.donjon.addItem(donjons[i]);
		}
		this.donjon.addActionListener(new donjonListener());
		retour.addActionListener(new retourListener());
		
		JPanel panelTitre=new JPanel(new BorderLayout());
		JLabel image=new JLabel(new ImageIcon("images/ihms/score/z2best.jpg"));
		panelTitre.setBackground(Color.white);
		panelTitre.add(image,BorderLayout.NORTH);
		panelTitre.add(choice,BorderLayout.CENTER);
		panelTitre.setBackground(new Color(255,255,206));
		
		//ajout du panel du titre et du combobox
		this.getContentPane().add(panelTitre,BorderLayout.NORTH);
		
		//ajout du panel du bouton retour
		this.getContentPane().add(panelSouth,BorderLayout.SOUTH);
		
		this.viewArea=new JList();
		refresh();
		JScrollPane scroll=new JScrollPane(this.viewArea);
		
		//ajout de la Jlist
		this.getContentPane().add(scroll,BorderLayout.CENTER);
		this.setSize(350,400);
		this.setResizable(false);
		this.show();

	}
	
	/**
	 *  method :void refresh
	 * @param dungeon
	 */	
	private void refresh(){
		HighScoreFile highScore=new HighScoreFile((String)donjon.getSelectedItem());
		this.viewArea.removeAll();
		this.viewArea.setListData(highScore.readScore());
	}
	
	
	/**
	 * 	the class retourListener
	 *	creation :6 juin 2003 at 11:15:31
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class retourListener implements ActionListener{

		/** method :retourListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 6 juin 2003 at 11:06:41 
		 */
		public void actionPerformed(ActionEvent arg0) {
			hide();
		}
	}
	
	/**
	 * 	the class donjonListener
	 *	creation :6 juin 2003 at 11:16:02
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class donjonListener implements ActionListener{

		/** method :donjonListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 6 juin 2003 at 11:15:58 
		 */
		public void actionPerformed(ActionEvent arg0) {
			refresh();
		}
		
	}
}

