package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

import zork2Class.DirectoryListReader;
import zork2Class.Game;
import zork2Class.Player;

/**
 * the class CreatPersoFrame.java which is use when we want to initialize the game
 * with a new player and a dungeon
 * 
 * 
 * @author Michel de VERDELHAN >>> IUT de Vannes projet de programmation 2002/2003 <<<
 * @version 22 avr. 03
 */
public class CreatPersoFrame extends JDialog {

	// attributs
	private JScrollBar barreForce;
	private JScrollBar barreDexterite;
	private JScrollBar barreIntelligence;
	private JScrollBar barreEnergie;
	private JLabel pointsRestants;
	private JLabel force;
	private JLabel dexterite;
	private JLabel intelligence;
	private JLabel energie;
	private JTextField nom;
	private JComboBox donjon;
	private Game partie;
	
	
	/**
	 * Constructor for CreatPersoFrame.
	 * create a new CreatePersoFrame with all the component created and placed
	 * @param partie the current game
	 */
	public CreatPersoFrame(Game partie,JDialog owner) {
		super(owner,true);
		//association  la partie
		this.partie=partie;
		//paramtres de la salle
		this.setTitle("Zork 2 : Cration du personnage");
		this.getContentPane().setBackground(new Color(255,255,206));
		this.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		
		//image de titre
		JLabel image=new JLabel(new ImageIcon("images/ihms/creatPerso/z2creatperso.jpg"));

		//cration du combo-box
		this.donjon=new JComboBox();
		DirectoryListReader tmp=new DirectoryListReader("./maps");
		String[] donjons=tmp.listDirectory();

		for (int i=0;i<donjons.length;i++){
			this.donjon.addItem(donjons[i]);
		}

		//cration des scrollbarre de niveau
		this.barreForce=new JScrollBar(JScrollBar.HORIZONTAL,40,0,10,100);
		this.barreForce.addAdjustmentListener(new BarreListener(1));
		this.barreForce.setBlockIncrement(10);
		this.barreForce.setBackground(new Color(255,255,206));
		
		this.barreDexterite=new JScrollBar(JScrollBar.HORIZONTAL,40,0,10,100);
		this.barreDexterite.addAdjustmentListener(new BarreListener(2));
		this.barreDexterite.setBlockIncrement(10);
		this.barreDexterite.setBackground(new Color(255,255,206));
		
		this.barreIntelligence=new JScrollBar(JScrollBar.HORIZONTAL,40,0,10,100);
		this.barreIntelligence.addAdjustmentListener(new BarreListener(3));
		this.barreIntelligence.setBlockIncrement(10);
		this.barreIntelligence.setBackground(new Color(255,255,206));
		
		this.barreEnergie=new JScrollBar(JScrollBar.HORIZONTAL,40,0,10,100);
		this.barreEnergie.addAdjustmentListener(new BarreListener(4));
		this.barreEnergie.setBlockIncrement(10);
		this.barreEnergie.setBackground(new Color(255,255,206));

		//cration des labels
		this.pointsRestants=new JLabel("40");
		this.nom = new JTextField("Joueur1");
		this.force=new JLabel("40");
		this.dexterite=new JLabel("40");
		this.intelligence=new JLabel("40");
		this.energie=new JLabel("40");
		
		//cration des panels de type : barre + label
		JPanel panelForce=new JPanel(new BorderLayout(5,5));
		panelForce.setBackground(new Color(255,255,206));
		panelForce.add(this.force,BorderLayout.WEST);
		panelForce.add(this.barreForce,BorderLayout.CENTER);
		
		JPanel panelDexterite=new JPanel(new BorderLayout(5,5));
		panelDexterite.setBackground(new Color(255,255,206));
		panelDexterite.add(this.dexterite,BorderLayout.WEST);
		panelDexterite.add(this.barreDexterite,BorderLayout.CENTER);
		
		JPanel panelIntelligence=new JPanel(new BorderLayout(5,5));
		panelIntelligence.setBackground(new Color(255,255,206));
		panelIntelligence.add(this.intelligence,BorderLayout.WEST);
		panelIntelligence.add(this.barreIntelligence,BorderLayout.CENTER);
		
		JPanel panelEnergie=new JPanel(new BorderLayout(5,5));
		panelEnergie.setBackground(new Color(255,255,206));
		panelEnergie.add(this.energie,BorderLayout.WEST);
		panelEnergie.add(this.barreEnergie,BorderLayout.CENTER);
		
		//cration du bouton quitter
		JButton retour;
		retour = new JButton(new ImageIcon("images/ihms/back.gif"));
		retour.setRolloverIcon(new ImageIcon("images/ihms/back2.gif"));
		retour.setPressedIcon(new ImageIcon("images/ihms/back3.gif"));
		retour.setContentAreaFilled(false);
		retour.addActionListener(new GereBoutons(1));
		
		//cration du bouton valider
		JButton valider;
		valider = new JButton(new ImageIcon("images/ihms/creatPerso/go.gif"));
		valider.setRolloverIcon(new ImageIcon("images/ihms/creatPerso/go2.gif"));
		valider.setPressedIcon(new ImageIcon("images/ihms/creatPerso/go3.gif"));
		valider.setContentAreaFilled(false);
		valider.addActionListener(new GereBoutons(2));
		
		//panel qui comprends tous les composants de la fentre
		JPanel panelCenter=new JPanel(new GridLayout(8,2,10,10));
		panelCenter.setOpaque(true);
		panelCenter.setBackground(new Color(255,255,206));
		panelCenter.add(new JLabel(new ImageIcon("images/ihms/creatPerso/nameprs.gif")));
		panelCenter.add(this.nom);
		panelCenter.add(new JLabel(new ImageIcon("images/ihms/creatPerso/strength.gif")));
		panelCenter.add(panelForce);
		panelCenter.add(new JLabel(new ImageIcon("images/ihms/creatPerso/dexterite.gif")));
		panelCenter.add(panelDexterite);
		panelCenter.add(new JLabel(new ImageIcon("images/ihms/creatPerso/intelligence.gif")));
		panelCenter.add(panelIntelligence);
		panelCenter.add(new JLabel(new ImageIcon("images/ihms/creatPerso/energy.gif")));
		panelCenter.add(panelEnergie);
		panelCenter.add(new JLabel(new ImageIcon("images/ihms/creatPerso/point.gif")));
		panelCenter.add(this.pointsRestants);
		panelCenter.add(new JLabel(new ImageIcon("images/ihms/creatPerso/choice.gif")));
		panelCenter.add(this.donjon);
		panelCenter.add(retour);
		panelCenter.add(valider);
		
		//cration et ajout au layout
		this.getContentPane().setLayout(new BorderLayout(10,10));
		this.getContentPane().add(image,BorderLayout.NORTH);
		this.getContentPane().add(panelCenter);
		
		//paramtres de la fentre
		this.setSize(350,500);
		this.setResizable(false);
		
		this.hide();
		
	}
	
	/**
	 * the class which manage the scrollbar
	 * @author Michel de VERDELHAN
	 */
	private class BarreListener implements AdjustmentListener{
		
		// attributs
		private int index;
		
		/**
		 * the constructor for BarreListener
		 * @param index the index of the scrollbar
		 */
		public BarreListener(int index){
			this.index=index;
		}
		
		/**
		 * method called when an adjustment event occure on the scrollbar.
		 * @param e the AdjustmentEvent
		 */
		public void adjustmentValueChanged(AdjustmentEvent e){
			int pointUtilise=(barreForce.getValue()+barreDexterite.getValue()+barreIntelligence.getValue()+barreEnergie.getValue());
			int pointMax=0;
			switch (index){
				case 1:
					if (pointUtilise>=200){
						pointMax=200-(barreDexterite.getValue()+barreIntelligence.getValue()+barreEnergie.getValue());
						barreForce.setValue(pointMax);
					}
					force.setText(""+barreForce.getValue());
				break;
				case 2:
					if (pointUtilise>=200){
						pointMax=200-(barreForce.getValue()+barreIntelligence.getValue()+barreEnergie.getValue());
						barreDexterite.setValue(pointMax);
					}
					dexterite.setText(""+barreDexterite.getValue());
				break;
				case 3:
					if (pointUtilise>=200){
						pointMax=200-(barreDexterite.getValue()+barreForce.getValue()+barreEnergie.getValue());
						barreIntelligence.setValue(pointMax);
					}
					intelligence.setText(""+barreIntelligence.getValue());
				break;
				case 4:
					if (pointUtilise>=200){
						pointMax=200-(barreDexterite.getValue()+barreIntelligence.getValue()+barreForce.getValue());
						barreEnergie.setValue(pointMax);
					}
					energie.setText(""+barreEnergie.getValue());
				break;
			}
			pointsRestants.setText(""+(200-(barreForce.getValue()+barreDexterite.getValue()+barreIntelligence.getValue()+barreEnergie.getValue())));
		}
	}
	
	/**
	 * 
	 *	the class GereBoutons
	 *	creation :5 mai 03 at 17:39:52
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class GereBoutons implements ActionListener{
		
		// attributs
		private int index;
		
		public GereBoutons(int index){
			this.index=index;
		}
		
		public void actionPerformed(ActionEvent e){
			switch (index){
				case 1:
					dispose();
					partie.changeIsLocked();
					partie.launchMainMenu();
				break;
				case 2:
					if ((nom.getText()!=null)&&(!donjon.getSelectedItem().equals(""))){
						partie.getFenetreLoading().show();
						Player joueur=new Player(nom.getText(),barreForce.getValue(),barreEnergie.getValue(),barreIntelligence.getValue(),barreDexterite.getValue());
						partie.setPlayer(joueur);
						partie.loadDungeonFromFile((String)donjon.getSelectedItem());
						/*DungeonFileReader reader=new DungeonFileReader((String)donjon.getSelectedItem());
						boolean truc=reader.readDungeonFile();
						partie.setFirstRoom(reader.getFirstRoom());
						partie.setFinalRoom(reader.getFinalRoom());
						//partie.createTestGame();
						joueur.setCurrentRoom(partie.getFirstRoom());
						joueur.setLastRoom(partie.getFirstRoom());
						joueur.setPosX(3);
						joueur.setPosY(2);
						dispose();*/
						partie.changeIsLocked();
						partie.launchGame();
						partie.getFenetreLoading().hide();
					}
				break;
			}
		}
	}
	

}
