package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.*;
import java.util.Enumeration;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import zork2Class.Game;
import zork2Class.Item;
import zork2Class.Player;

/**
 * the game frame class. this frame containe a game zone which represent the current 
 * room, a minimap which represent the closest room, a button zone with differents commands
 * a zone which display the players attributs, and an inventaire
 * 
 * @author Michel de VERDELHAN
 */
public class GameFrame extends JFrame {

	public ZoneJeu zoneJeu;// la zone ou est dessine le jeu
	public MiniMap miniMap;// la zone ou est dessine la minimap
	public ZoneCommande zoneCommande;// la zone ou sont afficher les bouttons
	public ZonePersonnage zonePersonnage;// la zone d'attributs du perso
	public JTextArea viewArea;// la zone ou est afficher l'histoire et les commandes
	public JTextField console;// la zone ou sont tape les commandes
	public JComboBox inventaire;// les item de l'inventaire
	public JComboBox usableItem;// les items sur lesquels le joueur peut effectuer une action
	private Game game;// la partie en cours
	private KeyboardListener keyboardListener;
	
	/**
	 * Constructor for GameFrame.create a game frame with all the component already
	 * created.
	 * @param partie the current game.
	 */
	public GameFrame(Game partie) {
		super();
		this.game=partie;
		
		this.setTitle("Zork 2 ..:: Projet de programmation 2002/2003 IUT de Vannes::..");
		this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/imgDefault/iconeZ2.gif"));
		
		// initialisation des composants de la fenetre
		this.zoneJeu=new ZoneJeu(this);
		this.miniMap=new MiniMap(this);
		this.zoneCommande=new ZoneCommande(this);
		this.zonePersonnage=new ZonePersonnage(this);
		this.viewArea=new JTextArea("");
		this.console=new JTextField();
		this.inventaire=new JComboBox();
		this.usableItem=new JComboBox();
		JLabel invLabel=new JLabel("Inventaire",JLabel.CENTER);
		JLabel usableLabel=new JLabel("Objets accessibles",JLabel.CENTER);
		
		JScrollPane panel=new JScrollPane(this.viewArea);
		panel.setVerticalScrollBar(panel.createVerticalScrollBar());
		
		Panel panel1=new Panel(new BorderLayout());
		Panel panel2=new Panel(new BorderLayout());
		
		this.viewArea.setEditable(false);
		this.viewArea.setBackground(new Color(204,204,204));
		this.viewArea.setAutoscrolls(true);
		
		// ajoute les listener
		this.inventaire.addActionListener(new ListenerInventaire());
		this.usableItem.addActionListener(new ListenerUsableItems());
		this.console.addActionListener(new ListenerConsole());
		
		// place les composant dans la fenetre
		this.zoneJeu.setBounds(0,0,500,500);
		this.miniMap.setBounds(500,0,200,200);
		invLabel.setBounds(500,200,200,20);
		this.inventaire.setBounds(500,220,203,20);
		this.zonePersonnage.setBounds(500,240,200,200);
		usableLabel.setBounds(500,440,200,20);
		this.usableItem.setBounds(500,460,203,20);
		this.zoneCommande.setBounds(500,480,200,200);
		panel.setBounds(0,500,500,160);
		this.console.setBounds(0,660,500,20);
		
		this.setSize(700,701);
		this.getContentPane().add(this.usableItem);
		this.getContentPane().add(this.inventaire);
		this.getContentPane().add(this.zoneJeu);
		this.getContentPane().add(this.miniMap);
		this.getContentPane().add(this.zonePersonnage);
		this.getContentPane().add(this.zoneCommande);
		this.getContentPane().add(panel);
		this.getContentPane().add(invLabel);
		this.getContentPane().add(usableLabel);
		this.getContentPane().add(this.console);

		
		//this.addKeyListener(new KeyboardListener(this.game));
		this.keyboardListener=new KeyboardListener(this.game);
		this.zoneCommande.addKeyListener(this.keyboardListener);
		this.zoneJeu.addKeyListener(this.keyboardListener);
		this.zonePersonnage.addKeyListener(this.keyboardListener);
		this.miniMap.addKeyListener(this.keyboardListener);
		
		this.getContentPane().add(new JLabel());
		this.updateInventaire(game.getPlayer());
		
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setResizable(false);
		this.setVisible(true);
		
	}

	/**
	 * Returns the game.
	 * @return Game
	 */
	public Game getGame() {
		return game;
	}

	/**
	 * Sets the game.
	 * @param game The game to set
	 */
	public void setGame(Game game) {
		this.game = game;
	}
	
	/**
	 * methode which update the inventaire JComboBox
	 * @param joueur the player
	 */
	public void updateInventaire(Player joueur){
		inventaire.removeAllItems();
		for (Enumeration e=joueur.getInventory().elements();e.hasMoreElements();){
			Item tmp=(Item)e.nextElement();
			inventaire.addItem(tmp);
		}
		
	}
	
	
	//******************************************************************************
	//******************************************************************************
	//******************************************************************************
	//******************************************************************************
	//***************** INNER CLASS ************************************************
	//******************************************************************************
	//******************************************************************************
	//******************************************************************************
	//******************************************************************************
	//******************************************************************************
	//******************************************************************************
	
	/**
	 * the action listener for inventaire JComboBox
	 */
	private class ListenerInventaire implements ActionListener{
		
		/**
		 * method called when an event occure 
		 * @param e the event
		 */
		public void actionPerformed(ActionEvent e){
			//game.executeCommand("inventaire");
		}
	}

	/**
	 * the action listener for usableItems JComboBox
	 */
	private class ListenerUsableItems implements ActionListener{
		
		/**
		 * method called when an event occure 
		 * @param e the event
		 */
		public void actionPerformed(ActionEvent e){
			//game.executeCommand("usable");
		}
	}

	/**
	 * the action listener for console JTextField
	 */
	private class ListenerConsole implements ActionListener{
		
		/**
		 * method called when an event occure 
		 * @param e the event
		 */
		public void actionPerformed(ActionEvent e){
			String commande=console.getText();
			console.setText("");
			game.executeCommand(commande);
		}
	}
	
}
