package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import zork2Class.FileContentLoader;
import zork2Class.Game;

/**
 * the class HelpFrame.java which is use to
 * 
 * 
 * @author Michel de VERDELHAN >>> IUT de Vannes projet de programmation 2002/2003 <<<
 * @version 23 avr. 03
 */
public class HelpFrame extends JDialog {

	private Game partie;
	/**
	 * 
	 * the constructor for HelpFrame
	 * @param partie the current game
	 */	
	public HelpFrame(Game partie) {
		super();
		this.partie=partie;
		//paramtres de la fentre
		this.setTitle("Zork 2 : Aide");
		this.getContentPane().setBackground(new Color(255,255,206));
		this.getContentPane().setLayout(new BorderLayout());
		//this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/ihms/z2help.jpg"));
		this.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		
		//image de titre
		JLabel image=new JLabel(new ImageIcon("images/ihms/help/z2help.jpg"));

		JTextArea viewArea=new JTextArea();
		viewArea.setLineWrap(true);
		viewArea.setWrapStyleWord(true);
		JScrollPane panel=new JScrollPane(viewArea,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		
		this.getContentPane().add(panel,BorderLayout.CENTER);
		FileContentLoader tmp = new FileContentLoader("./help/help.txt");
		viewArea.setText(tmp.loadContent());
		
		//cration du bouton retour
		JButton retour;
		retour = new JButton(new ImageIcon("images/ihms/back.gif"));
		retour.setRolloverIcon(new ImageIcon("images/ihms/back2.gif"));
		retour.setPressedIcon(new ImageIcon("images/ihms/back3.gif"));
		retour.setContentAreaFilled(false);
		retour.addActionListener(new ListenerRetour());
		
		//panel du bouton quitter
		JPanel bas = new JPanel(new FlowLayout(FlowLayout.CENTER));
		bas.setBackground(new Color(255,255,204));
		bas.add(retour);
		
		//ajouts au border laout de la fentre
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(image,BorderLayout.NORTH);
		this.getContentPane().add(panel,BorderLayout.CENTER);
		this.getContentPane().add(bas,BorderLayout.SOUTH);
		
		//paramtres de la fentre
		this.setSize(400,500);
		this.setVisible(true);
	}
	
	/**
	 * 
	 *	the class ListenerRetour
	 *	creation :5 mai 03 at 17:41:38
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class ListenerRetour implements ActionListener{
		
		/**
		 * method :ListenerRetour actionPerformed
		 * @param e
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 5 mai 03 at 17:45:10
		 */
		public void actionPerformed(ActionEvent e){

			hide();
		}
	}


}
