/*
 * Created on 14 mai 03
 *
 * By Michel de VERDELHAN
 */
package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import zork2Class.Item;

/**	the class ItemViewFrame
 *	creation :14 mai 03 at 16:39:32
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class ItemViewFrame extends JDialog {

	// attributs
	private JLabel labelForceAdd;
	private JLabel labelDexteriteAdd;
	private JLabel labelIntelligenceAdd;
	private JLabel labelEnergyAdd;
	private JLabel labelPower;
	private JLabel labelPowerPresentation;
	private JLabel labelPoid;
	private JLabel labelValue;
	private JLabel labelItemName;
	private JLabel labelImage;
	private JLabel labelMap;
	private JTextArea description;
	/**
	 *  the constructor for ItemViewFrame
	 * @param objet
	 * @param framePrecedente
	 */
	public ItemViewFrame(JFrame framePrecedente) {
		super(framePrecedente,true);

		this.setTitle("Zork 2 : Description d'un objet");
		this.getContentPane().setLayout(new BorderLayout(10,10));
		this.getContentPane().setBackground(new Color(255,255,206));
		//this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/imgDefault/iconeZ2.gif"));
		this.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);

		//on cr l'image de titre
		JLabel imageTitre=new JLabel(new ImageIcon("images/ihms/paramitem/z2pitem.jpg"));
		
		this.getContentPane().add(imageTitre,BorderLayout.NORTH);
		
		this.labelDexteriteAdd=new JLabel();
		this.labelEnergyAdd=new JLabel();
		this.labelForceAdd=new JLabel();
		this.labelIntelligenceAdd=new JLabel();
		this.labelPoid=new JLabel();
		this.labelPower=new JLabel();
		this.labelPowerPresentation=new JLabel("",JLabel.RIGHT);
		this.labelValue=new JLabel();
		this.labelItemName=new JLabel("",JLabel.CENTER);
		this.labelImage=new JLabel();
		this.description=new JTextArea();
		this.labelMap=new JLabel();
		
		this.labelItemName.setFont(new Font("TimeRoman",Font.BOLD,20));
		this.labelPoid.setFont(new Font("TimeRoman",Font.BOLD,16));
		this.labelPower.setFont(new Font("TimeRoman",Font.BOLD,16));
		this.labelPower.setForeground(Color.red);
		this.labelPowerPresentation.setFont(new Font("TimeRoman",Font.BOLD,16));
		JLabel poidL=new JLabel("Poid :",JLabel.RIGHT);
		poidL.setFont(new Font("TimeRoman",Font.BOLD,16));
		
		this.description.setEditable(false);
		this.description.setBackground(this.getBackground());
		JScrollPane description = new JScrollPane(this.description,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		this.description.setLineWrap(true);
		this.description.setWrapStyleWord(true);
		
		JPanel attributs=new JPanel(new GridLayout(6,2));
		attributs.setBackground(new Color(255,255,206));
		attributs.add(new JLabel("Bonus Force"));
		attributs.add(this.labelForceAdd);
		attributs.add(new JLabel("Bonus Dexterite"));
		attributs.add(this.labelDexteriteAdd);
		attributs.add(new JLabel("Bonus Intelligence"));
		attributs.add(this.labelIntelligenceAdd);
		attributs.add(new JLabel("Bonus Energie"));
		attributs.add(this.labelEnergyAdd);
		attributs.add(new JLabel("Valeur"));
		attributs.add(this.labelValue);
		attributs.add(new JLabel("Carte"));
		attributs.add(this.labelMap);
		
		//cration du bouton fermer a fentre
		JButton bouton;
		bouton = new JButton(new ImageIcon("images/ihms/backp.gif"));
		bouton.setRolloverIcon(new ImageIcon("images/ihms/backp2.gif"));
		bouton.setPressedIcon(new ImageIcon("images/ihms/backp3.gif"));
		bouton.setContentAreaFilled(false);
		bouton.addActionListener(new BoutonListener());
	
		//panel du bouton fermer la fentre
		JPanel bas = new JPanel(new FlowLayout(FlowLayout.CENTER));
		bas.setBackground(new Color(255,255,204));
		bas.add(bouton);
		
		this.getContentPane().add(bas,BorderLayout.SOUTH);

		JPanel panelNom=new JPanel(new BorderLayout(5,5));
		JPanel panel = new JPanel(new GridLayout(2,2,10,5));
		JPanel panel1=new JPanel(new BorderLayout(5,5));
		JPanel panel2=new JPanel(new BorderLayout(5,5));
		
		panelNom.setBackground(new Color(255,255,206));
		panel.setBackground(new Color(255,255,206));
		panel1.setBackground(new Color(255,255,206));
		panel2.setBackground(new Color(255,255,206));
		
		panelNom.add(this.labelItemName,BorderLayout.NORTH);
		panel.add(poidL);
		panel.add(this.labelPoid);
		panel.add(this.labelPowerPresentation);
		panel.add(this.labelPower);
		panelNom.add(panel,BorderLayout.CENTER);
		
		
		panel1.add(this.labelImage,BorderLayout.WEST);
		panel1.add(panelNom,BorderLayout.CENTER);
		panel2.add(panel1,BorderLayout.NORTH);
		panel2.add(description,BorderLayout.CENTER);
		panel2.add(attributs,BorderLayout.SOUTH);
		
		this.getContentPane().add(panel2,BorderLayout.CENTER);
		
		this.setResizable(false);
		this.hide();
	}
	
	public void affiche(Item objet){
		this.labelDexteriteAdd.setText(""+objet.getDexterityAdd());
		this.labelEnergyAdd.setText(""+objet.getEnergyAdd());
		this.labelForceAdd.setText(""+objet.getStrengthAdd());
		this.labelIntelligenceAdd.setText(""+objet.getIntelligenceAdd());
		this.labelPoid.setText(""+objet.getWeigth());
		if (objet.getPowerWeapon()>0){
			this.labelPower.setText(""+objet.getPowerWeapon());
			this.labelPowerPresentation.setText("puissance :");
		}
		else{
			this.labelPower.setText("");
			this.labelPowerPresentation.setText("");
		}
		this.labelValue.setText(""+objet.getValue());
		this.labelItemName.setText(objet.getName());
		this.labelImage.setIcon(new ImageIcon(objet.getImage()));
		this.description.setText(""+objet.getDescription());
		if (objet.isMap()){
			labelMap.setText("Oui");
		}
		else{
			labelMap.setText("Non");
		}
		
		// on le resize pour effectuer un layout
		this.setSize(400,500);
		this.show();

		
	}
	
	//////////////////////////////////////////////////////////////////
	private class BoutonListener implements ActionListener{

		/** method :BoutonListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 14 mai 03 at 18:14:32 
		 */
		public void actionPerformed(ActionEvent arg0) {
			hide();
		}
		
	}


}
