/*
 * Created on 12 mai 03
 *
 * By Michel de VERDELHAN
 */
package gameIHM;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import zork2Class.Game;

/**	the class KeybordListener
 *	creation :12 mai 03 at 15:50:22
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class KeyboardListener extends KeyAdapter {

	// attributs
	private Game partie;
	
	/** the constructor for KeybordListener
	 * 
	 */
	public KeyboardListener(Game partie) {
		super();
		this.partie=partie;
	}
	
	/**
	 *  method :KeybordListener keyPressed
	 * @param e
	 * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
	 * @since 12 mai 03 at 15:51:38
	 */
	public void keyPressed(KeyEvent e){
		switch (e.getKeyCode()){
			case KeyEvent.VK_UP:
				this.partie.executeCommand("@go north");
			break;
			case KeyEvent.VK_DOWN:
				this.partie.executeCommand("@go south");
			break;
			case KeyEvent.VK_LEFT:
				this.partie.executeCommand("@go west");
			break;
			case KeyEvent.VK_RIGHT:
				this.partie.executeCommand("@go east");
			break;
			case KeyEvent.VK_SPACE:
				this.partie.executeCommand("@take");
			break;
			case KeyEvent.VK_B:
				this.partie.executeCommand("@drop");
			break;
			case KeyEvent.VK_ESCAPE:
				this.partie.executeCommand("@exit");
			break;
			case KeyEvent.VK_C:
				this.partie.executeCommand("@open chest");
			break;
			case KeyEvent.VK_D:
				this.partie.executeCommand("@open door");
			break;
			case KeyEvent.VK_W:
				this.partie.executeCommand("@weapon");
			break;
			case KeyEvent.VK_F5:
				this.partie.executeCommand("@save "+this.partie.getPlayer().getName()+"_quicksave");
				this.partie.executeCommand("#Sauvegarde rapide effectue");
			break;
			case KeyEvent.VK_F8:
				this.partie.executeCommand("@load "+this.partie.getPlayer().getName()+"_quicksave");
				this.partie.executeCommand("#Chargement rapide effectue");
			break;
			
		}
	}
	


}
