package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import zork2Class.DirectoryListReader;
import zork2Class.Game;
import zork2Class.Player;

/**
 * 	the class LoadGameFrame
 *	creation :5 mai 03 at 17:45:38
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class LoadGameFrame extends JDialog {
	
	//private JComboBox partie;
	private JList partie;
	private Game laPartie;
	private Vector ret = new Vector(0,1);
	
	/**
	 *  the constructor for LoadGameFrame
	 * @param owner
	 * @param laPartie
	 */
	public LoadGameFrame(JFrame owner,Game laPartie) {
		super(owner,true);
		this.init(laPartie);
	}
	
	/**
	 *  the constructor for LoadGameFrame
	 * @param owner
	 * @param laPartie
	 */
	public LoadGameFrame(JDialog owner,Game laPartie) {
		super(owner,true);
		this.init(laPartie);
	}
	
	
	/**
	 *  void LoadGameFrame::init
	 * @param laPartie
	 */
	private void init(Game laPartie){
		this.laPartie=laPartie;
		this.setTitle("Zork 2 : Charger une partie");
		this.getContentPane().setLayout(new BorderLayout(10,10));
		//this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/imgDefault/iconeZ2.gif"));
		this.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		
		this.getContentPane().setBackground(new Color(255,255,206));
		JLabel image=new JLabel(new ImageIcon("images/ihms/load/z2.jpg"));
		
		this.getContentPane().add(image,BorderLayout.NORTH);
		
		JPanel panelCentre = new JPanel(new BorderLayout(10,10));
		JPanel panelNorth = new JPanel(new GridLayout(1,2,10,10));
		JPanel panelSouth = new JPanel(new GridLayout(1,2,10,10));
		panelSouth.setBackground(new Color(255,255,206));
		panelNorth.setBackground(new Color(255,255,206));
		panelCentre.setBackground(new Color(255,255,206));
		
		//la combobox
		//this.partie = new JComboBox();

		this.partie = new JList(ret);
		JScrollPane scrollPane = new JScrollPane(this.partie);
		this.partie.setBackground(new Color(255,255,206));
		this.partie.setOpaque(true);
		
		panelNorth.add(new JLabel("parties existantes :",JLabel.LEFT));
		panelNorth.add(new JLabel());
		panelCentre.add(scrollPane,BorderLayout.CENTER);
		
		//cration du bouton quitter
		JButton annuler;
		annuler = new JButton(new ImageIcon("images/ihms/bac.gif"));
		annuler.setRolloverIcon(new ImageIcon("images/ihms/bac2.gif"));
		annuler.setPressedIcon(new ImageIcon("images/ihms/bac3.gif"));
		annuler.setContentAreaFilled(false);
		annuler.addActionListener(new ListenerBoutonsAnnuler());
		
		//cration du bouton valider
		JButton valider;
		valider = new JButton(new ImageIcon("images/ihms/load/load.gif"));
		valider.setRolloverIcon(new ImageIcon("images/ihms/load/load2.gif"));
		valider.setPressedIcon(new ImageIcon("images/ihms/load/load3.gif"));
		valider.setContentAreaFilled(false);
		valider.addActionListener(new ListenerBoutonsValider());
		
		panelSouth.add(annuler);
		panelSouth.add(valider);		
		
		panelCentre.add(panelNorth,BorderLayout.NORTH);
		panelCentre.add(panelSouth,BorderLayout.SOUTH);
		
		DirectoryListReader tmp=new DirectoryListReader("./sauvegardes");
		String[] donjons = tmp.listDirectory();
		this.refresh();

		this.getContentPane().add(panelCentre,BorderLayout.CENTER);
		this.setResizable(false);
		this.setSize(326,440);

	}

	public void refresh(){
		//this.partie.removeAllItems();
		//this.partie.removeAll();
		this.ret=new Vector(0,1);
		File repertoire=new File("./sauvegardes");
		String[] fichiers = repertoire.list();
		for (int i=0;i<fichiers.length;i++){
			if (fichiers[i].endsWith(".sz2")){
				fichiers[i]=fichiers[i].replaceAll(".sz2", "");
				ret.addElement(fichiers[i]);
			}
		}
		this.partie.setListData(ret);
		this.partie.setSelectedIndex(0);
		
	}
	
	/**
	 * 	the class ListenerBoutonsAnnuler
	 *	creation :5 mai 03 at 17:45:56
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class ListenerBoutonsAnnuler implements ActionListener{
		public void actionPerformed(ActionEvent e){
			hide();
		}
	}

	/**
	 * 	the class ListenerBoutonsValider
	 *	creation :5 mai 03 at 17:46:00
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class ListenerBoutonsValider implements ActionListener{
		public void actionPerformed(ActionEvent e){
			// placer ici le code de chargement de la partie
			String tmp=(String)partie.getSelectedValue();


			hide();
			hide();
			laPartie.setPlayer(new Player());
			laPartie.changeIsLocked();
			laPartie.launchGame();
			laPartie.executeCommand("load "+tmp);
		}
	}


}
