package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import zork2Class.Game;

/**
 * 	the class MainMenuFrame
 *	creation :5 mai 03 at 17:46:08
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class MainMenuFrame extends JDialog {

	private Game partie;
	/**
	 *  the constructor for MainMenuFrame
	 * @param partie
	 */
	public MainMenuFrame(Game partie) {
		super();
		init(partie);
	}
	
	/**
	 *  the constructor for MainMenuFrame
	 * @param partie
	 * @param owner
	 */
	public MainMenuFrame(Game partie,JFrame owner){
		super(owner,true);
		init(partie);
	}
	
	
	/**
	 *  method :void init
	 * @param partie
	 */
	private void init(Game partie){
		this.partie=partie;
		//proprits de la fentre
		this.setTitle("Zork 2 : Menu principal");
		this.getContentPane().setBackground(new Color(255,255,204));
		this.setResizable(false);
		this.setLocation(400,100);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		//cration des composants de la fentre
		JButton[] boutons=new JButton[6];
		//cration du bouton nouvelle partie
		boutons[0]= new JButton(new ImageIcon("images/ihms/menuPrincipal/new.gif"));
		boutons[0].setRolloverIcon(new ImageIcon("images/ihms/menuPrincipal/new2.gif"));
		boutons[0].setPressedIcon(new ImageIcon("images/ihms/menuPrincipal/new3.gif"));
		boutons[0].setBorderPainted(false);
		boutons[0].setContentAreaFilled(false);
		//cration du bouton charger partie
		boutons[1]= new JButton(new ImageIcon("images/ihms/menuPrincipal/load.gif"));
		boutons[1].setRolloverIcon(new ImageIcon("images/ihms/menuPrincipal/load2.gif"));
		boutons[1].setPressedIcon(new ImageIcon("images/ihms/menuPrincipal/load3.gif"));
		boutons[1].setBorderPainted(false);
		boutons[1].setContentAreaFilled(false);
		//cration du bouton a propos
		boutons[2]= new JButton(new ImageIcon("images/ihms/menuPrincipal/about.gif"));
		boutons[2].setRolloverIcon(new ImageIcon("images/ihms/menuPrincipal/about2.gif"));
		boutons[2].setPressedIcon(new ImageIcon("images/ihms/menuPrincipal/about3.gif"));
		boutons[2].setBorderPainted(false);
		boutons[2].setContentAreaFilled(false);
		//cration du bouton aide
		boutons[3]= new JButton(new ImageIcon("images/ihms/menuPrincipal/help.gif"));
		boutons[3].setRolloverIcon(new ImageIcon("images/ihms/menuPrincipal/help2.gif"));
		boutons[3].setPressedIcon(new ImageIcon("images/ihms/menuPrincipal/help3.gif"));
		boutons[3].setBorderPainted(false);
		boutons[3].setContentAreaFilled(false);
		//cration du bouton meilleurs score
		boutons[4]= new JButton(new ImageIcon("images/ihms/menuPrincipal/best.gif"));
		boutons[4].setRolloverIcon(new ImageIcon("images/ihms/menuPrincipal/best2.gif"));
		boutons[4].setPressedIcon(new ImageIcon("images/ihms/menuPrincipal/best3.gif"));
		boutons[4].setBorderPainted(false);
		boutons[4].setContentAreaFilled(false);
		//cration du bouton quitter
		boutons[5]= new JButton(new ImageIcon("images/ihms/menuPrincipal/quit.gif"));
		boutons[5].setRolloverIcon(new ImageIcon("images/ihms/menuPrincipal/quit2.gif"));
		boutons[5].setPressedIcon(new ImageIcon("images/ihms/menuPrincipal/quit3.gif"));
		boutons[5].setBorderPainted(false);
		boutons[5].setContentAreaFilled(false);
		//ajout des actionListener aux boutons
		for (int i=0;i<boutons.length;i++){
			boutons[i].addActionListener(new ButtonListener(i+1));
		}
		
		//panel qui contient les boutons
		JPanel panel=new JPanel(new GridLayout(7,1));
		panel.setBackground(new Color(255,255,204));
		panel.add(boutons[0]);
		panel.add(boutons[1]);
		panel.add(boutons[2]);
		panel.add(boutons[3]);
		panel.add(boutons[4]);
		panel.add(new JLabel(""));
		panel.add(boutons[5]);
		
		//image de titre
		JLabel image=new JLabel(new ImageIcon("images/ihms/menuPrincipal/z2principframe.jpg"));

		//ajout au borderLayout principal
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(image,BorderLayout.NORTH);
		this.getContentPane().add(panel,BorderLayout.CENTER);
		
		//proprits de la fenetre
		//this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/imgDefault/iconeZ2.gif"));
		this.setSize(326,400);
		this.setVisible(true);
	}
	
	/**
	 * 	the class ButtonListener
	 *	creation :5 mai 03 at 17:46:16
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class ButtonListener implements ActionListener{
		
		// attributs
		private int index;
		
		/**
		 *  the constructor for ButtonListener
		 * @param index
		 */
		public ButtonListener(int index){
			this.index=index;
		}
		
		/**
		 *  method :ButtonListener actionPerformed
		 * @param e
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 5 mai 03 at 17:46:25
		 */
		public void actionPerformed(ActionEvent e){
			
			switch (this.index){
				case 1:
					partie.changeIsLocked();
					partie.launchCreatPerso();
				break;
				case 2:
					
					partie.changeIsLocked();
					partie.launchLoadGameMenu();
				break;
				case 3:
					AboutSoftFrame fenetre = new AboutSoftFrame();
				break;
				case 4:
					partie.executeCommand("Help");
				break;
				case 5:
				partie.executeCommand("best score");
				break;
				case 6:
					partie.executeCommand("Exit");

				break;
			}
		}
	}


}
