package gameIHM;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;

import zork2Class.Item;
import zork2Class.Player;
import zork2Class.Room;


/**
 * 	the class MiniMap
 *	creation :5 mai 03 at 17:46:37
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class MiniMap extends Canvas {

	// attributs
	private GameFrame fenetre;
	private final int LARGEUR_SALLE=60;
	private Image bufferImage;
	private Image roseVent;
	private Image fond;
	
	/**
	 *  the constructor for MiniMap
	 * @param fenetre
	 */
	public MiniMap(GameFrame fenetre) {
		super();
		this.fenetre=fenetre;
		this.init();
	}

	/**
	 *  the constructor for MiniMap
	 *
	 */
	public MiniMap() {
		super();
		this.init();
	}

	/**
	 *  method :MiniMap init
	 *
	 */
	private void init() {
		this.roseVent=Toolkit.getDefaultToolkit().getImage("images/imgDefault/RoseVents.gif");
		this.fond=Toolkit.getDefaultToolkit().getImage("images/imgDefault/FondMiniMap.jpg");
		this.setBackground(Color.lightGray);
		this.setVisible(true);
	}
	
//---------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void paint(Graphics g){
		// pour le double buffering on verifie si le buffer a ete initialis
		if (this.bufferImage==null){
			// si pas init alors on cree une image de la taille du canvas
			this.bufferImage=this.createImage(this.getWidth(),this.getHeight());
		}
		Graphics buffer=this.bufferImage.getGraphics();
		
		Room salle;
		boolean haveMap=false;
		Player joueur;
		Vector items;
		int milieuX=this.getWidth()/2;
		int milieuY=this.getHeight()/2;
		
		buffer.drawImage(this.fond,1,1,this);
		buffer.drawRect(0,0,this.getWidth()-1,this.getHeight()-1);
		buffer.drawImage(this.roseVent,10,10,this);
		joueur=this.fenetre.getGame().getPlayer();
		salle=joueur.getCurrentRoom();
		this.drawRoom(buffer,milieuX,milieuY,salle);
		
		// on test si le joueur a une carte dans son inventaire
		items=joueur.getInventory();
		for(Enumeration e=items.elements();e.hasMoreElements();){
			Item tmp=(Item)e.nextElement();
			if (tmp.isMap()){
				haveMap=true;
			}
		}
		
		// test si on doit afficher la salle north
		if (salle.getDoorNorth()!=null){
			if ((salle.getDoorNorth().getDestination().isVisited())||(haveMap)){
				this.drawRoom(buffer,milieuX,milieuY-LARGEUR_SALLE-4,salle.getDoorNorth().getDestination());
			}
		}
				
		// test si on doit afficher la salle south
		if (salle.getDoorSouth()!=null){
			if ((salle.getDoorSouth().getDestination().isVisited())||(haveMap)){
				this.drawRoom(buffer,milieuX,milieuY+LARGEUR_SALLE+4,salle.getDoorSouth().getDestination());
			}
		}
				
		// test si on doit afficher la salle east
		if (salle.getDoorEast()!=null){
			if ((salle.getDoorEast().getDestination().isVisited())||(haveMap)){
				this.drawRoom(buffer,milieuX+LARGEUR_SALLE+4,milieuY,salle.getDoorEast().getDestination());
			}
		}
				
		// test si on doit afficher la salle west
		if (salle.getDoorWest()!=null){
			if ((salle.getDoorWest().getDestination().isVisited())||(haveMap)){
				this.drawRoom(buffer,milieuX-LARGEUR_SALLE-4,milieuY,salle.getDoorWest().getDestination());
			}
		}
				
		// on swap les buffer
		g.drawImage(this.bufferImage,0,0,this);
	}
	
//---------------------------------------------------------------------------------------
	/** 
	 * methode which draw a room. the center of the drawed room is milieuX,milieuY
	 * 
	 */
	private void drawRoom(Graphics g,int milieuX,int milieuY,Room salle){
		g.setColor(Color.white);
		g.fillRect(milieuX-(this.LARGEUR_SALLE/2),milieuY-(this.LARGEUR_SALLE/2),LARGEUR_SALLE,LARGEUR_SALLE);
		g.setColor(Color.black);
		g.drawRect(milieuX-(this.LARGEUR_SALLE/2),milieuY-(this.LARGEUR_SALLE/2),LARGEUR_SALLE,LARGEUR_SALLE);
		
		for (int j=0;j<8;j++){
			for (int i=0;i<8;i++){
				if (salle.getItemPosition(i,j)!=null){
					Item objet=salle.getItemPosition(i,j);
					if (salle.getItemPosition(i,j).couldBeCross()){
						g.setColor(Color.lightGray);
						g.fillRect(milieuX-(this.LARGEUR_SALLE/2)+(i*7)+3,milieuY-(this.LARGEUR_SALLE/2)+(j*7)+3,6,6);						
						//g.drawImage(objet.getImage(),milieuX-(this.LARGEUR_SALLE/2)+(i*7)+3,milieuY-(this.LARGEUR_SALLE/2)+(j*7)+3,7,7,this);						
					}
					else{
						g.setColor(Color.black);
						g.fillRect(milieuX-(this.LARGEUR_SALLE/2)+(i*7)+3,milieuY-(this.LARGEUR_SALLE/2)+(j*7)+3,6,6);						
						//g.drawImage(objet.getImage(),milieuX-(this.LARGEUR_SALLE/2)+(i*7)+3,milieuY-(this.LARGEUR_SALLE/2)+(j*7)+3,7,7,this);						
					}
				}
				if (salle.getChest()!=null){
					if ((salle.getChest().getPosX()==i)&&((salle.getChest().getPosY()==j))){
						if (salle.getChest().isOpen()){
							g.setColor(Color.cyan);
							g.fillRect(milieuX-(this.LARGEUR_SALLE/2)+(i*7)+3,milieuY-(this.LARGEUR_SALLE/2)+(j*7)+3,6,6);						
						}
						else{
							g.setColor(Color.blue);
							g.fillRect(milieuX-(this.LARGEUR_SALLE/2)+(i*7)+3,milieuY-(this.LARGEUR_SALLE/2)+(j*7)+3,6,6);						

						}
					}
				}
				if ((this.fenetre.getGame().getPlayer().getPosX()==i)&&(this.fenetre.getGame().getPlayer().getPosY()==j)&&((this.getWidth()/2)==milieuX)&&((this.getHeight()/2)==milieuY)){
					this.drawPlayer(g, milieuX-(this.LARGEUR_SALLE/2)+(i*7)+3, milieuY-(this.LARGEUR_SALLE/2)+(j*7)+3);
				}
			}
		}
		// test si il y a des porte a afficher
		// porte north
		if (salle.getDoorNorth()!=null){
			if (salle.getDoorNorth().doorIsOpen()){
				this.drawNorthDoor(g,milieuX,milieuY,new Color(128,64,0));		
			}
			else{
				this.drawNorthDoor(g,milieuX,milieuY,Color.red);		
			}
		}
		// porte south
		if (salle.getDoorSouth()!=null){
			if (salle.getDoorSouth().doorIsOpen()){
				this.drawSouthDoor(g,milieuX,milieuY,new Color(128,64,0));		
			}
			else{
				this.drawSouthDoor(g,milieuX,milieuY,Color.red);		
			}
		}
		// porte east
		if (salle.getDoorEast()!=null){
			if (salle.getDoorEast().doorIsOpen()){
				this.drawEastDoor(g,milieuX,milieuY,new Color(128,64,0));		
			}
			else{
				this.drawEastDoor(g,milieuX,milieuY,Color.red);		
			}
		}
		// porte west
		if (salle.getDoorWest()!=null){
			if (salle.getDoorWest().doorIsOpen()){
				this.drawWestDoor(g,milieuX,milieuY,new Color(128,64,0));		
			}
			else{
				this.drawWestDoor(g,milieuX,milieuY,Color.red);		
			}
		}
	}
	
//---------------------------------------------------------------------------------------
	/**
	 * 
	 */
	private void drawWestDoor(Graphics g,int milieuX,int milieuY,Color couleur){
		g.setColor(couleur);
		g.fillRect(milieuX-(this.LARGEUR_SALLE/2)-2,milieuY-14,4,16);
	}

//---------------------------------------------------------------------------------------
	/**
	 * 
	 */
	private void drawEastDoor(Graphics g,int milieuX,int milieuY,Color couleur){
		g.setColor(couleur);
		g.fillRect(milieuX+(this.LARGEUR_SALLE/2)-2,milieuY-14,4,16);
	}

//---------------------------------------------------------------------------------------
	/**
	 * 
	 */
	private void drawNorthDoor(Graphics g,int milieuX,int milieuY,Color couleur){
		g.setColor(couleur);
		g.fillRect(milieuX-7,milieuY-(this.LARGEUR_SALLE/2)-2,16,4);
	}

//---------------------------------------------------------------------------------------
	/**
	 * 
	 */
	private void drawSouthDoor(Graphics g,int milieuX,int milieuY,Color couleur){
		g.setColor(couleur);
		g.fillRect(milieuX-7,milieuY+(this.LARGEUR_SALLE/2)-2,16,4);
	}
	
	/**
	 *  void MiniMap::drawPlayer
	 * @param g
	 * @param posX
	 * @param posY
	 */
	private void drawPlayer(Graphics g,int posX,int posY){
		g.setColor(Color.BLACK);
		g.drawLine(posX+3,posY, posX+3, posY+4);
		g.drawLine(posX+1,posY+2, posX+5, posY+2);
		g.drawLine(posX+1,posY+6, posX+2, posY+5);
		g.drawLine(posX+5,posY+6, posX+4, posY+5);
	}

}
