package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import zork2Class.Game;

/**
 * 	the class SkillOrdealFrame
 *	creation :5 mai 03 at 17:49:08
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class OrdealFrame extends JFrame {

	private Game partie;
	private JFrame previousFrame;
	private JTextArea viewArea;
	private JPanel panelCote;
	private ZonePersonnage zone;
	/**
	 *  the constructor for SkillOrdealFrame
	 * @param partie
	 */
	public OrdealFrame(Game partie,JFrame previousFrame,String titreString) {
		super();
		this.partie = partie;
		this.previousFrame=previousFrame;
		this.previousFrame.setEnabled(false);

		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().setBackground(new Color(255,255,206));
		this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/imgDefault/iconeZ2.gif"));
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		
		String imagePath = new String();
		String title = new String();
		if(titreString == "fight"){
			imagePath = "images/ihms/frameordeal/fight.jpg";
			title = "Epreuve de combat";
		}
		else{
			if(titreString == "skill"){
				imagePath = "images/ihms/frameordeal/skill.jpg";
				title = "Epreuve de comptence";
			}
			else{
				if(titreString == "withqcm"){
					imagePath = "images/ihms/frameordeal/qcm.jpg";
					title = "Enigme de type QCM";
				}
				else{
					if(titreString == "withoutqcm"){
						imagePath = "images/ihms/frameordeal/question.jpg";
						title = "Enigme";
					}
				}
			}
		}
		this.setTitle("Zork 2 : "+title);
		JLabel image = new JLabel(new ImageIcon(imagePath));
		this.getContentPane().add(image,BorderLayout.NORTH);
		
		JPanel panel1=new JPanel(new GridLayout(2,1));
		JPanel panel2=new JPanel(new BorderLayout(5,1));
		this.panelCote=new JPanel(new GridLayout(7,1));
		this.viewArea=new JTextArea();
		this.viewArea.setLineWrap(true);
		this.viewArea.setEditable(false);
		this.viewArea.setBackground(new Color(255,255,206));
		this.viewArea.setWrapStyleWord(true);
		JScrollPane text=new JScrollPane(this.viewArea);
		this.zone = new ZonePersonnage(this.partie.getFenetre());
		this.zone.setBackground(new Color(255,255,206));
		panelCote.setSize(50,200);
		panel2.add(panelCote,BorderLayout.EAST);
		panel2.add(zone,BorderLayout.CENTER);
		panel1.add(text);
		panel1.add(panel2);
		panelCote.setBackground(new Color(255,255,206));
		panel1.setBackground(new Color(255,255,206));
		panel2.setBackground(new Color(255,255,206));
		this.getContentPane().add(panel1,BorderLayout.CENTER);
		this.setResizable(false);
	}
	

	/** method :JTextArea getViewArea
	 */
	public JTextArea getViewArea() {
		return viewArea;
	}

	/** method :void setViewArea
	 * @param area
	 */
	public void setViewArea(JTextArea area) {
		viewArea = area;
	}

	/** method :JPanel getPanelCote
	 */
	public JPanel getPanelCote() {
		return panelCote;
	}

	/** method :void setPanelCote
	 * @param panel
	 */
	public void setPanelCote(JPanel panel) {
		panelCote = panel;
	}

	/** method :JFrame getPreviousFrame
	 */
	public JFrame getPreviousFrame() {
		return previousFrame;
	}

	/** method :void setPreviousFrame
	 * @param frame
	 */
	public void setPreviousFrame(JFrame frame) {
		previousFrame = frame;
	}

	/** method :Game getPartie
	 */
	public Game getPartie() {
		return partie;
	}

	/** method :void setPartie
	 * @param game
	 */
	public void setPartie(Game game) {
		partie = game;
	}

	/** method :ZonePersonnage getZone
	 */
	public ZonePersonnage getZone() {
		return zone;
	}

	/** method :void setZone
	 * @param personnage
	 */
	public void setZone(ZonePersonnage personnage) {
		zone = personnage;
	}

}
