/*
 * Created on 26 mai 2003
 *
 * By Michel de VERDELHAN
 */
package gameIHM;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

import zork2Class.Chest;
import zork2Class.Item;
import zork2Class.Room;

/**	the class RoomView
 *	creation :26 mai 2003 at 21:50:53
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class RoomView extends Canvas {

	private Image roseVent;
	private Image zork2;
	private Image bufferImage;
	private Room salle;
	private static final int DECALAGE_X=3;
	private static final int DECALAGE_Y=70;
	private static final int TAILLE_CASEX=44;// largeur en pixel d'une case 
	private static final int TAILLE_CASEY=35;// hauteur en pixel d'une case
	private static final int TAILLEX_MUR_N=354;// largeur du mur nord/sud
	private static final int TAILLEY_MUR_N=66;// hauteur du mur nord/sud
	private static final int TAILLEX_MUR_E=141;// largeur du mur est/ouest
	private static final int TAILLEY_MUR_E=345;// hauteur du mur est/ouest
	private static final int TAILLEX_SOL=494;// largeur du sol
	private static final int TAILLEY_SOL=280;// hauteur du sol
	private static final int DECALAGE_HAUT=138;// decalage en x entre le haut et le bas
	
	/** the constructor for RoomView
	 * 
	 */
	public RoomView() {
		super();
	}
	/**
	 *  method :void init
	 *
	 */
	private void init() {
		this.setBackground(Color.white);
		this.roseVent=Toolkit.getDefaultToolkit().getImage("images/imgDefault/RoseVents2.gif");
		this.zork2=Toolkit.getDefaultToolkit().getImage("images/imgDefault/zork2.gif");
		this.setVisible(true);
	}
	
	/**
	 *  method :ZoneJeu paint
	 * @param g
	 * @see java.awt.Component#paint(java.awt.Graphics)
	 * @since 5 mai 03 at 17:50:43
	 */
	public void paint(Graphics g){
		
		// pour le double buffering on verifie si le buffer a ete initialis
		if (this.bufferImage==null){
			// si pas init alors on cree une image de la taille du canvas
			this.bufferImage=this.createImage(this.getWidth(),this.getHeight());
		}
		Graphics buffer=this.bufferImage.getGraphics();
		
		// affiche la rose des vents
		buffer.drawImage(this.roseVent,10,10,this);
		buffer.drawImage(this.zork2,120,433,this);
		buffer.drawImage(salle.getImgFloor(),0+DECALAGE_X,TAILLEY_MUR_N+DECALAGE_Y,this);
		buffer.setColor(this.getBackground());
		buffer.fillRect(DECALAGE_HAUT+2+DECALAGE_X,0+DECALAGE_Y,TAILLEX_MUR_N,TAILLEY_MUR_N);
		buffer.drawImage(salle.getImgBackWall(),DECALAGE_HAUT+2+DECALAGE_X,0+DECALAGE_Y,this);
		if (salle.getDoorNorth()!=null){
			buffer.drawImage(salle.getDoorNorth().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X+(TAILLEX_MUR_N/2)-43,0+DECALAGE_Y,this);
		}
			
		buffer.drawImage(salle.getImgLeftWall(),0+DECALAGE_X,0+DECALAGE_Y,this);
		if (salle.getDoorWest()!=null){
			buffer.drawImage(salle.getDoorWest().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X-(4*18),0+DECALAGE_Y+75,this);
		}
		
		Item[][] tabTmp=salle.getItemPosition();
		for (int i=0;i<tabTmp.length;i++){
			for (int j=0;j<tabTmp[i].length;j++){
				// on test si il y a un objet a cette case
				Chest coffre=salle.getChest();
				if ((coffre!=null)&&(coffre.getPosX()==i)&&(coffre.getPosY()==j)){
					if (salle.getChest().isOpen()){
						buffer.drawImage(coffre.getImgChestOpen(),i*TAILLE_CASEX+DECALAGE_HAUT-(j*(18))+DECALAGE_X-8,j*TAILLE_CASEY+25+DECALAGE_Y,44,67,this);
					}
					else{
						buffer.drawImage(coffre.getImgChestClose(),i*TAILLE_CASEX+DECALAGE_HAUT-(j*(18))+DECALAGE_X-8,j*TAILLE_CASEY+25+DECALAGE_Y,44,67,this);
					}
				}
				else if (tabTmp[i][j]!=null){
					// on affiche l'objet
					buffer.drawImage(tabTmp[i][j].getImage(),i*TAILLE_CASEX+DECALAGE_HAUT-(j*(18))+DECALAGE_X-8,j*TAILLE_CASEY+25+DECALAGE_Y,44,67,this);
				}
				
				
			}
		}
		
		buffer.drawImage(salle.getImgRightWall(),TAILLEX_MUR_N+DECALAGE_X,0+DECALAGE_Y,this);
		if (salle.getDoorEast()!=null){
			buffer.drawImage(salle.getDoorEast().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X+TAILLEX_SOL-DECALAGE_HAUT-(4*18)-2,0+DECALAGE_Y+75,this);
			//buffer.drawImage(salle.getDoorEast().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X-(4*18),0+DECALAGE_Y+75,this);
		}
		
		buffer.drawImage(salle.getImgFrontWall(),0+DECALAGE_X,TAILLEY_SOL+DECALAGE_Y,this);
		if (salle.getDoorSouth()!=null){
			buffer.drawImage(salle.getDoorSouth().getImgDoor(),2+DECALAGE_X+(TAILLEX_MUR_N/2)-43,0+DECALAGE_Y+TAILLEY_SOL,this);
		}
		
		
		// on swap les buffer
		g.drawImage(this.bufferImage,0,0,this);
	}
	
	/**
	 *  method :ZoneJeu update
	 * @param g
	 * @see java.awt.Component#update(java.awt.Graphics)
	 * @since 5 mai 03 at 17:50:52
	 */
	public void update(Graphics g){
		// on redefinit la methode update car on ne veut pas effacer l'image
		// afin d'avoir un affichage plus fluide
		this.paint(g);
	}
	/** method :Room getSalle
	 */
	public Room getSalle() {
		return salle;
	}

	/** method :void setSalle
	 * @param room
	 */
	public void setSalle(Room room) {
		salle = room;
	}

}
