/*
 * Created on 11 juin 2003
 *
 * By Michel de VERDELHAN
 */
package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import zork2Class.Game;

/**	the class SaveGameFrame
 *	creation :11 juin 2003 at 17:14:35
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class SaveGameFrame extends JDialog {
	
	// attributs
	private Game partie;
	private JTextField nom;
	
	public SaveGameFrame(Game partie,JFrame owner){
		super(owner,true);
		//association  la partie
		this.partie=partie;
		//paramtres de la salle
		this.setTitle("Zork 2 : Cration du personnage");
		this.getContentPane().setBackground(new Color(255,255,206));
		this.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		
		JLabel image=new JLabel(new ImageIcon("images/ihms/load/z2save.jpg"));
		this.getContentPane().add(image,BorderLayout.NORTH);

		JPanel panText = new JPanel(new FlowLayout(FlowLayout.LEFT,10,10));
		panText.add(new JLabel("Nom de la sauvegarde :"));
		panText.setBackground(new Color(255,255,206));
		this.nom = new JTextField(this.partie.getPlayer().getName()+"_"+this.partie.getDungeonName(),17);
		panText.add(this.nom);
		this.getContentPane().add(panText,BorderLayout.CENTER);
		
		JPanel panelSouth=new JPanel (new GridLayout(1,2,10,10));
		panelSouth.setBackground(new Color(255,255,206));
		JButton annuler;
		annuler = new JButton(new ImageIcon("images/ihms/bac.gif"));
		annuler.setRolloverIcon(new ImageIcon("images/ihms/bac2.gif"));
		annuler.setPressedIcon(new ImageIcon("images/ihms/bac3.gif"));
		annuler.setContentAreaFilled(false);
		annuler.addActionListener(new AnnulerListener());
		
		
		JButton valider;
		valider = new JButton(new ImageIcon("images/ihms/load/save.gif"));
		valider.setRolloverIcon(new ImageIcon("images/ihms/load/save2.gif"));
		valider.setPressedIcon(new ImageIcon("images/ihms/load/save3.gif"));
		valider.setContentAreaFilled(false);
		valider.addActionListener(new ValiderListener());
		
		panelSouth.add(annuler);
		panelSouth.add(valider);
		this.getContentPane().add(panelSouth,BorderLayout.SOUTH);
		this.setTitle("Sauvegarde de la partie");
		this.setSize(350, 280);
		this.setResizable(false);

	}
	
	/**
	 * 	the class AnnulerListener
	 *	creation :11 juin 2003 at 17:28:37
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	class AnnulerListener implements ActionListener{

		/** method :AnnulerListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 11 juin 2003 at 17:28:09 
		 */
		public void actionPerformed(ActionEvent arg0) {
			hide();
			
		}
		
	}

	/**
	 * 	the class ValiderListener
	 *	creation :11 juin 2003 at 17:28:35
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class ValiderListener implements ActionListener{

		/** method :AnnulerListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 11 juin 2003 at 17:28:09 
		 */
		public void actionPerformed(ActionEvent arg0) {
			hide();
			partie.executeCommand("@save "+nom.getText());
			partie.executeCommand("#Partie sauvegarde");
		}
		
	}

}
