/*
 * Created on 11 juin 2003
 *
 * By Michel de VERDELHAN
 */
package gameIHM;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import zork2Class.Game;
import zork2Class.HighScoreFile;
import zork2Class.Item;

/**	the class WinnerFrame
 *	creation :11 juin 2003 at 18:31:37
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class WinnerFrame extends JDialog {
	
	// attributs
	private Game partie;
	
	public WinnerFrame(Game partie,boolean win){
		super();
		this.partie=partie;
		this.setSize(450,400);
		this.setResizable(false);
		this.getContentPane().setBackground(new Color(255,255,206));
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		if (win){
			this.setTitle("Bravo vous avez gagn !!!");
			JLabel labelCentre = new JLabel(new ImageIcon("images/ihms/winner/win.jpg"));
			this.getContentPane().add(labelCentre,BorderLayout.CENTER);
		}
		else{
			this.setTitle("vous avez perdu !!!");
			JLabel labelCentre = new JLabel(new ImageIcon("images/ihms/winner/lost.jpg"));
			this.getContentPane().add(labelCentre,BorderLayout.CENTER);
		}
		
		JButton menu;
		menu = new JButton(new ImageIcon("images/ihms/winner/mp.gif"));
		menu.setRolloverIcon(new ImageIcon("images/ihms/winner/mp2.gif"));
		menu.setPressedIcon(new ImageIcon("images/ihms/winner/mp3.gif"));
		menu.setContentAreaFilled(false);
		
		JButton quitter;
		quitter = new JButton(new ImageIcon("images/ihms/winner/quit.gif"));
		quitter.setRolloverIcon(new ImageIcon("images/ihms/winner/quit2.gif"));
		quitter.setPressedIcon(new ImageIcon("images/ihms/winner/quit3.gif"));
		quitter.setContentAreaFilled(false);
		
		JButton highScore;
		highScore = new JButton(new ImageIcon("images/ihms/winner/ms.gif"));
		highScore.setRolloverIcon(new ImageIcon("images/ihms/winner/ms2.gif"));
		highScore.setPressedIcon(new ImageIcon("images/ihms/winner/ms3.gif"));
		highScore.setContentAreaFilled(false);
		
		menu.addActionListener(new MenuListener());
		quitter.addActionListener(new QuitterListener());
		highScore.addActionListener(new HighScoreListener());
		
		JPanel panelSouth=new JPanel(new GridLayout(1,3));
		panelSouth.setBackground(new Color(255,255,206));
		panelSouth.add(menu);
		panelSouth.add(highScore);
		panelSouth.add(quitter);
		this.getContentPane().add(panelSouth,BorderLayout.SOUTH);
		
		this.show();
		
		long score=partie.getPlayer().getScore().getValue();
		for (Enumeration e=partie.getPlayer().getInventory().elements();e.hasMoreElements();){
			Item tmp=(Item)e.nextElement();
			score=score+tmp.getValue();
		}

		HighScoreFile bestScore=new HighScoreFile(partie.getDungeonName());
		if (bestScore.writeScore(partie.getPlayer().getName(), score)){
			JOptionPane.showMessageDialog(this, "Vous avez realise un des meilleurs scores avec un score de "+score, "meilleurs scores", JOptionPane.INFORMATION_MESSAGE);
		}
		
	}
	
	/**
	 * 	the class MenuListener
	 *	creation :11 juin 2003 at 18:59:01
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class MenuListener implements ActionListener{

		/** method :MenuListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 11 juin 2003 at 18:58:32 
		 */
		public void actionPerformed(ActionEvent arg0) {
			hide();
			partie=new Game();
			partie.changeIsLocked();
			partie.launchMainMenu();
			
		}
	}
	
	/**
	 * 	the class HighScoreListener
	 *	creation :11 juin 2003 at 18:59:47
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class HighScoreListener implements ActionListener{

		/** method :HighScoreListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 11 juin 2003 at 18:59:43 
		 */
		public void actionPerformed(ActionEvent arg0) {
			partie.executeCommand("best score");
			
		}
	}
	
	/**
	 * 	the class QuitterListener
	 *	creation :11 juin 2003 at 19:00:20
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class QuitterListener implements ActionListener{

		/** method :QuitterListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 11 juin 2003 at 19:00:22 
		 */
		public void actionPerformed(ActionEvent arg0) {
			partie.executeCommand("exit");
			
		}
	}

}
