package gameIHM;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

/**
 * 	the class ZoneCommande
 *	creation :5 mai 03 at 17:49:20
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class ZoneCommande extends Canvas implements MouseListener,MouseMotionListener{

	private GameFrame fenetre;
	private boolean isJeu;
	private Image bouttonWest;
	private Image bouttonWestInv;
	private Image bouttonEast;
	private Image bouttonEastInv;
	private Image bouttonNorth;
	private Image bouttonNorthInv;
	private Image bouttonSouth;
	private Image bouttonSouthInv;
	private Graphics leGraphics;
	private Image fond;
	private Image bufferImage;
	private final int POSX_IMAGECOMMANDE=3;
	private final int POSY_IMAGECOMMANDE=20;
	/**
	 *  the constructor for ZoneCommande
	 * @param fenetre
	 */
	public ZoneCommande(GameFrame fenetre) {
		super();
		this.fenetre=fenetre;
		this.isJeu=true;
		this.setBackground(Color.darkGray);
		this.setVisible(true);
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.fond=Toolkit.getDefaultToolkit().getImage("images/imgDefault/FondMiniMap.jpg");
		this.bouttonWest=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonWest.gif");
		this.bouttonWestInv=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonWestInv.gif");
		this.bouttonEast=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonEast.gif");
		this.bouttonEastInv=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonEastInv.gif");
		this.bouttonNorth=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonNorth.gif");
		this.bouttonNorthInv=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonNorthInv.gif");
		this.bouttonSouth=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonSouth.gif");
		this.bouttonSouthInv=Toolkit.getDefaultToolkit().getImage("images/ihms/com/bouttonSouthInv.gif");
	}
	
	/**
	 *  method :ZoneCommande paint
	 * @param g
	 * @see java.awt.Component#paint(java.awt.Graphics)
	 * @since 5 mai 03 at 17:49:31
	 */
	public void paint(Graphics g){
		// pour le double buffering on verifie si le buffer a ete initialis
		if (this.bufferImage==null){
			// si pas init alors on cree une image de la taille du canvas
			this.bufferImage=this.createImage(this.getWidth(),this.getHeight());
		}
		Graphics buffer=this.bufferImage.getGraphics();
		
		buffer.drawImage(this.fond,0,0,this);
		if (this.isJeu){
			buffer.setColor(Color.blue);
			buffer.fillRect(1,1,30,15);
			buffer.setColor(Color.lightGray);
			buffer.fillRect(30,1,40,15);
			buffer.setColor(Color.white);
			buffer.drawString("Jeu",5,12);
			buffer.setColor(Color.black);
			buffer.drawString("Menu",35,12);
			buffer.setColor(Color.red);
			buffer.fillRect(POSX_IMAGECOMMANDE+36,37+POSY_IMAGECOMMANDE,28,29);
			buffer.drawImage(this.bouttonWest,POSX_IMAGECOMMANDE,38+POSY_IMAGECOMMANDE,this);
			buffer.drawImage(this.bouttonNorth,POSX_IMAGECOMMANDE+36,POSY_IMAGECOMMANDE,this);
			buffer.drawImage(this.bouttonSouth,POSX_IMAGECOMMANDE+36,POSY_IMAGECOMMANDE+38+28,this);
			buffer.drawImage(this.bouttonEast,POSX_IMAGECOMMANDE+36+28,POSY_IMAGECOMMANDE+38,this);
			buffer.setColor(Color.lightGray);
			buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,10,80,25,10,10);
			buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,45,80,25,10,10);
			buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,80,80,25,10,10);
			buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,115,80,25,10,10);
			buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,150,80,25,10,10);
			buffer.fillRoundRect(10,130,95,45,10,10);
			buffer.setColor(Color.black);
			buffer.drawString("Prendre objet",POSX_IMAGECOMMANDE+36*2+28+13,10+15);
			buffer.drawString("Poser objet",POSX_IMAGECOMMANDE+36*2+28+18,45+15);
			buffer.drawString("Ouvrir porte",POSX_IMAGECOMMANDE+36*2+28+19,80+15);
			buffer.drawString("Ouvrir coffre",POSX_IMAGECOMMANDE+36*2+28+18,115+15);
			buffer.drawString("Armer objet",POSX_IMAGECOMMANDE+36*2+28+17,150+15);
			buffer.drawString("Caracteristiques",12,130+15);
			buffer.drawString("de l'objet",33,150+15);
		}
		else{
			buffer.setColor(Color.lightGray);
			buffer.fillRect(1,1,30,15);
			buffer.setColor(Color.blue);
			buffer.fillRect(30,1,40,15);
			buffer.setColor(Color.black);
			buffer.drawString("Jeu",5,12);
			buffer.setColor(Color.white);
			buffer.drawString("Menu",35,12);
			buffer.setColor(Color.lightGray);
			buffer.fillRoundRect(50,25,100,25,10,10);
			buffer.setColor(Color.black);
			buffer.drawString("Sauvegarder",50+15,25+15);
			buffer.setColor(Color.lightGray);
			buffer.fillRoundRect(50,55,100,25,10,10);
			buffer.setColor(Color.black);
			buffer.drawString("Charger",50+25,55+15);
			buffer.setColor(Color.lightGray);
			buffer.fillRoundRect(50,85,100,25,10,10);
			buffer.setColor(Color.black);
			buffer.drawString("Quitter",50+30,85+15);
		}
		// on swap les buffer
		g.drawImage(this.bufferImage,0,0,this);
			
	}
	
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void mouseClicked(MouseEvent e){
	}
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void mousePressed(MouseEvent e){
		int mouseX=e.getX();
		int mouseY=e.getY();
		
		if (this.isJeu){
			if (isInRect(mouseX,mouseY,30,0,40,15)){
				this.isJeu=false;
				this.repaint();
			}
			// west		
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE,38+POSY_IMAGECOMMANDE,36,28)){
				this.fenetre.getGame().executeCommand("@go west");
			}
			// north	
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE+36,POSY_IMAGECOMMANDE,28,36)){
				this.fenetre.getGame().executeCommand("@go north");
			}
			// south	
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE+36,38+28+POSY_IMAGECOMMANDE,28,36)){
				this.fenetre.getGame().executeCommand("@go south");
			}
			// east	
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE+36+28,38+POSY_IMAGECOMMANDE,36,28)){
				this.fenetre.getGame().executeCommand("@go east");
			}	
			// bouton prendre
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,10,80,25)){
				this.fenetre.getGame().executeCommand("@take");
			}	
			// bouton poser
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,45,80,25)){
				this.fenetre.getGame().executeCommand("@drop");
			}	
			// bouton ouvrir porte
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,80,80,25)){
				this.fenetre.getGame().executeCommand("@open door");
			}	
			//bouton ouvrir coffre 
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,115,80,25)){
				this.fenetre.getGame().executeCommand("@open chest");
			}	
			// bouton armer objet
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,150,80,25)){
				this.fenetre.getGame().executeCommand("@weapon");
			}	
			// bouton caracteristiques de l'arme
			if (isInRect(mouseX,mouseY,10,130,95,45)){
				this.fenetre.getGame().executeCommand("@description");
			}	
		}	
		else{
			if (isInRect(mouseX,mouseY,0,0,30,15)){
				this.isJeu=true;
				this.repaint();
			}
			// test du bouton sauvegarder
			if (isInRect(mouseX,mouseY,50,25,100,25)){
				this.fenetre.getGame().launchSaveGame();
				
			}
			// test du boutton charger
			if (isInRect(mouseX,mouseY,50,55,100,25)){
				this.fenetre.getGame().changeIsLocked();
				this.fenetre.getGame().launchLoadGameGame();
				
			}
			// test du boutton quitter
			if (isInRect(mouseX,mouseY,50,85,100,25)){
				fenetre.getGame().executeCommand("Exit");
			}
		}		
			
	}
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void mouseReleased(MouseEvent e){
	}
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void mouseEntered(MouseEvent e){
	}
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void mouseExited(MouseEvent e){
		this.repaint();
	}
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void mouseDragged(MouseEvent e){
	}
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	public void mouseMoved(MouseEvent e){
		int mouseX=e.getX();
		int mouseY=e.getY();
		Graphics g=this.getGraphics();
		// pour le double buffering on verifie si le buffer a ete initialis
		if (this.bufferImage==null){
			// si pas init alors on cree une image de la taille du canvas
			this.bufferImage=this.createImage(this.getWidth(),this.getHeight());
		}
		Graphics buffer=this.bufferImage.getGraphics();
		
		if (this.isJeu){
			// test du west
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE,38+POSY_IMAGECOMMANDE,36,28)){
				buffer.drawImage(this.bouttonWestInv,POSX_IMAGECOMMANDE,38+POSY_IMAGECOMMANDE,this);
			}
			else{
				buffer.drawImage(this.bouttonWest,POSX_IMAGECOMMANDE,38+POSY_IMAGECOMMANDE,this);
			}
			// test du north
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE+36,POSY_IMAGECOMMANDE,28,36)){
				buffer.drawImage(this.bouttonNorthInv,POSX_IMAGECOMMANDE+36,POSY_IMAGECOMMANDE,this);
			}
			else{
				buffer.drawImage(this.bouttonNorth,POSX_IMAGECOMMANDE+36,POSY_IMAGECOMMANDE,this);
			}
			// test du south
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE+36,38+28+POSY_IMAGECOMMANDE,28,36)){
				buffer.drawImage(this.bouttonSouthInv,POSX_IMAGECOMMANDE+36,38+28+POSY_IMAGECOMMANDE,this);
			}
			else{
				buffer.drawImage(this.bouttonSouth,POSX_IMAGECOMMANDE+36,38+28+POSY_IMAGECOMMANDE,this);
			}
			// test du east
			if (isInRect(mouseX,mouseY,0+POSX_IMAGECOMMANDE+36+28,38+POSY_IMAGECOMMANDE,36,28)){
				buffer.drawImage(this.bouttonEastInv,POSX_IMAGECOMMANDE+36+28,38+POSY_IMAGECOMMANDE,this);
			}
			else{
				buffer.drawImage(this.bouttonEast,POSX_IMAGECOMMANDE+36+28,38+POSY_IMAGECOMMANDE,this);
			}
			// bouton prendre
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,10,80,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,10,80,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Prendre objet",POSX_IMAGECOMMANDE+36*2+28+13,10+15);
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,10,80,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Prendre objet",POSX_IMAGECOMMANDE+36*2+28+13,10+15);
			}	
			// bouton poser
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,45,80,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,45,80,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Poser objet",POSX_IMAGECOMMANDE+36*2+28+18,45+15);
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,45,80,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Poser objet",POSX_IMAGECOMMANDE+36*2+28+18,45+15);
			}	
			// bouton ouvrir porte
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,80,80,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,80,80,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Ouvrir porte",POSX_IMAGECOMMANDE+36*2+28+19,80+15);
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,80,80,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Ouvrir porte",POSX_IMAGECOMMANDE+36*2+28+19,80+15);
			}	
			// bouton ouvrir coffre
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,115,80,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,115,80,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Ouvrir coffre",POSX_IMAGECOMMANDE+36*2+28+18,115+15);
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,115,80,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Ouvrir coffre",POSX_IMAGECOMMANDE+36*2+28+18,115+15);
			}	
			// bouton armer objet
			if (isInRect(mouseX,mouseY,POSX_IMAGECOMMANDE+36*2+28+10,150,80,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,150,80,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Armer objet",POSX_IMAGECOMMANDE+36*2+28+17,150+15);
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(POSX_IMAGECOMMANDE+36*2+28+10,150,80,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Armer objet",POSX_IMAGECOMMANDE+36*2+28+17,150+15);
			}	
			// bouton caracteristiques
			if (isInRect(mouseX,mouseY,10,130,95,45)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(10,130,95,45,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Caracteristiques",12,130+15);
				buffer.drawString("de l'objet",33,150+15);
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(10,130,95,45,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Caracteristiques",12,130+15);
				buffer.drawString("de l'objet",33,150+15);
			}	
		}	
		else{
			// test du boutton sauvegarder
			if (isInRect(mouseX,mouseY,50,25,100,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(50,25,100,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Sauvegarder",50+15,25+15);
				
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(50,25,100,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Sauvegarder",50+15,25+15);
			}				
			// test du boutton charger
			if (isInRect(mouseX,mouseY,50,55,100,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(50,55,100,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Charger",50+25,55+15);
				
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(50,55,100,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Charger",50+25,55+15);
			}				
			// test du boutton quitter
			if (isInRect(mouseX,mouseY,50,85,100,25)){
				buffer.setColor(Color.blue);
				buffer.fillRoundRect(50,85,100,25,10,10);
				buffer.setColor(Color.white);
				buffer.drawString("Quitter",50+30,85+15);
				
			}
			else{
				buffer.setColor(Color.lightGray);
				buffer.fillRoundRect(50,85,100,25,10,10);
				buffer.setColor(Color.black);
				buffer.drawString("Quitter",50+30,85+15);
			}				
		}		
			
		// on swap les buffer
		g.drawImage(this.bufferImage,0,0,this);
	}
//-------------------------------------------------------------------------------------
	/**
	 * 
	 */
	private boolean isInRect(int x,int y,int posXRect,int posYRect,int longeur,int hauteur){
		return((x>=posXRect)&&(x<=posXRect+longeur)&&(y>=posYRect)&&(y<=posYRect+hauteur));
	}
	
	
	/**
	 *  method :ZoneCommande update
	 * @param g
	 * @see java.awt.Component#update(java.awt.Graphics)
	 * @since 10 juin 2003 at 17:45:40
	 */
	public void update (Graphics g){
		paint(g);
	}
	


}
