package gameIHM;

import zork2Class.*;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

/**
 * 	the class ZoneJeu
 *	creation :5 mai 03 at 17:50:22
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class ZoneJeu extends Canvas {

	// attributs
	private GameFrame fenetre;
	private Image joueur;
	private Image roseVent;
	private Image zork2;
	private Image epe;
	private Image bufferImage;
	private static final int DECALAGE_X=3;
	private static final int DECALAGE_Y=70;
	private static final int TAILLE_CASEX=44;// largeur en pixel d'une case 
	private static final int TAILLE_CASEY=35;// hauteur en pixel d'une case
	private static final int TAILLEX_MUR_N=354;// largeur du mur nord/sud
	private static final int TAILLEY_MUR_N=66;// hauteur du mur nord/sud
	private static final int TAILLEX_MUR_E=141;// largeur du mur est/ouest
	private static final int TAILLEY_MUR_E=345;// hauteur du mur est/ouest
	private static final int TAILLEX_SOL=494;// largeur du sol
	private static final int TAILLEY_SOL=280;// hauteur du sol
	private static final int DECALAGE_HAUT=138;// decalage en x entre le haut et le bas
	private int oldX;// a supprimer
	private int oldY;// a supprimer
	
	/**
	 *  the constructor for ZoneJeu
	 * @param fenetre
	 */
	public ZoneJeu(GameFrame fenetre) {
		super();
		this.fenetre=fenetre;
		this.init();
	}


	/**
	 *  the constructor for ZoneJeu
	 *
	 */
	public ZoneJeu() {
		super();
		this.init();
	}

	/**
	 *  method :void init
	 *
	 */
	private void init() {
		this.setBackground(new Color(255,255,206));
		this.roseVent=Toolkit.getDefaultToolkit().getImage("images/imgDefault/RoseVents2.gif");
		this.zork2=Toolkit.getDefaultToolkit().getImage("images/ihms/zork2play.jpg");
		this.epe=Toolkit.getDefaultToolkit().getImage("images/imgDefault/epe.gif");
		this.joueur=Toolkit.getDefaultToolkit().getImage("images/imgDefault/merlin.gif");
		this.oldX=3;
		this.oldY=3;
		this.setVisible(true);
	}
	
	/**
	 *  method :ZoneJeu paint
	 * @param g
	 * @see java.awt.Component#paint(java.awt.Graphics)
	 * @since 5 mai 03 at 17:50:43
	 */
	public void paint(Graphics g){
		
		// pour le double buffering on verifie si le buffer a ete initialis
		if (this.bufferImage==null){
			// si pas init alors on cree une image de la taille du canvas
			this.bufferImage=this.createImage(this.getWidth(),this.getHeight());
		}
		Graphics buffer=this.bufferImage.getGraphics();
		
		// initialise les variables d'affichage
		Player joueur=fenetre.getGame().getPlayer();
		Room salle =joueur.getCurrentRoom();
		int x=joueur.getPosX();
		int y=joueur.getPosY();
		boolean isArmee;
		if (joueur.getCurrentWeapon()!=null){
			isArmee=true;
		}
		else
		{
			isArmee=false;
		}
		
		// affiche la rose des vents
		buffer.drawImage(this.roseVent,10,10,this);
		buffer.drawImage(this.zork2,120,433,this);
		buffer.drawImage(salle.getImgFloor(),0+DECALAGE_X,TAILLEY_MUR_N+DECALAGE_Y,this);
		buffer.setColor(this.getBackground());
		buffer.fillRect(DECALAGE_HAUT+2+DECALAGE_X,0+DECALAGE_Y,TAILLEX_MUR_N,TAILLEY_MUR_N);
		buffer.drawImage(salle.getImgBackWall(),DECALAGE_HAUT+2+DECALAGE_X,0+DECALAGE_Y,this);
		if (salle.getDoorNorth()!=null){
			buffer.drawImage(salle.getDoorNorth().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X+(TAILLEX_MUR_N/2)-43,0+DECALAGE_Y,this);
		}
			
		buffer.drawImage(salle.getImgLeftWall(),0+DECALAGE_X,0+DECALAGE_Y,this);
		if (salle.getDoorWest()!=null){
			buffer.drawImage(salle.getDoorWest().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X-(4*18),0+DECALAGE_Y+75,this);
		}
		
		Item[][] tabTmp=salle.getItemPosition();
		for (int i=0;i<tabTmp.length;i++){
			for (int j=0;j<tabTmp[i].length;j++){
				// on test si il y a un objet a cette case
				Chest coffre=salle.getChest();
				if ((coffre!=null)&&(coffre.getPosX()==i)&&(coffre.getPosY()==j)){
					if (salle.getChest().isOpen()){
						buffer.drawImage(coffre.getImgChestOpen(),i*TAILLE_CASEX+DECALAGE_HAUT-(j*(18))+DECALAGE_X-8,j*TAILLE_CASEY+25+DECALAGE_Y,44,67,this);
					}
					else{
						buffer.drawImage(coffre.getImgChestClose(),i*TAILLE_CASEX+DECALAGE_HAUT-(j*(18))+DECALAGE_X-8,j*TAILLE_CASEY+25+DECALAGE_Y,44,67,this);
					}
				}
				else if (tabTmp[i][j]!=null){
					// on affiche l'objet
					buffer.drawImage(tabTmp[i][j].getImage(),i*TAILLE_CASEX+DECALAGE_HAUT-(j*(18))+DECALAGE_X-8,j*TAILLE_CASEY+25+DECALAGE_Y,44,67,this);
				}
				
				
				// on test si le joueur est sur cette case
				if ((i==x)&&(j==y)){
					// on affiche le joueur
					buffer.drawImage(this.joueur,x*TAILLE_CASEX+DECALAGE_HAUT-(y*(18))+DECALAGE_X-8,y*TAILLE_CASEY+25+DECALAGE_Y,this);
					if (isArmee){
						// on affiche l'arme si il y en a une
						buffer.drawImage(this.epe,x*TAILLE_CASEX+DECALAGE_HAUT-(y*(18))+DECALAGE_X-8,y*TAILLE_CASEY+25+DECALAGE_Y,this);
					}
				}
			}
		}
		
		buffer.drawImage(salle.getImgRightWall(),TAILLEX_MUR_N+DECALAGE_X,0+DECALAGE_Y,this);
		if (salle.getDoorEast()!=null){
			buffer.drawImage(salle.getDoorEast().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X+TAILLEX_SOL-DECALAGE_HAUT-(4*18)-2,0+DECALAGE_Y+75,this);
			//buffer.drawImage(salle.getDoorEast().getImgDoor(),DECALAGE_HAUT+2+DECALAGE_X-(4*18),0+DECALAGE_Y+75,this);
		}
		
		buffer.drawImage(salle.getImgFrontWall(),0+DECALAGE_X,TAILLEY_SOL+DECALAGE_Y,this);
		if (salle.getDoorSouth()!=null){
			buffer.drawImage(salle.getDoorSouth().getImgDoor(),2+DECALAGE_X+(TAILLEX_MUR_N/2)-43,0+DECALAGE_Y+TAILLEY_SOL,this);
		}
		
		
		// on swap les buffer
		g.drawImage(this.bufferImage,0,0,this);
	}
	
	/**
	 *  method :ZoneJeu update
	 * @param g
	 * @see java.awt.Component#update(java.awt.Graphics)
	 * @since 5 mai 03 at 17:50:52
	 */
	public void update(Graphics g){
		// on redefinit la methode update car on ne veut pas effacer l'image
		// afin d'avoir un affichage plus fluide
		this.paint(g);
	}

	/**
	 *  method :void movePlayerNorth
	 *
	 */
	public void movePlayerNorth(){
		Player joueur=fenetre.getGame().getPlayer();
		int x=joueur.getPosX();
		int y=joueur.getPosY();

		if(((y-1)>0)&&((y-1)<8)){
			this.repaint(this.oldX*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-(this.oldY*18)+ZoneJeu.DECALAGE_X,this.oldY*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
			this.repaint(this.oldX*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-((this.oldY-1)*18)+ZoneJeu.DECALAGE_X,(this.oldY-1)*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
		}
	}

	/**
	 *  method :void movePlayerSouth
	 *
	 */
	public void movePlayerSouth(){
		Player joueur=fenetre.getGame().getPlayer();
		int x=joueur.getPosX();
		int y=joueur.getPosY();

		if(((y+1)>0)&&((y+1)<8)){
			this.repaint(this.oldX*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-(this.oldY*18)+ZoneJeu.DECALAGE_X,this.oldY*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
			this.repaint(this.oldX*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-((this.oldY+1)*18)+ZoneJeu.DECALAGE_X,(this.oldY+1)*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
		}
	}

	/**
	 *  method :void movePlayerEast
	 *
	 */
	public void movePlayerEast(){
		Player joueur=fenetre.getGame().getPlayer();
		int x=joueur.getPosX();
		int y=joueur.getPosY();

		if(((x+1)>0)&&((x+1)<8)){
			this.repaint(this.oldX*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-(this.oldY*18)+ZoneJeu.DECALAGE_X,this.oldY*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
			this.repaint((this.oldX+1)*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-(this.oldY*18)+ZoneJeu.DECALAGE_X,this.oldY*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
		}
	}

	/**
	 *  method :void movePlayerWest
	 *
	 */
	public void movePlayerWest(){
		Player joueur=fenetre.getGame().getPlayer();
		int x=joueur.getPosX();
		int y=joueur.getPosY();

		if(((x-1)>0)&&((x-1)<8)){
			this.repaint(this.oldX*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-(this.oldY*18)+ZoneJeu.DECALAGE_X,this.oldY*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
			this.repaint((this.oldX-1)*ZoneJeu.TAILLE_CASEX+DECALAGE_HAUT-(this.oldY*18)+ZoneJeu.DECALAGE_X,this.oldY*ZoneJeu.TAILLE_CASEY+25+ZoneJeu.DECALAGE_Y,43,67);
		}
	}

}
