package gameIHM;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import zork2Class.Player;

/**
 * 	the class ZonePersonnage
 *	creation :5 mai 03 at 17:51:14
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class ZonePersonnage extends Canvas {

	private final int DEBUT_BARREX=72;
	private final int DEBUT_BARREY=2;
	private GameFrame fenetre;
	private Image vie;
	private Image fond;


	/**
	 *  the constructor for ZonePersonnage
	 * @param fenetre
	 */
	public ZonePersonnage(GameFrame fenetre) {
		super();
		this.fenetre=fenetre;
		this.init();
	}


	/**
	 *  the constructor for ZonePersonnage
	 *
	 */
	public ZonePersonnage() {
		super();
		this.init();
	}

	/**
	 *  method :void init
	 *
	 */
	private void init() {
		this.vie=Toolkit.getDefaultToolkit().getImage("images/imgDefault/vie.GIF");
		this.fond=Toolkit.getDefaultToolkit().getImage("images/imgDefault/FondMiniMap.jpg");
		this.setBackground(Color.white);
		this.setVisible(true);

	}

	/**
	 *  method :ZonePersonnage paint
	 * @param g
	 * @see java.awt.Component#paint(java.awt.Graphics)
	 * @since 5 mai 03 at 17:51:29
	 */
	public void paint(Graphics g){
		Player joueur=fenetre.getGame().getPlayer();
		
		g.drawImage(this.fond,0,0,this);
		g.drawRect(0,0,this.getWidth()-1,this.getHeight()-1);
		g.drawString("         nom : "+fenetre.getGame().getPlayer().getName(),6,14);
		g.drawString("       Force :",6,34);
		g.drawString("  Dexterit :",3,54);
		g.drawString("Intelligence :",1,74);
		g.drawString("    Energie :",6,94);
		g.drawString("        Poid :",9,114);
		g.drawString("      Score : "+fenetre.getGame().getPlayer().getScore().getValue(),10,134);
		g.drawString("        Vies : ",10,164);
		String arme=new String("        Arme : ");
		if (fenetre.getGame().getPlayer().getCurrentWeapon()!=null){
			arme=arme+fenetre.getGame().getPlayer().getCurrentWeapon().getName();
		}
		g.drawString(arme,5,190);
		for (int i=0;i<joueur.getLifeNumber();i++){
			g.drawImage(this.vie,72+i*20,149,this);
		}
		this.drawBarre(DEBUT_BARREX,DEBUT_BARREY+20,joueur.getStrengthLevel());
		this.drawBarre(DEBUT_BARREX,DEBUT_BARREY+40,joueur.getDexterityLevel());
		this.drawBarre(DEBUT_BARREX,DEBUT_BARREY+60,joueur.getIntelligenceLevel());
		this.drawRelativeBarre(DEBUT_BARREX,DEBUT_BARREY+80,joueur.getCurrentEnergy(),joueur.getEnergyLevel());
		
		this.drawRelativeBarre(DEBUT_BARREX,DEBUT_BARREY+100,joueur.getPoid(),joueur.getMaxWeight());
	}
	
	/**
	 *  method :void drawBarre
	 * @param posX
	 * @param posY
	 * @param value
	 */
	private void drawBarre(int posX,int posY,int value){
		Graphics g=this.getGraphics();
		g.setColor(Color.lightGray);
		g.fillRect(posX,posY,100,15);
		g.setColor(Color.blue);
		g.fillRect(posX,posY,value,15);
		g.setColor(Color.white);
		g.drawString(value+"%",posX+3,posY+12);
	}

	/**
	 *  method :void drawPoid
	 * @param posX
	 * @param posY
	 * @param value
	 */
	private void drawRelativeBarre(int posX,int posY,double current,double max){
		Graphics g=this.getGraphics();
		double valued;
		valued=current/max;
		valued=valued*100;
		int value=(int)valued;
		if (value>100){
			value=100;
		}
		int poid=(int)current;
		int poidMax=(int)max;
		g.setColor(Color.lightGray);
		g.fillRect(posX,posY,100,15);
		g.setColor(Color.blue);
		g.fillRect(posX,posY,(int)value,15);
		g.setColor(Color.white);
		g.drawString(poid+"/"+poidMax,posX+3,posY+12);
	}
}
