package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;

/**
 * 	the class Chest
 *	creation :5 mai 03 at 17:51:42
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class Chest {
	
	// Chemin des chemin des images par default
	/**
	 * the default chest's open image 
	 */
	public static String IMG_OPEN_CHEST_DEFAULT_PATH = "images/imgDefault/chestOpen.gif";
	/**
	 * the default chest's close image 
	 */
	public static String IMG_CLOSE_CHEST_DEFAULT_PATH = "images/imgDefault/chestClose.gif";
	
	//attributs du coffre
	private String Key;// le nom de l'item cle
	private Item item;// l'item contenu dans le coffre
	private Image imgChestOpen;// l'image du coffre ouvert
	private Image imgChestClose; //l'image du coffre ferm
	private boolean isOpen;//mis a vrai si le coffre est ouvert
	private int posX;// la position en abcisse du coffre
	private int posY;// position en ordonne du coffre
	

	//constructor
	
	/**
	 * create a new chest whith default values
	 * <BR>posX = 4
	 * <BR>posY = 4
	 * <BR>key = no_key
	 * <BR>chest is open
	 * <BR>open and close image are default images
	 */
	public Chest(){
		this.posX = 4;
		this.posY = 4;
		this.Key = "no_key";
		this.isOpen = true;
		this.imgChestOpen = Toolkit.getDefaultToolkit().getImage(Chest.IMG_OPEN_CHEST_DEFAULT_PATH);
		this.imgChestClose = Toolkit.getDefaultToolkit().getImage(Chest.IMG_CLOSE_CHEST_DEFAULT_PATH);
		invariant();
	}

///////////////////      LES METHODES      \\\\\\\\\\\\\\\\\\\\\\
	

	
///////////////////     LES ACCESSEURS     \\\\\\\\\\\\\\\\\\\\\\

	/**
	 * return true if chest is open
	 * @return boolean true if open, false if close
	 */
	public boolean isOpen() {
		invariant();
		return isOpen;
	}

	/**
	 * Returns the item contained in the chest.
	 * @return Item: the item contained in the chest
	 */
	public Item getItem() {
		invariant();
		return item;
	}

	/**
	 * Returns the key which open the chest.
	 * @return a string representing the key item's name 
	 */
	public String getKey() {
		invariant();
		return Key;
	}

	/**
	 * Returns the chest posX.
	 * @return the X position
	 */
	public int getPosX() {
		invariant();
		return posX;
	}

	/**
	 * Returns the chest posY.
	 * @return the Y position
	 */
	public int getPosY() {
		invariant();
		return posY;
	}

	/**
	 * Returns the chest Close image.
	 * @return the chest close image
	 */
	public Image getImgChestClose() {
		invariant();
		return imgChestClose;
	}

	/**
	 * Returns the Chest Open image.
	 * @return the Chest Open image
	 */
	public Image getImgChestOpen() {
		invariant();
		return imgChestOpen;
	}
	
///////////////////   LES MODIFICATEURS      \\\\\\\\\\\\\\\\\\\\
	/**
	 * Sets if the chest is open.
	 * @param isOpen the value to set: true if chest is open, false is the chest is close
	 */
	public void setIsOpen(boolean isOpen) {
		this.isOpen = isOpen;
		invariant();
	}

	/**
	 * Sets the chest's item.
	 * @param item The item to set
	 */
	public void setItem(Item item) {
		this.item = item;
		invariant();
	}

	/**
	 * Sets the key.
	 * @param key The key to set
	 */
	public void setKey(String key) {
		Key = key;
		invariant();
	}

	/**
	 * Sets the chest's X position.
	 * @param posX The X position to set
	 */
	public void setPosX(int posX) {
		this.posX = posX;
		invariant();
	}

	/**
	 * Sets the chest Y position.
	 * @param posY The Y position to set
	 */
	public void setPosY(int posY) {
		this.posY = posY;
		invariant();
	}


	/**
	 * Sets the Chest's Close image.
	 * @param imgChestClose The Chest's Close image to set
	 */
	public void setImgChestClose(Image imgChestClose) {
		this.imgChestClose = imgChestClose;
		invariant();
	}
	
	/**
	 * Sets the Chest's Close image.
	 * @param imgChestClose a string representing the image location on disk
	 */
	public void setImgChestClose(String imgChestClose) {
		this.imgChestClose = Toolkit.getDefaultToolkit().getImage(imgChestClose);
		invariant();
	}
	
	/**
	 * Sets the Chest's Open image.
	 * @param imgChestOpen a string representing the image location on disk
	 */
	public void setImgChestOpen(String imgChestOpen) {
		this.imgChestOpen = Toolkit.getDefaultToolkit().getImage(imgChestOpen);
		invariant();
	}
	
	/**
	 * Sets the Chest's Open image.
	 * @param imgChestOpen The Chest's Open image to set
	 */
	public void setImgChestOpen(Image imgChestOpen) {
		this.imgChestOpen = imgChestOpen;
		invariant();
	}
	
	private void invariant(){
		//assert ((this.posX>=0)&&(this.posX<8)) : "pos x invalide";
		//assert ((this.posY>=0)&&(this.posY<8)) : "pos y invalide";
	}

}
