package zork2Class;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

/**
 * 	the class DirectoryListReader
 * <BR>list all the sub directory of a given directory
 *	creation :5 mai 03 at 17:52:09
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class DirectoryListReader {

	private String directory;
	/**
	 *  the constructor for DirectoryListReader
	 * @param directory
	 */
	public DirectoryListReader(String directory) {
		super();
		File fichier=new File(directory);
		if (fichier.exists()){
			this.directory=directory;
		}
		else{
			this.directory="./";
		}
		invariant();
	}
	
	/**
	 *  method :String[] listDirectory
	 * @return String[] an array containing the sub directory
	 */
	public String[] listDirectory(){
		
		String[] ret=new String[1];
		Vector dirVector=new Vector(0,1);
		
		try{
			
			File fichier=new File(this.directory);
			String[] listeFichier=fichier.list();
			
			for (int i=0;i<listeFichier.length;i++){
				
				File tmp=new File(this.directory+"/"+listeFichier[i]);
				
				if ((tmp.isDirectory())){
					// si c'est un repertoire ->on l'ajoute a la liste des donjons
					dirVector.add(listeFichier[i]);
				}
				
			}
			
			if(dirVector.isEmpty()){
				
				ret[0]=new String("Pas de donjon disponible");
			}
			
			else{
				
				Enumeration e;
				int i=0;
				ret=new String[dirVector.size()];
				
				for(e=dirVector.elements();e.hasMoreElements();i++){
					String chaine=(String)e.nextElement();
					chaine.trim();
					ret[i]=chaine;
				}
			}
			
		}
		catch(SecurityException e){
			System.out.println("SecurityException:impossible de lire le fichier");
			System.exit(0);
		}

		invariant();
		return (ret);
	}
	
	private void invariant(){
		//assert (this.directory!=null) : "nom du repertoire null";		
	}
			

}
