package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;

/**
 * 	the class Door
 *	creation :5 mai 03 at 17:52:24
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class Door {
	
	// attributs
	/**
	 * the default east/west placed door image location on disk
	 */
	public static final String IMG_NEXT_DOOR_DEFAULT_PATH = "images/imgDefault/Door_E.gif";
	/**
	 * teh default north/south placed door image location on disk
	 */
	public static final String IMG_FRONT_DOOR_DEFAULT_PATH = "images/imgDefault/Door.gif";
	
	private String key;// le nom de l'item cle
	private String destinationName;// la salle de l'autre cote de la porte
	private Room destination;
	private Image imgDoor;
	private boolean isOpen;// la porte est-elle ouverte?

	//constructeur
	
	
	/**
	 * default Constructor for Door.
	 */
	public Door(){
		this.key = "no_key";
		this.isOpen = true;
		invariant();
	}
	/**
	 * Constructor for Door.
	 * @param laPiece destination room's name
	 */
	public Door(String laPiece){
		this.key = "no_key";
		this.destinationName = laPiece;
		this.isOpen = true;
		invariant();
	}
	
	/**
	 * Constructor for Door.
	 * @param laPiece destination room
	 */
	public Door(Room laPiece){
		this.key = "no_key";
		this.destination = laPiece;
		this.isOpen = true;	
		invariant();
	}


///////////////////      LES METHODES      \\\\\\\\\\\\\\\\\\\\\\

	/**
 	 * Method CanBeOpen.
 	 * <BR>if the door can't be open (if it is closed and haven't a key) this return false
 	 * elsewhere this return true
 	 * @return boolean saying if the door is "openable"
	 */
	public boolean CanBeOpen(){
		boolean ret=true;
		if ((this.getKey().equalsIgnoreCase("no_key"))&&(!this.isOpen)){
			ret=false;
		}
		invariant();
		return ret;
	}

///////////////////     LES ACCESSEURS     \\\\\\\\\\\\\\\\\\\\\\

	/**
	 * Returns the destination room name.
	 * @return String the destination room name
	 */
	public String getDestinationName() {
		invariant();
		return destinationName;
	}

	/**
	 * Returns if the door is Open.
	 * @return boolean true if the door is open
	 */
	public boolean doorIsOpen() {
		invariant();
		return isOpen;
	}

	/**
	 * Returns the door key.
	 * @return String the key representing the name of the key item
	 */
	public String getKey() {
		invariant();
		return key;
	}

	/**
	 * Returns the destination room.
	 * @return Room the destination
	 */
	public Room getDestination() {
		invariant();
		return destination;
	}

	/**
	 * Returns the Door's image.
	 * @return Image the door's image
	 */
	public Image getImgDoor() {
		invariant();
		return imgDoor;
	}

///////////////////   LES MODIFICATEURS      \\\\\\\\\\\\\\\\\\\\

	/**
	 * Sets the destination room name.
	 * @param destinationName The destination room name to set
	 */
	public void setDestinationName(String destination) {
		this.destinationName = destination;
		invariant();
	}

	/**
	 * Sets if the door is Open.
	 * @param isOpen The value to set
	 */
	public void setIsOpen(boolean isOpen) {
		this.isOpen = isOpen;
		invariant();
	}

	/**
	 * Sets the item key name.
	 * @param key The key to set
	 */
	public void setKey(String key) {
		this.key = key;
		invariant();
	}
	
	/**
	 * Sets the destination room.
	 * @param destination The destination room to set
	 */
	public void setDestination(Room destination) {
		this.destination = destination;
		invariant();
	}

	/**
	 * Sets the Door's image.
	 * @param imgDoor The image to set
	 */
	public void setImgDoor(Image imgDoor) {
			this.imgDoor = imgDoor;
		invariant();
	}
	
	/**
	 * Sets the Doors image location on disk.
	 * @param imgDoor The imgDoor Path which is used to set.
	 */
	public void setImgDoor(String imgDoor) {
		this.imgDoor = Toolkit.getDefaultToolkit().getImage(imgDoor);
		invariant();
	}
	/**
	 *  void Door::checkAndSetImgDoor
	 * <BR>check the door location and set the valide default image for the door
	 * @param string
	 */
	public void checkAndSetImgDoor(String string) {
		if(this.imgDoor == null){
			if((string.equalsIgnoreCase("east"))||(string.equalsIgnoreCase("west"))){
				this.setImgDoor(Door.IMG_NEXT_DOOR_DEFAULT_PATH);
			}
			else{
				if((string.equalsIgnoreCase("north"))||(string.equalsIgnoreCase("south"))){
					this.setImgDoor(Door.IMG_FRONT_DOOR_DEFAULT_PATH);
				}
			}
		}
		invariant();
	}
	
	private void invariant(){
		// nothing in invariant
	}
}
