/*
 * Created on 8 juin 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package zork2Class;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

/**
 * This method permit to load a Zork2 saving which are writen by the programm : 
 * DungeonFileSaving.
 * @author BOYERE Fabien
 * @version 8 juin 2003
 * @since j2sdk 1.4
 */
public class DungeonFileLoading {
	
	//attributs
	private Hashtable listRooms;//the listRoom which are loaded
	private String pathFile;//the path of the saving file
	private DungeonFileReader dunFileRead;//the Dungeon which the saving is about
	private Player player;//the player which are concerned by the saving

	//constructeur
	/**
	 * @param pathFile this is the path of the saving.
	 */
	public DungeonFileLoading(String pathFile){
		this.pathFile = pathFile;	
	}
	
	/** method :boolean DungeonFileLoading::readDungeonFileSave
	 * <BR>read a dungeon file
	 * @return true if the reading is ok
	 */
	//methodes
	public boolean readDungeonFileSave(){
		
		boolean ret = false;//booleen retourn
		
		String s;//cette String permet de stocker temporairement la ligne en cours de lecture
		
		FileReader inReader;//permet de lire un fichier
		BufferedReader in;//permet de lire un fichier
		StringTokenizer st, sl;//contiennent les morceaux de la ligne en cours de chargement
		
		Room room = null;//salle temporaire contient les infos sur la salle en cours de chargement
		player = new Player();
		boolean initRead = false;//set as true if the initial dungeon as correctly loaded
		
		try{
						
			//lecture du fichier dongeon.zdu
			inReader = new FileReader("sauvegardes/"+pathFile+".sz2");

			//inReader = new FileReader("sauvegardes/coucou2.sz2");
			in = new BufferedReader(inReader);
			
			//boucle pour sauter les commentaires situs avant la balise <Z2SAVING>
			do{
				s = in.readLine().trim();
			}while(!s.equalsIgnoreCase("<Z2SAVING>"));
			
			//on lit une nouvelle ligne
			s = in.readLine().trim();
			
			while(!s.startsWith("Dungeon")){
				s = in.readLine().trim();
			}
			
			//on rcupre le nom du donjon	
			st = new StringTokenizer(s,"\"");
			st.nextToken();
			if(st.hasMoreTokens()){
				s = st.nextToken().trim();
				dunFileRead = new DungeonFileReader(s);
				initRead = this.dunFileRead.readDungeonFile();
				this.listRooms = this.dunFileRead.getListRooms();
			}

			
			if(initRead){
				s = in.readLine().trim();
				while(!s.equalsIgnoreCase("</Z2SAVING>")){
				
					//boucle pour sauter les commentaires
					if(s.startsWith("<!--")){
						while(!s.endsWith("-->")){
							s = in.readLine().trim();
						}
					}
					else{
						
						//boucle pour sauter les lignes vides
						if(s.equals("")){
							do{
								s =in.readLine();	
							}while(s.equals(""));
						}
						else{
							
							//on rcupre les attributs du joueur
							if(s.equalsIgnoreCase("<PLAYER>")){
								s = in.readLine().trim();
								while(!s.equalsIgnoreCase("</PLAYER>")){
													
									//on rcupre le type de l'attribut
									st = new StringTokenizer(s,"=");
									if(st.hasMoreTokens()){
										s = st.nextToken().trim();
									}
											
									//suivant son type on modify la porte pour qu'elle corresponde au fichier
									
									//nom du joueur
									if(s.equalsIgnoreCase("Name")){
										sl = new StringTokenizer(st.nextToken(),"\"");
										sl.nextToken();
										if(sl.hasMoreTokens()){
											s = sl.nextToken();
											player.setName(s);
										}
									}
									else{
										if(s.equalsIgnoreCase("Strength")){
											sl = new StringTokenizer(st.nextToken(),"\"");
											sl.nextToken();
											if(sl.hasMoreTokens()){
												s = sl.nextToken();
												player.setStrengthLevel(Integer.parseInt(s));
											}
										}
										else{
											if(s.equalsIgnoreCase("Dexterity")){
												sl = new StringTokenizer(st.nextToken(),"\"");
												sl.nextToken();
												if(sl.hasMoreTokens()){
													s = sl.nextToken();
													player.setDexterityLevel(Integer.parseInt(s));
												}
											}
											else{
												if(s.equalsIgnoreCase("Intelligence")){
													sl = new StringTokenizer(st.nextToken(),"\"");
													sl.nextToken();
													if(sl.hasMoreTokens()){
														s = sl.nextToken();
														player.setIntelligenceLevel(Integer.parseInt(s));
													}
												}
												else{
													if(s.equalsIgnoreCase("StartEnergy")){
														sl = new StringTokenizer(st.nextToken(),"\"");
														sl.nextToken();
														if(sl.hasMoreTokens()){
															s = sl.nextToken();
															player.setEnergyLevel(Integer.parseInt(s));
														}
													}
													else{
														if(s.equalsIgnoreCase("EnergyAt")){
															sl = new StringTokenizer(st.nextToken(),"\"");
															sl.nextToken();
															if(sl.hasMoreTokens()){
																s = sl.nextToken();
																player.setCurrentEnergy(Integer.parseInt(s));
															}
														}
														else{
															if(s.equalsIgnoreCase("PosX")){
																sl = new StringTokenizer(st.nextToken(),"\"");
																sl.nextToken();
																if(sl.hasMoreTokens()){
																	s = sl.nextToken();
																	player.setPosX(Integer.parseInt(s));
																}
															}
															else{
																if(s.equalsIgnoreCase("PosY")){
																	sl = new StringTokenizer(st.nextToken(),"\"");
																	sl.nextToken();
																	if(sl.hasMoreTokens()){
																		s = sl.nextToken();
																		player.setPosY(Integer.parseInt(s));
																	}
																}
																else{
																	if(s.equalsIgnoreCase("Score")){
																		sl = new StringTokenizer(st.nextToken(),"\"");
																		sl.nextToken();
																		if(sl.hasMoreTokens()){
																			s = sl.nextToken();
																			player.setScore(new Score(Integer.parseInt(s)));
																		}
																	}
																	else{
																		if(s.equalsIgnoreCase("LifeNumber")){
																			sl = new StringTokenizer(st.nextToken(),"\"");
																			sl.nextToken();
																			if(sl.hasMoreTokens()){
																				s = sl.nextToken();
																				player.setLifeNumber(Integer.parseInt(s));
																			}
																		}
																		else{
																			if(s.equalsIgnoreCase("CurrentWeapon")){
																				sl = new StringTokenizer(st.nextToken(),"\"");
																				sl.nextToken();
																				if(sl.hasMoreTokens()){
																					s = sl.nextToken().trim();
																					Item ite = this.CheckIfItemExist(s);
																					if(ite != null){
																						this.player.setCurrentWeapon(ite);
																					}
																				}
																			}
																			else{
																				if(s.equalsIgnoreCase("LastRoom")){
																					sl = new StringTokenizer(st.nextToken(),"\"");
																					sl.nextToken();
																					if(sl.hasMoreTokens()){
																						s = sl.nextToken().trim();
																						Room rom = this.CheckIfRoomExist(s);
																						if(rom != null){
																							this.player.setLastRoom(rom);
																						}
																					}
																				}
																				else{
																					if(s.equalsIgnoreCase("CurrentRoom")){
																						sl = new StringTokenizer(st.nextToken(),"\"");
																						sl.nextToken();
																						if(sl.hasMoreTokens()){
																							s = sl.nextToken().trim();
																							Room rom = this.CheckIfRoomExist(s);
																							if(rom != null){
																								this.player.setCurrentRoom(rom);
																							}
																						}
																					}
																					else{
																						if(s.equalsIgnoreCase("item")){
																							sl = new StringTokenizer(st.nextToken(),"\"");
																							sl.nextToken();
																							if(sl.hasMoreTokens()){
																								s = sl.nextToken().trim();
																								Item ite = this.CheckIfItemExist(s);
																								if(ite != null){
																								
																									this.player.getInventory().addElement(ite);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									s = in.readLine();
									if(s!=null){
										s = s.trim();
									}
								}
							}
							else{
								//on rcupre les attributs des salles
								if(s.equalsIgnoreCase("<ROOM>")){
									
									String name = null;
									boolean DoorSouthOpen = false;
									boolean DoorNorthOpen = false;
									boolean DoorEastOpen = false;
									boolean DoorWestOpen = false;
									Item itemInChest = null;
									boolean ordealActivate = false;
									boolean chestIsOpen = false;
									Item[][] tabItem;
									tabItem = new Item[8][];
									//boucle d'initialisation
									for(int i=0; i<8; i++){
										tabItem[i] = new Item[8];
									}
									
									
									while(!s.equalsIgnoreCase("</ROOM>")){
										
										
										//on rcupre le type de l'attribut
										st = new StringTokenizer(s,"=");
										if(st.hasMoreTokens()){
											s = st.nextToken().trim();
											
											//nom de la salle
											if(s.equalsIgnoreCase("Name")){
												sl = new StringTokenizer(st.nextToken(),"\"");
												sl.nextToken();
												if(sl.hasMoreTokens()){
													s = sl.nextToken().trim();
													name = s;
												}
											}
											else{
												//on charge les items
												if(s.equalsIgnoreCase("item")){
													sl = new StringTokenizer(st.nextToken(),"\"");
													sl.nextToken();
													if(sl.hasMoreTokens()){
														StringTokenizer sx = new StringTokenizer(sl.nextToken(),",");
														if(sx.hasMoreTokens()){
															s = sx.nextToken().trim();
														}
														Item ite = this.CheckIfItemExist(s);
														if(ite != null){
															if(sx.hasMoreTokens()){
																int posY = Integer.parseInt(s = sx.nextToken().trim());
																if(sx.hasMoreTokens()){
																	int posX = Integer.parseInt(s = sx.nextToken().trim());
																	tabItem[posX][posY] = ite;
																}
															}
														}
													}
												}
												else{
													if(s.equalsIgnoreCase("DoorWestOpen")){
														sl = new StringTokenizer(st.nextToken(),"\"");
														sl.nextToken();
														if(sl.hasMoreTokens()){
															s = sl.nextToken().trim();
															if(s.equalsIgnoreCase("true")){
																DoorWestOpen = true;
															}
															else{
																if(s.equalsIgnoreCase("false")){
																	DoorWestOpen = false;
																}
															}
														}
													}
													else{
														if(s.equalsIgnoreCase("DoorEastOpen")){
															sl = new StringTokenizer(st.nextToken(),"\"");
															sl.nextToken();
															if(sl.hasMoreTokens()){
																s = sl.nextToken().trim();
																if(s.equalsIgnoreCase("true")){
																	DoorEastOpen = true;
																}
																else{
																	if(s.equalsIgnoreCase("false")){
																		DoorEastOpen = false;
																	}
																}
															}
														}
														else{
															if(s.equalsIgnoreCase("DoorSouthOpen")){
																sl = new StringTokenizer(st.nextToken(),"\"");
																sl.nextToken();
																if(sl.hasMoreTokens()){
																	s = sl.nextToken().trim();
																	if(s.equalsIgnoreCase("true")){
																		DoorSouthOpen = true;
																	}
																	else{
																		if(s.equalsIgnoreCase("false")){
																			DoorSouthOpen = false;
																		}
																	}
																}
															}
															else{
																if(s.equalsIgnoreCase("DoorNorthOpen")){
																	sl = new StringTokenizer(st.nextToken(),"\"");
																	sl.nextToken();
																	if(sl.hasMoreTokens()){
																		s = sl.nextToken().trim();
																		if(s.equalsIgnoreCase("true")){
																			DoorNorthOpen = true;
																		}
																		else{
																			if(s.equalsIgnoreCase("false")){
																				DoorNorthOpen = false;
																			}
																		}
																	}
																}
																else{
																	if(s.equalsIgnoreCase("ordealActivate")){
																		sl = new StringTokenizer(st.nextToken(),"\"");
																		sl.nextToken();
																		if(sl.hasMoreTokens()){
																			s = sl.nextToken().trim();
																			if(s.equalsIgnoreCase("true")){
																				ordealActivate = true;
																			}
																			else{
																				if(s.equalsIgnoreCase("false")){
																					ordealActivate = false;
																				}
																			}
																		}
																	}
																	else{
																		if(s.equalsIgnoreCase("ChestIsOpen")){
																			sl = new StringTokenizer(st.nextToken(),"\"");
																			sl.nextToken();
																			if(sl.hasMoreTokens()){
																				s = sl.nextToken().trim();
																				if(s.equalsIgnoreCase("true")){
																					chestIsOpen = true;
																				}
																				else{
																					if(s.equalsIgnoreCase("false")){
																						chestIsOpen = false;
																					}
																				}
																			}
																		}
																		else{
																			if(s.equalsIgnoreCase("itemInchest")){
																				sl = new StringTokenizer(st.nextToken(),"\"");
																				sl.nextToken();
																				if(sl.hasMoreTokens()){
																					Item ite = this.CheckIfItemExist(sl.nextToken().trim());
																					if(ite != null){
																						itemInChest = ite;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
										s = in.readLine();
										if(s!=null){
											s = s.trim();	
										}
									}
									
									//on met  jour la salle 
									if(name != null){
										Room roomX;
										roomX = this.CheckIfRoomExist(name);
										if(roomX != null){
											roomX.setIsOrdealActivate(ordealActivate);
											roomX.setItemPosition(tabItem);
											
											if(roomX.getDoorEast() != null){
												roomX.getDoorEast().setIsOpen(DoorEastOpen);
											}
											if(roomX.getDoorNorth() != null){
												roomX.getDoorNorth().setIsOpen(DoorNorthOpen);
											}
											if(roomX.getDoorWest() != null){
												roomX.getDoorWest().setIsOpen(DoorWestOpen);
											}
											if(roomX.getDoorSouth() != null){
												roomX.getDoorSouth().setIsOpen(DoorSouthOpen);
											}
											if(roomX.getChest()!=null){
												roomX.getChest().setItem(itemInChest);
												roomX.getChest().setIsOpen(chestIsOpen);
											}
											roomX.setIsVisited(true);
										}
									}
								}
							}
						}
					}
					
					//lecture d'une nouvelle ligne
					s = in.readLine();
					if(s!=null){
						s = s.trim();
					}
				}
				ret = true;

			}			
			else{
				//dans le cas ou le fichier dongeon n'a pas t bien lu
				ret = false;

				
			}
		}
		
		//rcupration des diffrentes erreurs de lecture
		catch(IOException e){
			ret = false;

		}
		
		//rcupration des diffrentes erreurs de lecture
		catch(Exception e){
			ret = false;
			e.printStackTrace();
		}
		
		//retour final
		finally{
			return ret;
		}	
	}
	
	/**
	 * This method check if the room exist in the original dungeon. If the room exist, it return 
	 * the room, but if the room doesn't exist it return "null".
	 * @param nameRoom this is the name of the room you like to check the presence
	 * @return If the room exist in the listRoom, the method return the room. In the other fact
	 * it return null
	 */
	private Room CheckIfRoomExist(String nameRoom){
		Room ret = null;//booleen de retour
		
		//on vrifie si l'item existe et on le charge
		//si il existe pas on renvoie "null"
		if(this.listRooms!=null){
			if(this.listRooms.containsKey(nameRoom)){
				ret = (Room) this.listRooms.get(nameRoom);
				//rcupration des diffrentes erreurs de lecture


			}
		}

		return(ret);
	}

	/**
	 * This method check if an item exist with the name, in the original dungeon. If the item exist, it return 
	 * the item, but if the item doesn't exist it return "null".
	 * @param nameItem this is the name of the item you like to check the existing
	 * @return If the item exist in the listItem, the method return the item. In the other fact
	 * it return null.
	 */
	private Item CheckIfItemExist(String nameItem){
		
		Item ret = null;//booleen de retour
		
		//on vrifie si l'item existe et on le charge
		//si il existe pas on renvoie "null"
		if(this.dunFileRead!=null){
			if(this.dunFileRead.getTableItems().containsKey(nameItem)){
				ret = (Item) this.dunFileRead.getTableItems().get(nameItem);
			}
		}

		return(ret);
	}
	
	/**
	 * Returns the listRooms. The listRoom is the hashtable which contain
	 * all the rooms
	 * @return Hashtable
	 */
	public Hashtable getListRooms() {
		return listRooms;
	}

	/**
	 * Returns the tableItems. This is the hashtable which contains all items.
	 * @return Hashtable
	 */
	public Hashtable getTableItems() {
		return(this.dunFileRead.getTableItems());
	}
	
	/**
	 * Returns the finalRoom, this is the last room of the game.
	 * @return Room
	 */
	public Room getFinalRoom() {
		Room ret;
		ret = this.dunFileRead.getFinalRoom();
		return ret;
	}
	/**
	 * Returns the firstRoom, this is the first room of the game.
	 * @return Room
	 */
	public Room getFirstRoom() {
		Room ret;
		ret = this.dunFileRead.getFirstRoom();
		return ret;
	}
	/**
	 * method use to get the saved player
	 * @return player the saved player
	 */
	public Player getPlayer() {
		return player;
	}

	/**
	 * Returns the firstRoom, this is the first room of the game.
	 * @return Room
	 */
	public String getNameDungeon() {
		return (this.dunFileRead.getNameDungeon());
	}


}
