package zork2Class;

//imports pour la cration d'images
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

import javax.swing.JOptionPane;


/** 
 * This class permit to read the configuration file "dungeon.zdu". This file is file which contains 
 * the configuration of a dungeon for ZorkII.<br>
 * &lt;center&gt;The meaning of the different tag&lt;/center&gt;<br>
 * <ol>
 * 	<li>&lt;DUNGEON&gt; show the begin of a dungeon file configuration.
 * -->You should use &lt;/DUNGEON&gt;, to close the file. It should be the last tag. This tag is obligatory. 
 * If between &lt;DUNGEON&gt; et &lt;/DUNGEON>, there are no firstRoom, no finalRoom attribut, the
 * become unvalide.
 * 	<li>&lt;DOOR&gt;this tag is used when you like to show the begin of the list of the door.
 * -->You should use &lt;/DOOR&gt;, to mark the end of the door of a room enumeration.
 * 	<li>&lt;CHEST&gt;this tag is used when you like to show the begin of the list of the chest attribut
 * -->You should use &lt;/CHEST&gt;, to mark the end of the chest attributs.
 * 	<li>&lt;ITEM&gt;this tag is used when you like to show the begin of a item position.
 * -->You should use &lt;/ITEM&gt;, to mark the end of the item attributs.
 * 	<li>&lt;COMMENTS&gt;this tag is used when you like to add comments in the file Dungeon.zdu
 * -->You should use &lt;/COMMENTS&gt;, to mark the end of the comments.
 * 	<li>&lt;SOUTH&gt;this tag is used when you like to show the begin of a south door attribut.
 * -->You should use &lt;/SOUTH&gt;, to mark the end.
 * 	<li>&lt;NORTH&gt;this tag is used when you like to show the begin of a north door attribut.
 * -->You should use &lt;/NORTH&gt;, to mark the end.
 * 	<li>&lt;EAST&gt;this tag is used when you like to show the begin of a east door attribut.
 * -->You should use &lt;/EAST&gt;, to mark the end.
 * 	<li>&lt;WEST&gt;this tag is used when you like to show the begin of a west door attribut.
 * -->You should use &lt;/WEST&gt;, to mark the end.
 * </ol>
 * 
 * <b>WARNING :</b>For using this class, you should have create three files which named
 * ordeal.zor, item.zit and dungeon.zor. This files should be create in the same directory.
 * The directory is the directory which is put as parameter of the constructor..
 * @version 1.0, 28/03/03
 * @author IUT de Vannes, Fabien BOYERE
 */
public class DungeonFileReader {

	//les attributs
	
	private Hashtable listRooms;//table qui contient les salles provisoirement
	private Hashtable tableItems;//table qui contient tous les items
	private Hashtable tableOrdeals;//table qui contient toutes les preuves
	private String nameDungeon;//nom du donjon, c'est  dire le nom du dossier dans lequel il se trouve.
	private String firstRoom;//premire salle du donjon
	private String finalRoom;//dernire salle du donjon
	
	//le constructeur
	/**
	 * This constructor permit to build a new object which permit to load
	 * a dungeon for Zork2. A dungeon with its item, its ordeal and its rooms...etc
	 * @param String - this string is the directory of the different files : dungeon.zdu,
	 * item.zit and ordeal.zor. The three must exist, before
	 */
	public DungeonFileReader(String str){
		
		//initialisation des attributs
		this.listRooms = new Hashtable();
		this.nameDungeon = str;
			
	}
	
	
	/** 
	 * This method is a methode which permit to read a file dungeon.zdu. This method
	 * read the file and build a dongeon which is composed by room. This method check if all the room has been 
	 * exist.
	 * @return boolean - Return false, if the file hasn't correctly loaded or the file hasn't correcty write (lack of tag or other).
  	 */
	public boolean readDungeonFile(){
		
		boolean ret = false;//booleen retourn
		
		String s;//cette String permet de stocker temporairement la ligne en cours de lecture
		
		FileReader inReader;//permet de lire un fichier
		BufferedReader in;//permet de lire un fichier
		StringTokenizer st, sl;//contiennent les morceaux de la ligne en cours de chargement
		
		Room room = null;//salle temporaire contient les infos sur la salle en cours de chargement
		
		try{
			
			//on charge les preuves et les items
			this.loadDungeonParts();
						
			//lecture du fichier dongeon.zdu
			inReader = new FileReader("maps/"+nameDungeon+"/dungeon.zdu");
			in = new BufferedReader(inReader);
			
			//boucle pour sauter les commentaires situs avant la balise <DUNGEON>
			do{
				s = in.readLine().trim();
			}while(!s.equals("<DUNGEON>"));
						
			//boucle de traitement des Rooms tant que l'on atteint pas la balise </DUNGEON>
			// et des attributs du don jon tel que la salle de dpart, la salle de fin etc...
			s = in.readLine().trim();
			
			while((!s.equals("</DUNGEON>"))&&(s!=null)){
				
				st = new StringTokenizer(s,"=");
				if(st.hasMoreTokens()){
					s = st.nextToken().trim();
				}
				
				//boucle qui permet de dtecter les parties de commentaires et de les ignorer
				if(s.startsWith("<!--")){
					while(!s.endsWith("-->")){
						s = in.readLine().trim();
					}
				}
				else{			
					
					//permet de dtecter l'apparition de beginRoom
					if(s.equalsIgnoreCase("firstRoom")){
						sl = new StringTokenizer(st.nextToken().trim(),"\"");
						if(sl.hasMoreTokens()){
							this.firstRoom = sl.nextToken().trim();
						}
					}
					
					else{
						
						//permet de dtecter l'apparition de finalRoom
						if(s.equalsIgnoreCase("finalRoom")){
							sl = new StringTokenizer(st.nextToken().trim(),"\"");
							if(sl.hasMoreTokens()){
								this.finalRoom = sl.nextToken().trim();
							}
						}
						else{
							if(s.equalsIgnoreCase("<ROOM>")){
								room = new Room();
								//cette boucle permet de stocker toutes les lignes prsentent entre
								//les lignes <room> et </room> en supprimant les commentaires et les lignes vides
								s = in.readLine().trim();
								while(!s.equalsIgnoreCase("</ROOM>")){
									//boucle qui permet de supprimer d'ventuels commentaires
									//qui seraient prsent entre les balises <room> et </room>
									if(s.equals("")){
										do{
											s = in.readLine().trim();
										}while(s.equals(""));
									}
									else{
										if(s.startsWith("<!--")){
											while(!s.endsWith("-->")){
												s = in.readLine().trim();
											}
										}
										else{
											//dans cette boucle on traite les arguments de la room
											if(s!=null){
												st = new StringTokenizer(s,"=");
												s = st.nextToken().trim();
												
											}
											
											//traitement du cas ou il y a une preuve dans la salle
											if(s.equalsIgnoreCase("Name")){
												s = st.nextToken().trim();
												sl = new StringTokenizer(s,"\"");
												if(sl.hasMoreTokens()){
													room.setRoomName(sl.nextToken().trim());
												}
											}
											else{
												if(s.equalsIgnoreCase("Description")){
													s = st.nextToken().trim();
													sl = new StringTokenizer(s,"\"");
													if(sl.hasMoreTokens()){
														room.setRoomDescription(sl.nextToken().trim());
														room.setRoomDescription(room.getDescription().replace('','\n'));
													}
												}
												else{
													if(s.equalsIgnoreCase("imgBackWall")){
														s = st.nextToken().trim();
														sl = new StringTokenizer(s,"\"");
														if(sl.hasMoreTokens()){
															s = sl.nextToken().trim();
															if(!s.equalsIgnoreCase("default")){
																room.setImgBackWall(s);
															}
														}
													}
													else{
														if(s.equalsIgnoreCase("imgRightWall")){
															s = st.nextToken().trim();
															sl = new StringTokenizer(s,"\"");
															if(sl.hasMoreTokens()){
																s = sl.nextToken().trim();
																if(!s.equalsIgnoreCase("default")){
																	room.setImgRightWall(s);
																}
															}
														}
														else{
															if(s.equalsIgnoreCase("imgFrontWall")){
																s = st.nextToken().trim();
																sl = new StringTokenizer(s,"\"");
																if(sl.hasMoreTokens()){
																	s = sl.nextToken().trim();
																	if(!s.equalsIgnoreCase("default")){
																		room.setImgFrontWall(s);
																	}
																}
															}
															else{
																if(s.equalsIgnoreCase("imgLeftWall")){
																	s = st.nextToken().trim();
																	sl = new StringTokenizer(s,"\"");
																	if(sl.hasMoreTokens()){
																		s = sl.nextToken().trim();
																		if(!s.equalsIgnoreCase("default")){
																			room.setImgLeftWall(s);
																		}
																	}
																}
																else{
																	if(s.equalsIgnoreCase("imgFloor")){
																		s = st.nextToken().trim();
																		sl = new StringTokenizer(s,"\"");
																		if(sl.hasMoreTokens()){
																			s = sl.nextToken().trim();
																			if(!s.equalsIgnoreCase("default")){
																				room.setImgFloor(s);
																			}
																		}
																	}
																	else{
																		if(s.equalsIgnoreCase("Ordeal")){
																			sl = new StringTokenizer(st.nextToken().trim(),"\"");

																			if(sl.hasMoreTokens()){
																				s = sl.nextToken().trim();
																				Ordeal tempOrd = (Ordeal)this.tableOrdeals.get(s.toLowerCase());
																				room.setOrdeal(tempOrd);
																			}
																		}
																		else{
																			// traitement des items, ente les balises <Item> et </ITEM>
																			//si la position de l'item est identique  un autre item, on ne mmorisera 
																			//que le dernier charg
																			if(s.equalsIgnoreCase("<ITEM>")){
																				
																				st = new StringTokenizer(in.readLine(),"=");
																				if(st.hasMoreElements()){	
																					s = st.nextToken().trim();
																				}
																				int posX = 4;//position y de l'item par default
																				int posY = 4;//position x de l'item par default
																				String nameItem = new String();
																				while(!s.equalsIgnoreCase("</ITEM>")){
																					if(s.equalsIgnoreCase("name")){
																						s = st.nextToken();
																						sl = new StringTokenizer(s.trim(),"\"");
																					
																						if(sl.hasMoreTokens()){
																							nameItem = sl.nextToken().trim();
																						}
																					}
																					else{
																						if(s.equalsIgnoreCase("posX")){
																							sl = new StringTokenizer(st.nextToken().trim(),"\"");
																							
																							if(sl.hasMoreTokens()){
																								posX = Integer.parseInt(sl.nextToken().trim());
																							}
																						}
																						else{
																							if(s.equalsIgnoreCase("posY")){
																								sl = new StringTokenizer(st.nextToken().trim(),"\"");
																							
																								if(sl.hasMoreTokens()){
																									posY = Integer.parseInt(sl.nextToken().trim());
																								}
																							}
																						}
																					}
																					st = new StringTokenizer(in.readLine(),"=");
																					if(st.hasMoreTokens()){
																						s = st.nextToken().trim();
																					}
																				}
																				
																				//on vrifie si l'item existe dans la liste
																				if(!nameItem.equals("")){
																					if(this.tableItems.containsKey(nameItem)){
																						Item item = (Item)this.tableItems.get(nameItem);
																						room.setItemPosition(item, posX, posY);
																					}
																				} 	
																			}
																			else{
																				
																				//vrifie si il y a la balise Chest
																				//Si il y a la balise chest cela signifie que la salle possde un coffre
																				if(s.equalsIgnoreCase("<CHEST>")){
																					s = in.readLine().trim();										
																					Chest chest = new Chest();
																					while(!s.equalsIgnoreCase("</CHEST>")){
																						
																						//supression des commentaires
																						if(s.startsWith("<!--")){
																							while(!s.endsWith("-->")){
																								s = in.readLine().trim();
																							}
																						}
																						
																						//traitement des attributs du coffre de la prsente salle
																						else{
																							
																							st = new StringTokenizer(s,"=");
																							if(st.hasMoreTokens()){	
																								s = st.nextToken();
																								s = s.trim();
																							}
																							
																							if(s.equalsIgnoreCase("Key")){
																								sl = new StringTokenizer(st.nextToken().trim(),"\"");
																								
																								if(sl.hasMoreTokens()){
																									chest.setKey(sl.nextToken());
																								}
																							}
																							else{	
																								if(s.equalsIgnoreCase("Item")){
																									
																									sl = new StringTokenizer(st.nextToken().trim(),"\"");
																									
																									
																									if(sl.hasMoreTokens()){
																										s = sl.nextToken();
																										if(this.tableItems.containsKey(s)){
																											chest.setItem((Item)this.tableItems.get(s));
																										}
																									}
																									
																								}
																								else{
																									if(s.equalsIgnoreCase("imgClose")){
																										
																										sl = new StringTokenizer(st.nextToken().trim(),"\"");
																										
																										if(sl.hasMoreTokens()){
																											s = sl.nextToken();
																											if(!s.equalsIgnoreCase("default")){
																												chest.setImgChestClose(Toolkit.getDefaultToolkit().getImage(s));
																											}
																										}
																										
																									}
																									else{
																										if(s.equalsIgnoreCase("imgOpen")){
																											
																											sl = new StringTokenizer(st.nextToken().trim(),"\"");
																											
																											if(sl.hasMoreTokens()){
																												s = sl.nextToken();
																												if(!s.equalsIgnoreCase("default")){
																													chest.setImgChestOpen(Toolkit.getDefaultToolkit().getImage(s));
																												}
																											}
																											
																										}
																										else{
																											if(s.equalsIgnoreCase("isOpen")){
																												
																												sl = new StringTokenizer(st.nextToken().trim(),"\"");
																									
																												if(sl.hasMoreTokens()){
																													s = sl.nextToken();
																													if(s.equalsIgnoreCase("false")){
																														chest.setIsOpen(false);
																													}
																												}
																												
																											}
																											else{
																												if(s.equalsIgnoreCase("posX")){
																													
																													sl = new StringTokenizer(st.nextToken().trim(),"\"");
																													
																													
																													if(sl.hasMoreTokens()){
																														chest.setPosX(Integer.parseInt(sl.nextToken().trim()));
																													}
																													
																												}
																												else{
																													if(s.equalsIgnoreCase("posY")){
																														sl = new StringTokenizer(st.nextToken().trim(),"\"");
																														if(sl.hasMoreTokens()){
																															chest.setPosY(Integer.parseInt(sl.nextToken().trim()));
																														}
																														
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																							
																						}
																						//on traite une nouvelle ligne
																						s = in.readLine().trim();
																						
																					}
																					//on attribut le coffre cr,  la salle courrante
																					room.setChest(chest);
																				}
																				else{
																					
																					//verification si prsence de la balise <DOOR>
																					if(s.equalsIgnoreCase("<DOOR>")){
					
																						s = in.readLine().trim();
					
																						Door door;
																						
																						//on traite les attributs des diffrentes portes
																						//prsentent dans la salle
																						while(!s.equalsIgnoreCase("</DOOR>")){
																							door = new Door();
																							if(s.equalsIgnoreCase("<NORTH>")){
																								s = in.readLine().trim();
																								while(!s.equalsIgnoreCase("</NORTH>")){
																									this.readDoor(door,s);
																									s = in.readLine().trim();
																								}
																								room.setDoorNorth(door);
																							}
																							
																							else{
																								if(s.equalsIgnoreCase("<SOUTH>")){
																									s = in.readLine().trim();
																									while(!s.equalsIgnoreCase("</SOUTH>")){
																										this.readDoor(door,s);
																										s = in.readLine().trim();
																									}
																									room.setDoorSouth(door);
																								}
																								
																								else{	
																									if(s.equalsIgnoreCase("<EAST>")){
																										s = in.readLine().trim();
																										while(!s.equalsIgnoreCase("</EAST>")){
																											this.readDoor(door,s);
																											s = in.readLine().trim();
																										}
																										room.setDoorEast(door);
																									}
																									
																									else{	
																										if(s.equalsIgnoreCase("<WEST>")){
																											
																											s = in.readLine().trim();
																											
																											while(!s.equalsIgnoreCase("</WEST>")){
																												this.readDoor(door,s);
																												s = in.readLine().trim();
																											}
																											room.setDoorWest(door);
																										}
																									}
																								}
																							}
																							s = in.readLine().trim();
																						}
																					}
																				}			
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
										//on lit une nouvelle ligne de fichier
										s = in.readLine();
										if(s!=null){
											s = s.trim();
										}
									}
								}
							}
							
							//si la salle n'est pas null et qu'elle comporte bien
							//un nom, alors on l'ajoute  la hashtable de rooms
							if(room!=null){
								if(room.getName()!=null){
									this.listRooms.put(room.getName(),room);
								}
							}
						}
					}
				}
				
				//on lit une nouvelle ligne du fichier
				s = in.readLine();
				if(s!=null){
					s = s.trim();
				}
			}
			//fermeture du fichier
			in.close();
			//pour l'instant la lecture c'est bien passe donc on renvoie "true"
			ret = true;
			
			
			//on vrifie la prsence de l'attribut "firstRoom"
			//puis on vrifie que la premire salle est prsente dans le fichier
			//Si une des deux conditions n'est pas remplie, alors un message d'erreur apparait
			//et l'opration de chargement est annule 
			if((firstRoom==null)){
				JOptionPane.showMessageDialog(null,"Le fichier "+nameDungeon+"/dongeon.zdu ne comporte pas d'attributs beginRoom.\n Cet attribut est obligatoire.","Incohrences dans le fichier de paramtrages",JOptionPane.ERROR_MESSAGE);
				ret = false;
			}
			else{
				boolean isIn = false;
				Enumeration e = this.listRooms.keys();
				for(;e.hasMoreElements();){
					if(firstRoom.equalsIgnoreCase((String)e.nextElement())){
						isIn = true;
					}
				}
				if(isIn == false){
					JOptionPane.showMessageDialog(null,"L'attribut firstRoom contenu dans le fichier "+nameDungeon+"/dongeon.zdu, n'est pas une salle existante.\n Veuillez contacter le crateur du niveau.","Incohrences dans le fichier de paramtrages",JOptionPane.ERROR_MESSAGE);
					ret = false;
				}
				
			}	
			
			//on vrifie la prsence de l'attribut "finalRoom"
			//puis on vrifie que la dernire salle est prsente dans le fichier
			//Si une des deux conditions n'est pas remplie, alors un message d'erreur apparait
			//et l'opration de chargement est annule
			if(ret){
				if((finalRoom == null)){
					JOptionPane.showMessageDialog(null,"Le fichier "+nameDungeon+"/dongeon.zdu ne comporte pas d'attributs finalRoom.\n Cet attribut est obligatoire.","Incohrences dans le fichier de paramtrages",JOptionPane.ERROR_MESSAGE);
					ret = false;
				}
				else{
					boolean isIn = false;
					Enumeration e = this.listRooms.keys();
					for(;e.hasMoreElements();){
						if(finalRoom.equalsIgnoreCase((String)e.nextElement())){
							isIn = true;
						}
					}
					if(isIn == false){
						JOptionPane.showMessageDialog(null,"L'attribut finalRoom contenu dans le fichier "+nameDungeon+"/dongeon.zdu, n'est pas une salle existante.\n Veuillez contacter le crateur du niveau.","Incohrences dans le fichier de paramtrages",JOptionPane.ERROR_MESSAGE);
						ret = false;
					}	
				}
			}
			
			//Sur chaque salle on vrifie si les portes mnent  des salles existantes
			//dans le cas ou elle ne mne pas  des salles existantes, alors on les supprime
			if(ret == true){
				Enumeration e = this.listRooms.elements();
				for(;e.hasMoreElements();){
					room = (Room)e.nextElement();
					if(room.getDoorEast()!=null){						
						room.setDoorEast(loadDoor(room.getDoorEast()));
					}
					if(room.getDoorWest()!=null){
						room.setDoorWest(loadDoor(room.getDoorWest()));
					}
					if(room.getDoorSouth()!=null){
						room.setDoorSouth(loadDoor(room.getDoorSouth()));
					}
					if(room.getDoorNorth()!=null){
						room.setDoorNorth(loadDoor(room.getDoorNorth()));
					}
				}
			}
		}//du try
		
		
		catch(IOException e){
			e.printStackTrace();
			JOptionPane.showMessageDialog(null,e.getMessage(),"Erreur de chargement",JOptionPane.ERROR_MESSAGE);
			//on retourne ""false"" pour signifier que la lecture est incorrecte
			ret = false;
		}
		catch(Exception e){
			e.printStackTrace();
		}
			
		finally{
			return(ret);
		}
	}
	
	
	//les mthodes prives
	/**
	 * This method permit to check if the destination of the door has exist. The method
	 * search in the listRoom, if the room(which is the destination of the door) exist. If
	 * the room exist the programm load the room in the door destination.
	 * @param This door is the door which is currently analyse.
	 */
	private Door loadDoor(Door door){
		String nameDest,tmp;
		Room room;
		boolean roomExist = false;
		nameDest = door.getDestinationName();
		Enumeration e = this.listRooms.keys();
		while((e.hasMoreElements())&&(!roomExist)){
			tmp = (String)e.nextElement();
			if(nameDest.equalsIgnoreCase(tmp)){
				roomExist = true;
				room = (Room)this.listRooms.get(tmp);
				door.setDestination(room);
			}
		}
		if(!roomExist){
			door.setDestinationName(null);
		}
		return(door);
	}
	
	
	/**
	 * This method is used to analyse a line which is contains between the tag <DOOR> and
	 * the finish tag </DOOR>. It permit to define the different parameters of the  
	 * south, the east, the west or the north door.
	 * @param This door is the door which is currently loaded.
	 * @param This line is the line which is actually analyse by the programm.
	 */
	private void readDoor(Door door, String line){
		
		//variables locales
		StringTokenizer st,sl;
		String s = line;
		
		//on rcupre le type de l'attribut
		st = new StringTokenizer(s,"=");
		if(st.hasMoreTokens()){
			s = st.nextToken().trim();
		}
		
		//suivant son type on modify la porte pour qu'elle corresponde au fichier
		if(s.equalsIgnoreCase("destination")){
			sl = new StringTokenizer(st.nextToken().trim(),"\"");
			if (sl.hasMoreTokens()){
				s = sl.nextToken();
				door.setDestinationName(s);
			}
		}
		else{
			if(s.equalsIgnoreCase("isOpen")){
				sl = new StringTokenizer(st.nextToken().trim(),"\"");
				if (sl.hasMoreTokens()){
					s = sl.nextToken();
					if(s.equalsIgnoreCase("false")){
						door.setIsOpen(false);
					}
				}
			}
			else{
				if(s.equalsIgnoreCase("key")){
					sl = new StringTokenizer(st.nextToken().trim(),"\"");
					if (sl.hasMoreTokens()){
						door.setKey(sl.nextToken());
					}
				}
				else{
					if(s.equalsIgnoreCase("img")){
						sl = new StringTokenizer(st.nextToken().trim(),"\"");
						if (sl.hasMoreTokens()){
							s = sl.nextToken();
							if(!s.equalsIgnoreCase("default")){
								door.setImgDoor(s);
							}
						}
					}
				}
			}
		}
	}//end of readDoor
	
	/**
	 * This private class permit to load the list of ordeal an the list of item which 
	 * are used in the dungeon. The directory which contain the file dongeon.zdu must contain
	 * a file items.zit and a file ordeal.zor.
	 */
	private void loadDungeonParts(){
		
		ItemFileReader itemRead;//permet la lecture du fichier item.zit
		OrdealFileReader ordRead;//permet la lecture du fichier ordeal.zor
		
		//on lit le fichier item associ
		itemRead = new ItemFileReader(this.nameDungeon);
		
		//si le fichier est correctement charg on charge les items dans 
		//la hastable d'items et on charge la liste des preuves
		if(itemRead.readItemFile()){
			
			this.tableItems = itemRead.getLesItems();
			
			//chargement des preuves
			ordRead = new OrdealFileReader(this.nameDungeon, this.tableItems);
			if(ordRead.readOrdealFile()){
				this.tableOrdeals = ordRead.getLesOrdeals();
			}
		}
		
	}
	
	
	//les accesseurs
	/**
	 * Returns the finalRoom name.
	 * @return String the final room name
	 */
	public String getFinalRoomName() {
		return finalRoom;
	}
	
	/**
	 * Returns the finalRoom.
	 * @return Room the final room
	 */
	public Room getFinalRoom() {
		Room ret;
		if(this.listRooms.containsKey(this.finalRoom)){
			ret = (Room)this.listRooms.get(this.finalRoom);
		}
		else{
			ret = null;
		}
		return ret;
	}

	/**
	 * Returns the firstRoom name.
	 * @return String the first room name
	 */
	public String getFirstRoomName() {
		return firstRoom;
	}
	
	/**
	 * Returns the firstRoom.
	 * @return Room the first room
	 */
	public Room getFirstRoom() {
		Room ret;
		if(this.listRooms.containsKey(this.firstRoom)){
			ret = (Room)this.listRooms.get(this.firstRoom);
		}
		else{
			ret = null;
		}
		return ret;
	}

	/**
	 * Returns the listRooms. The listRoom is the hashtable which contain all the rooms.
	 * @return Hashtable containing dungeon's rooms
	 */
	public Hashtable getListRooms() {
		return listRooms;
	}

	/**
	 * Returns the tableItems.
	 * @return Hashtable containing dungeon's items
	 */
	public Hashtable getTableItems() {
		return tableItems;
	}
	
	/**
	 * Returns the nameDungeon.
	 * @return String dungeon's name
	 */
	public String getNameDungeon() {
		return nameDungeon;
	}

	/**
	 * Returns the tableOrdeals.
	 * @return Hashtable containing dungeon's ordeal
	 */
	public Hashtable getTableOrdeals() {
		return tableOrdeals;
	}


}//fin de classe