package zork2Class;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

 /**
  * This class permit the player to save his game, and load it an other day. The class build a
  * file like <i>{namedungeon}</i>_<i>{namePlayer}</i>.sz2. This file contains all the parameter
  * of the game which could change : example (The state of the door, the state of an ordeal...etc..).
  * The programm save only the room which are visited because the other room, can't be modified because the player 
  * could not go there.<br>
  * <b>This is an example of a file which are Generate by this programm : essai.sz2</B><br>
  * &lt;!-- Backup Zork 2<br>
  * Build by Zork2, used only on the game : Zork 2<br>
  * Authors : BOYERE Fabien, DE VERDELHAN Michel<br>
  * --&gt;<br>
  * &lt;Z2SAVING&gt;<i> //the begin of the saving</i><br>
  * 	Dungeon = "hantedDungeon"<i> //this is the name of the original dungeon</i><br>
  *     &lt;PLAYER&gt;<i> //this tag contain all the information about the player</i><br>
  *         Name = "Joueur1"<br>
  *         Strength = "68"<br>
  *         Dexterity = "100"<br>
  *         Intelligence = "89"<br>
  *         StartEnergy = "52"<i> //His energy level when he start the game</i><br>
  *         LifeNumber = "3"<br>
  *         EnergyAt = "24"<i> //His Energy Level when the game was saving</i><br>
  *         posY = "3"<br>
  *         posX = "3"<br>
  *         Score = "22090"<br>
  *         LastRoom = "north"<br>
  *         CurrentRoom = "center"<br>
  *         CurrentWeapon = "pe d'or"<br>
  *         Item = "trou"<i> //an item in his inventory</i><br>
  *         Item = "feu"<br>
  *         Item = "pe d'or"<br>
  *     &lt;/PLAYER&gt;<br>
  *     &lt;ROOM&gt; <i>//a room which are visited</i><br>
  *         Name = "center"<br>
  *         DoorSouthOpen = "true"<i>the state of the south door (Open or close)</i><br>
  *         DoorNorthOpen = "true"<br>
  *         DoorWestOpen = "true"<br>
  *         DoorEastOpen = "true"<br>
  *         item = "mur,2,1"<i>//all the item and their position</i><br>
  *         item = "soupe,6,1"<br>
  *         item = "mur,2,2"<br>
  *         item = "pilier,6,3"<br>
  *         item = "puit,2,4"<br>
  *         item = "table1,3,4"<br>
  *         item = "table2,4,4"<br>
  *         item = "table,6,5"<br>
  *         OrdealActivate = "false"<i>The state of the ordeal</i><br>
  *    &lt;/ROOM&gt;<br>
  * &lt;/Z2SAVING&gt;<br>
  *  <br>
  * This file could be read by a class which name is DungeonFileLoading.
  * @version 1.0, 28/03/03
  * @author IUT de Vannes, Fabien BOYERE
  */
public class DungeonFileSaving {

	//les attributs
	private Game game;//la partie qui est sauvegarde
	private String name;//nom du fichier de sauvegarde
	private PrintWriter out;//le fichier de sortie
	
	//le constructeur
	/**
	 * This is the constructor of DungeonFile Saving. It permit to construct a new saving 
	 * of a Zork2 play. 
	 * @param game - The game which is saving.
	 * @param nameSaving - The name of the saving. It better if the name like <i>{namedungeon}</i>_<i>{namePlayer}</i>.sz2.
	 */
	public DungeonFileSaving(Game game, String nameSaving){
		this.name = nameSaving;
		this.game = game;
	}
	
		
///////////////////      ////////////////////////////////////////////////////////////////	
	/**
	 * This method is used to write the saving.
	 * @return this method return true if the operation is complete. If the programm meet error
	 * the method return false.
	 */
	public boolean writeDungeonFile(){
		
		//attributs
		boolean ret = false;
		String ligne;// une ligne temporaire
		Room laRoom; //une salle temporaire
		try{
			//Ouvrir le fichier en criture

			out = new PrintWriter(new BufferedWriter(new FileWriter("sauvegardes/"+name+".sz2")));
			
			//Ecriture des commentaires	

			out.println("<!-- Backup Zork 2");
			out.println("Build by Zork2, used only on the game : Zork 2");
			out.println("Authors : BOYERE Fabien, DE VERDELHAN Michel");
			out.println("-->");
			out.println("<Z2SAVING>");
			out.println("\t\t"+"Dungeon"+" = \""+this.game.getDungeonName()+"\"");
			
			//Sauvegarde des caractristiques du player
  			out.println("\t<PLAYER>");
  			out.println("\t\t"+"Name"+" = \""+this.game.getPlayer().getName()+"\"");
			out.println("\t\t"+"Strength"+" = \""+this.game.getPlayer().getStrengthLevel()+"\"");
			out.println("\t\t"+"Dexterity"+" = \""+this.game.getPlayer().getDexterityLevel()+"\"");
			out.println("\t\t"+"Intelligence"+" = \""+this.game.getPlayer().getIntelligenceLevel()+"\"");
			out.println("\t\t"+"StartEnergy"+" = \""+this.game.getPlayer().getEnergyLevel()+"\"");
			out.println("\t\t"+"LifeNumber"+" = \""+this.game.getPlayer().getLifeNumber()+"\"");
			out.println("\t\t"+"EnergyAt"+" = \""+this.game.getPlayer().getCurrentEnergy()+"\"");
			out.println("\t\t"+"posY"+" = \""+this.game.getPlayer().getPosY()+"\"");
			out.println("\t\t"+"posX"+" = \""+this.game.getPlayer().getPosX()+"\"");
			out.println("\t\t"+"Score"+" = \""+this.game.getPlayer().getScore().getValue()+"\"");
			//la dernire salle traverse
			if(this.game.getPlayer().getLastRoom()!=null){
				out.println("\t\t"+"LastRoom"+" = \""+this.game.getPlayer().getLastRoom().getName()+"\"");
			}

			//la salle courrante
			if(this.game.getPlayer().getCurrentRoom()!=null){
				out.println("\t\t"+"CurrentRoom"+" = \""+this.game.getPlayer().getCurrentRoom().getName()+"\"");
			}
			//l'arme courrante
			if(this.game.getPlayer().getCurrentWeapon()!=null){
				out.println("\t\t"+"CurrentWeapon"+" = \""+this.game.getPlayer().getCurrentWeapon().getName()+"\"");
			}
			//Les items contenus dans l'inventaire du joueur
			Enumeration e = this.game.getPlayer().getInventory().elements();
			for(;e.hasMoreElements();){
				Item item = (Item)e.nextElement();
				out.println("\t\t"+"Item"+" = \""+item.getName()+"\"");
			}
			out.println("\t</PLAYER>");
			
			//critures dans le fichier des diffrents lments des salles qui ont t visites
			//on crit seulement les parties de la room qui ont pu tre modifi
			
			//ecriture des rooms
			Enumeration i;

			for(i = this.game.getListRoom().elements(); i.hasMoreElements();){
				laRoom = (Room) i.nextElement();
				if(laRoom.isVisited()){
					
					out.println("\t<ROOM>");
					out.println("\t\t"+"Name = \""+laRoom.getName()+"\"");
					
					//ecriture des attributs de chaque portes de la pice courante
					if((laRoom.getDoorSouth()!=null)){
						out.println("\t\t"+"DoorSouthOpen"+" = \""+laRoom.getDoorSouth().doorIsOpen()+"\"");
					}
					if((laRoom.getDoorNorth()!=null)){
						out.println("\t\t"+"DoorNorthOpen"+" = \""+laRoom.getDoorNorth().doorIsOpen()+"\"");
					}					
					if((laRoom.getDoorWest()!=null)){
						out.println("\t\t"+"DoorWestOpen"+" = \""+laRoom.getDoorWest().doorIsOpen()+"\"");
					}
					if((laRoom.getDoorEast()!=null )){
						out.println("\t\t"+"DoorEastOpen"+" = \""+laRoom.getDoorEast().doorIsOpen()+"\"");
					}
					
					//criture des attributs  du coffre
					if((laRoom.getChest()!=null)){
						
						//criture de la prsence d'item dans le coffre
						if(laRoom.getChest().getItem()!=null){ 
							out.println("\t\t"+"itemInChest"+" = \""+laRoom.getChest().getItem().getName()+"\"");
						}
						//criture de l'tat du coffre : ouvert ou ferm
						if(!(laRoom.getChest().isOpen())){ 
							out.println("\t\t"+"chestIsOpen"+" = \""+"false"+"\"");
						}
						else{
							out.println("\t\t"+"chestIsOpen"+" = \""+"true"+"\"");	
						}
					}
							
					//criture de la position des items
					for(int k=0; k<8; k++){
						for(int j=0; j<8; j++){
						if (laRoom.getItemPosition(j,k)!=null){
								if(!(laRoom.getItemPosition(j,k).equals(""))){
									out.println("\t\t"+"item = \""+laRoom.getItemPosition(j,k).getName()+","+k+","+j+"\"");
								}							
							}
						}
					}
												
					//criture du nom de l'preuve dans la salle
					if((laRoom.getOrdeal()!=null)){
						out.println("\t\t"+"OrdealActivate = \""+laRoom.isOrdealActivate()+"\"");
					}
					
					out.println("\t</ROOM>");
				}
			}
			out.println("</Z2SAVING>");
			//fermeture du fichier
			out.close();
			ret = true;
		}
		
		catch(IOException e){
			System.out.println("Le fichier ne peut tre crer");
			ret = false;
		}
		
		return(ret);
	}
	
}//fin de classe