package zork2Class;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * 	the class FightOrdeal used for fight ordeal
 *	<BR>creation :5 mai 03 at 17:52:40
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class FightOrdeal extends Ordeal{
	
	// attributs 
	private OrdealFrame fenetre;
	private String monsterName;// le nom du monstre
	private int monsterEnergy;// le niveau de vie du monstre
	private int currentMonsterEnergy;
	private int monsterFightsCapacity;// la capacite de combat du monstre
	private JButton bouton;
	private JButton abandonner;
	private int numberOfTurn;

	/**
	 *  the constructor for FightOrdeal
	 * @param name the ordeal name
	 * @param desctiption the ordeal description
	 */
	public FightOrdeal (String name,String description){
		this.setName(name);
		this.setDescription(description);
		invariant();
	}
	
	/**
	 *  the default constructor for FightOrdeal
	 *
	 */
	public FightOrdeal (){
		this.setName(name);
		this.setDescription(this.description);
		invariant();
	}

	/**
	 * Returns the monster Energy.
	 * @return int the monster energy
	 */
	public int getMonsterEnergy() {
		invariant();
		return monsterEnergy;
	}

	/**
	 * Returns the monsterFightCapacity.
	 * @return int the monster fight capacity
	 */
	public int getMonsterFightCapacity() {
		invariant();
		return monsterFightsCapacity;
	}

	/**
	 * Returns the monsterName.
	 * @return String the monster name
	 */
	public String getMonsterName() {
		invariant();
		return monsterName;
	}

	/**
	 * Sets the monsterEnergy.
	 * @param monsterEnergy The monster Energy to set
	 */
	public void setMonsterEnergy(int monsterEnergy) {
		this.monsterEnergy = monsterEnergy;
		invariant();
	}

	/**
	 * Sets the monsterFightCapacity.
	 * @param monsterFightCapacity The monster Fight Capacity to set
	 */
	public void setMonsterFightsCapacity(int monsterFightsCapacity) {
		this.monsterFightsCapacity = monsterFightsCapacity;
		invariant();
	}

	/**
	 * Sets the monsterName.
	 * @param monsterName The monster Name to set
	 */
	public void setMonsterName(String monsterName) {
		this.monsterName = monsterName;
		invariant();
	}
	
	/** method :int get Current Monster Energy
	 * @return the current monster energy
	 */
	public int getCurrentMonsterEnergy() {
		invariant();
		return currentMonsterEnergy;
	}

	/** method :void set Current Monster Energy
	 * @param i the current monster energy to set
	 */
	public void setCurrentMonsterEnergy(int i) {
		currentMonsterEnergy = i;
		invariant();
	}

	/**
	 *  method :FightOrdeal ordealSuccess
	 * <BR>method called when the ordeal finish
	 * @param b the success to set : true if player win, false if he lose
	 * @see zork2Class.Ordeal#ordealSuccess(boolean)
	 * @since 14 mai 03 at 22:47:37
	 */
	public void ordealSuccess(boolean b){
		Game partie=fenetre.getPartie();
		if (b){
			partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
			this.appReward();
			this.bouton.setEnabled(false);
			this.abandonner.setEnabled(false);
			CloseTimer closer=new CloseTimer(fenetre);
		}
		else{
			partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
			partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
			partie.executeCommand("#Vous avez perdu une vie car vous vous etes fait battre par le monstre\n");
			//partie.getFenetre().zonePersonnage.repaint();
			this.bouton.setEnabled(false);
			this.abandonner.setEnabled(false);
			CloseTimer closer=new CloseTimer(fenetre);
			//partie.getFenetre().setEnabled(true);
			//fenetre.dispose();
			
			// on ne re-enleve pas une vie au joueur car il l'a deja perdu pendant le combat
			if (partie.getPlayer().getLifeNumber()<=0){
				closer.stop();
				this.fenetre.dispose();
				partie.PlayerIsDead();
			}
		}
		invariant();
	}
	/**
	 *  method :FightOrdeal appReward
	 * <BR>apply a reward to the player
	 * @see zork2Class.Ordeal#appReward()
	 * @since 14 mai 03 at 22:47:41
	 */
	public void appReward(){
		Game partie=fenetre.getPartie();
		Player joueur=partie.getPlayer();
		Reward recompense=this.getRecompense();
		if (recompense!=null){
			joueur.setStrengthLevel(joueur.getBaseStrengthLevel()+recompense.getStrengthBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getStrengthBonus()+" en force.\n");
			joueur.setDexterityLevel(joueur.getBaseDexterityLevel()+recompense.getDexterityBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getDexterityBonus()+" en dexterite.\n");
			joueur.setIntelligenceLevel(joueur.getBaseIntelligenceLevel()+recompense.getIntelligenceBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getIntelligenceBonus()+" en intelligence.\n");
			joueur.setCurrentEnergy(joueur.getCurrentEnergy()+recompense.getEnergyBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getEnergyBonus()+" en energie.\n");
			joueur.getScore().addPoint(this.getRecompense().getScore()/this.numberOfTurn);
			partie.executeCommand("#Vous avez gagn "+(this.getRecompense().getScore()/this.numberOfTurn)+" points.\n");
			partie.executeCommand("#Vous avez gagn "+this.getRecompense().getLifeBonus()+" vie(s).\n");
			for (Enumeration e=recompense.getItem().elements();e.hasMoreElements();){
				Item objet=(Item)e.nextElement();
				joueur.getInventory().add(objet);
				if (!joueur.canWearItem(objet)){
					joueur.dropItem(objet);
				}
			}
			partie.getFenetre().updateInventaire(partie.getPlayer());
			partie.getFenetre().miniMap.repaint();
			partie.getFenetre().zonePersonnage.repaint();
		}
		invariant();
	}

	/** method :FightOrdeal doOrdeal
	 * <BR>Built the ihm and launch the ordeal
	 * @param partie the game in which this ordeal is launch
	 * @see zork2Class.Ordeal#doOrdeal(zork2Class.Game)
	 * @since 14 mai 03 at 22:47:05 
	 */
	public void doOrdeal(Game partie) {
		bouton=new JButton("Lancer l'preuve");
		abandonner=new JButton("Abandonner");
		this.fenetre = new OrdealFrame(partie,partie.getFenetre(),"fight");
		JPanel panel =fenetre.getPanelCote();
		panel.add(new JLabel());
		panel.add(new JLabel("cliquez pour",JLabel.CENTER));
		panel.add(new JLabel("commencer l'preuve",JLabel.CENTER));
		panel.add(bouton);
		panel.add(new JLabel());
		panel.add(new JLabel());
		panel.add(abandonner);
		fenetre.setPanelCote(panel);
		bouton.addActionListener(new FightOrdealListener(fenetre,1));
		abandonner.addActionListener(new FightOrdealListener(fenetre,2));
		this.fenetre.getViewArea().setText("EPREUVE DE COMBAT :\n");
		this.fenetre.getViewArea().append("_____________________________________________\n");
		partie.executeCommand("#_____________________________________________\n");
		this.fenetre.getViewArea().append("Vous devez affronter "+this.getMonsterName()+"\n");
		partie.executeCommand("#Vous devez affronter "+this.getMonsterName()+"\n");
		this.fenetre.getViewArea().append("qui a "+this.getMonsterEnergy()+" points de vie\n");
		partie.executeCommand("#qui a "+this.getMonsterEnergy()+" points de vie\n");
		this.fenetre.getViewArea().append("et une capacite de combat de "+this.getMonsterFightCapacity()+" points\n");
		partie.executeCommand("#et une capacite de combat de "+this.getMonsterFightCapacity()+" points\n");
		this.fenetre.getViewArea().append("_____________________________________________\n");
		partie.executeCommand("#_____________________________________________\n");
		this.fenetre.getViewArea().append(this.getDescription()+"\n");
		partie.executeCommand("#"+this.getDescription()+"\n");
		this.currentMonsterEnergy=this.getMonsterEnergy();
		this.numberOfTurn=0;
		fenetre.setSize(338,582);
		fenetre.setVisible(true);
		
		invariant();
		
	}
	
////////////////////////////////////////////////////////////////////////////////////
	/**
	 * 	the class FightOrdealListener
	 *	creation :2 juin 2003 at 22:38:13
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class FightOrdealListener implements ActionListener{

		// attributs
		private OrdealFrame fenetre;
		private int index;
		
		public FightOrdealListener(OrdealFrame fenetre,int index){
			this.fenetre=fenetre;
			this.index=index;
		}
		
		/** method :FightOrdealListener actionPerformed
		 * @param the action event
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 15 mai 03 at 09:39:51 
		 */
		public void actionPerformed(ActionEvent e) {
			Game partie=this.fenetre.getPartie();
			switch (this.index){
				case 1:
					JButton bouton=(JButton)e.getSource();
					if (bouton.getText().equalsIgnoreCase("Lancer l'preuve")){
						bouton.setText("Etape suivante");
					}
					numberOfTurn++;
					Player joueur=partie.getPlayer();
					Item arme=joueur.getCurrentWeapon();
					boolean critique=false;
					int attaque=joueur.getStrengthLevel()/10;
					Random rand=new Random(); 
					attaque=rand.nextInt(attaque+1);
					if (arme!=null){
						attaque=attaque+arme.getPowerWeapon();
					}
					if ((rand.nextInt(101)<joueur.getStrengthLevel())&&(rand.nextInt(101)<joueur.getIntelligenceLevel())&&(rand.nextInt(101)<joueur.getDexterityLevel())){
						critique=true;
						attaque=attaque*3;
					}
					int attaqueMonstre=rand.nextInt(getMonsterFightCapacity()+1);
					this.fenetre.getViewArea().append("_____________________________________________\n");
					partie.executeCommand("#_____________________________________________\n");
					this.fenetre.getViewArea().append("Le monstre vous frappe de "+attaqueMonstre+"\n");
					partie.executeCommand("#Le monstre vous frappe de "+attaqueMonstre+"\n");
					if (critique){
						this.fenetre.getViewArea().append("COUP CRITIQUE\n");
						partie.executeCommand("#COUP CRITIQUE\n");
					}
					this.fenetre.getViewArea().append("Vous frappez le monstre de "+attaque+"\n");
					partie.executeCommand("#Vous frappez le monstre de "+attaque+"\n");
					int tmp=getCurrentMonsterEnergy()-attaque;
					if (tmp<0){
						tmp=0;
					}
					this.fenetre.getViewArea().append("Le monstre n'a plus que "+tmp+" points de vie\n");
					partie.executeCommand("#Le monstre n'a plus que "+tmp+" points de vie\n");
					this.fenetre.getViewArea().append("_____________________________________________\n");
					partie.executeCommand("#_____________________________________________\n");
					boolean test=true;
					if (joueur.getCurrentEnergy()-attaqueMonstre<=0){
						joueur.setCurrentEnergy(joueur.getCurrentEnergy()-attaqueMonstre);
						setCurrentMonsterEnergy(getCurrentMonsterEnergy()-attaque);
						this.fenetre.getZone().repaint();
						ordealSuccess(false);
						test=false;
					}
					if (getCurrentMonsterEnergy()-attaque<=0){
						joueur.setCurrentEnergy(joueur.getCurrentEnergy()-attaqueMonstre);
						setCurrentMonsterEnergy(getCurrentMonsterEnergy()-attaque);
						this.fenetre.getZone().repaint();
						ordealSuccess(true);
						test=false;
					}
					if (test){
						joueur.setCurrentEnergy(joueur.getCurrentEnergy()-attaqueMonstre);
						setCurrentMonsterEnergy(getCurrentMonsterEnergy()-attaque);
						this.fenetre.getZone().repaint();
					}
					
				break;
				case 2:
					partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
					partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
					partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'preuve\n");
					partie.setLockCommand(false);
					partie.getFenetre().setEnabled(true);
					fenetre.dispose();
					partie.getFenetre().zonePersonnage.repaint();
					partie.getFenetre().zoneJeu.repaint();
					try {
						partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber()-1);
					} catch (PlayerIsDeadException e1) {
						partie.PlayerIsDead();
					}
				break;
			}
		}
		
	}
	
	private void invariant(){
		// nothing in invariant
	}
}
