package zork2Class;

import gameIHM.BestScoreFrame;
import gameIHM.CreatPersoFrame;
import gameIHM.GameFrame;
import gameIHM.HelpFrame;
import gameIHM.ItemViewFrame;
import gameIHM.LoadGameFrame;
import gameIHM.MainMenuFrame;
import gameIHM.SaveGameFrame;
import gameIHM.WinnerFrame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/**
 * 	the class Game
 *	creation :5 mai 03 at 17:53:31
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */

public class Game {
	
	//attributs
	private Room firstRoom;//premire salle du jeu
	private Room finalRoom;//dernire salle du jeu
	private Player player;//le joueur en lui mme
	private Hashtable listRoom;//liste des items disponibles
	// ajouter par michel
	private GameFrame fenetre;// fenetre de jeu
	private boolean isLocked;// determine si une fenetre est deja lance ou pas
	private boolean isDeveloppeur;// autorise les commandes de developpement
	private boolean lockCommand;
	private boolean cheat;
	private HelpFrame helpFrame;
	private MainMenuFrame mainMenuFrame;
	private JDialog fenetreLoading;
	private ItemViewFrame itemViewFrame;
	private CreatPersoFrame creatPersoFrame;
	private LoadGameFrame loadGameFrameGame;// la fenetre de loading de la partie
	private LoadGameFrame loadGameFrameMenu;// la fenetre de loading du menu
	private String dungeonName;
	private BestScoreFrame bestScore;
	private SaveGameFrame saveFrame;
	

	
	//constructor
	/**
	 * the constructor for game
	 */
	public Game(){
		
		this.player=new Player();
		this.isLocked=false;
		this.setIsDeveloppeur(false);
		this.lockCommand=false;
		this.helpFrame=new HelpFrame(this);
		this.helpFrame.hide();
		this.fenetreLoading=new JDialog(fenetre,"Chargement du projet Zork 2");
		JLabel image=new JLabel(new ImageIcon("images/imgDefault/zork2.gif"));
		JLabel text=new JLabel("Chargement de Zork 2",JLabel.CENTER);
		text.setForeground(Color.red);
		JPanel panelSouth=new JPanel(new BorderLayout());
		panelSouth.add(text,BorderLayout.NORTH);
		JLabel progbar=new JLabel(new ImageIcon("images/imgDefault/progbar.gif"));
		panelSouth.add(progbar,BorderLayout.SOUTH);
		Image icone=Toolkit.getDefaultToolkit().getImage("images/imgDefault/iconeZ2.gif");
		this.fenetreLoading.getContentPane().setLayout(new BorderLayout());
		this.fenetreLoading.getContentPane().add(image,BorderLayout.CENTER);
		this.fenetreLoading.getContentPane().add(panelSouth,BorderLayout.SOUTH);
		this.fenetreLoading.setSize(image.getIcon().getIconWidth()+4,image.getIcon().getIconHeight()+55);
		this.fenetreLoading.setEnabled(false);
		this.fenetreLoading.setLocation((1024/2)-(fenetreLoading.getWidth()/2),(768/2)-(fenetreLoading.getHeight()/2));
		this.fenetreLoading.setVisible(true);
		this.fenetreLoading.hide();
		this.mainMenuFrame=new MainMenuFrame(this);
	}
	
	
///////////////////      LES METHODES      \\\\\\\\\\\\\\\\\\\\\\


	/**
	 *  method :void executeCommand
	 * <BR>this method permit to manage the commandWord executeur
	 * <BR> this method ignore the word case
	 * <BR> the known commands are :<BR>
	 * <OL>
	 * <LI>best score : launch the best score frame<BR>
	 * <LI>help : launch the help frame<BR>
	 * <LI>hide all : hide all the dialog frame<BR>
	 * <LI>exit : ask if player realy want to quit and exit if true<BR>
	 * <LI>exit -f : ewit program without asking<BR>
	 * <LI>cheat : enable cheat mode : player name is changed to "tricheur"<BR>
	 * <LI>life : player life number = 6<BR>
	 * <LI>god : player capacity are all at 100 and player have the ultimate weapon<BR>
	 * <LI>go north : player move to the north, if there is an open door he change room<BR>
	 * <LI>go south : like go north but for south<BR>
	 * <LI>go East : like go north but for east<BR>
	 * <LI>go west : like go north but for west<BR>
	 * <LI>take : if there is an item in the accessible comboBox the player take it<BR>
	 * <LI>drop : drop the inventory selected item an floor<BR>
	 * <LI>open chest : if the player have the chest key, this command open the chest<BR>
	 * <LI>open door : if the player have the door key, this command open the door<BR>
	 * <LI>weapon : the inventory selected is set as current weapon. if the selected item is already the weapon, the player's current weapon is set as null <BR>
	 * <LI>noweapon : player's current weapon is set as null<BR>
	 * <LI>description : launch the item description frame<BR>
	 * <LI>clear : clear the consol<BR>
	 * <LI>kill : remove 10 player's energy points<BR>
	 * <LI>high score : launch the high score frame<BR>
	 * <LI>save : save the current game. if there is no name given, the save name is
	 * the default name. Elsewhere the save name is the given name<BR>
	 * <LI>load : load a game. if the load name is not given, this try to load the 
	 * default name. Elsewhere the load name is the given name (warrning : name must
	 * be given without the .sz2 extention)<BR>
	 * <LI># : only write the text write after the # without trying to execute it<BR>
	 * </OL>
	 * @param com the command to execute
	 */
	public void executeCommand(String com){
			
			// on verifie le premier caractere de le commande
			switch (com.charAt(0)){
				default:
				// par default :
				// on verifie si l'execution des commande est autorise
				if (!this.lockCommand){
					
					// si oui on cre une string qui sera affiche dans la console
					String textAdd=new String("");
					boolean framcom=false;// dit si la commande passer est une commande de l'interface graphique
			
					// si la fenetre de jeu a bien ete cre
					if (fenetre!=null){
						
						// si le joueur est un developpeur
						if (this.isDeveloppeur){
							
							// on enleve les espaces au debut et a la fin de la commande
							com=com.trim();
							// et on ajoute un retour a la ligne
							fenetre.viewArea.append(com+"\n");
							
							// si le premier caractere est un @
							if (com.charAt(0)=='@'){
								// on l'enleve de la commande
								char[] text=com.toCharArray();
								text[0]=' ';
								com=new String(text);
							}
						}
						else{
							// si le joueur n'est pas developpeur
							// on test si le 1er caractere est un @
							if (com.charAt(0)!='@'){
								// si non on ajoute un retour a la ligne a la commande
								fenetre.viewArea.append(com+"\n");// by moi
							}
							else{
								// si le 1er caractere est un @
								// on enleve le @
								char[] text=com.toCharArray();
								text[0]=' ';
								com=new String(text);
							}
						}
					}
					// on enleve les espaces avant et apres la commande
					com=com.trim();
					
					// et on passe la commande en minuscule pour etre sur des egalites par la suite
					com=com.toLowerCase();
			
					///////////////////////////////////////
					// si la commande est best score
					if (com.equalsIgnoreCase("best score")){
						if (this.bestScore==null){
							this.bestScore=new BestScoreFrame();
							this.bestScore.hide();
						}
						this.bestScore.show();
					}
					///////////////////////////////////////
					// si la commande est help
					if (com.equalsIgnoreCase("help")){
						// on montre l'aide
						this.helpFrame.show();
					}
					
					
					///////////////////////////////////////
					// si la commande est hide all
					if (com.equalsIgnoreCase("hide all")){
						// on montre l'aide
						if (this.helpFrame!=null){
							this.helpFrame.hide();
						}
						if (this.mainMenuFrame!=null){
							this.mainMenuFrame.hide();
						}
						if (this.fenetreLoading!=null){
							this.fenetreLoading.hide();
						}
						if (this.itemViewFrame!=null){
							this.itemViewFrame.hide();
						}
						if (this.creatPersoFrame!=null){
							this.creatPersoFrame.hide();
						}
						if (this.bestScore!=null){
							this.bestScore.hide();
						}
						if (this.loadGameFrameGame!=null){
							this.loadGameFrameGame.hide();
						}
						if (this.loadGameFrameMenu!=null){
							this.loadGameFrameMenu.hide();
						}
					}
					
					
					///////////////////////////////////////
					// si la commande est exit
					if (com.equalsIgnoreCase("exit")){
						// on lui demande de verifier si il veut rellement quitter
						int tmp=JOptionPane.showConfirmDialog(null,"Voulez vous rellement quitter ?", "Quitter ?", JOptionPane.YES_NO_OPTION);
						if (tmp==0){
							// il veut quitter donc on quite
							System.exit(0);
						}
					}
					///////////////////////////////////////
					// la on quit sans lui demander son avis
					if (com.equalsIgnoreCase("exit -f")){
							System.exit(0);
					}
				
					///////////////////////////////////////
					// la on quit sans lui demander son avis
					if (com.equalsIgnoreCase("cheat")){
							this.player.setName("Tricheur");
							this.cheat=true;
					}
					
					///////////////////////////////////////
					// la on quit sans lui demander son avis
					if (com.equalsIgnoreCase("life")&&(this.cheat)){
							try {
								this.player.setLifeNumber(6);
							} catch (PlayerIsDeadException e) {
								// le joueur ne peut pas mourrir si on lui ajout de 
								// la vie donc il n'y a rien a fair
							}
					}
				
					///////////////////////////////////////
					// la on quit sans lui demander son avis
					if (com.equalsIgnoreCase("god")&&(this.cheat)){
						this.player.setStrengthLevel(100);
						this.player.setDexterityLevel(100);
						this.player.setIntelligenceLevel(100);
						this.player.setCurrentEnergy(this.player.getEnergyLevel());
						Item ultime=new Item("Ultimate","L'arme ultime");
						ultime.setPowerWeapon(99999);
						this.player.getInventory().addElement(ultime);
						this.fenetre.updateInventaire(this.player);
					}
				
					///////////////////////////////////////
					// commande pour aller au nord
					if (com.equalsIgnoreCase("go north")){
						
						// on verifie si il ne porte pas une charge trop lourde
						if (this.getPlayer().getPoid()<=this.getPlayer().getMaxWeight()){
							
							// on verifie si il est pre de la porte nord
							if (this.player.getCardinalPosition()=='n'){// on test si il est pres de la porte north
								// si il est pres de la porte nord alors il doit sortir
								// precision : on sait desormais que la porte nord existe
								if (this.player.getCurrentRoom().getDoorNorth().doorIsOpen()){
									// la porte est ouverte
									// on dit que la salle courante est la salle precedante
									this.player.setLastRoom(this.player.getCurrentRoom());
									// et on le fait changer de salle
									this.player.setCurrentRoom(this.player.getCurrentRoom().getDoorNorth().getDestination());
									// code de changement de salle
									this.changeRoom();
								}
								else{
									// la porte n'est pas ouverte
									if (this.player.getCurrentRoom().getDoorNorth().getKey().equalsIgnoreCase("no_key")){
										//si il n'existe pas de cle pour la porte alors c'est une porte bloque
										textAdd="impossible de passer par la porte elle est bloque.\n";
									}
									else{
										// sinon c'est que le joueur n'a pas ouverte la porte avec la bonne cl
										textAdd="impossible de passer par la porte elle est ferme a cl.\nIl faut l'objet "+this.player.getCurrentRoom().getDoorNorth().getKey()+" pour l'ouvrire.\n";
									}
								}
							}// si on ne prend pas la porte on bouge au nord
							else if (this.player.getCurrentRoom().canGoToPosition(this.player.getPosX(),this.player.getPosY()-1)){
								// le joueur peut aller sur la case nord
								// donc on change sa position
								this.player.setPosY(this.player.getPosY()-1);
								// et on reaffiche
								this.fenetre.zoneJeu.repaint();
								this.fenetre.miniMap.repaint();
							}
				
							// on verifie les objet autour du joueur
							checkUsableItem();
						}
						else{
							// le joueur porte une charge trop lourde et ne peut donc pas bouger
							this.executeCommand("#Impossible de bouger vous portez une charge trop lourde\n");
						}
					}
				
					///////////////////////////////////////
					// pour les commantaires se referer a la commande "go north" c'est le meme principe de fonctionnement
					if (com.equalsIgnoreCase("go south")){
						if (this.getPlayer().getPoid()<=this.getPlayer().getMaxWeight()){
							if (this.player.getCardinalPosition()=='s'){// on test si il est pres de la porte north
								if (this.player.getCurrentRoom().getDoorSouth().doorIsOpen()){
									// la porte est ouverte
									// code de changement de salle
									this.player.setLastRoom(this.player.getCurrentRoom());
									this.player.setCurrentRoom(this.player.getCurrentRoom().getDoorSouth().getDestination());
									this.changeRoom();
						
								}
								else{
									if (this.player.getCurrentRoom().getDoorSouth().getKey().equalsIgnoreCase("no_key")){
										textAdd="impossible de passer par la porte elle est bloque.\n";
									}
									else{
										textAdd="impossible de passer par la porte elle est ferme a cl.\nIl faut l'objet "+this.player.getCurrentRoom().getDoorSouth().getKey()+" pour l'ouvrire.\n";
									}
								}
							}// si on ne prend pas la porte on bouge au sud
							else if (this.player.getCurrentRoom().canGoToPosition(this.player.getPosX(),this.player.getPosY()+1)){
								this.player.setPosY(this.player.getPosY()+1);
								this.fenetre.zoneJeu.repaint();
								this.fenetre.miniMap.repaint();
							}
				
							checkUsableItem();
						}
						else{
							this.executeCommand("#Impossible de bouger vous portez une charge trop lourde\n");
						}

					}
				
					///////////////////////////////////////
					// pour les commantaires se referer a la commande "go north" c'est le meme principe de fonctionnement
					if (com.equalsIgnoreCase("go east")){
						if (this.getPlayer().getPoid()<=this.getPlayer().getMaxWeight()){
							if (this.player.getCardinalPosition()=='e'){// on test si il est pres de la porte north
								if (this.player.getCurrentRoom().getDoorEast().doorIsOpen()){
									// la porte est ouverte
									// code de changement de salle
									this.player.setLastRoom(this.player.getCurrentRoom());
									this.player.setCurrentRoom(this.player.getCurrentRoom().getDoorEast().getDestination());
									this.changeRoom();
						
								}
								else{
									if (this.player.getCurrentRoom().getDoorEast().getKey().equalsIgnoreCase("no_key")){
										textAdd="impossible de passer par la porte elle est bloque.\n";
									}
									else{
										textAdd="impossible de passer par la porte elle est ferme a cl.\nIl faut l'objet "+this.player.getCurrentRoom().getDoorEast().getKey()+" pour l'ouvrire.\n";
									}
								}
							}// si on ne prend pas la porte on bouge a l'est
							else if (this.player.getCurrentRoom().canGoToPosition(this.player.getPosX()+1,this.player.getPosY())){
								this.player.setPosX(this.player.getPosX()+1);
								this.fenetre.zoneJeu.repaint();
								this.fenetre.miniMap.repaint();
							}
	
				
							checkUsableItem();
						}
						else{
							this.executeCommand("#Impossible de bouger vous portez une charge trop lourde\n");
						}
					}
				
					///////////////////////////////////////
					// pour les commantaires se referer a la commande "go north" c'est le meme principe de fonctionnement
					if (com.equalsIgnoreCase("go west")){
						if (this.getPlayer().getPoid()<=this.getPlayer().getMaxWeight()){
							if (this.player.getCardinalPosition()=='w'){// on test si il est pres de la porte north
									if (this.player.getCurrentRoom().getDoorWest().doorIsOpen()){
										// la porte est ouverte
										// code de changement de salle
										this.player.setLastRoom(this.player.getCurrentRoom());
										this.player.setCurrentRoom(this.player.getCurrentRoom().getDoorWest().getDestination());
										this.changeRoom();
						
									}
									else{
										if (this.player.getCurrentRoom().getDoorWest().getKey().equalsIgnoreCase("no_key")){
											textAdd="impossible de passer par la porte elle est bloque.\n";
										}
										else{
											textAdd="impossible de passer par la porte elle est ferme a cl.\nIl faut l'objet "+this.player.getCurrentRoom().getDoorWest().getKey()+" pour l'ouvrire.\n";
										}
									}
								}// si on ne prend pas la porte on bouge a l'ouest
								else if (this.player.getCurrentRoom().canGoToPosition(this.player.getPosX()-1,this.player.getPosY())){
									this.player.setPosX(this.player.getPosX()-1);
									this.fenetre.zoneJeu.repaint();
									this.fenetre.miniMap.repaint();
								}
							checkUsableItem();
						}
						else{
							this.executeCommand("#Impossible de bouger vous portez une charge trop lourde\n");
						}
	
					}
			
					///////////////////////////////////////
					// commande pour rammasser un objet
					if (com.equalsIgnoreCase("take")){
						this.take();
					}
			
					///////////////////////////////////////
					// commande pour jeter un objet au sol
					if (com.equalsIgnoreCase("drop")){
						this.drop();
					}
	
					///////////////////////////////////////
					// commande pour ouvrir un coffre
					if (com.equalsIgnoreCase("open chest")){
						this.openChest();
					}
				
					///////////////////////////////////////
					// commande pour ouvrir une porte
					if (com.equalsIgnoreCase("open door")){
						this.openDoor();
					}
	
					///////////////////////////////////////
					// commande qui permet de selectionner une arme
					// ou de la deselectionne si elle etait deja selectionne
					if (com.equalsIgnoreCase("weapon")){
						this.weapon();
					}
		
					///////////////////////////////////////
					// commande pour enlever l'arme active
					if (com.equalsIgnoreCase("noweapon")){
						this.noWeapon();
					}
		
					///////////////////////////////////////
					// commande qui lance une fenetre de description d'un item
					if (com.equalsIgnoreCase("description")){
						Item objet=(Item)this.fenetre.inventaire.getSelectedItem();
						// on test si l'objet selectionne existe
						if (objet!=null){
							// il existe donc on lance une fenetre de description
							this.itemViewFrame.affiche(objet);
						}
					}
				
					///////////////////////////////////////
					// commande qui nettoie la console
					if (com.equalsIgnoreCase("clear")){
						this.fenetre.viewArea.setText("");
					}
					
					///////////////////////////////////////
					//
					if (com.equalsIgnoreCase("kill")){
						this.player.setCurrentEnergy(this.player.getCurrentEnergy()-10);
						this.getFenetre().zonePersonnage.repaint();
					}
	
					///////////////////////////////////////
					//
					if (com.equalsIgnoreCase("high score")){
						this.bestScore.show();
					}

					// pour les commandes en 2 partie comme load et save
					StringTokenizer st=new StringTokenizer(com," ");
					String[] com2=new String[2];
					com2[0]=st.nextToken();
					if (st.hasMoreElements()){
						com2[1]=st.nextToken();
					}
					
					///////////////////////////////////////
					// pour la commande de sauvegarde
					if (com2[0].equalsIgnoreCase("save")){
						if (com2[1]==null){
							com2[1]=this.dungeonName+"_"+this.player.getName();
						}
						DungeonFileSaving saver=new DungeonFileSaving(this,com2[1]);
						saver.writeDungeonFile();
					}
					
					///////////////////////////////////////
					// pour la commande de sauvegarde
					if (com2[0].equalsIgnoreCase("load")){
						if (com2[1]==null){
							com2[1]=this.dungeonName+"_"+this.player.getName();
						}
						DungeonFileLoading saver = new DungeonFileLoading(com2[1]);
						if(saver.readDungeonFileSave()){
							this.listRoom = saver.getListRooms();
							this.player = saver.getPlayer();
							if (saver.getPlayer().getCurrentRoom()==null){
							}
							else{
							}
							this.finalRoom = saver.getFinalRoom();
							this.firstRoom = saver.getFirstRoom();
							this.getFenetre().zoneJeu.repaint();
							this.getFenetre().miniMap.repaint();
							this.getFenetre().updateInventaire(this.player);
							//this.checkUsableItem();
							this.getFenetre().zonePersonnage.repaint();
						}
						else{
							System.out.println("impossible de charger le donjon");
						}
					}
					
					if (fenetre!=null){
						fenetre.viewArea.append(textAdd);// by moi
					}
				}
				break;
				case '#':
					char[] text=com.toCharArray();
					text[0]=' ';
					com=new String(text);
					com=com.trim();
					fenetre.viewArea.append(com+"\n");// by moi
				break;
			}// fin du switch

	}
	
	
	/**
	 *  void Game::checkUsableItem
	 *	<BR>check if there is usable item near the player and refresh the combo box
	 */
	private void checkUsableItem(){
			
		// test si pres du coffre
		// puis test si sur un objet
		// puis cree la liste des item accessibles
			
		// cree le vecteur des objet accessibles
		Vector item=new Vector(0,1);
		
		// test si le joueur est pres du coffre
		if (this.player.isNearChest()){
			
			// si oui alors on recupere le coffre
			Chest coffre=this.player.getCurrentRoom().getChest();
			
			// on verifie si le coffre est ouvert
			if (coffre.isOpen()){
				
				// si oui on test si le coffre contient un item
				if (coffre.getItem()!=null){
					
					// si oui on verifie que ce soit un item portable
					if(coffre.getItem().getWeigth()>0){
						
						// si oui on ajoute l'item du coffre au vecteur
						item.addElement(coffre.getItem());
					}
				}
			}
		}
		
		// on test si le joueur est plac sur un item
		if (this.player.isNearItem()){
			
			// si oui on ajoute l'item au vecteur
			item.addElement(this.player.getCurrentRoom().getItemPosition(this.player.getPosX(),this.player.getPosY()));
		}
		
		// on enleve tout les items de la JComboBox
		this.fenetre.usableItem.removeAllItems();
		
		// et on ajoute a la JComboBox les items accessibles
		for (Enumeration e=item.elements();e.hasMoreElements();){
			Item tmp=(Item)e.nextElement();
			if (tmp!=null){
				this.fenetre.usableItem.addItem(tmp);
			}
		}
	}

	/**
	 *  method :void changeRoom
	 * <BR>	code de changement de salle commun a toute les directions
	 */
	private void changeRoom(){
		
		
		// on affiche la description de la salle
		this.executeCommand("#__________________________________________________________\n"+this.player.getCurrentRoom().getDescription()+"\n__________________________________________________________\n");
		
		// on verifie si la salle a des portes
		if (!this.player.getCurrentRoom().haveDoor()){
			
			// si non alors on est dans ne oubliette
			// on affiche le message
			this.executeCommand("#Vous etes tomb dans une oubliette.\nVous perdez une vie.");
			// on enleve une vie
			try {
				this.player.setLifeNumber(this.player.getLifeNumber()-1);
			} catch (PlayerIsDeadException e) {
				this.PlayerIsDead();
			}
			// on retourne dans la salle precedante
			this.player.setCurrentRoom(this.player.getLastRoom());
			// et on reaffiche
			this.fenetre.zonePersonnage.repaint();
		}
		// on precise que la salle courrante a ete visite
		if (!this.player.getCurrentRoom().isVisited()){
			this.player.getCurrentRoom().setIsVisited(true);
			// on ajoute des point au joueur
			this.player.getScore().addPoint(50);
		}
		else{
			// on retire des point au joueur car il a deja visite la salle
			this.player.getScore().addPoint(-10);
		}
		// on place le joueur au centre de la salle
		this.player.getCurrentRoom().centerPlayer(this.player);
		// et on reaffiche le tout
		this.fenetre.zonePersonnage.repaint();
		this.fenetre.zoneJeu.repaint();
		this.fenetre.miniMap.repaint();
		
		// on verifie si la salle courante est la derniere salle
		if (this.player.getCurrentRoom()==this.getFinalRoom()){
			this.PlayerWin();
		}
		else{
			// on regarde si la salle courante a une epreuve et si cette epreuve est active
			if ((this.player.getCurrentRoom().getOrdeal()!=null)&&(this.player.getCurrentRoom().isOrdealActivate())){
			
				// si oui on bloque l'execution des commandes (pour ne pas fair bouger le
				// joueur en fond
				this.lockCommand=true;
			
				// et on demarre l'epreuve
				this.player.getCurrentRoom().getOrdeal().doOrdeal(this);
			}
		}
						
	}
	
	/**
	 *  method :void loadDungeonFromFile
	 * <BR>load a dungeon from a file
	 * @param file the dungeon to load
	 */
	public void loadDungeonFromFile(String dungeon){
		
		// on cre un objet chargeur de donjons
		DungeonFileReader reader=new DungeonFileReader(dungeon);
		
		// et on lit le donjon
		if(reader.readDungeonFile()){
			
			this.dungeonName = dungeon;
			
			// on prend la premiere salle du donjon...
			this.setFirstRoom(reader.getFirstRoom());
		
			// et on desactive son epreuve
			//this.getFirstRoom().setIsOrdealActivate(false);
		
			// idem pour la salle finale
			this.setFinalRoom(reader.getFinalRoom());
			//this.getFinalRoom().setIsOrdealActivate(false);
		
			// on fait demarrer le joueur dans la premiere salle
			this.player.setCurrentRoom(this.getFirstRoom());
			
			// le joueur a visit la premiere salle
			this.getFirstRoom().setIsVisited(true);
			
			// on centre le player dans la salle
			this.player.getCurrentRoom().centerPlayer(this.player);
		
			// et on lui dit que la premiere salle est la salle ou il etait precedament
			this.player.setLastRoom(this.getFirstRoom());
			
			// puis on recupere la liste des salles
			this.listRoom=reader.getListRooms();
						
		}
		else{
			JOptionPane.showMessageDialog(null,"impossible de lire le donjon","erreur",JOptionPane.ERROR_MESSAGE);
		}

	}
	
	/**
	 *  method :void noWeapon
	 * <BR>set the player's weapon as null
	 *
	 */
	private void noWeapon(){
		Item weapon=this.player.getCurrentWeapon();
		// on test si l'objet selectionn existe
		if (weapon!=null){
			// il existe
			// on verifie si le fait d'enlever cette arme tue le joueur
			// ( au cas ou l'arme aurait un bonus d'energie et que le joueur aurait
			// perdu trop d'energie donc le fait de lui enlever son arme le fait passer
			// en dessous de 0 en energie donc il meurt
			if(this.player.dropWeaponKill()){
				// on signale sa mort au joueur
				this.executeCommand("#Vous avez perdu une vie car vous avez enlever un objet qui vous maintenait en vie.\n");
			}
			// on met l'arme courrante a null
			this.player.setCurrentWeapon(null);
			// et on ajoute le bonus d'energie
			this.player.setCurrentEnergy(this.player.getCurrentEnergy()-weapon.getEnergyAdd());
							
			// puis on raffraichit le tout (bon je vait pas recommencer la blague
			// pourrie du coca cola ou de l'orangina...)
			this.fenetre.zonePersonnage.repaint();
			this.fenetre.zoneJeu.repaint();
							
			// on verifie si le joueur est definitivment mort
			if (this.player.getLifeNumber()<=0){
				this.PlayerIsDead(); 
			}
		}
	}
	
	/**
	 *  method :void weapon
	 * <BR>set teh selected weapon as active weapon or set the active weapon as null
	 * if the selected weapon is already the current weapon
	 */
	private void weapon(){
		Item weapon=(Item)this.fenetre.inventaire.getSelectedItem();
		// on test si l'objet selectionne existe
		if (weapon!=null){
			// l'objet existe
			if (!weapon.equals(this.player.getCurrentWeapon())){
				// l'objet selectione est different de l'arme active
				// donc on enleve l'arme active
				// /!\attention si le joueur a une arme qui lui ajoute de l'energie
				// et qu'il a un niveau d'energie trop faible il meurt quand il enleve son
				// arme avec cette commande /!\
				this.executeCommand("@noweapon");
				// puis on change l'arme
				this.player.changeWeapon(weapon);
				// et on rafraichit avec orangina
				// (attention il faut secouer sinon la pulpe elle reste en bas )
				this.fenetre.zonePersonnage.repaint();
				this.fenetre.zoneJeu.repaint();
			}
			else{
				// si c'est l'arme qu'il a deja on l'enleve
				this.executeCommand("@noweapon");
			}
		}

	}
	
	/**
	 *  method :void openDoor
	 * <BR>open the door near the player if he have the key
	 *
	 */
	private void openDoor(){
		Door porte=new Door();
		boolean ok=false;// booleen qui sert a savoir si on a une porte a porte
						
		// on test la position du joueur
		switch (this.player.getCardinalPosition()){
			case 'n':
				// le joueur se trouve au nord
				porte=this.player.getCurrentRoom().getDoorNorth();
				// alors la porte qu'on va ouvrir est la porte nord
				ok=true;
			break;
			case 's':
				// le joueur se trouve au sud
				porte=this.player.getCurrentRoom().getDoorSouth();
				// alors la porte qu'on va ouvrir est la porte sud
				ok=true;
			break;
			case 'e':
				// le joueur se trouve a l'est
				porte=this.player.getCurrentRoom().getDoorEast();
				// alors la porte qu'on va ouvrir est la porte est
				ok=true;
			break;
			case 'w':
				// le joueur se trouve a l'ouest
				porte=this.player.getCurrentRoom().getDoorWest();
				// alors la porte qu'on va ouvrir est la porte sud...
				// mais non je rigole c'et la porte ouest
				ok=true;
			break;
		}
						
		if (ok){
			// le joueur est a porte d une porte
			// donc on dit au joueur d'ouvrir la porte
			if (this.player.openADoor(porte)){
				// et on lui signal qu'il a reussit a ouvrir la porte (il est fort quand mme notre joueur ...)
				this.executeCommand("#Vous avez reussi a ouvrir la porte");
			}
			else{
				// le joueur n'a pas reussi a ouvrir la porte (bhou le nul !!!!)
				// c'est peut etre parce que la porte est deja ouverte
				// donc on test si la porte est deja ouverte
				if (porte.doorIsOpen()){
					// c'est parce que la porte etait deja ouverte (mais quel boulet ce joueur ...)
					this.executeCommand("#Cette porte est deja ouverte");
				}
				else{
					// en fait la porte n'etait pas ouverte alors pourquoi n'a t il pas pu l'ouvrir ???? suite dans le prochain episode ....
					// on test si c'est parce que la porte n'a pas de cle et
					// donc qu'elle est bloque definitivement
					if (porte.getKey().equalsIgnoreCase("no_key")){
						// effectivement elle est bloque
						this.executeCommand("#Cette porte est bloque");
					}
					else{
						// en fait le joueur n'a pas la cle
						this.executeCommand("#Impossible d'ouvrir la porte vous n'avez pas la cl");
					}
				}
			}
			// et on raffraichit tout le monde
			// (toujours avec coca cola :) )
			this.fenetre.updateInventaire(this.player);
			this.fenetre.miniMap.repaint();
			this.fenetre.zonePersonnage.repaint();
		}

	}
	

	/**
	 *  method :void openChest
	 * <BR>open the chest near the player if he have the key
	 *
	 */
	private void openChest(){
						
		// ouvre le coffre
		try {
			this.player.openChest();
		} catch (PlayerNotHaveKeyException e) {
			if (this.player.getCurrentRoom().getChest()!=null){
				if (this.player.getCurrentRoom().getChest().getKey().equalsIgnoreCase("no_key")){
					this.executeCommand("#Ce coffre est bloqu : Vous ne pouvez pas l'ouvrir");
				}
				else{
					this.executeCommand("#vous n'avez pas la bonne cl, il vous faut l'objet "+this.player.getCurrentRoom().getChest().getKey());
				}
			}
		}
		//et on raffraichit tout le monde (toujours avec coca cola ( Always coca cola in english :) )
		this.fenetre.zoneJeu.repaint();
		this.fenetre.zonePersonnage.repaint();
		this.fenetre.updateInventaire(this.player);
		this.fenetre.miniMap.repaint();
		this.checkUsableItem();
	
	}
	
	
	/**
	 *  method :void drop
	 * <BR>drop the selected item on the floor.
	 *
	 */
	private void drop(){
		// on verifie si il existe bien un objet selectionn
		if (this.getFenetre().inventaire.getSelectedItem()!=null){
			Item selected=(Item)this.getFenetre().inventaire.getSelectedItem();
			// on verifie si l'objet selectionn est l'arme active
			if (selected==this.player.getCurrentWeapon()){
				// si c'est l'arme active on lance la commande "weapon"
				// qui aura pour effet d'enlever l'objet de l'arme active
				this.executeCommand("@weapon");
			}
			// on pose l'objet selectionn au sol
			this.player.dropItem(selected);
			// et on raffraichit tout les trucs qui on besoin d'etre
			// raffraichit (avec coca cola rafaichissement a tout moment :) )
			this.fenetre.updateInventaire(this.player);
			this.fenetre.zonePersonnage.repaint();
			this.fenetre.miniMap.repaint();
			this.checkUsableItem();
			this.fenetre.zoneJeu.repaint();
		}

	}
	
	/**
	 *  method :void take
	 * <BR> take the selected item and put it on the player's inventory
	 *
	 */
	private void take(){
		// on verifie si il existe bien un objet selectionn
		if (this.getFenetre().usableItem.getSelectedItem()!=null){
			// il existe bien un objet selectionn
			Item selected=(Item)this.getFenetre().usableItem.getSelectedItem();
			// on test si le joueur peut porter l'objet
			if (!player.canWearItem(selected)){
				// le joueur ne peut pas porter l'objet et on le signal au joueur
				this.executeCommand("#Impossible de prendre cet objet il est trop lourd");
			}
			else{
				// le joueur peut porter l'objet
				// donc on rammasse l'objet
				this.player.takeItem(selected);
				// on reaffiche la JComboBox d'inventaire du joueur
				this.fenetre.updateInventaire(this.player);
				// on rafraichit la zone de caracteristiques du personnage
				// a cause du poid de l'objet dans l'inventaire
				this.fenetre.zonePersonnage.repaint();
				// idem pour la minimap
				this.fenetre.miniMap.repaint();
				// et on raffraichit la JComboBox des objet accessibles
				this.checkUsableItem();
				// on reaffiche la zone de jeu pour bien enlever l'image de l'item
				// au sol
				this.fenetre.zoneJeu.repaint();
			}
		}

	}
	
	/**
	 *  method :void PlayerIsDead
	 * <BR>method called when the player's life number if 0 so the player have lose
	 *
	 */
	public void PlayerIsDead(){
		//JOptionPane.showMessageDialog(fenetre, "t'est mort", "caca", JOptionPane.ERROR_MESSAGE);
		this.fenetre.dispose();
		this.lockCommand=false;
		WinnerFrame winner=new WinnerFrame(this,false);

	}
	
	/**
	 *  method :void PlayerWin
	 * <BR>method called when the player is in the final room so the player have win
	 *
	 */
	public void PlayerWin(){
		//JOptionPane.showMessageDialog(fenetre, "t'a winner mec", "youpi", JOptionPane.INFORMATION_MESSAGE);
		this.fenetre.dispose();
		this.lockCommand=false;
		WinnerFrame winner=new WinnerFrame(this,true);
	}
	
	/**
	 *  void Game::launchMainMenu
	 *	<BR>create or show if already created the main Menu
	 */
	public void launchMainMenu(){
		// si on a l'autorisation de lance une commande d'interface graphique
		String textAdd="";
		if (!this.isLocked){
			// alors on interdit de lance une commande d'interface graphique par la suite
			this.isLocked=true;
			// on regarde si le joueur est un developpeur
			if (this.isDeveloppeur){
				// si oui alors on ajoute des information a la chaine qui sera afiche
				textAdd=textAdd+new String("change IHM status->ok\n");
			}
			// creation de la frame
			this.mainMenuFrame.show();
							
			// et encore un ajout d'information si le joueur est un developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("launching frame->ok\n");// by moi
			}
		}
		else{
			// si on a pas le droit de lance une commande de l'interface graphique
			// on le signale si le joueur est developpeur
			if (this.isDeveloppeur){
				fenetre.viewArea.append("impossible de lancer la frame : une frame est deja lance\n");
			}
		}
	}
	
	/**
	 *  void Game::launchCreatPerso
	 *	<BR>create or show if already created the create perso frame
	 */
	public void launchCreatPerso(){
		String textAdd="";
		if (!this.isLocked){
			// on a le droit de lancer une commande de l'interface graphique
			// on bloque ce droit pour la suite
			this.isLocked=true;
							
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("change IHM status->ok\n");// by moi
			}
			// creation de la frame
			if (this.creatPersoFrame==null){
				this.creatPersoFrame=new CreatPersoFrame(this,this.mainMenuFrame);
				this.creatPersoFrame.hide();
			}
			this.creatPersoFrame.show();
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("launching frame->ok\n");// by moi
			}
		}
		else{
			// on a pas le droit de cre la frame
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("impossible de lancer la frame : une frame est deja lance\n");
			}
		}
	}
	
	/**
	 *  void Game::launchSaveGame
	 *	<BR>create or show if already created the save ame frame
	 */
	public void launchSaveGame(){
		String textAdd="";
		// ajout d'info pour le developpeur
		if (this.isDeveloppeur){
			textAdd=textAdd+"change IHM status->ok\n";// by moi
		}
		// creation de la frame
		if (this.fenetre!=null){
			if (this.saveFrame==null){
				this.saveFrame=new SaveGameFrame(this,this.fenetre);
				this.saveFrame.hide();
			}
			this.saveFrame.show();
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("launching frame->ok\n");// by moi
			}
		}
		else{
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("launching frame->error\nGame's main frame must be loaded to run this frame");// by moi
			}
		}
	}
	
	/**
	 *  void Game::launchLoadGame
	 *	<BR>create or show if already created the load game frame for game frame
	 */
	public void launchLoadGameGame(){
		String textAdd="";
		if (!this.isLocked){
			// on a la droit de lancer une commande de l'interface graphique
			// on enlev se droit pour la suite
			this.isLocked=true;
			// ajout d'info pour le developpeur
			textAdd=textAdd+new String("change IHM status->ok\n");// by moi
			// creation de la frame
			if (this.loadGameFrameGame==null){
				this.loadGameFrameGame=new LoadGameFrame(this.getFenetre(),this);
				this.loadGameFrameGame.hide();
			}
			this.loadGameFrameGame.refresh();
			this.loadGameFrameGame.show();
			// ajout d'info pour le developpeur
			if (this.fenetre!=null){
				textAdd=textAdd+new String("launching frame->ok\n");// by moi
			}
		}
		else{
			// on a aps le droit de cree une commande de l'interface graphique
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("impossible de lancer la frame : une frame est deja lance\n");
			}
		}
	}
	
	/**
	 *  void Game::launchLoadGameGame
	 *	<BR>create or show if already created the load game frame for main menu frame
	 */
	public void launchLoadGameMenu(){
		String textAdd="";
		if (!this.isLocked){
			// on a la droit de lancer une commande de l'interface graphique
			// on enlev se droit pour la suite
			this.isLocked=true;
			// ajout d'info pour le developpeur
			textAdd=textAdd+new String("change IHM status->ok\n");// by moi
			// creation de la frame
			if (this.loadGameFrameMenu==null){
				this.loadGameFrameMenu=new LoadGameFrame(this.mainMenuFrame,this);
				this.loadGameFrameMenu.hide();
			}
			this.loadGameFrameMenu.refresh();
			this.loadGameFrameMenu.show();
			// ajout d'info pour le developpeur
			if (this.fenetre!=null){
				textAdd=textAdd+new String("launching frame->ok\n");// by moi
			}
		}
		else{
			// on a aps le droit de cree une commande de l'interface graphique
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("impossible de lancer la frame : une frame est deja lance\n");
			}
		}
	}

	/**
	 *  void Game::launchGame
	 *	<BR>create or show if already created the main game frame
	 */
	public void launchGame(){
		String textAdd="";
		if (!this.isLocked){
			// on a le droit de lancer une commnde de l'interface graphique
			// et on enleve ce droit pour la suite
			this.isLocked=true;
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("change IHM status->ok\n");// by moi
			}
			// creation de la frame
			if (this.fenetre==null){
				this.fenetre=new GameFrame(this);
			}
			// et on cree l'itemViewFrame qui a besoin de la game frame pour
			// pouvoir etre cree
			this.itemViewFrame=new ItemViewFrame(this.fenetre);
							
			// on dit au jeu de fermer toute les dialog ouverte
			this.executeCommand("@hide all");
			this.fenetre.zoneJeu.requestFocus();
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("launching frame->ok\n");// by moi
			}
		}
		else{
			// on a pas le droit de lance une commande de l'interface graphique
			// ajout d'info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("impossible de lancer la frame : une frame est deja lance\n");
			}
		}
		fenetre.viewArea.append(textAdd);// by moi
	}
	
	/**
	 *  void Game::changeIsLocked
	 *	<BR>change the ihm status : now we can run an other frame
	 */
	public void changeIsLocked(){
		String textAdd="";
		// on redonne le droit de lancer une commande de l'interface graphique
		this.isLocked=false;
		// on verifie si la fenetre de keu a ete cree
		if (this.fenetre!=null){
			// puis on ajoute des info pour le developpeur
			if (this.isDeveloppeur){
				textAdd=textAdd+new String("change IHM status->ok\n");// by moi
			}
			fenetre.viewArea.append(textAdd);// by moi
		}
	}

///////////////////     LES ACCESSEURS     \\\\\\\\\\\\\\\\\\\\\\

	/**
	 * Returns the finalRoom.
	 * @return Room
	 */
	public Room getFinalRoom() {
		return finalRoom;
	}

	/**
	 * Returns the firstRoom.
	 * @return Room
	 */
	public Room getFirstRoom() {
		return firstRoom;
	}

	/**
	 * Returns the listItem.
	 * @return Hashtable
	 */
	public Hashtable getListRoom() {
		return listRoom;
	}

	/**
	 * Returns the player.
	 * @return Player
	 */
	public Player getPlayer() {
		return player;
	}

///////////////////   LES MODIFICATEURS      \\\\\\\\\\\\\\\\\\\\

	/**
	 * Sets the finalRoom.
	 * @param finalRoom The finalRoom to set
	 */
	public void setFinalRoom(Room finalRoom) {
		this.finalRoom = finalRoom;
	}

	/**
	 * Sets the firstRoom.
	 * @param firstRoom The firstRoom to set
	 */
	public void setFirstRoom(Room firstRoom) {
		this.firstRoom = firstRoom;
	}

	/**
	 * Sets the listItem.
	 * @param listItem The listItem to set
	 */
	public void setListRoom(Hashtable listRoom) {
		this.listRoom = listRoom;
	}

	/**
	 * Sets the player.
	 * @param player The player to set
	 */
	public void setPlayer(Player player) {
		this.player = player;
	}
	
	/**
	 * Returns the isDeveloppeur.
	 * @return boolean
	 */
	public boolean isDeveloppeur() {
		return isDeveloppeur;
	}

	/**
	 * Sets if the player is a developpeur.
	 * @param isDeveloppeur The isDeveloppeur to set
	 */
	public void setIsDeveloppeur(boolean isDeveloppeur) {
		this.isDeveloppeur = isDeveloppeur;
	}

	/**
	 * Returns the game window.
	 * @return GameFrame
	 */
	public GameFrame getFenetre() {
		return fenetre;
	}

	/**
	 * Sets the game window.
	 * @param fenetre The fenetre to set
	 */
	public void setFenetre(GameFrame fenetre) {
		this.fenetre = fenetre;
	}

	/** get the lockCommand parameter
	 * @return the lockCommand value
	 */
	public boolean isLockCommand() {
		return lockCommand;
	}

	/** set the lockCommand parameter
	 * <BR>lockCommand is used to stop the execution of the command, only text command
	 * ( # ) are read.
	 * @param b
	 */
	public void setLockCommand(boolean b) {
		lockCommand = b;
	}

	/** method :JDialog getFenetreLoading
	 * @return the loading pop up window
	 */
	public JDialog getFenetreLoading() {
		return fenetreLoading;
	}

	/** method :void setFenetreLoading
	 * @param dialog
	 */
	public void setFenetreLoading(JDialog dialog) {
		fenetreLoading = dialog;
	}
	

	/**
	 * @return the dungeon name
	 */
	public String getDungeonName() {
		return dungeonName;
	}

	/**
	 * set the dungeon name
	 * @param string the dungeon name to set
	 */
	public void setDungeonName(String string) {
		dungeonName = string;
	}

}
