/*
 * Created on 5 juin 2003
 *
 * By Michel de VERDELHAN
 */
package zork2Class;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

/**	the class HighScoreReader
 *	creation :5 juin 2003 at 23:28:43
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class HighScoreFile {

	// attributs
	private String dungeonName;
	/** the constructor for HighScoreReader
	 * 
	 */
	public HighScoreFile(String dungeon) {
		super();
		this.dungeonName=dungeon;
	}
	
	/**
	 *  method :Vector readScore
	 * <BR>read the high score file
	 */
	public Vector readScore(){
		Vector ret=new Vector(0,1);
		FileReader inReader;
		String ligne="";
		try {
			inReader = new FileReader("maps/" + this.dungeonName + "/highScore.sco");
			BufferedReader stream = new BufferedReader(inReader);
			
			int lignesLue=0;// nombre de lignes lues
			ligne=stream.readLine();
			while ((ligne!=null)&&(lignesLue<=10)){
				lignesLue++;
				ret.add(ligne);
				ligne=stream.readLine();
			}
			inReader.close();
		} 
		catch (FileNotFoundException e) {
			e.printStackTrace();
			ret.add("pas de high score");
		}
		 catch (IOException e) {
			e.printStackTrace();
		}
		finally{
		}
		HighScore[] tab = new HighScore[ret.size()];
		int i = 0;
		for (Enumeration e = ret.elements();e.hasMoreElements();){
			String tmp=(String)e.nextElement();
			StringTokenizer st = new StringTokenizer(tmp,":");
			String arg1=new String();
			int arg2=0;
			if (st.hasMoreTokens()){
				arg1= st.nextToken();
			}
			if (st.hasMoreTokens()){
				arg2=Integer.parseInt((String)st.nextToken().trim());
			}
			tab[i]=new HighScore(arg1,arg2);
			i++;
		}
		ret=this.sort(tab);
		
		//assert (ret!=null):"post condition error HighScoreFile->readScore return vector null";
		return ret;
	}
	
	/**
	 * method :boolean writeScore
	 * <BR>write the high score in the high score file if score is in the 10 best high score
	 * @param name player name
	 * @param score player score
	 * @return boolean true if the score is a highScore, else false
	 */
	public boolean writeScore(String name,long score){
		
		boolean ret=true;
		Vector highScore=this.readScore();
		highScore.add(name+" : "+score);
		HighScore[] tab = new HighScore[highScore.size()];
		int i = 0;
		for (Enumeration e = highScore.elements();e.hasMoreElements();){
			String tmp=(String)e.nextElement();
			StringTokenizer st = new StringTokenizer(tmp,":");
			String arg1=new String();
			int arg2=0;
			if (st.hasMoreTokens()){
				arg1= st.nextToken();
			}
			if (st.hasMoreTokens()){
				arg2=Integer.parseInt((String)st.nextToken().trim());
			}
			tab[i]=new HighScore(arg1,arg2);
			i++;
		}
		highScore=this.sort(tab);
		String tmp=(String)highScore.lastElement();
		if ((tmp.equals(name+" : "+score))&&(highScore.size()>10)){
			ret=false;
		}
		// placer ici le code d'ecriture dans le fichier
		try {
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("maps/" + this.dungeonName + "/highScore.sco")));
			Enumeration e=highScore.elements();
			i=0;
			while ((e.hasMoreElements())&&(i<10)){
				i++;
				out.println(e.nextElement().toString());
			}
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return ret;
	}
	
	/**
	 *  sort an array
	 * @param tableau the array to sort
	 * @return int[] the sorted array
	 */
	private Vector sort(HighScore[] tableau){
		Vector ret=new Vector(0,1);
		boolean change=true;
		while(change){
			change=false;
			for (int i=0;i<tableau.length-1;i++){
				if (tableau[i].getValeur()<tableau[i+1].getValeur()){
					HighScore tmp=tableau[i+1];
					tableau[i+1]=tableau[i];
					tableau[i]=tmp;
					change=true;
				}
			}
		}
		for (int i=0;i<tableau.length;i++){
			ret.add(tableau[i].toString());
		}

		return ret;
	}
	
	class HighScore{
		private String name;
		private int valeur;
		
		public HighScore(String name,int valeur){
			this.setName(name);
			this.setValeur(valeur);
			
		}
		/** the constructor for HighScore
		 * 
		 */
		public HighScore() {
			
		}
		/** method :String getName
		 */
		public String getName() {
			return name;
		}

		/** method :int getValeur
		 */
		public int getValeur() {
			return valeur;
		}

		/** method :void setName
		 * @param string
		 */
		public void setName(String string) {
			name = string;
		}

		/** method :void setValeur
		 * @param i
		 */
		public void setValeur(int i) {
			valeur = i;
		}
		
		/**
		 *  method :HighScore toString
		 * @return
		 * @see java.lang.Object#toString()
		 * @since 6 juin 2003 at 00:02:14
		 */
		public String toString(){
			return (this.getName().trim()+" : "+this.valeur);
		}

	}

}
