package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;

/**
 * 	the class Item
 *	creation :5 mai 03 at 17:54:16
 *  @author Michel de VERDELHAN
 *  @version 1.0
 */
public class Item {
	
	//chemin de l'image par default
	private static final String IMG_ITEM_DEFAULT = "images/imgDefault/item.gif";
	
	// attributs
	private String name;// le nom de l'item
	private String description;// la description de l'item
	private int value;// la valeur en or de l'item
	private int weigth;// le poid de l'item
	private int energyAdd;// le bonus/malus d'energie apporte par l'item
	private int strengthAdd;// idem force
	private int dexterityAdd;// idem pour la dexterite
	private int intelligenceAdd;// idem intelligence
	private int powerWeapon;// la puissance de l'item lorqu'il est utilis comme arme active
	private Image image;// le chemin d'accs de image de l'item sur la zone de jeu
	private boolean isMap;// si l'objet est une carte


	//constructeur
	
	/**
	 * Constructor Item.
	 * @param itName, this the name of the item we would like to create
	 * @param itDescription, the description of the itm we would like to create 
	 */
	public Item(String itName, String itDescription){
		this.name = itName;
		this.description = itDescription;
		this.isMap=false;
		this.strengthAdd=0;
		this.dexterityAdd=0;
		this.intelligenceAdd=0;
		this.energyAdd=0;
		this.value=0;
		this.weigth=0;
		this.setImage(Item.IMG_ITEM_DEFAULT);
	}
	
///////////////////      LES METHODES      \\\\\\\\\\\\\\\\\\\\\\
	
	/**
	 * Method couldBeCross.
	 * <BR> if the item can be crossed by the player
	 * @return boolean true if player can cross item else false
	 */
	public boolean couldBeCross() {
		boolean ret=true;
		if (this.weigth==0){
			ret=false;
		}
		return ret;
	}

	
	/**
	 * Method isWeapon, this method check if that Item could be a weapon. It
	 * return true if this Item could serve as a weapon.
	 * @return boolean true if item can be used as weapon else false
	 */
	public boolean isWeapon() {
		boolean ret = false;
		if(powerWeapon>0){
			ret = true;
		}
		return(ret);
	}
	
	/**
	 *  method :Item toString
	 * <BR>return the item as a string
	 * @return String representing the item
	 * @see java.lang.Object#toString()
	 * @since 12 mai 03 at 22:11:33
	 */
	public String toString(){
		String poid=" poid:"+this.getWeigth();
		String attaque="";
		if (this.isWeapon()){
			attaque=" force:"+this.getPowerWeapon();
		}
		String ret=this.getName()+poid+attaque;
		return ret;
	}
	
///////////////////     LES ACCESSEURS     \\\\\\\\\\\\\\\\\\\\\\

	/**
	 * Returns the dexterityAdd.
	 * @return int
	 */
	public int getDexterityAdd() {
		return dexterityAdd;
	}

	/**
	 * Returns the energyAdd.
	 * @return int
	 */
	public int getEnergyAdd() {
		return energyAdd;
	}

	/**
	 * Returns the image.
	 * @return Image
	 */
	public Image getImage() {
		return image;
	}

	/**
	 * Returns the intelligenceAdd.
	 * @return int
	 */
	public int getIntelligenceAdd() {
		return intelligenceAdd;
	}

	/**
	 * Returns the isMap.
	 * @return boolean
	 */
	public boolean isMap() {
		return isMap;
	}

	/**
	 * Returns the itemDescription.
	 * @return String
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Returns the itemName.
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns the itemValue.
	 * @return int
	 */
	public int getValue() {
		return value;
	}

	/**
	 * Returns the itemWeigth.
	 * @return int
	 */
	public int getWeigth() {
		return weigth;
	}

	/**
	 * Returns the strengthAdd.
	 * @return int
	 */
	public int getStrengthAdd() {
		return strengthAdd;
	}
	
	/**
	 * Returns the powerWeapon.
	 * @return int
	 */
	public int getPowerWeapon() {
		return powerWeapon;
	}

///////////////////   LES MODIFICATEURS      \\\\\\\\\\\\\\\\\\\\

	/**
	 * Sets the dexterityAdd.
	 * @param dexterityAdd The dexterityAdd to set
	 */
	public void setDexterityAdd(int dexterityAdd) {
		this.dexterityAdd = dexterityAdd;
	}

	/**
	 * Sets the energyAdd.
	 * @param energyAdd The energyAdd to set
	 */
	public void setEnergyAdd(int energyAdd) {
		this.energyAdd = energyAdd;
	}

	/**
	 * Sets the image.
	 * @param image The image to set
	 */
	public void setImage(Image image) {
			this.image = image;
	}
	
	/**
	 * Sets the image.
	 * @param image The image to set
	 */
	public void setImage(String image) {
		this.image = Toolkit.getDefaultToolkit().getImage(image);
	}
	

	/**
	 * Sets the intelligenceAdd.
	 * @param intelligenceAdd The intelligenceAdd to set
	 */
	public void setIntelligenceAdd(int intelligenceAdd) {
		this.intelligenceAdd = intelligenceAdd;
	}

	/**
	 * Sets the isMap.
	 * @param isMap The isMap to set
	 */
	public void setIsMap(boolean isMap) {
		this.isMap = isMap;
	}

	/**
	 * Sets the itemDescription.
	 * @param itemDescription The itemDescription to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Sets the itemName.
	 * @param itemName The itemName to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Sets the itemValue.
	 * @param itemValue The itemValue to set
	 */
	public void setValue(int value) {
		this.value = value;
	}

	/**
	 * Sets the itemWeigth.
	 * @param itemWeigth The itemWeigth to set
	 */
	public void setWeigth(int weigth) {
		this.weigth = weigth;
	}

	/**
	 * Sets the strengthAdd.
	 * @param strengthAdd The strengthAdd to set
	 */
	public void setStrengthAdd(int strengthAdd) {
		this.strengthAdd = strengthAdd;
	}

	/**
	 * Sets the powerWeapon.
	 * @param powerWeapon The powerWeapon to set
	 */
	public void setPowerWeapon(int powerWeapon) {
		this.powerWeapon = powerWeapon;
	}



}
