package zork2Class;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JOptionPane;

import zork2Class.Item;


/** This class permit to open the file "Item.zit". This file is the file which contains 
  * the configuration of the different item, you can use in the current Level.
  * la balise <FILEITEM> show the begin of the project
  * la balise <ITEM> show the begin of an item
  * @version 1.0, 28/03/03
  * @author IUT de Vannes, Fabien BOYERE, Michel de VERDELHAN
  */
public class ItemFileReader {

	//les attributs
	private Hashtable lesItems;
	private String nameDungeon;
	
	//le constructeur
	public ItemFileReader(String str){
		lesItems = new Hashtable();
		this.nameDungeon = str;
	}
		
	/** 
	 * This method is a methode which permit to write a new file item.zit.
	 */
	public boolean readItemFile(){
		String s, se;//cette String permet de stocker temporairement la ligne en cours de lecture
		FileReader inReader;
		BufferedReader in;
		StringTokenizer st, sl;
		boolean iteYes; 
		Item ite;
		try{
			
			//lecture du fichier
			inReader = new FileReader("maps/"+nameDungeon+"/items.zit");
			//inReader = new FileReader("items.zit");
			in = new BufferedReader(inReader);
			Vector vectElement;

			//boucle pour sauter les commentaires situs avant la balise <FILEITEM>
			do{
				s = in.readLine().trim();
				s.equalsIgnoreCase("<ITEMFILE>");
			}while(!(s.equalsIgnoreCase("<ITEMFILE>")));
			
			//boucle de traitement des Items tant que l'on atteint pas la balise </FILEITEM>
			s = in.readLine().trim();
			while((!s.equalsIgnoreCase("</ITEMFILE>"))&&(!(s.equals(null)))){
				
				//Sauter les lignes de commentaires avant la balise FILE
				while(!(s.equalsIgnoreCase("<ITEM>"))){
					s = in.readLine().trim();
				}	
				
				//rcupration de tout les attributs du n-me item que l'on stock dans
				//un vecteur temporaire avant analyse
				s = in.readLine().trim();
				vectElement = new Vector();
				while((!s.equalsIgnoreCase("</ITEMFILE>"))&&(!s.equalsIgnoreCase("</ITEM>"))&&(!s.equals(null))){
					//boucle qui permet de supprimer d'ventuels commentaires
					if(s.startsWith("<!--")){
						while(!s.endsWith("-->")){
							s = in.readLine().trim();
						}
					}
					//on saute les lignes vides
					if(s.equalsIgnoreCase("")){
						do{
							s = in.readLine().trim();
						}while(s.equalsIgnoreCase(""));
					}
					//on ajoute au vecteur, d'attribut d'Item, provisoir
					else{
						vectElement.addElement(s);
					}
					s = in.readLine().trim();
				}
							
				//vrification de la prsence des attributs minimums
				//les attribut name et Description sont obligatoires
				String name = new String();
				String description = new String();
				boolean presenceName = false;
				boolean presenceDescription = false;	
				Enumeration e;
				
				for(e = vectElement.elements();e.hasMoreElements();){
					s = (String) e.nextElement();
					st = new StringTokenizer(s,"=");	
					s = st.nextToken().trim();
					if(s.equalsIgnoreCase("Name")){
						s = st.nextToken().trim();
						sl = new StringTokenizer(s,"\"");
						name = sl.nextToken().trim();
						presenceName = true;
					}
					else{
						if(s.equalsIgnoreCase("Description")){
							s = st.nextToken().trim();
							sl = new StringTokenizer(s,"\"");

							description = sl.nextToken().trim();
							description=description.replace('','\n');
							presenceDescription = true;
						}
					}
				}
							
				//vrification que les attributs obligatoires sont bien prsents
				if(((presenceName)&&(presenceDescription))){
					
					//cration de l'item
					ite = new Item(name, description);
					ite.setDescription(ite.getDescription().replace('','\t'));
					//boucle qui permet de traiter les attributs collects
					int integer;
					Enumeration i;
					for(i = vectElement.elements();i.hasMoreElements();){
						s = (String) i.nextElement();
						st = new StringTokenizer(s,"=");
						s = st.nextToken().trim();
						if(s.equalsIgnoreCase("Weigth")){
							s = st.nextToken().trim();
							sl = new StringTokenizer(s,"\"");

							integer = Integer.parseInt(sl.nextToken().trim());
							ite.setWeigth(integer);
						}
						else{	
							if(s.equalsIgnoreCase("Value")){
								s = st.nextToken().trim();
								sl = new StringTokenizer(s,"\"");
		
								integer = Integer.parseInt(sl.nextToken().trim());
								ite.setValue(integer);
								}
							else{
								if(s.equalsIgnoreCase("EnergyAdd")){
									s = st.nextToken().trim();
									sl = new StringTokenizer(s,"\"");

									integer = Integer.parseInt(sl.nextToken().trim());
									ite.setEnergyAdd(integer);
								}
								else{
									if(s.equalsIgnoreCase("IntelligenceAdd")){
										s = st.nextToken().trim();
										sl = new StringTokenizer(s,"\"");
		
										integer = Integer.parseInt(sl.nextToken().trim());
										ite.setIntelligenceAdd(integer);
									}
									else{
										if(s.equalsIgnoreCase("DexterityAdd")){
											s = st.nextToken().trim();
											sl = new StringTokenizer(s,"\"");
					
											integer = Integer.parseInt(sl.nextToken().trim());
											ite.setDexterityAdd(integer);
										}
										else{
											if(s.equalsIgnoreCase("StrengthAdd")){
												s = st.nextToken().trim();
												sl = new StringTokenizer(s,"\"");
											
												integer = Integer.parseInt(sl.nextToken().trim());
												ite.setStrengthAdd(integer);
											}
											else{
												if(s.equalsIgnoreCase("Image")){
													s = st.nextToken().trim();
													sl = new StringTokenizer(s,"\"");
									
													ite.setImage(sl.nextToken().trim());
												}
												else{
													if(s.equalsIgnoreCase("IsMap")){
														s = st.nextToken().trim();
														sl = new StringTokenizer(s,"\"");
											
														s = sl.nextToken().trim();
														if(s.equalsIgnoreCase("true")){
															ite.setIsMap(true);
														}
													}//fin du if
													else{
														if(s.equalsIgnoreCase("powerWeapon")){
															s = st.nextToken().trim();
															sl = new StringTokenizer(s,"\"");
														
															integer = Integer.parseInt(sl.nextToken().trim());
															ite.setPowerWeapon(integer);
														}// fin du if PowerWeapon
													}//fin du else
												}//fin du else
											}//fin du else
										}//fin du else
									}//fin du else
								}
							}
						}
					}//fermeture de la boucle for
					lesItems.put(ite.getName(),ite);
				}//fin du bloc if
				s = in.readLine().trim();
			}//fin du bloc while					
			
			//fermeture du fichier
			in.close();
			return(true);
		}//du try
		
		catch(IOException e){
			JOptionPane.showMessageDialog(null,e+"\n Pour continuer : press [ENTER]");
			return(false);
		}
	}
	
	
	
	//accesseurs
	/**
	 * Method getLesItems.
	 * @return Vector
	 */
	public Hashtable getLesItems(){
		return(lesItems);
	}
		
		
	//modificateurs
	/**
	 * Method addItem. This method permit to add an item the private 
	 * vector lesItems.
	 * @param itemAjout
	 */
	public void addItem(Item itemAjout){
		lesItems.put(itemAjout.getName(),itemAjout);
	}
	
	
}//fin de classe