package zork2Class;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JOptionPane;

import zork2Class.FightOrdeal;
import zork2Class.Item;
import zork2Class.Ordeal;
import zork2Class.Reward;
import zork2Class.SkillOrdeal;
import zork2Class.WithQCM;
import zork2Class.WithoutQCM;

/** This class permit to open the file "Item.zit". This file is the file which contains 
  * the configuration of the different item, you can use in the current Level.
  * la balise <ORDEALFILE> show the begin of the project
  * la balise <FIGHTORDEAL> show the begin of an ordeal type Fight
  * la balise <SKILLORDEAL> show the begin of an ordeal type Skill
  * la balise <QUESTION> show the begin of an ordeal type Question
  * la balise <QCM> show the begin of an ordeal type QCM
  * @version 1.0, 28/03/03
  * @author IUT de Vannes, Fabien BOYERE, Michel de VERDELHAN
  */
public class OrdealFileReader {

	//les attributs
	private Hashtable lesOrdeals;
	private Hashtable itemLoad;
	private String nameDungeon;
	
	//le constructeur
	public OrdealFileReader(String str, Hashtable itemLoad){
		lesOrdeals = new Hashtable();
		this.nameDungeon = str;
		this.itemLoad = itemLoad;
	}
	
	
	/**
	 * <b>Method createReward.</b> This method used a Vector of attribut, create a reward. 
	 * Before used this method you must load all the line which are contains between
	 * <REWARD> and </REWARD>.
	 * @param attributs This vector is the vector which contains all the line between <REWARD> et </REWARD>
	 * @return Reward - This the reward which are been creating.
	 */
	private Reward createReward(Vector attributs){
		
		//attributs
		Reward reward;//la rcompense crer
		int strBonus = 0;
		int intBonus = 0;
		int lifBonus = 0;
		int dexBonus = 0;
		int eneBonus = 0;
		int score = 0;
		Vector listItems = new Vector();
		//on prend chaque ligne et on l'analyse
		Enumeration i;
		for(i = attributs.elements();i.hasMoreElements();){
			
			//attributs temporaires
			String s;
			StringTokenizer st,sl;
			int integer;
			
			//on prend l'lment qui suit
			s = (String) i.nextElement();
			//on garde que le type de l'attribut
			st = new StringTokenizer(s,"=");
			//on enlve les caractre "espace"
			s = st.nextToken().trim();
			
			//on compare par rapport au type d'attributs existants
			if(s.equalsIgnoreCase("energyBonus")){
				s = st.nextToken().trim();
				sl = new StringTokenizer(s,"\"");
				
				eneBonus = Integer.parseInt(sl.nextToken().trim());
			}
			else{			
				if(s.equalsIgnoreCase("StrengthBonus")){
					s = st.nextToken().trim();
					sl = new StringTokenizer(s,"\"");
					
					strBonus = Integer.parseInt(sl.nextToken().trim());
				}
				else{	
					if(s.equalsIgnoreCase("IntelligenceBonus")){
						s = st.nextToken().trim();
						sl = new StringTokenizer(s,"\"");
						
						intBonus = Integer.parseInt(sl.nextToken().trim());
						}
					else{
						if(s.equalsIgnoreCase("dexterityBonus")){
							s = st.nextToken().trim();
							sl = new StringTokenizer(s,"\"");
							
							dexBonus = Integer.parseInt(sl.nextToken().trim());
						}
						else{			
							if(s.equalsIgnoreCase("score")){
								s = st.nextToken().trim();
								sl = new StringTokenizer(s,"\"");
								
								score = Integer.parseInt(sl.nextToken().trim());
							}
							else{	
								if(s.equalsIgnoreCase("lifeBonus")){
									s = st.nextToken().trim();
									sl = new StringTokenizer(s,"\"");
									
									lifBonus = Integer.parseInt(sl.nextToken().trim());
								}
								else{
									if(s.equalsIgnoreCase("item")){
										s = st.nextToken().trim();
										sl = new StringTokenizer(s,"\"");
										
										s = sl.nextToken().trim();
										if(this.itemLoad.containsKey(s)){
											Item it = (Item) this.itemLoad.get(s);
											if(it.getWeigth()>0){
												listItems.addElement(it);
											}
										}
										else{
										}
									}
								}
							}
						}
					}
				}
			}
		}
		
		//cration et initialisation de la nouvelle rcompense
		reward = new Reward();
		reward.setDexterityBonus(dexBonus);
		reward.setEnergyBonus(intBonus);
		reward.setIntelligenceBonus(intBonus);
		reward.setLifeBonus(lifBonus);
		reward.setStrengthBonus(strBonus);
		reward.setScore(score);
		reward.setItem(listItems);
		return(reward);
	}
	
	
	private void createFightOrdeal(String name, String description, Vector attribut){
		
		//attributs temporaires
		String s;
		StringTokenizer st, sl;
		
		//cration de la fight ordeal
		FightOrdeal fightOrd;
		fightOrd = new FightOrdeal(name, description);
		
		//boucle qui permet de traiter les attributs collects
		//on rcupre les diffrents attributs et on met  jour l'preuve
		int integer;
		Enumeration i;
		for(i = attribut.elements();i.hasMoreElements();){
			s = (String) i.nextElement();
			
			if(s.trim().equalsIgnoreCase("<REWARD>")){
				Vector rewardAtt = new Vector();//vecteur qui reoit les attributs de la rcompense
				boolean atLessAnElement = false;
				s = (String) i.nextElement();
				s = s.trim();
				while(!s.equalsIgnoreCase("</REWARD>")){
					rewardAtt.addElement(s);
					s = (String) i.nextElement();
					atLessAnElement = true;
				}
				if(atLessAnElement){
					Reward reward = createReward(rewardAtt);
					fightOrd.setRecompense(reward);
				}
			}
			else{			
				st = new StringTokenizer(s,"=");
				s = st.nextToken().trim();
				if(s.equalsIgnoreCase("MonsterEnergy")){
					s = st.nextToken().trim();
					sl = new StringTokenizer(s,"\"");
					
					integer = Integer.parseInt(sl.nextToken().trim());
					fightOrd.setMonsterEnergy(integer);
				}
				else{	
					if(s.equalsIgnoreCase("MonsterName")){
						s = st.nextToken().trim();
						sl = new StringTokenizer(s,"\"");
						
						fightOrd.setMonsterName(sl.nextToken().trim());
						}
					else{
						if(s.equalsIgnoreCase("MonsterFightCapacity")){
							s = st.nextToken().trim();
							sl = new StringTokenizer(s,"\"");
							
							integer = Integer.parseInt(sl.nextToken().trim());
							fightOrd.setMonsterFightsCapacity(integer);
						} 
					}
				}
			}
		}//fermeture de la boucle for
		
		//ajout de la nouvelle preuve  la hashtable
		this.addOrdeal(fightOrd);
	}
	
	
	
	
	private void createSkillOrdeal(String name, String description, Vector attribut){
				
		//attributs
		String s;
		StringTokenizer st, sl;
		
		//cration de la skill ordeal
		SkillOrdeal skillOrd;
		skillOrd = new SkillOrdeal(name, description);
		
		//boucle qui permet de traiter les attributs collects
		//on rcupre les diffrents attributs et on met  jour l'preuve
		int integer;
		Enumeration i;
		for(i = attribut.elements();i.hasMoreElements();){
			s = (String) i.nextElement();
			
			if(s.trim().equalsIgnoreCase("<REWARD>")){
				Vector rewardAtt = new Vector();//vecteur qui reoit les attributs de la rcompense
				boolean atLessAnElement = false;
				s = (String) i.nextElement();
				s = s.trim();
				while(!s.equalsIgnoreCase("</REWARD>")){
					rewardAtt.addElement(s);
					s = (String) i.nextElement();
					atLessAnElement = true;
				}
				if(atLessAnElement){
					Reward reward = createReward(rewardAtt);
					skillOrd.setRecompense(reward);
				}
			}
			else{			
				st = new StringTokenizer(s,"=");
				s = st.nextToken().trim();
				if(s.equalsIgnoreCase("dexterityLevel")){
					s = st.nextToken().trim();
					sl = new StringTokenizer(s,"\"");
					
					integer = Integer.parseInt(sl.nextToken().trim());
					skillOrd.setDexterityLevel(integer);
				}
				else{	
					if(s.equalsIgnoreCase("intelligenceLevel")){
						s = st.nextToken().trim();
						sl = new StringTokenizer(s,"\"");
						
						integer = Integer.parseInt(sl.nextToken().trim());
						skillOrd.setIntelligenceLevel(integer);
						}
					else{
						if(s.equalsIgnoreCase("StrengthLevel")){
							s = st.nextToken().trim();
							sl = new StringTokenizer(s,"\"");
							
							integer = Integer.parseInt(sl.nextToken().trim());
							skillOrd.setStrengthLevel(integer);
						} 
					}
				}
			}
		}//fermeture de la boucle for
		
		//ajout de la nouvelle preuve  la hashtable
		this.addOrdeal(skillOrd);	
	}
	
	private void createQuestionOrdeal(String name, String description, Vector attribut){
		
		//attributs
		String s;
		StringTokenizer st, sl;
		
		//cration de la fight ordeal
		WithoutQCM questionOrd;
		questionOrd = new WithoutQCM(name, description);
		
		//boucle qui permet de traiter les attributs collects
		//on rcupre les diffrents attributs et on met  jour l'preuve
		int integer;
		Enumeration i;
		for(i = attribut.elements();i.hasMoreElements();){
			s = (String) i.nextElement();
			
			if(s.trim().equalsIgnoreCase("<REWARD>")){
				Vector rewardAtt = new Vector();//vecteur qui reoit les attributs de la rcompense
				boolean atLessAnElement = false;
				s = (String) i.nextElement();
				s = s.trim();
				while(!s.equalsIgnoreCase("</REWARD>")){
					rewardAtt.addElement(s);
					s = (String) i.nextElement();
					atLessAnElement = true;
				}
				if(atLessAnElement){
					Reward reward = createReward(rewardAtt);
					questionOrd.setRecompense(reward);
				}
			}
			else{			
				st = new StringTokenizer(s,"=");
				s = st.nextToken().trim();
				if(s.equalsIgnoreCase("answer")){
					s = st.nextToken().trim();
					sl = new StringTokenizer(s,"\"");
					
					questionOrd.setAnswer(sl.nextToken().trim());
				}
				else{	
					if(s.equalsIgnoreCase("question")){
						s = st.nextToken().trim();
						sl = new StringTokenizer(s,"\"");
						
						questionOrd.setQuestion(sl.nextToken().trim());
					}
				}
			}
		}//fermeture de la boucle for
		
		//ajout de la nouvelle preuve  la hashtable
		this.addOrdeal(questionOrd);
	}
	
	private void createQCMOrdeal(String name, String description, Vector attribut){
		//attributs
		String s;
		StringTokenizer st, sl;
		
		//cration de la fight ordeal
		WithQCM qCMOrd;
		qCMOrd = new WithQCM(name, description);
		
		//boucle qui permet de traiter les attributs collects
		//on rcupre les diffrents attributs et on met  jour l'preuve
		int integer;
		Enumeration i;
		for(i = attribut.elements();i.hasMoreElements();){
			s = (String) i.nextElement();
			
			if(s.trim().equalsIgnoreCase("<REWARD>")){
				Vector rewardAtt = new Vector();//vecteur qui reoit les attributs de la rcompense
				boolean atLessAnElement = false;
				s = (String) i.nextElement();
				while(!s.equalsIgnoreCase("</REWARD>")){
					rewardAtt.addElement(s);
					s = (String) i.nextElement();
					atLessAnElement = true;
				}
				if(atLessAnElement){
					Reward reward = createReward(rewardAtt);
					qCMOrd.setRecompense(reward);
				}
			}
			else{			
				st = new StringTokenizer(s,"=");
				s = st.nextToken().trim();
				if(s.equalsIgnoreCase("answer")){
					s = st.nextToken().trim();
					sl = new StringTokenizer(s,"\"");
					
					qCMOrd.setAnswer(sl.nextToken().trim());
				}
				else{	
					if(s.equalsIgnoreCase("question")){
						s = st.nextToken().trim();
						sl = new StringTokenizer(s,"\"");
						
						s = sl.nextToken().trim();
						qCMOrd.setQuestion(s);
					}
					else{
						if(s.equalsIgnoreCase("choice")){
							s = st.nextToken().trim();
							sl = new StringTokenizer(s,"\"");
							
							s = sl.nextToken().trim();
							qCMOrd.getAnswerChoice().addElement(s);
						}
					}
				}
			}
		}//fermeture de la boucle for
		
		//ajout de la nouvelle preuve  la hashtable
		this.addOrdeal(qCMOrd);
	}
	
	
		
	/** 
	 * This method is a methode which permit to write a new file item.zit.
	 */
	public boolean readOrdealFile(){
		String s, se;//cette String permet de stocker temporairement la ligne en cours de lecture
		FileReader inReader;
		BufferedReader in;
		StringTokenizer st, sl;
		boolean endAppear = false; 
		try{
			
			//lecture du fichier
			inReader = new FileReader("maps/"+nameDungeon+"/ordeal.zor");
			in = new BufferedReader(inReader);
			Vector vectElement;

			//boucle pour sauter les commentaires situs avant la balise <ORDEALFILE>
			do{
				s = in.readLine().trim();
				s.equalsIgnoreCase("<ORDEALFILE>");
			}while(!(s.equalsIgnoreCase("<ORDEALFILE>")));
			
			//boucle de traitement des ordeals tant que l'on atteint pas la balise </ORDEALFILE>
			s = in.readLine().trim();
			while((!s.equalsIgnoreCase("</ORDEALFILE>"))&&(!(s.equals(null)))){
				
				//Sauter les lignes de commentaires avant les balise de type ordeal
				while(!((s.equalsIgnoreCase("<QCM>"))||(s.equalsIgnoreCase("</ORDEALFILE>"))||(s.equals(null))||(s.equalsIgnoreCase("<fightordeal>"))||(s.equalsIgnoreCase("<Question>"))||(s.equalsIgnoreCase("<skillordeal>")))){
					s = in.readLine().trim();
				}	
				
				//on dclenche une sentinelle qui signifie que une balise de fin a t approch
				//et que le fichier n'est pas correctement structur
				if(s.equalsIgnoreCase("</ORDEALFILE>")||s.equals(null)){
					endAppear = true;
				}
				
				if(!endAppear){
					//rcupration de tout les attributs du n-me item que l'on stock dans
					//un vecteur temporaire avant analyse
					vectElement = new Vector();
					//on met le type d'preuve dan le premier lment
					vectElement.addElement(s);
					
					s = in.readLine().trim();
					while((!s.equalsIgnoreCase("</ORDEALFILE>"))&&(!s.equalsIgnoreCase("</FIGHTORDEAL>"))&&(!s.equalsIgnoreCase("</SKILLORDEAL>"))&&(!s.equalsIgnoreCase("</QUESTION>"))&&(!s.equalsIgnoreCase("</QCM>"))&&(!s.equals(null))){
						//boucle qui permet de supprimer d'ventuels commentaires
						if(s.startsWith("<!--")){
							while(!s.endsWith("-->")){
								s = in.readLine().trim();
							}
						}
						else{
							//on saute les lignes vides
							if(!s.equalsIgnoreCase("")){
								vectElement.addElement(s);
							}
						}
						s = in.readLine().trim();
					}
					
					//on dclenche une sentinelle qui signifie que une balise de fin a t approch
					//et que le fichier n'est pas correctement structur
					if(s.equalsIgnoreCase("</ORDEALFILE>")||s.equals(null)){
						endAppear = true;
					}
								
					//vrification de la prsence des attributs minimums
					//les attribut name et Description sont obligatoires
					String name = new String();
					String description = new String();
					boolean presenceName = false;
					boolean presenceDescription = false;	
					Enumeration e;
					
					for(e = vectElement.elements();e.hasMoreElements();){
						s = (String) e.nextElement();
						st = new StringTokenizer(s,"=");	
						s = st.nextToken().trim();
						if(s.equalsIgnoreCase("Name")){
							s = st.nextToken().trim();
							sl = new StringTokenizer(s,"\"");
							name = sl.nextToken().trim();
							presenceName = true;
						}
						else{
							if(s.equalsIgnoreCase("Description")){
								s = st.nextToken().trim();
								sl = new StringTokenizer(s,"\"");
								description = sl.nextToken().trim();
								description=description.replace('','\n');
								presenceDescription = true;
							}
						}
					}
								
					//vrification que les attributs obligatoires sont bien prsents
					if(((presenceName)&&(presenceDescription))){
						s = (String) vectElement.elementAt(0);
						s = s.trim();
						if(s.equalsIgnoreCase("<QCM>")){
							this.createQCMOrdeal(name, description, vectElement);
						}
						else{
							if(s.equalsIgnoreCase("<Question>")){
								this.createQuestionOrdeal(name, description, vectElement);
							}
							else{
								if(s.equalsIgnoreCase("<fightOrdeal>")){
									this.createFightOrdeal(name, description, vectElement);
								}
								else{
									if(s.equalsIgnoreCase("<skillOrdeal>")){
										this.createSkillOrdeal(name, description, vectElement);
									}
								}
							}
						}
					}
				}
				if(!endAppear){
					s = in.readLine().trim();
				}
			}//fin du bloc while					
			
			//fermeture du fichier
			in.close();
			return(true);
		}//du try
		
		catch(IOException e){
			JOptionPane.showMessageDialog(null,e+"\n Pour continuer : press [ENTER]");
			return(false);
		}
	}
	
	
	
	//accesseurs
	/**
	 * Method getLesItems.
	 * @return Vector
	 */
	public Hashtable getLesOrdeals(){
		return(lesOrdeals);
	}
		
		
	//modificateurs
	/**
	 * Method addItem. This method permit to add an item the private 
	 * vector lesItems.
	 * @param itemAjout
	 */
	public void addOrdeal(Ordeal ordeal){
		lesOrdeals.put(ordeal.getName().toLowerCase(),ordeal);
	}
	
	
}//fin de classe