package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;

/**
 * 	the class Player
 *	<BR>creation :5 mai 03 at 17:54:36
 *  <BR>the class repreenting the player in the game. the player is the heros which move 
 * 	at screen...
 *  @author Michel de VERDELHAN
 *  @version 1.0
 *
 */
public class Player {

	//attributs
	private String name;//nom du personnage
	private int strengthLevel;//niveau de force
	private int dexterityLevel;//niveau de dexterity
	private int intelligenceLevel;//niveau d'intelligence
	private int energyLevel;//niveau d'energy de base
	private int currentEnergy;// nombre de points d'energie actuels
	private int lifeNumber;//nombre de vies
	private int posX;// position x du joueur
	private int posY;//position Y du joueur
	private Score score;//score du joueur
	private Room currentRoom;//piece courrante
	private Room lastRoom;//dernire pice traverse
	private Item currentWeapon;//arme active
	private Vector inventory;//inventaire des items possd sur soi
	private Image imgPlayer;

	//constructor
	/**
	 * the default constructor for player whith no attributs
	 */
	public Player() {
		this.setScore(new Score());
		this.setPosX(4);
		this.setPosY(4);
		this.setInventory(new Vector());
		this.setImgPlayer(Toolkit.getDefaultToolkit().getImage("imgDefault/perso.gif")); 
	}
	
	
	/**
	 * Constructor Player.
	 * @param name the player's name
	 * @param strength the player's strength
	 * @param energy the player's energy
	 * @param intelligence ths player's intelligence
	 * @param dexterity the player's dexterity
	 */
	public Player(String name, int strength, int energy, int intelligence, int dexterity) {
		this.setName(name);
		this.setDexterityLevel(dexterity);
		this.setIntelligenceLevel(intelligence);
		this.setStrengthLevel(strength);
		try {
			this.setLifeNumber(3);
		} catch (PlayerIsDeadException e) {
			System.out.println("Player Constuctor error : default life number<0 ");
		}
		try {
			this.setEnergyLevel(energy);
		} catch (PlayerIsDeadException e1) {
			System.out.println("Player Constuctor error : default energy level<0 ");
		}
		this.setScore(new Score());
		this.setPosX(4);
		this.setPosY(4);
		this.setInventory(new Vector());
		this.setImgPlayer(Toolkit.getDefaultToolkit().getImage("imgDefault/perso.gif")); 
	}
	




///////////////////      LES METHODES      \\\\\\\\\\\\\\\\\\\\\\
	/**
 	 * Method getCardinalPosition.
 	 * <BR>methode used to know if player is near a door and the cardinal position of this door
 	 * @return char representing the cardinal position :
 	 * <ol>
 	 * <LI> n =>the player is near the north door
 	 * <LI> s =>the player is near the south door
 	 * <LI> e =>the player is near the east door
 	 * <LI> w =>the player is near the west door
     */
	public char getCardinalPosition(){
		char ch = ' ';
		if ((this.getPosX()==0)&&((this.getPosY()==2)||(this.getPosY()==3))){
			if (this.currentRoom.getDoorWest()!=null){// test si il y a une porte
				ch='w';
			}
		}
		if ((this.getPosX()==7)&&((this.getPosY()==2)||(this.getPosY()==3))){
			if (this.currentRoom.getDoorEast()!=null){// test si il y a une porte
				ch='e';
			}
		}
		if ((this.getPosY()==0)&&((this.getPosX()==3)||(this.getPosX()==4))){
			if (this.currentRoom.getDoorNorth()!=null){// test si il y a une porte
				ch='n';
			}
		}
		if ((this.getPosY()==7)&&((this.getPosX()==3)||(this.getPosX()==4))){
			if (this.currentRoom.getDoorSouth()!=null){// test si il y a une porte
				ch='s';
			}
		}
		return(ch);
	}
	
	/**
	 * Method isNearChest.
	 * <BR> method used to know if the player is near the room chest
	 * @return boolean true if player is near the chest else false
	 */
	public boolean isNearChest(){
		boolean ret = false;
		Chest coffre=this.getCurrentRoom().getChest();
		if (coffre!=null){
			int distanceX=Math.abs(this.getPosX()-coffre.getPosX());
			int distanceY=Math.abs(this.getPosY()-coffre.getPosY());
			if ((distanceX<=1)&&(distanceY<=1)){
				ret=true;
			}
		}
		return (ret);
	}
	
	/**
	 * Method isNearItem.
	 * <BR> method used to know if the player is near an item
	 * @return boolean true if player is near an item else false
	 */
	public boolean isNearItem(){
		boolean ret = false;
		if (this.getCurrentRoom().getItemPosition(this.getPosX(),this.getPosY())!=null){
			ret=true;
		}
		return (ret);
	}
	
	/**
	 * Method canWearItem.
	 * <BR> method used to know if the player can wear this item or if this
	 * item is too eavy
	 * @param item the item to check
	 * @return boolean true if player can wear this item else false
	 */ 
	public boolean canWearItem(Item item){
		boolean ret = false;
		if (item.getWeigth()>0){
			if (this.getMaxWeight()>=(this.getPoid()+item.getWeigth())){
				ret=true;
			}
		}
		return (ret);
	}
	
	/**
	 * Method dropItem.
	 * @param item
	 */
	public void dropItem(Item item){
		if (item!=null){
			if(this.inventory.contains(item)){
				if (this.getCurrentRoom().getItemPosition(this.getPosX(),this.getPosY())==null){
					// pas besoin de tester le coffre car le joueur ne peut pas aller dessus
					this.inventory.remove(item);
					if (this.getCurrentWeapon()==item){
						this.setCurrentWeapon(null);
					}
					this.getCurrentRoom().setItemPosition(item,this.getPosX(),this.getPosY());
				}
				else{
					boolean place=false;
					int delta=1;
					while ((!place)&&(delta<8)){
						for (int j=this.getPosY()-delta;j<this.getPosY()+delta+1;j++){
							for (int i=this.getPosX()-delta;i<this.getPosX()+delta+1;i++){
								if ((i>=0)&&(i<8)&&(j>=0)&&(j<8)&&(!place)){
									if (this.getCurrentRoom().getItemPosition(i,j)==null){
										if (this.getCurrentRoom().getChest()!=null){
											if ((this.getCurrentRoom().getChest().getPosX()!=i)||(this.getCurrentRoom().getChest().getPosY()!=j)){
												this.inventory.remove(item);
												if (this.getCurrentWeapon()==item){
													this.setCurrentWeapon(null);
												}
												this.getCurrentRoom().setItemPosition(item,i,j);
												place=true;
											}
										}
										else{
											this.inventory.remove(item);
											if (this.getCurrentWeapon()==item){
												this.setCurrentWeapon(null);
											}
											this.getCurrentRoom().setItemPosition(item,i,j);
											place=true;
										}
									}
								}
							}
							
						}
						delta++;
					}
				}
			}
		}
	}
	
	/**
	 * Method takeItem.
	 * @param item
	 */
	public void takeItem(Item item){
		if (this.canWearItem(item)){
			Room salle=this.getCurrentRoom();
			this.getInventory().add(item);
			// on test si l'item etait sur le sol
			if (salle.getItemPosition(this.getPosX(),this.getPosY())!=null){
				if (salle.getItemPosition(this.getPosX(),this.getPosY())==item){
					salle.setItemPosition(null,this.getPosX(),this.getPosY());
				}
			}
			// on test si l'item etait dans le coffre
			if (salle.getChest()!=null){
				if (salle.getChest().getItem()!=null){
					if (salle.getChest().getItem()==item){
						salle.getChest().setItem(null);
					}
				}
			}
		}
	}
	
	/**
	 * Method changeWeapon.
	 * @param weapon
	 */
	public void changeWeapon(Item weapon){
		if (weapon.isWeapon()){
			this.setCurrentWeapon(weapon);
			this.setCurrentEnergy(this.currentEnergy+weapon.getEnergyAdd());
		}
	}

	/**
	 * Method openADoor.
	 * @param door
	 */
	public boolean openADoor(Door door){
		boolean ret=false;
		if (!door.doorIsOpen()){
			String cle=door.getKey();
			for (Enumeration e=this.getInventory().elements();e.hasMoreElements();){
				Item objet=(Item)e.nextElement();
				if ((objet.getName().equals(cle)&&(!door.doorIsOpen()))){
					door.setIsOpen(true);
					ret=true;
					this.getInventory().remove(objet);// quand la cle sert elle est detruite
					if (objet==this.getCurrentWeapon()){// meme si c'est l'arme
						this.setCurrentWeapon(null);
					}
				}
			}
		}
		return ret;
	}
	
	/**
	 *  method :void openChest
	 *
	 */
	public void openChest()throws PlayerNotHaveKeyException{
		boolean haveKey=false;
		if (this.isNearChest()){
			String cle=this.getCurrentRoom().getChest().getKey();
			for (Enumeration e=this.getInventory().elements();e.hasMoreElements();){
				Item objet=(Item)e.nextElement();
				if ((objet.getName().equals(cle)&&(!this.getCurrentRoom().getChest().isOpen()))){
					this.getCurrentRoom().getChest().setIsOpen(true);
					this.getInventory().remove(objet);// quand la cle sert elle est detruite
					if (objet==this.getCurrentWeapon()){// meme si c'est l'arme
						this.setCurrentWeapon(null);
					}
					haveKey=true;
				}
			}
			if (!haveKey){
				if (!this.getCurrentRoom().getChest().isOpen()){
					throw new PlayerNotHaveKeyException();
				}
			}
			
		}

	}
	
	/**
	 *  method :boolean checkLoseLife
	 */
	public boolean checkLoseLife() throws PlayerIsDeadException{
		boolean ret=false;
		int bonus=0;
		if (this.currentWeapon!=null){
			bonus=this.currentWeapon.getEnergyAdd();
		}
		if (this.currentEnergy+bonus<=0){
			ret=true;
			this.setLifeNumber(this.getLifeNumber()-1);
		}
		return ret;
	}
	
	/**
	 *  method :boolean dropWeaponKill
	 */
	public boolean dropWeaponKill(){
		boolean ret=false;
		int bonus=0;
		if (this.currentWeapon!=null){
			bonus=this.currentWeapon.getEnergyAdd();
		}
		if (this.getCurrentEnergy()-bonus<=0){
			ret=true;
		}
		
		return (ret);
	}

///////////////////     LES ACCESSEURS     \\\\\\\\\\\\\\\\\\\\\\

	/**
	 * Returns the currentRoom.
	 * @return Room
	 */
	public Room getCurrentRoom() {
		return currentRoom;
	}

	/**
	 * Returns the currentWeapon.
	 * @return Item
	 */
	public Item getCurrentWeapon() {
		return currentWeapon;
	}

	/**
	 * Returns the dexterityLevel.
	 * @return int
	 */
	public int getDexterityLevel() {
		int ret=this.dexterityLevel;
		if (this.getCurrentWeapon()!=null){
			ret=ret+this.getCurrentWeapon().getDexterityAdd();
		}
		if (ret>100)ret=100;
		return ret;
	}

	/**
	 *  method :int getBaseDexterityLevel
	 */
	public int getBaseDexterityLevel() {
		int ret=this.dexterityLevel;
		return ret;
	}

	/**
	 *  method :int getEnergyLevel
	 */
	public int getEnergyLevel() {
		int ret=this.energyLevel;
		if (this.getCurrentWeapon()!=null){
			ret=ret+this.getCurrentWeapon().getEnergyAdd();
		}
		if (ret>100)ret=100;
		return ret;
	}

	/**
	 * Returns the energyLevel.
	 * @return int
	 */
	public int getBaseEnergyLevel() {
		int ret=this.energyLevel;
		return ret;
	}

	/**
	 * Returns the imgPlayer.
	 * @return Image
	 */
	public Image getImgPlayer() {
		return imgPlayer;
	}

	/**
	 * Returns the intelligenceLevel.
	 * @return int
	 */
	public int getIntelligenceLevel() {
		int ret=this.intelligenceLevel;
		if (this.getCurrentWeapon()!=null){
			ret=ret+this.getCurrentWeapon().getIntelligenceAdd();
		}
		if (ret>100)ret=100;
		return ret;
	}

	/**
	 *  method :int getBaseIntelligenceLevel
	 */
	public int getBaseIntelligenceLevel() {
		int ret=this.intelligenceLevel;
		return ret;
	}

	/**
	 * Returns the inventory.
	 * @return Vector
	 */
	public Vector getInventory() {
		return inventory;
	}

	/**
	 * Returns the lastRoom.
	 * @return Room
	 */
	public Room getLastRoom() {
		return lastRoom;
	}

	/**
	 * Returns the lifeNumber.
	 * @return int
	 */
	public int getLifeNumber() {
		return lifeNumber;
	}

	/**
	 * Returns the name.
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns the posX.
	 * @return int
	 */
	public int getPosX() {
		return posX;
	}

	/**
	 * Returns the posY.
	 * @return int
	 */
	public int getPosY() {
		return posY;
	}

	/**
	 * Returns the score.
	 * @return Score
	 */
	public Score getScore() {
		return score;
	}

	/**
	 * Returns the strengthLevel.
	 * @return int
	 */
	public int getStrengthLevel() {
		int ret=this.strengthLevel;
		if (this.getCurrentWeapon()!=null){
			ret=ret+this.getCurrentWeapon().getStrengthAdd();
		}
		if (ret>100)ret=100;
		return ret;
	}
	
	/**
	 * Returns the strengthLevel.
	 * @return int
	 */
	public int getBaseStrengthLevel() {
		int ret=this.strengthLevel;
		return ret;
	}
	
	/**
	 * Returns the max weight level.
	 * @return int
	 */
	public int getMaxWeight() {
		return this.getStrengthLevel()*2;
	}
	
	/**
	 * Returns the max weight level.
	 * @return int
	 */
	public int getPoid() {
		int poid=0;
		for (Enumeration e=this.inventory.elements();e.hasMoreElements();){
			Item tmp=(Item)e.nextElement();
			poid=poid+tmp.getWeigth();
		}
		return poid;
	}
	

	/** method :int getCurrentEnergy
	 */
	public int getCurrentEnergy() {
		return currentEnergy;
	}

///////////////////   LES MODIFICATEURS      \\\\\\\\\\\\\\\\\\\\
	
	/**
	 * Sets the currentRoom.
	 * @param currentRoom The currentRoom to set
	 */
	public void setCurrentRoom(Room currentRoom) {
		this.currentRoom = currentRoom;
	}

	/**
	 * Sets the currentWeapon.
	 * @param currentWeapon The currentWeapon to set
	 */
	public void setCurrentWeapon(Item currentWeapon) {
		this.currentWeapon = currentWeapon;
	}

	/**
	 * Sets the dexterityLevel.
	 * @param dexterityLevel The dexterityLevel to set
	 */
	public void setDexterityLevel(int dexterityLevel) {
		if ((dexterityLevel>=0)&&(dexterityLevel<=100)){
			this.dexterityLevel = dexterityLevel;
		}
	}

	/**
	 * Sets the energyLevel.
	 * @param energyLevel The energyLevel to set
	 */
	public void setEnergyLevel(int energyLevel) throws PlayerIsDeadException {
		if ((energyLevel>=0)&&(energyLevel<=100)){
			this.energyLevel = energyLevel;
			this.setCurrentEnergy(this.energyLevel);
		}
	}

	/**
	 * Sets the imgPlayer.
	 * @param imgPlayer The imgPlayer to set
	 */
	public void setImgPlayer(Image imgPlayer) {
		this.imgPlayer = imgPlayer;
	}
	
	/**
	 * Sets the imgPlayer.
	 * @param imgPlayer The imgPlayer to set
	 */
	public void setImgPlayer(String imgPlayer) {
		this.imgPlayer = Toolkit.getDefaultToolkit().getImage(imgPlayer);
	}

	/**
	 * Sets the intelligenceLevel.
	 * @param intelligenceLevel The intelligenceLevel to set
	 */
	public void setIntelligenceLevel(int intelligenceLevel) {
		if ((intelligenceLevel>=0)&&(intelligenceLevel<=100)){
			this.intelligenceLevel = intelligenceLevel;
		}
	}

	/**
	 * Sets the inventory.
	 * @param inventory The inventory to set
	 */
	public void setInventory(Vector inventory) {
		this.inventory = inventory;
	}

	/**
	 * Sets the lastRoom.
	 * @param lastRoom The lastRoom to set
	 */
	public void setLastRoom(Room lastRoom) {
		this.lastRoom = lastRoom;
	}

	/**
	 * Sets the lifeNumber.
	 * @param lifeNumber The lifeNumber to set
	 */
	public void setLifeNumber(int lifeNumber) throws PlayerIsDeadException {
		if (lifeNumber<this.lifeNumber){
			this.setCurrentEnergy(this.getEnergyLevel());
		}
		this.lifeNumber = lifeNumber;
		if (this.lifeNumber<=0){
			throw new PlayerIsDeadException();
		}
		if (this.lifeNumber>6){
			this.lifeNumber=6;
		}
	}

	/**
	 * Sets the name.
	 * @param name The name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Sets the posX.
	 * @param posX The posX to set
	 */
	public void setPosX(int posX) {
		this.posX = posX;
	}

	/**
	 * Sets the posY.
	 * @param posY The posY to set
	 */
	public void setPosY(int posY) {
		this.posY = posY;
	}

	/**
	 * Sets the score.
	 * @param score The score to set
	 */
	public void setScore(Score score) {
		this.score = score;
	}

	/**
	 * Sets the strengthLevel.
	 * @param strengthLevel The strengthLevel to set
	 */
	public void setStrengthLevel(int strengthLevel) {
		if ((strengthLevel>=0)&&(strengthLevel<=100)){
			this.strengthLevel = strengthLevel;
		}
	}
	/** method :void setCurrentEnergy
	 * @param i
	 */
	public void setCurrentEnergy(int energy){
		boolean test=false;
		if (energy<this.currentEnergy){
			test=true;
		}
		if (energy<=this.getEnergyLevel()){
			this.currentEnergy = energy;
		}
		else{
			this.currentEnergy=this.getEnergyLevel();
		}
		
		if (test){
			try {
				test=this.checkLoseLife();
			} catch (PlayerIsDeadException e) {
				//do nothing
			}
		}
	}

}