package zork2Class;

import java.util.Vector;

/**
 * classe : Reward.java
 * <BR>the definition of reward given by ordeal
 * @author Fabien BOYERE, Michel de VERDELHAN
 *
 */
public class Reward {
	
	// attributs
	private int score;// le score apporte par la recompense
	private int strengthBonus;// le bonus de force
	private int dexterityBonus;// idem pour dexterite
	private int intelligenceBonus;// idem intelligence
	private int lifeBonus;// le nombre de vies apporte par le bonus
	private int energyBonus;// le bonus d'energie apporte
	private Vector item;//les items gagns

	/**
	 * default Constructor for Reward.
	 */
	public Reward() {
		this.score = 0;
		this.strengthBonus = 0;
		this.dexterityBonus = 0;
		this.intelligenceBonus = 0;
		this.lifeBonus = 0;
		this.energyBonus = 0;
		this.item = new Vector();
	}

///////////////////////////LES ACCESSEURS\\\\\\\\\\\\\\\\\\\\\\\\\

	/**
	 * Returns the dexterityBonus.
	 * @return int
	 */
	public int getDexterityBonus() {
		return dexterityBonus;
	}

	/**
	 * Returns the energyBonus.
	 * @return int
	 */
	public int getEnergyBonus() {
		return energyBonus;
	}

	/**
	 * Returns the intelligenceBonus.
	 * @return int
	 */
	public int getIntelligenceBonus() {
		return intelligenceBonus;
	}

	/**
	 * Returns the item.
	 * @return Vector
	 */
	public Vector getItem() {
		return item;
	}

	/**
	 * Returns the lifeBonus.
	 * @return int
	 */
	public int getLifeBonus() {
		return lifeBonus;
	}

	/**
	 * Returns the score.
	 * @return int
	 */
	public int getScore() {
		return score;
	}

	/**
	 * Returns the strengthBonus.
	 * @return int
	 */
	public int getStrengthBonus() {
		return strengthBonus;
	}

/////////////////////////////LES MODIFICATEURS\\\\\\\\\\\\\\\\\\\\\\

	/**
	 * Sets the dexterityBonus.
	 * @param dexterityBonus The dexterityBonus to set
	 */
	public void setDexterityBonus(int dexterityBonus) {
		this.dexterityBonus = dexterityBonus;
	}

	/**
	 * Sets the energyBonus.
	 * @param energyBonus The energyBonus to set
	 */
	public void setEnergyBonus(int energyBonus) {
		this.energyBonus = energyBonus;
	}

	/**
	 * Sets the intelligenceBonus.
	 * @param intelligenceBonus The intelligenceBonus to set
	 */
	public void setIntelligenceBonus(int intelligenceBonus) {
		this.intelligenceBonus = intelligenceBonus;
	}

	/**
	 * Sets the item.
	 * @param item The item to set
	 */
	public void setItem(Vector item) {
		this.item = item;
	}

	/**
	 * Sets the lifeBonus.
	 * @param lifeBonus The lifeBonus to set
	 */
	public void setLifeBonus(int lifeBonus) {
		this.lifeBonus = lifeBonus;
	}

	/**
	 * Sets the score.
	 * @param score The score to set
	 */
	public void setScore(int score) {
		this.score = score;
	}

	/**
	 * Sets the strengthBonus.
	 * @param strengthBonus The strengthBonus to set
	 */
	public void setStrengthBonus(int strengthBonus) {
		this.strengthBonus = strengthBonus;
	}

}
