package zork2Class;

import java.awt.Image;
import java.awt.Toolkit;

/**
 * classe : Room.java
 * This class room contains all room attribut. A room is a place where
 * the player can walk. He can find chest an Item in a room. Each wall has is
 * image. It the same for the floor.
 * @author de VERDELHAN Michel, BOYERE Fabien
 *
 */
public class Room {
	
	// Chemin des images par default
	public static final String IMG_WALL_FRONT_DEFAULT = "images/imgDefault/frontWall.gif";;
	public static final String IMG_WALL_NEXT_DEFAULT = "images/imgDefault/rightWall.gif";
	public static final String IMG_FLOOR_DEFAULT = "images/imgDefault/floor.gif";
	
	//identifiant d'une salle
	private String name;// le nom de la salle
	private String description;// la description de la salle

	//attributs correspondant aux divers lment de la salle	
	private Item[][] itemPosition;// position des items dans la salle
	private Door doorWest;// le porte ouest
	private Door doorEast;// la porte est
	private Door doorNorth;// la port nord
	private Door doorSouth;// la porte sud
	private Ordeal ordeal;// identifiant de l'epreuve (le nom)
	private Chest chest;// le coffre de la salle

	//images graphique de la pice contenu dans l'cran de jeu
	private Image imgRightWall;//chemin d'acces de l'image du mur de droite
	private Image imgLeftWall;//chemin d'acces de l'image du mur de gauche
	private Image imgFrontWall;//chemin d'acces de l'image du mur de devant
	private Image imgBackWall;//chemin d'acces de l'image du mur du fond
	private Image imgFloor;//chemin d'acces de l'image du sol de la salle
	
	private boolean isVisited;//permet de vrifier si la salle a t visite
	private boolean isOrdealActivate;//permet de dsactiver l'preuve de la salle si l'preuve a dj
									  // t gagn
	//constructor
	/**
	 * the default constructeur for room
	 */
	public Room(){
		//initialisation des attributs
		this.imgRightWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_NEXT_DEFAULT);
		this.imgBackWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_FRONT_DEFAULT);
		this.imgFrontWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_FRONT_DEFAULT);
		this.imgLeftWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_NEXT_DEFAULT);
		this.imgFloor = Toolkit.getDefaultToolkit().getImage(Room.IMG_FLOOR_DEFAULT);
		this.itemPosition = new Item[8][];
		this.isVisited = false;
		this.isOrdealActivate = true;
		
		this.itemPosition = new Item[8][];
		//initialisation du tableau de disposition des items
		for(int i=0; i<8;i++){
			this.itemPosition[i] = new Item[8];
		}
	}

	//constructor
	/**
	 * Create a room with a name and a description
	 * @param name th room's name
	 * @param description the room's description
	 */
	public Room(String name, String description){
		
		//cration des identifants de la pice
		this.name = name;
		this.description = description;
		
		//initialisation des attributs
		this.imgRightWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_NEXT_DEFAULT);
		this.imgBackWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_FRONT_DEFAULT);
		this.imgFrontWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_FRONT_DEFAULT);
		this.imgLeftWall = Toolkit.getDefaultToolkit().getImage(Room.IMG_WALL_NEXT_DEFAULT);
		this.imgFloor = Toolkit.getDefaultToolkit().getImage(Room.IMG_FLOOR_DEFAULT);
		this.isVisited = false;
		this.isOrdealActivate = true;
		
		this.itemPosition = new Item[8][];
		//initialisation du tableau de disposition des items
		for(int i=0; i<8;i++){
			this.itemPosition[i] = new Item[8];
		}
	}
	

//////////////////////// LES METHODES \\\\\\\\\\\\\\\\\\\\\\\\\\\	
	
	
	//methode qui permettent de determiner si les differentes portes existent		
	/**
	 * westDoorExist return a boolean attribut which permit to know if
	 * there is a west door in this room. Return <code>true</code> if the west door exist
	 * and <code>false</code>, if the door does not exist.
	 * @return boolean 
	 */
	public boolean westDoorExist() {
		boolean ret;
		if (this.doorWest == null) {
			ret = false;
		}
		else{
			ret = true;
		}	
		return(ret);
	}

	/**
	 * eastDoorExist return a boolean attribut which permit to know if
	 * there is a east door in this room. Return <code>true</code> if the east door exist
	 * and <code>false</code>, if the east door does not exist.
	 * @return boolean 
	 */
	public boolean eastDoorExist() {
		boolean ret;
		if (this.doorEast == null) {
			ret = false;
		}
		else{
			ret = true;
		}	
		return(ret);
	}
	
	/**
	 * southDoorExist return a boolean attribut which permit to know if
	 * there is a south door in this room. Return <code>true</code> if the south door exist
	 * and <code>false</code>, if the door does not exist.
	 * @return boolean 
	 */
	public boolean southDoorExist() {
		boolean ret;
		if (this.doorSouth == null) {
			ret = false;
		}
		else{
			ret = true;
		}	
		return(ret);
	}
	
	/**
	 * <b>northDoorExist</b> return a boolean attribut which permit to know if
	 * there is a north door in this room. Return <code>true</code> if the north door exist
	 * and <code>false</code>, if the north door does not exist.
	 * @return boolean 
	 */
	public boolean northDoorExist() {
		boolean ret;
		if (this.doorNorth == null) {
			ret = false;
		}
		else{
			ret = true;
		}	
		return(ret);
	}
	
	/**
	 * This method check if there are at less one door in the room, and return 
	 * true if there are at less one door
	 * @return boolean
	 */
	public boolean haveDoor(){
		boolean ret = false;
		if(this.northDoorExist()){
			ret = true;
		}
		if(this.southDoorExist()){
			ret = true;
		}
		if(this.eastDoorExist()){
			ret = true;
		}
		if(this.westDoorExist()){
			ret = true;
		}
		return(ret);
	}
	
	/**
	 * <b>canGoToPosition</b> check if there is a chest at Xposition, and Y position
	 * you choice and return <code>true</code> if the player could go to position
	 * @param posX : the X position we d'like to check
	 * @param posY : the Y position we d'like to check
	 * @return boolean
	 */
	public boolean canGoToPosition(int posX,int posY){
		boolean ret = true;
		if ((posX<8)&&(posX>=0)&&(posY<8)&&(posY>=0)){
			if (this.chest!=null){
				if((this.chest.getPosX()==posX)&&(this.chest.getPosY()==posY)){
					ret = false;
				}
			}
			if(this.itemPosition[posX][posY]!=null){
				if(!this.itemPosition[posX][posY].couldBeCross()){
					ret = false;
				}
			}
		}
		else{
			ret=false;
		}
		
		return(ret);
	}
	
	
	
	/**
	 * <b>isItemOnPosition</b> check if there is an item at X position, and Y position
	 * you have choose and return <code>true</code> if there are Item to position
	 * @param posX : the X position we d'like to check
	 * @param posY : the Y position we d'like to check
	 * @return boolean
	 */
	public boolean isItemOnPosition(int posX, int posY){
		boolean ret = true;
		if(this.itemPosition[posY][posX] == null){
			ret = false;
		}
		return(ret);
	}
	
	/**
	 *  method :void centerPlayer
	 * @param joueur
	 */
	public void centerPlayer(Player joueur){
		if (this.canGoToPosition(3,3)){
			joueur.setPosX(3);
			joueur.setPosY(3);
		}
		else{
			boolean place=false;
			int delta=0;// valeure du decalage
			while ((!place)&&(delta<2)){
				for (int j=2-delta;j<=4+delta;j++){
					for (int i=2-delta;i<=4+delta;i++){
						if ((this.canGoToPosition(i,j))&&(!place)){
							joueur.setPosX(i);
							joueur.setPosY(j);
							place=true;
						}
					}
				}
				delta++;
			}
		}
	}
	
	/**
	 *  method :int countDoor
	 * <BR> return the number of door
	 * @return the number of door
	 */
	public int countDoor(){
		int ret=0;
		if (this.getDoorEast()!=null){
			ret++;
		}
		if (this.getDoorNorth()!=null){
			ret++;
		}
		if (this.getDoorSouth()!=null){
			ret++;
		}
		if (this.getDoorWest()!=null){
			ret++;
		}
		return ret;
	}

////////////////////////LES ACCESSEURS\\\\\\\\\\\\\\\\\\\\\\\\\\\

	/**
	 * Returns the isVisited.
	 * @return boolean
	 */
	public boolean isVisited() {
		return isVisited;
	}


//Accesseurs des Attributs concernants les coffres

	/**
	 * This method return the chest which is on the room.
	 * @return Chest
	 */
	public Chest getChest() {
		return chest;
	}


//Accesseurs des Attributs concernants les portes
	/**
	 * Returns the doorEast.
	 * @return Door
	 */
	public Door getDoorEast() {
		return doorEast;
	}

	/**
	 * Returns the doorNorth.
	 * @return Door
	 */
	public Door getDoorNorth() {
		return doorNorth;
	}

	/**
	 * Returns the doorSouth.
	 * @return Door
	 */
	public Door getDoorSouth() {
		return doorSouth;
	}

	/**
	 * Returns the doorWest.
	 * @return Door
	 */
	public Door getDoorWest() {
		return doorWest;
	}

//Accesseurs des Attributs concernants les chemins des images des murs
	
	/**
	 * The imgBackWall is the image of the back wall which is display in the game Screen.
	 * This method return an image to display it.
	 * @return Image
	 */
	public Image getImgBackWall() {
		return imgBackWall;
	}

	/**
	 * The imgFloor is the image of the floor which is display in the game Screen.
	 * This method return an image to display it.
	 * @return Image
	 */	
	public Image getImgFloor() {
		return imgFloor;
	}

	/**
	 * The imgFrontWall is the image of the front wall which is display in the game Screen.
	 * This method return an image to display it.
	 * @return Image
	 */
	public Image getImgFrontWall() {
		return imgFrontWall;
	}

	/**
	 * The imgLeftWall is the image of the left wall which is display in the game Screen.
	 * This method return an image to display it.
	 * @return Image
	 */
	public Image getImgLeftWall() {
		return imgLeftWall;
	}

	/**
	 * The imgRightWall is the image of the right wall which is display in the game Screen.
	 * This method return an image to display it.
	 * @return Image
	 */
	public Image getImgRightWall() {
		return imgRightWall;
	}


//Accesseurs des Attributs concernants les items
	/**
	 * Returns the itemPosition.
	 * @return String[][]
	 */
	public Item[][] getItemPosition() {
		return itemPosition;
	}
	
   /**
	 * Returns the itemPosition.
	 * @return String[][]
	 */
	public Item getItemPosition(int x, int y) {
		return(itemPosition[x][y]);
	}

//Accesseur concernant les preuves
	/**
	 * Returns the ordeal.
	 * @return String
	 */
	public Ordeal getOrdeal() {
		return ordeal;
	}
	
    /**
	 * Returns the isOrdealSuccess.
	 * @return boolean
	 */
	public boolean isOrdealActivate() {
		return isOrdealActivate;
	}

//accesseurs concernant les caractristiques minimums d'une room
	/**
	 * Returns the Description of the current room.
	 * @return String
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Returns the Name of the room which is selected.
	 * @return String
	 */
	public String getName() {
		return name;
	}

////////////////////////LES MODIFICATEURS\\\\\\\\\\\\\\\\\\\\\\\\\\\

//modificateurs des Attributs concernants l'ventuel coffre
	/**
	 * Sets the chest.
	 * @param chest The chest to set
	 */
	public void setChest(Chest chest) {
		this.chest = chest;
	}

// modificateurs des attributs attenants aux portes de la salle
	/**
	 * Sets the doorEast.
	 * @param doorEast The doorEast to set
	 */
	public void setDoorEast(Door doorEast) {
		this.doorEast = doorEast;
	}


	/**
	 * Sets the doorNorth.
	 * @param doorNorth The doorNorth to set
	 */
	public void setDoorNorth(Door doorNorth) {
		this.doorNorth = doorNorth;
	}

	/**
	 * Sets the doorSouth.
	 * @param doorSouth The doorSouth to set
	 */
	public void setDoorSouth(Door doorSouth) {
		this.doorSouth = doorSouth;
	}

	/**
	 * Sets the doorWest.
	 * @param doorWest The doorWest to set
	 */
	public void setDoorWest(Door doorWest) {
		this.doorWest = doorWest;
	}


//modificateur du chemin des diffrentes images
	/**
	 * Sets the imgBackWallPath.
	 * @param imgBackWallPath The imgBackWallPath to set
	 */
	public void setImgBackWall(String imgBackWallPath) {
		this.imgBackWall = Toolkit.getDefaultToolkit().getImage(imgBackWallPath);
	}

	/**
	 * Sets the imgFloorPath.
	 * @param imgFloorPath The imgFloorPath to set
	 */
	public void setImgFloor(String imgFloorPath) {
		this.imgFloor = Toolkit.getDefaultToolkit().getImage(imgFloorPath);
	}

	/**
	 * Sets the imgFrontWallPath.
	 * @param imgFrontWallPath The imgFrontWallPath to set
	 */
	public void setImgFrontWall(String imgFrontWallPath) {
		this.imgFrontWall = Toolkit.getDefaultToolkit().getImage(imgFrontWallPath);
	}

	/**
	 * Sets the imgLeftWallPath.
	 * @param imgLeftWallPath The imgLeftWallPath to set
	 */
	public void setImgLeftWall(String imgLeftWallPath) {
		this.imgLeftWall = Toolkit.getDefaultToolkit().getImage(imgLeftWallPath);
	}

	/**
	 * Sets the imgRightWallPath.
	 * @param imgRightWallPath The imgRightWallPath to set
	 */
	public void setImgRightWall(String imgRightWallPath) {
		this.imgRightWall = Toolkit.getDefaultToolkit().getImage(imgRightWallPath);
	}

//modificateurs des Attributs concernants les items
	/**
	 * Sets the itemPosition.
	 * @param itemPosition The itemPosition to set
	 */
	public void setItemPosition(Item item, int posX, int posY ) {
		if((posY<itemPosition.length)&&(posX<(itemPosition[0].length))){
			this.itemPosition[posX][posY] = item;
		}
	}

//modificateurs des Attributs concernants l'preuve
	/**
	 * Sets the ordeal.
	 * @param ordeal The ordeal to set
	 */
	public void setOrdeal(Ordeal ordeal) {
		this.ordeal = ordeal;
	}

//modificateurs des Attributs concernants la room
	/**
	 * Sets the roomDescription.
	 * @param roomDescription The roomDescription to set
	 */
	public void setRoomDescription(String roomDescription) {
		this.description = roomDescription;
	}

	/**
	 * Sets the roomName.
	 * @param roomName The roomName to set
	 */
	public void setRoomName(String name) {
		this.name = name;
	}

	/**
	 * Sets the imgBackWall.
	 * @param imgBackWall The imgBackWall to set
	 */
	public void setImgBackWall(Image imgBackWall) {
		this.imgBackWall = imgBackWall;
	}

	/**
	 * Sets the imgFloor.
	 * @param imgFloor The imgFloor to set
	 */
	public void setImgFloor(Image imgFloor) {
		this.imgFloor = imgFloor;
	}

	/**
	 * Sets the imgFrontWall.
	 * @param imgFrontWall The imgFrontWall to set
	 */
	public void setImgFrontWall(Image imgFrontWall) {
		this.imgFrontWall = imgFrontWall;
	}

	/**
	 * Sets the imgLeftWall.
	 * @param imgLeftWall The imgLeftWall to set
	 */
	public void setImgLeftWall(Image imgLeftWall) {
		this.imgLeftWall = imgLeftWall;
	}

	/**
	 * Sets the imgRightWall.
	 * @param imgRightWall The imgRightWall to set
	 */
	public void setImgRightWall(Image imgRightWall) {
		this.imgRightWall = imgRightWall;
	}

//modificateur des booleen concernat l'tat de la salle
	/**
	 * Sets the isOrdealSuccess.
	 * @param isOrdealSuccess The isOrdealSuccess to set
	 */
	public void setIsOrdealActivate(boolean isOrdealActivate) {
		this.isOrdealActivate = isOrdealActivate;
	}

	/**
	 * Sets the isVisited.
	 * @param isVisited The isVisited to set
	 */
	public void setIsVisited(boolean isVisited) {
		this.isVisited = isVisited;
	}

	/**
	 * set an array of items in the room
	 * @param items
	 */
	public void setItemPosition(Item[][] items) {
		this.itemPosition = items;
	}

}
