package zork2Class;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * classe : SkillOrdeal.java
 * <BR> the ordeal which use player's skill
 * @author Michel de VERDELHAN, Fabien BOYERE
 *
 */
public class SkillOrdeal extends Ordeal{
	
	// attributs
	private OrdealFrame fenetre;
	private int strengthLevel;// le niveau de force requis
	private int dexterityLevel;// le niveau de dexterite requis
	private int intelligenceLevel;// le niveau d'intelligence requis
	private JButton bouton;
	private JButton abandonner;

	/**
	 *  the constructor for SkillOrdeal
	 * @param name the ordeal name
	 * @param desctiption the ordeal description
	 */
	public SkillOrdeal(String name, String description){
		this.setName(name);
		this.setDescription(description);
		this.setDexterityLevel(0);
		this.setDexterityLevel(0);
		this.setDexterityLevel(0);
	}

	/**
	 *  the default constructor for SkillOrdeal
	 *
	 */
	public SkillOrdeal (){
		this.setName(name);
		this.setDescription(this.description);
	}
	/**
	 * Returns the dexterityLevel.
	 * @return int
	 */
	public int getDexterityLevel() {
		return dexterityLevel;
	}

	/**
	 * Returns the intelligenceLevel.
	 * @return int
	 */
	public int getIntelligenceLevel() {
		return intelligenceLevel;
	}

	/**
	 * Returns the strengthLevel.
	 * @return int
	 */
	public int getStrengthLevel() {
		return strengthLevel;
	}

	/**
	 * Sets the dexterityLevel.
	 * @param dexterityLevel The dexterityLevel to set
	 */
	public void setDexterityLevel(int dexterityLevel) {
		this.dexterityLevel = dexterityLevel;
	}

	/**
	 * Sets the intelligenceLevel.
	 * @param intelligenceLevel The intelligenceLevel to set
	 */
	public void setIntelligenceLevel(int intelligenceLevel) {
		this.intelligenceLevel = intelligenceLevel;
	}

	/**
	 * Sets the strengthLevel.
	 * @param strengthLevel The strengthLevel to set
	 */
	public void setStrengthLevel(int strengthLevel) {
		this.strengthLevel = strengthLevel;
	}

	/**
	 *  method :SkillOrdeal ordealSuccess
	 * @param b
	 * @see zork2Class.Ordeal#ordealSuccess(boolean)
	 * @since 14 mai 03 at 22:36:41
	 */
	public void ordealSuccess(boolean b){
		Game partie=fenetre.getPartie();
		if (b){
			partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
			this.appReward();
			this.bouton.setEnabled(false);
			this.abandonner.setEnabled(false);
			CloseTimer closer=new CloseTimer(fenetre);
		}
		else{
			partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
			partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
			partie.executeCommand("#Vous avez perdu une vie car vous avez perdu l'preuve\n");
			//partie.getFenetre().zonePersonnage.repaint();
			this.bouton.setEnabled(false);
			this.abandonner.setEnabled(false);
			CloseTimer closer=new CloseTimer(fenetre);
			//partie.getFenetre().setEnabled(true);
			//fenetre.dispose();
			try {
				partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber()-1);
			} catch (PlayerIsDeadException e) {
				closer.stop();
				this.fenetre.dispose();
				partie.PlayerIsDead();
			}
		}
	}
	/** method :SkillOrdeal doOrdeal
	 * @param partie
	 * @see zork2Class.Ordeal#doOrdeal(zork2Class.Game)
	 * @since 14 mai 03 at 22:47:57 
	 */
	public void doOrdeal(Game partie) {
		bouton=new JButton("Lancer l'preuve");
		abandonner=new JButton("Abandonner");
		this.fenetre = new OrdealFrame(partie,partie.getFenetre(),"skill");
		JPanel panel =this.fenetre.getPanelCote();
		panel.add(new JLabel());
		panel.add(new JLabel("cliquez pour",JLabel.CENTER));
		panel.add(new JLabel("commencer l'preuve",JLabel.CENTER));
		panel.add(bouton);
		panel.add(new JLabel());
		panel.add(new JLabel());
		panel.add(abandonner);
		this.fenetre.setPanelCote(panel);
		bouton.addActionListener(new SkillOrdealListener(1));
		abandonner.addActionListener(new SkillOrdealListener(2));
		this.fenetre.getViewArea().setText("EPREUVE DE COMPETENCES :\n");
		partie.executeCommand("#EPREUVE DE COMPETENCES :\n");
		this.fenetre.getViewArea().append(this.getDescription());
		String strenghtAdd="\n\t-  "+this.getStrengthLevel()+" en force et";
		String dexteAdd="\n\t-  "+this.getDexterityLevel()+" en dexterite et";
		String intelAdd="\n\t-  "+this.getIntelligenceLevel()+" en intelligence";
		String descAdd="\n______________________________________________\nVous devez obtenir un minimum de :"+strenghtAdd+dexteAdd+intelAdd+
		"\nLors d'un lanc alatoire en fonction de vos comptences\n______________________________________________\n";
		this.fenetre.getViewArea().append(descAdd);
		partie.executeCommand("#\n______________________________________________\nVous devez obtenir un minimum de :"+strenghtAdd+dexteAdd+intelAdd+
		"\nLors d'un lanc alatoire en fonction de vos comptences\n______________________________________________\n");
		this.fenetre.setSize(338,590);
		this.fenetre.setVisible(true);
		
	}
	/**
	 *  method :SkillOrdeal appReward
	 * 
	 * @see zork2Class.Ordeal#appReward()
	 * @since 14 mai 03 at 22:36:53
	 */
	public void appReward(){
		Game partie=fenetre.getPartie();
		Player joueur=partie.getPlayer();
		Reward recompense=this.getRecompense();
		if (recompense!=null){
			joueur.setStrengthLevel(joueur.getStrengthLevel()+recompense.getStrengthBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getStrengthBonus()+" en force.\n");
			joueur.setDexterityLevel(joueur.getDexterityLevel()+recompense.getDexterityBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getDexterityBonus()+" en dexterite.\n");
			joueur.setIntelligenceLevel(joueur.getIntelligenceLevel()+recompense.getIntelligenceBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getIntelligenceBonus()+" en intelligence.\n");
			joueur.setCurrentEnergy(joueur.getCurrentEnergy()+recompense.getEnergyBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getEnergyBonus()+" en energie.\n");
			joueur.getScore().addPoint(this.getRecompense().getScore());
			partie.executeCommand("#Vous avez gagn "+this.getRecompense().getScore()+" points.\n");
			partie.executeCommand("#Vous avez gagn "+this.getRecompense().getLifeBonus()+" vie(s).\n");
			for (Enumeration e=recompense.getItem().elements();e.hasMoreElements();){
				Item objet=(Item)e.nextElement();
				joueur.getInventory().add(objet);
				if (!joueur.canWearItem(objet)){
					joueur.dropItem(objet);
				}
			}
			partie.getFenetre().updateInventaire(partie.getPlayer());
			try {
				joueur.setLifeNumber(joueur.getLifeNumber()+recompense.getLifeBonus());
			} catch (PlayerIsDeadException e1) {
				partie.PlayerIsDead();
			}
			partie.getFenetre().miniMap.repaint();
			partie.getFenetre().zonePersonnage.repaint();
		}
	}
	
	
	////////////////////////////////////////////////////////////////////////////
	public class SkillOrdealListener implements ActionListener{
		
		// attributs
		private int index;
		
		public SkillOrdealListener(int index){
			this.index=index;
		}

		/** method :SkillOrdealListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 14 mai 03 at 22:38:56 
		 */
		public void actionPerformed(ActionEvent arg0) {
			Game partie=fenetre.getPartie();
			switch (this.index){
				case 1:
					boolean success=true;
					Random rand=new Random();
					int valStrength=rand.nextInt(partie.getPlayer().getStrengthLevel());
					String strengthSummary="";
					int valDexte=rand.nextInt(partie.getPlayer().getDexterityLevel());
					String dexteSummary="";
					int valIntel=rand.nextInt(partie.getPlayer().getIntelligenceLevel());
					String intelSummary="";
					
					if (valStrength<getStrengthLevel()){
						success=false;
						strengthSummary="\n\t-Vous n'avez obtenu que "+valStrength+" sur "+getStrengthLevel()+" requis.";
					}
					else{
						strengthSummary="\n\t-Vous avez obtenu "+valStrength+" sur "+getStrengthLevel()+" requis.";
					}
					if (valDexte<getDexterityLevel()){
						success=false;
						dexteSummary="\n\t-Vous n'avez obtenu que "+valDexte+" sur "+getDexterityLevel()+" requis.";
					}
					else{
						dexteSummary="\n\t-Vous avez obtenu "+valDexte+" sur "+getDexterityLevel()+" requis.";
					}
					if (valIntel<getIntelligenceLevel()){
						success=false;
						intelSummary="\n\t-Vous n'avez obtenu que "+valIntel+" sur "+getIntelligenceLevel()+" requis.";
					}
					else{
						intelSummary="\n\t-Vous avez obtenu "+valIntel+" sur "+getIntelligenceLevel()+" requis.";
					}
					String result;
					if (success){
						result="\nRsultat de l'preuve :"+strengthSummary+dexteSummary+intelSummary+"\nL'preuve est un succes";
					}
					else{
						result="\nRsultat de l'preuve :"+strengthSummary+dexteSummary+intelSummary+"\nL'preuve est perdu";
					}
					fenetre.getViewArea().append(result);
				partie.executeCommand("#"+result);
					ordealSuccess(success);
				break;
				case 2:
					partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
					partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
					partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'preuve\n");
					partie.setLockCommand(false);
					partie.getFenetre().setEnabled(true);
					fenetre.dispose();
					partie.getFenetre().zonePersonnage.repaint();
					partie.getFenetre().zoneJeu.repaint();
					try {
						partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber()-1);
					} catch (PlayerIsDeadException e) {
						partie.PlayerIsDead();
					}
				break;
			}
			
		}
		 
	}
}
