package zork2Class;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * classe : WithoutQCM.java
 * <BR> the ordeal which ask question with multiple choice
 * @author Michel de VERDELHAN, Fabien BOYERE
 *
 */
public class WithQCM extends QuestionOrdeal{
	
	// attributs
	private Vector answerChoice;// les differentes choix possibles
	private OrdealFrame fenetre;
	private JButton[] boutons;
	private JButton abandonner;

	/**
	 *  the constructor for WithQCM
	 * @param name the ordeal's name
	 * @param desctiption the ordeal's description
	 */
	public WithQCM(String name, String description) {
		this.setName(name);
		this.setDescription(description);
		this.setAnswer("");
		this.setQuestion("");
		this.answerChoice = new Vector(0,1);
	}

	/**
	 *  the default constructor for WithQCM
	 *
	 */
	public WithQCM (){
		this.setName(name);
		this.setDescription(this.description);
	}

	/**
	 * Returns the answerChoice.
	 * @return Vector
	 */
	public Vector getAnswerChoice() {
		return answerChoice;
	}

	/**
	 * Sets the answerChoice.
	 * @param answerChoice The answerChoice to set
	 */
	public void setAnswerChoice(Vector answerChoice) {
		this.answerChoice = answerChoice;
	}

	/**
	 *  method :WithQCM ordealSuccess
	 * <BR> methode called when the player finish th ordeal
	 * @param b true if player win the ordeal else false
	 * @see zork2Class.Ordeal#ordealSuccess(boolean)
	 * @since 14 mai 03 at 22:50:26
	 */
	public void ordealSuccess(boolean b){
		Game partie=fenetre.getPartie();
		fenetre.getPanelCote().setEnabled(false);
		if (b){
			partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
			this.fenetre.getViewArea().append("\nBonne reponse");
			partie.executeCommand("#\nBonne reponse");
			this.appReward();
			for (int i=0;i<this.boutons.length;i++){
				this.boutons[i].setEnabled(false);
			}
			this.abandonner.setEnabled(false);
			CloseTimer closer=new CloseTimer(fenetre);
		}
		else{
			this.fenetre.getViewArea().append("\nMauvaise reponse");
			partie.executeCommand("#\nMauvaise reponse");
			partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
			partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
			partie.executeCommand("#Vous avez perdu une vie car vous avez perdu l'preuve\n");
			//partie.getFenetre().zonePersonnage.repaint();
			for (int i=0;i<this.boutons.length;i++){
				this.boutons[i].setEnabled(false);
			}
			this.abandonner.setEnabled(false);
			CloseTimer closer=new CloseTimer(fenetre);
			//partie.getFenetre().setEnabled(true);
			//fenetre.dispose();
			try {
				partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber()-1);
			} catch (PlayerIsDeadException e) {
				closer.stop();
				this.fenetre.dispose();
				partie.PlayerIsDead();
			}
		}
	}
	/** method :WithQCM doOrdeal
	 * <BR> methode called to start the ordeal
	 * @param partie the game on which the ordeal is launched
	 * @see zork2Class.Ordeal#doOrdeal(zork2Class.Game)
	 * @since 14 mai 03 at 22:50:16 
	 */
	public void doOrdeal(Game partie) {
		this.fenetre = new OrdealFrame(partie,partie.getFenetre(),"withqcm");
		JPanel panel =this.fenetre.getPanelCote();
		panel.add(new JLabel("____Votre reponse :____",JLabel.CENTER));
		Random rand =new Random();
		Vector reponsesPossibles=(Vector)this.answerChoice.clone();
		Vector reponses=new Vector(0,1);
		int i=0;
		while ((i<4)&&(!reponsesPossibles.isEmpty())){
			int val=rand.nextInt(reponsesPossibles.size());
			reponses.add(reponsesPossibles.elementAt(val));
			reponsesPossibles.removeElementAt(val);
			i++;
		}
		int val=rand.nextInt(reponses.size()+1);
		reponses.add(val,this.getAnswer());
		
		boutons=new JButton[reponses.size()];
		for (i=0;i<boutons.length;i++){
			boutons[i]=new JButton((String)reponses.elementAt(i));
			panel.add(boutons[i]);
			this.boutons[i].addActionListener(new ButtonListener());
		}
		// on ajoute des labels avant le bouton abandonner
		if (boutons.length<5){
			for (i=boutons.length;i<5;i++){
				panel.add(new JLabel());
			}
		}
		
		abandonner=new JButton("abandonner");
		abandonner.addActionListener(new AbandonnerListener());
		panel.add(abandonner);
		
		this.fenetre.setPanelCote(panel);
		
		this.fenetre.getViewArea().setText("EPREUVE DE QUESTION A CHOIX MULTIPLE:\n");
		partie.executeCommand("#EPREUVE DE QUESTION A CHOIX MULTIPLE:\n");
		this.fenetre.getViewArea().append("______________________________________________\n"+this.getDescription()+"\n"+this.getQuestion()+" ?\n______________________________________________\n");
		partie.executeCommand("#______________________________________________\n"+this.getDescription()+"\n"+this.getQuestion()+" ?\n______________________________________________\n");
		this.fenetre.setSize(338,590);
		this.fenetre.setVisible(true);
	}
	/**
	 *  method :WithQCM appReward
	 * <BR> the methode called to apply an ordeal
	 * @see zork2Class.Ordeal#appReward()
	 * @since 14 mai 03 at 22:50:30
	 */
	public void appReward(){
		Game partie=fenetre.getPartie();
		Player joueur=partie.getPlayer();
		Reward recompense=this.getRecompense();
		if (recompense!=null){
			joueur.setStrengthLevel(joueur.getStrengthLevel()+recompense.getStrengthBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getStrengthBonus()+" en force.\n");
			joueur.setDexterityLevel(joueur.getDexterityLevel()+recompense.getDexterityBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getDexterityBonus()+" en dexterite.\n");
			joueur.setIntelligenceLevel(joueur.getIntelligenceLevel()+recompense.getIntelligenceBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getIntelligenceBonus()+" en intelligence.\n");
			joueur.setCurrentEnergy(joueur.getCurrentEnergy()+recompense.getEnergyBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getEnergyBonus()+" en energie.\n");
			joueur.getScore().addPoint(this.getRecompense().getScore());
			partie.executeCommand("#Vous avez gagn "+this.getRecompense().getScore()+" points.\n");
			partie.executeCommand("#Vous avez gagn "+this.getRecompense().getLifeBonus()+" vie(s).\n");
			for (Enumeration e=recompense.getItem().elements();e.hasMoreElements();){
				Item objet=(Item)e.nextElement();
				joueur.getInventory().add(objet);
				if (!joueur.canWearItem(objet)){
					joueur.dropItem(objet);
				}
			}
			partie.getFenetre().updateInventaire(partie.getPlayer());
			try {
				joueur.setLifeNumber(joueur.getLifeNumber()+recompense.getLifeBonus());
			} catch (PlayerIsDeadException e1) {
				partie.PlayerIsDead();
			}
			partie.getFenetre().miniMap.repaint();
			partie.getFenetre().zonePersonnage.repaint();
		}
	}
	
	/**
	 * 	the class ButtonListener
	 *	creation :2 juin 2003 at 19:04:39
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class ButtonListener implements ActionListener{

		/** method :ButtonListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 2 juin 2003 at 19:04:35 
		 */
		public void actionPerformed(ActionEvent e) {
			JButton bouton=(JButton)e.getSource();
			fenetre.getPartie().executeCommand("#"+bouton.getText()+"\n");
			ordealSuccess(bouton.getText().equalsIgnoreCase(getAnswer()));
		}
	}
	
	/**
	 * 	the class AbandonnerListener
	 *	creation :2 juin 2003 at 21:12:48
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class AbandonnerListener implements ActionListener{

		/** method :AbandonnerListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 2 juin 2003 at 21:12:37 
		 */
		public void actionPerformed(ActionEvent arg0) {
			Game partie=fenetre.getPartie();
			partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
			partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
			partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'preuve\n");
			partie.setLockCommand(false);
			partie.getFenetre().setEnabled(true);
			fenetre.dispose();
			partie.getFenetre().zoneJeu.repaint();
			partie.getFenetre().zonePersonnage.repaint();
			try {
				partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber()-1);
			} catch (PlayerIsDeadException e) {
				partie.PlayerIsDead();
			}
		}
		
	}
	

}
