package zork2Class;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

import gameIHM.CloseTimer;
import gameIHM.OrdealFrame;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * classe : WithQCM.java
 * <BR> the ordeal which ask question without multiple choice
 * for player
 * @author Michel de VERDELHAN, Fabien BOYERE
 *
 */
public class WithoutQCM extends QuestionOrdeal{
	
	// attributs
	private int answerNumber;// le nombres d'essais du joueur
	private JTextField text;
	private OrdealFrame fenetre;
	private JButton valider;
	private JButton abandonner;

	/**
	 *  the constructor for WithoutQCM
	 * @param name the ordeal name
	 * @param desctiption the ordeal description
	 */
	public WithoutQCM(String name,String description){
		this.setName(name);
		this.setDescription(description);
		this.setAnswer("");
		this.setQuestion("");
	}

	/**
	 *  the default constructor for WithoutQCM
	 *
	 */
	public WithoutQCM (){
		this.setName(name);
		this.setDescription(this.description);
	}

	/**
	 * Returns the answerNumber
	 * @return int
	 */
	public int getAnswerNumber() {
		return answerNumber;
	}

	/**
	 * Sets the answerNumber
	 * @param answerNumber The answerNumber to set
	 */
	public void setAnswerNumber(int answerNumber) {
		this.answerNumber = answerNumber;
	}
	/**
	 *  method :WithoutQCM ordealSuccess
	 * <BR> method called when player finish an ordeal
	 * @param b true if ordeal is winned else false
	 * @see zork2Class.Ordeal#ordealSuccess(boolean)
	 * @since 14 mai 03 at 22:50:06
	 */
	public void ordealSuccess(boolean b){
		Game partie=fenetre.getPartie();
		fenetre.getPanelCote().setEnabled(false);
		if (b){
			partie.getPlayer().getCurrentRoom().setIsOrdealActivate(false);
			this.appReward();
			this.valider.setEnabled(false);
			this.abandonner.setEnabled(false);
			this.text.setEditable(false);
			CloseTimer closer=new CloseTimer(fenetre);
		}
		else{
			partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
			partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
			partie.executeCommand("#Vous avez perdu une vie car vous avez perdu l'preuve\n");
			//partie.getFenetre().zonePersonnage.repaint();
			this.valider.setEnabled(false);
			this.abandonner.setEnabled(false);
			this.text.setEditable(false);
			CloseTimer closer=new CloseTimer(fenetre);
			//partie.getFenetre().setEnabled(true);
			//fenetre.dispose();
			try {
				partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber()-1);
			} catch (PlayerIsDeadException e) {
				closer.stop();
				this.fenetre.dispose();
				partie.PlayerIsDead();
			}
		}
	}
	/** method :WithoutQCM doOrdeal
	 * <BR>method called to start the ordeal
	 * @param partie
	 * @see zork2Class.Ordeal#doOrdeal(zork2Class.Game)
	 * @since 14 mai 03 at 22:49:55 
	 */
	public void doOrdeal(Game partie) {
		text=new JTextField();
		valider=new JButton("Valider");
		abandonner=new JButton("Abandonner");
		this.fenetre = new OrdealFrame(partie,partie.getFenetre(),"withoutqcm");
		JPanel panel =this.fenetre.getPanelCote();
		panel.add(new JLabel());
		panel.add(new JLabel("     Votre reponse :     ",JLabel.CENTER));
		panel.add(text);
		panel.add(new JLabel());
		panel.add(valider);
		panel.add(new JLabel());
		panel.add(abandonner);
		this.fenetre.setPanelCote(panel);
		this.text.addActionListener(new ValiderListener());
		valider.addActionListener(new ValiderListener());
		abandonner.addActionListener(new AbandonnerListener());
		this.answerNumber=0;
		
		this.fenetre.getViewArea().setText("EPREUVE DE QUESTION :\n");
		partie.executeCommand("#EPREUVE DE QUESTION :\n");
		this.fenetre.getViewArea().append("______________________________________________\n"+this.getDescription()+"\n"+this.getQuestion()+" ?\n______________________________________________\n");
		partie.executeCommand("#______________________________________________\n"+this.getDescription()+"\n"+this.getQuestion()+" ?\n______________________________________________\n");
		this.fenetre.setSize(330,590);
		this.fenetre.setVisible(true);
		
	}
	/**
	 *  method :WithoutQCM appReward
	 * <BR> methode called to apply the reward to the player
	 * 
	 * @see zork2Class.Ordeal#appReward()
	 * @since 14 mai 03 at 22:50:09
	 */
	public void appReward(){
		Game partie=fenetre.getPartie();
		Player joueur=partie.getPlayer();
		Reward recompense=this.getRecompense();
		if (recompense!=null){
			joueur.setStrengthLevel(joueur.getStrengthLevel()+recompense.getStrengthBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getStrengthBonus()+" en force.\n");
			joueur.setDexterityLevel(joueur.getDexterityLevel()+recompense.getDexterityBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getDexterityBonus()+" en dexterite.\n");
			joueur.setIntelligenceLevel(joueur.getIntelligenceLevel()+recompense.getIntelligenceBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getIntelligenceBonus()+" en intelligence.\n");
			joueur.setCurrentEnergy(joueur.getCurrentEnergy()+recompense.getEnergyBonus());
			partie.executeCommand("#Vous avez gagn "+recompense.getEnergyBonus()+" en energie.\n");
			joueur.getScore().addPoint(this.getRecompense().getScore()/(this.answerNumber+1));
			partie.executeCommand("#Vous avez gagn "+(this.getRecompense().getScore()/(this.answerNumber+1))+" points.\n");
			partie.executeCommand("#Vous avez gagn "+this.getRecompense().getLifeBonus()+" vie(s).\n");
			for (Enumeration e=recompense.getItem().elements();e.hasMoreElements();){
				Item objet=(Item)e.nextElement();
				joueur.getInventory().add(objet);
				if (!joueur.canWearItem(objet)){
					joueur.dropItem(objet);
				}
			}
			partie.getFenetre().updateInventaire(partie.getPlayer());
			try {
				joueur.setLifeNumber(joueur.getLifeNumber()+recompense.getLifeBonus());
			} catch (PlayerIsDeadException e1) {
				partie.PlayerIsDead();
			}
			partie.getFenetre().miniMap.repaint();
			partie.getFenetre().zonePersonnage.repaint();
		}
	}
	
	/**
	 * 	the class ValiderListener
	 *	creation :2 juin 2003 at 11:21:10
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class ValiderListener implements ActionListener{

		/** method :ValiderListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 2 juin 2003 at 11:21:03 
		 */
		public void actionPerformed(ActionEvent arg0) {
			if(text.getText().equalsIgnoreCase(getAnswer().trim())){
				fenetre.getViewArea().append(text.getText()+"\nVotre reponse est bonne.\n");
				fenetre.getPartie().executeCommand("#"+text.getText()+"\nVotre reponse est bonne.\n");
				ordealSuccess(true);
			}
			else{
				fenetre.getViewArea().append(text.getText()+"\nVotre reponse est mauvaise.\nIl vous reste "+(2-answerNumber)+" chances.\n");
				fenetre.getPartie().executeCommand("#"+text.getText()+"\nVotre reponse est mauvaise.\nIl vous reste "+(2-answerNumber)+" chances.\n");
				text.setText("");
				if (answerNumber>=2){
					ordealSuccess(false);
				}
				else{
					answerNumber++;
				}
			}
		}
	}
	
	/**
	 * 	the class AbandonnerListener
	 *	creation :2 juin 2003 at 11:21:39
	 *  @author Michel de VERDELHAN
	 *  @version 1.0
	 *
	 */
	private class AbandonnerListener implements ActionListener{

		/** method :AbandonnerListener actionPerformed
		 * @param arg0
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 * @since 2 juin 2003 at 11:21:33 
		 */
		public void actionPerformed(ActionEvent arg0) {
			Game partie=fenetre.getPartie();
			partie.getPlayer().setCurrentRoom(partie.getPlayer().getLastRoom());
			partie.getPlayer().getCurrentRoom().centerPlayer(partie.getPlayer());
			partie.executeCommand("#Vous avez perdu une vie car vous avez abandonner l'preuve\n");
			partie.setLockCommand(false);
			partie.getFenetre().setEnabled(true);
			fenetre.dispose();
			partie.getFenetre().zoneJeu.repaint();
			partie.getFenetre().zonePersonnage.repaint();
			try {
				partie.getPlayer().setLifeNumber(partie.getPlayer().getLifeNumber()-1);
			} catch (PlayerIsDeadException e) {
				partie.PlayerIsDead();
			}
			
		}
		
	}


}
